/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jai.codecimpl;

import com.sun.media.jai.codec.ImageCodec;
import com.sun.media.jai.codecimpl.ImagingListenerProxy;
import com.sun.media.jai.codecimpl.JaiI18N;
import com.sun.media.jai.codecimpl.SimpleRenderedImage;
import com.sun.media.jai.codecimpl.util.ImagingException;
import com.sun.media.jai.codecimpl.util.RasterFactory;
import java.awt.Point;
import java.awt.color.ColorSpace;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferInt;
import java.awt.image.DataBufferUShort;
import java.awt.image.DirectColorModel;
import java.awt.image.IndexColorModel;
import java.awt.image.MultiPixelPackedSampleModel;
import java.awt.image.Raster;
import java.awt.image.SinglePixelPackedSampleModel;
import java.awt.image.WritableRaster;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;

class BMPImage
extends SimpleRenderedImage {
    private BufferedInputStream inputStream;
    private long bitmapFileSize;
    private long bitmapOffset;
    private long compression;
    private long imageSize;
    private byte[] palette;
    private int imageType;
    private int numBands;
    private boolean isBottomUp;
    private int bitsPerPixel;
    private int redMask;
    private int greenMask;
    private int blueMask;
    private int alphaMask;
    private static final int VERSION_2_1_BIT = 0;
    private static final int VERSION_2_4_BIT = 1;
    private static final int VERSION_2_8_BIT = 2;
    private static final int VERSION_2_24_BIT = 3;
    private static final int VERSION_3_1_BIT = 4;
    private static final int VERSION_3_4_BIT = 5;
    private static final int VERSION_3_8_BIT = 6;
    private static final int VERSION_3_24_BIT = 7;
    private static final int VERSION_3_NT_16_BIT = 8;
    private static final int VERSION_3_NT_32_BIT = 9;
    private static final int VERSION_4_1_BIT = 10;
    private static final int VERSION_4_4_BIT = 11;
    private static final int VERSION_4_8_BIT = 12;
    private static final int VERSION_4_16_BIT = 13;
    private static final int VERSION_4_24_BIT = 14;
    private static final int VERSION_4_32_BIT = 15;
    private static final int LCS_CALIBRATED_RGB = 0;
    private static final int LCS_sRGB = 1;
    private static final int LCS_CMYK = 2;
    private static final int BI_RGB = 0;
    private static final int BI_RLE8 = 1;
    private static final int BI_RLE4 = 2;
    private static final int BI_BITFIELDS = 3;
    private WritableRaster theTile;

    public BMPImage(InputStream inputStream) {
        Object object;
        int n2;
        int n3;
        block75: {
            this.theTile = null;
            this.inputStream = inputStream instanceof BufferedInputStream ? (BufferedInputStream)inputStream : new BufferedInputStream(inputStream);
            try {
                if (this.readUnsignedByte(this.inputStream) != 66 || this.readUnsignedByte(this.inputStream) != 77) {
                    throw new RuntimeException(JaiI18N.getString("BMPImageDecoder0"));
                }
                this.bitmapFileSize = this.readDWord(this.inputStream);
                this.readWord(this.inputStream);
                this.readWord(this.inputStream);
                this.bitmapOffset = this.readDWord(this.inputStream);
                long l2 = this.readDWord(this.inputStream);
                if (l2 == 12L) {
                    this.width = this.readWord(this.inputStream);
                    this.height = this.readWord(this.inputStream);
                } else {
                    this.width = this.readLong(this.inputStream);
                    this.height = this.readLong(this.inputStream);
                }
                int n4 = this.readWord(this.inputStream);
                this.bitsPerPixel = this.readWord(this.inputStream);
                this.properties.put("color_planes", new Integer(n4));
                this.properties.put("bits_per_pixel", new Integer(this.bitsPerPixel));
                this.numBands = 3;
                if (l2 == 12L) {
                    this.properties.put("bmp_version", "BMP v. 2.x");
                    if (this.bitsPerPixel == 1) {
                        this.imageType = 0;
                    } else if (this.bitsPerPixel == 4) {
                        this.imageType = 1;
                    } else if (this.bitsPerPixel == 8) {
                        this.imageType = 2;
                    } else if (this.bitsPerPixel == 24) {
                        this.imageType = 3;
                    }
                    n3 = (int)((this.bitmapOffset - 14L - l2) / 3L);
                    n2 = n3 * 3;
                    this.palette = new byte[n2];
                    this.inputStream.read(this.palette, 0, n2);
                    this.properties.put("palette", this.palette);
                    break block75;
                }
                this.compression = this.readDWord(this.inputStream);
                this.imageSize = this.readDWord(this.inputStream);
                long l3 = this.readLong(this.inputStream);
                long l4 = this.readLong(this.inputStream);
                long l5 = this.readDWord(this.inputStream);
                long l6 = this.readDWord(this.inputStream);
                switch ((int)this.compression) {
                    case 0: {
                        this.properties.put("compression", "BI_RGB");
                        break;
                    }
                    case 1: {
                        this.properties.put("compression", "BI_RLE8");
                        break;
                    }
                    case 2: {
                        this.properties.put("compression", "BI_RLE4");
                        break;
                    }
                    case 3: {
                        this.properties.put("compression", "BI_BITFIELDS");
                    }
                }
                this.properties.put("x_pixels_per_meter", new Long(l3));
                this.properties.put("y_pixels_per_meter", new Long(l4));
                this.properties.put("colors_used", new Long(l5));
                this.properties.put("colors_important", new Long(l6));
                if (l2 == 40L) {
                    switch ((int)this.compression) {
                        case 0: 
                        case 1: 
                        case 2: {
                            int n5 = (int)((this.bitmapOffset - 14L - l2) / 4L);
                            int n6 = n5 * 4;
                            this.palette = new byte[n6];
                            this.inputStream.read(this.palette, 0, n6);
                            this.properties.put("palette", this.palette);
                            if (this.bitsPerPixel == 1) {
                                this.imageType = 4;
                            } else if (this.bitsPerPixel == 4) {
                                this.imageType = 5;
                            } else if (this.bitsPerPixel == 8) {
                                this.imageType = 6;
                            } else if (this.bitsPerPixel == 24) {
                                this.imageType = 7;
                            } else if (this.bitsPerPixel == 16) {
                                this.imageType = 8;
                                this.redMask = 31744;
                                this.greenMask = 992;
                                this.blueMask = 31;
                                this.properties.put("red_mask", new Integer(this.redMask));
                                this.properties.put("green_mask", new Integer(this.greenMask));
                                this.properties.put("blue_mask", new Integer(this.blueMask));
                            } else if (this.bitsPerPixel == 32) {
                                this.imageType = 9;
                                this.redMask = 0xFF0000;
                                this.greenMask = 65280;
                                this.blueMask = 255;
                                this.properties.put("red_mask", new Integer(this.redMask));
                                this.properties.put("green_mask", new Integer(this.greenMask));
                                this.properties.put("blue_mask", new Integer(this.blueMask));
                            }
                            this.properties.put("bmp_version", "BMP v. 3.x");
                            break block75;
                        }
                        case 3: {
                            int n6;
                            if (this.bitsPerPixel == 16) {
                                this.imageType = 8;
                            } else if (this.bitsPerPixel == 32) {
                                this.imageType = 9;
                            }
                            this.redMask = (int)this.readDWord(this.inputStream);
                            this.greenMask = (int)this.readDWord(this.inputStream);
                            this.blueMask = (int)this.readDWord(this.inputStream);
                            this.properties.put("red_mask", new Integer(this.redMask));
                            this.properties.put("green_mask", new Integer(this.greenMask));
                            this.properties.put("blue_mask", new Integer(this.blueMask));
                            if (l5 != 0L) {
                                n6 = (int)l5 * 4;
                                this.palette = new byte[n6];
                                this.inputStream.read(this.palette, 0, n6);
                                this.properties.put("palette", this.palette);
                            }
                            this.properties.put("bmp_version", "BMP v. 3.x NT");
                            break block75;
                        }
                        default: {
                            throw new RuntimeException(JaiI18N.getString("BMPImageDecoder1"));
                        }
                    }
                }
                if (l2 == 108L) {
                    this.properties.put("bmp_version", "BMP v. 4.x");
                    this.redMask = (int)this.readDWord(this.inputStream);
                    this.greenMask = (int)this.readDWord(this.inputStream);
                    this.blueMask = (int)this.readDWord(this.inputStream);
                    this.alphaMask = (int)this.readDWord(this.inputStream);
                    long l7 = this.readDWord(this.inputStream);
                    int n7 = this.readLong(this.inputStream);
                    int n8 = this.readLong(this.inputStream);
                    int n9 = this.readLong(this.inputStream);
                    int n10 = this.readLong(this.inputStream);
                    int n11 = this.readLong(this.inputStream);
                    int n12 = this.readLong(this.inputStream);
                    int n13 = this.readLong(this.inputStream);
                    int n14 = this.readLong(this.inputStream);
                    int n15 = this.readLong(this.inputStream);
                    long l8 = this.readDWord(this.inputStream);
                    long l9 = this.readDWord(this.inputStream);
                    long l10 = this.readDWord(this.inputStream);
                    int n16 = (int)((this.bitmapOffset - 14L - l2) / 4L);
                    int n17 = n16 * 4;
                    this.palette = new byte[n17];
                    this.inputStream.read(this.palette, 0, n17);
                    if (this.palette != null || this.palette.length != 0) {
                        this.properties.put("palette", this.palette);
                    }
                    switch ((int)l7) {
                        case 0: {
                            this.properties.put("color_space", "LCS_CALIBRATED_RGB");
                            this.properties.put("redX", new Integer(n7));
                            this.properties.put("redY", new Integer(n8));
                            this.properties.put("redZ", new Integer(n9));
                            this.properties.put("greenX", new Integer(n10));
                            this.properties.put("greenY", new Integer(n11));
                            this.properties.put("greenZ", new Integer(n12));
                            this.properties.put("blueX", new Integer(n13));
                            this.properties.put("blueY", new Integer(n14));
                            this.properties.put("blueZ", new Integer(n15));
                            this.properties.put("gamma_red", new Long(l8));
                            this.properties.put("gamma_green", new Long(l9));
                            this.properties.put("gamma_blue", new Long(l10));
                            throw new RuntimeException(JaiI18N.getString("BMPImageDecoder2"));
                        }
                        case 1: {
                            this.properties.put("color_space", "LCS_sRGB");
                            break;
                        }
                        case 2: {
                            this.properties.put("color_space", "LCS_CMYK");
                            throw new RuntimeException(JaiI18N.getString("BMPImageDecoder2"));
                        }
                    }
                    if (this.bitsPerPixel == 1) {
                        this.imageType = 10;
                    } else if (this.bitsPerPixel == 4) {
                        this.imageType = 11;
                    } else if (this.bitsPerPixel == 8) {
                        this.imageType = 12;
                    } else if (this.bitsPerPixel == 16) {
                        this.imageType = 13;
                        if ((int)this.compression == 0) {
                            this.redMask = 31744;
                            this.greenMask = 992;
                            this.blueMask = 31;
                        }
                    } else if (this.bitsPerPixel == 24) {
                        this.imageType = 14;
                    } else if (this.bitsPerPixel == 32) {
                        this.imageType = 15;
                        if ((int)this.compression == 0) {
                            this.redMask = 0xFF0000;
                            this.greenMask = 65280;
                            this.blueMask = 255;
                        }
                    }
                    this.properties.put("red_mask", new Integer(this.redMask));
                    this.properties.put("green_mask", new Integer(this.greenMask));
                    this.properties.put("blue_mask", new Integer(this.blueMask));
                    this.properties.put("alpha_mask", new Integer(this.alphaMask));
                    break block75;
                }
                this.properties.put("bmp_version", "BMP v. 5.x");
                throw new RuntimeException(JaiI18N.getString("BMPImageDecoder4"));
            }
            catch (IOException iOException) {
                object = JaiI18N.getString("BMPImageDecoder5");
                ImagingListenerProxy.errorOccurred((String)object, new ImagingException((String)object, iOException), this, false);
            }
        }
        if (this.height > 0) {
            this.isBottomUp = true;
        } else {
            this.isBottomUp = false;
            this.height = Math.abs(this.height);
        }
        this.tileWidth = this.width;
        this.tileHeight = this.height;
        if (this.bitsPerPixel == 1 || this.bitsPerPixel == 4 || this.bitsPerPixel == 8) {
            byte[] byArray;
            byte[] byArray2;
            this.numBands = 1;
            this.sampleModel = this.bitsPerPixel == 8 ? RasterFactory.createPixelInterleavedSampleModel(0, this.width, this.height, this.numBands) : new MultiPixelPackedSampleModel(0, this.width, this.height, this.bitsPerPixel);
            if (this.imageType == 0 || this.imageType == 1 || this.imageType == 2) {
                n3 = this.palette.length / 3;
                if (n3 > 256) {
                    n3 = 256;
                }
                byArray2 = new byte[n3];
                object = new byte[n3];
                byArray = new byte[n3];
                int n18 = 0;
                while (n18 < n3) {
                    n2 = 3 * n18;
                    byArray[n18] = this.palette[n2];
                    object[n18] = this.palette[n2 + 1];
                    byArray2[n18] = this.palette[n2 + 2];
                    ++n18;
                }
            } else {
                n3 = this.palette.length / 4;
                if (n3 > 256) {
                    n3 = 256;
                }
                byArray2 = new byte[n3];
                object = new byte[n3];
                byArray = new byte[n3];
                int n19 = 0;
                while (n19 < n3) {
                    n2 = 4 * n19;
                    byArray[n19] = this.palette[n2];
                    object[n19] = this.palette[n2 + 1];
                    byArray2[n19] = this.palette[n2 + 2];
                    ++n19;
                }
            }
            this.colorModel = ImageCodec.isIndicesForGrayscale(byArray2, (byte[])object, byArray) ? ImageCodec.createComponentColorModel(this.sampleModel) : new IndexColorModel(this.bitsPerPixel, n3, byArray2, (byte[])object, byArray);
        } else if (this.bitsPerPixel == 16) {
            this.numBands = 3;
            this.sampleModel = new SinglePixelPackedSampleModel(1, this.width, this.height, new int[]{this.redMask, this.greenMask, this.blueMask});
            this.colorModel = new DirectColorModel(ColorSpace.getInstance(1000), 16, this.redMask, this.greenMask, this.blueMask, 0, false, 1);
        } else if (this.bitsPerPixel == 32) {
            int[] nArray;
            int n20 = this.numBands = this.alphaMask == 0 ? 3 : 4;
            if (this.numBands == 3) {
                int[] nArray2 = new int[3];
                nArray2[0] = this.redMask;
                nArray2[1] = this.greenMask;
                nArray = nArray2;
                nArray2[2] = this.blueMask;
            } else {
                int[] nArray3 = new int[4];
                nArray3[0] = this.redMask;
                nArray3[1] = this.greenMask;
                nArray3[2] = this.blueMask;
                nArray = nArray3;
                nArray3[3] = this.alphaMask;
            }
            int[] nArray4 = nArray;
            this.sampleModel = new SinglePixelPackedSampleModel(3, this.width, this.height, nArray4);
            this.colorModel = new DirectColorModel(ColorSpace.getInstance(1000), 32, this.redMask, this.greenMask, this.blueMask, this.alphaMask, false, 3);
        } else {
            this.numBands = 3;
            this.sampleModel = RasterFactory.createPixelInterleavedSampleModel(0, this.width, this.height, this.numBands);
            this.colorModel = ImageCodec.createComponentColorModel(this.sampleModel);
        }
    }

    private void read1Bit(byte[] byArray, int n2) {
        int n3 = 0;
        int n4 = (int)Math.ceil((double)this.width / 8.0);
        int n5 = n4 % 4;
        if (n5 != 0) {
            n3 = 4 - n5;
        }
        int n6 = (n4 + n3) * this.height;
        byte[] byArray2 = new byte[n6];
        try {
            int n7 = 0;
            while (n7 < n6) {
                n7 += this.inputStream.read(byArray2, n7, n6 - n7);
            }
        }
        catch (IOException iOException) {
            String string = JaiI18N.getString("BMPImageDecoder6");
            ImagingListenerProxy.errorOccurred(string, new ImagingException(string, iOException), this, false);
        }
        if (this.isBottomUp) {
            int n8 = 0;
            while (n8 < this.height) {
                System.arraycopy(byArray2, n6 - (n8 + 1) * (n4 + n3), byArray, n8 * n4, n4);
                ++n8;
            }
        } else {
            int n9 = 0;
            while (n9 < this.height) {
                System.arraycopy(byArray2, n9 * (n4 + n3), byArray, n9 * n4, n4);
                ++n9;
            }
        }
    }

    private void read4Bit(byte[] byArray, int n2) {
        int n3 = 0;
        int n4 = (int)Math.ceil((double)this.width / 2.0);
        int n5 = n4 % 4;
        if (n5 != 0) {
            n3 = 4 - n5;
        }
        int n6 = (n4 + n3) * this.height;
        byte[] byArray2 = new byte[n6];
        try {
            int n7 = 0;
            while (n7 < n6) {
                n7 += this.inputStream.read(byArray2, n7, n6 - n7);
            }
        }
        catch (IOException iOException) {
            String string = JaiI18N.getString("BMPImageDecoder6");
            ImagingListenerProxy.errorOccurred(string, new ImagingException(string, iOException), this, false);
        }
        if (this.isBottomUp) {
            int n8 = 0;
            while (n8 < this.height) {
                System.arraycopy(byArray2, n6 - (n8 + 1) * (n4 + n3), byArray, n8 * n4, n4);
                ++n8;
            }
        } else {
            int n9 = 0;
            while (n9 < this.height) {
                System.arraycopy(byArray2, n9 * (n4 + n3), byArray, n9 * n4, n4);
                ++n9;
            }
        }
    }

    private void read8Bit(byte[] byArray, int n2) {
        int n3 = 0;
        int n4 = this.width * 8;
        if (n4 % 32 != 0) {
            n3 = (n4 / 32 + 1) * 32 - n4;
            n3 = (int)Math.ceil((double)n3 / 8.0);
        }
        int n5 = (this.width + n3) * this.height;
        byte[] byArray2 = new byte[n5];
        try {
            int n6 = 0;
            while (n6 < n5) {
                n6 += this.inputStream.read(byArray2, n6, n5 - n6);
            }
        }
        catch (IOException iOException) {
            String string = JaiI18N.getString("BMPImageDecoder6");
            ImagingListenerProxy.errorOccurred(string, new ImagingException(string, iOException), this, false);
        }
        if (this.isBottomUp) {
            int n7 = 0;
            while (n7 < this.height) {
                System.arraycopy(byArray2, n5 - (n7 + 1) * (this.width + n3), byArray, n7 * this.width, this.width);
                ++n7;
            }
        } else {
            int n8 = 0;
            while (n8 < this.height) {
                System.arraycopy(byArray2, n8 * (this.width + n3), byArray, n8 * this.width, this.width);
                ++n8;
            }
        }
    }

    private void read24Bit(byte[] byArray) {
        int n2;
        int n3 = 0;
        int n4 = this.width * 24;
        if (n4 % 32 != 0) {
            n3 = (n4 / 32 + 1) * 32 - n4;
            n3 = (int)Math.ceil((double)n3 / 8.0);
        }
        if ((n2 = (int)this.imageSize) == 0) {
            n2 = (int)(this.bitmapFileSize - this.bitmapOffset);
        }
        byte[] byArray2 = new byte[n2];
        try {
            int n5 = 0;
            while (n5 < n2) {
                n5 += this.inputStream.read(byArray2, n5, n2 - n5);
            }
        }
        catch (IOException iOException) {
            String string = JaiI18N.getString("BMPImageDecoder4");
            ImagingListenerProxy.errorOccurred(string, new ImagingException(string, iOException), this, false);
        }
        int n6 = 0;
        if (this.isBottomUp) {
            int n7 = this.width * this.height * 3 - 1;
            int n8 = -n3;
            int n9 = 0;
            while (n9 < this.height) {
                n6 = n7 - (n9 + 1) * this.width * 3 + 1;
                n8 += n3;
                int n10 = 0;
                while (n10 < this.width) {
                    byArray[n6++] = byArray2[n8++];
                    byArray[n6++] = byArray2[n8++];
                    byArray[n6++] = byArray2[n8++];
                    ++n10;
                }
                ++n9;
            }
        } else {
            int n11 = -n3;
            int n12 = 0;
            while (n12 < this.height) {
                n11 += n3;
                int n13 = 0;
                while (n13 < this.width) {
                    byArray[n6++] = byArray2[n11++];
                    byArray[n6++] = byArray2[n11++];
                    byArray[n6++] = byArray2[n11++];
                    ++n13;
                }
                ++n12;
            }
        }
    }

    private void read16Bit(short[] sArray) {
        int n2;
        int n3 = 0;
        int n4 = this.width * 16;
        if (n4 % 32 != 0) {
            n3 = (n4 / 32 + 1) * 32 - n4;
            n3 = (int)Math.ceil((double)n3 / 8.0);
        }
        if ((n2 = (int)this.imageSize) == 0) {
            n2 = (int)(this.bitmapFileSize - this.bitmapOffset);
        }
        int n5 = 0;
        try {
            if (this.isBottomUp) {
                int n6 = this.width * this.height - 1;
                int n7 = 0;
                while (n7 < this.height) {
                    n5 = n6 - (n7 + 1) * this.width + 1;
                    int n8 = 0;
                    while (n8 < this.width) {
                        sArray[n5++] = (short)(this.readWord(this.inputStream) & 0xFFFF);
                        ++n8;
                    }
                    int n9 = 0;
                    while (n9 < n3) {
                        this.inputStream.read();
                        ++n9;
                    }
                    ++n7;
                }
            } else {
                int n10 = 0;
                while (n10 < this.height) {
                    int n11 = 0;
                    while (n11 < this.width) {
                        sArray[n5++] = (short)(this.readWord(this.inputStream) & 0xFFFF);
                        ++n11;
                    }
                    int n12 = 0;
                    while (n12 < n3) {
                        this.inputStream.read();
                        ++n12;
                    }
                    ++n10;
                }
            }
        }
        catch (IOException iOException) {
            String string = JaiI18N.getString("BMPImageDecoder6");
            ImagingListenerProxy.errorOccurred(string, new ImagingException(string, iOException), this, false);
        }
    }

    private void read32Bit(int[] nArray) {
        int n2 = (int)this.imageSize;
        if (n2 == 0) {
            n2 = (int)(this.bitmapFileSize - this.bitmapOffset);
        }
        int n3 = 0;
        try {
            if (this.isBottomUp) {
                int n4 = this.width * this.height - 1;
                int n5 = 0;
                while (n5 < this.height) {
                    n3 = n4 - (n5 + 1) * this.width + 1;
                    int n6 = 0;
                    while (n6 < this.width) {
                        nArray[n3++] = (int)this.readDWord(this.inputStream);
                        ++n6;
                    }
                    ++n5;
                }
            } else {
                int n7 = 0;
                while (n7 < this.height) {
                    int n8 = 0;
                    while (n8 < this.width) {
                        nArray[n3++] = (int)this.readDWord(this.inputStream);
                        ++n8;
                    }
                    ++n7;
                }
            }
        }
        catch (IOException iOException) {
            String string = JaiI18N.getString("BMPImageDecoder6");
            ImagingListenerProxy.errorOccurred(string, new ImagingException(string, iOException), this, false);
        }
    }

    private void readRLE8(byte[] byArray) {
        int n2 = (int)this.imageSize;
        if (n2 == 0) {
            n2 = (int)(this.bitmapFileSize - this.bitmapOffset);
        }
        int n3 = 0;
        int n4 = this.width % 4;
        if (n4 != 0) {
            n3 = 4 - n4;
        }
        byte[] byArray2 = new byte[n2];
        try {
            int n5 = 0;
            while (n5 < n2) {
                n5 += this.inputStream.read(byArray2, n5, n2 - n5);
            }
        }
        catch (IOException iOException) {
            String string = JaiI18N.getString("BMPImageDecoder6");
            ImagingListenerProxy.errorOccurred(string, new ImagingException(string, iOException), this, false);
        }
        byte[] byArray3 = this.decodeRLE8(n2, n3, byArray2);
        n2 = this.width * this.height;
        if (this.isBottomUp) {
            int n6 = this.width;
            int n7 = 0;
            while (n7 < this.height) {
                System.arraycopy(byArray3, n2 - (n7 + 1) * n6, byArray, n7 * n6, n6);
                ++n7;
            }
        } else {
            byArray = byArray3;
        }
    }

    private byte[] decodeRLE8(int n2, int n3, byte[] byArray) {
        byte[] byArray2 = new byte[this.width * this.height];
        int n4 = 0;
        int n5 = 0;
        boolean bl2 = false;
        while (n4 != n2) {
            int n6;
            int n7;
            if ((n7 = byArray[n4++] & 0xFF) == 0) {
                switch (byArray[n4++] & 0xFF) {
                    case 0: {
                        break;
                    }
                    case 1: {
                        bl2 = true;
                        break;
                    }
                    case 2: {
                        n6 = byArray[n4++] & 0xFF;
                        int n8 = byArray[n4] & 0xFF;
                        n5 += n6 + n8 * this.width;
                        break;
                    }
                    default: {
                        int n9 = byArray[n4 - 1] & 0xFF;
                        int n10 = 0;
                        while (n10 < n9) {
                            byArray2[n5++] = (byte)(byArray[n4++] & 0xFF);
                            ++n10;
                        }
                        if (!this.isEven(n9)) {
                            ++n4;
                            break;
                        } else {
                            break;
                        }
                    }
                }
            } else {
                n6 = 0;
                while (n6 < n7) {
                    byArray2[n5++] = (byte)(byArray[n4] & 0xFF);
                    ++n6;
                }
                ++n4;
            }
            if (bl2) break;
        }
        return byArray2;
    }

    private int[] readRLE4() {
        Object object;
        int n2 = (int)this.imageSize;
        if (n2 == 0) {
            n2 = (int)(this.bitmapFileSize - this.bitmapOffset);
        }
        int n3 = 0;
        int n4 = this.width % 4;
        if (n4 != 0) {
            n3 = 4 - n4;
        }
        int[] nArray = new int[n2];
        try {
            int n5 = 0;
            while (n5 < n2) {
                nArray[n5] = this.inputStream.read();
                ++n5;
            }
        }
        catch (IOException iOException) {
            object = JaiI18N.getString("BMPImageDecoder6");
            ImagingListenerProxy.errorOccurred((String)object, new ImagingException((String)object, iOException), this, false);
        }
        int[] nArray2 = this.decodeRLE4(n2, n3, nArray);
        if (this.isBottomUp) {
            object = nArray2;
            nArray2 = new int[this.width * this.height];
            int n6 = 0;
            int n7 = this.height - 1;
            while (n7 >= 0) {
                int n8 = n7 * this.width;
                int n9 = n6 + this.width;
                while (n6 != n9) {
                    nArray2[n6++] = (int)object[n8++];
                }
                --n7;
            }
        }
        return nArray2;
    }

    private int[] decodeRLE4(int n2, int n3, int[] nArray) {
        int[] nArray2 = new int[this.width * this.height];
        int n4 = 0;
        int n5 = 0;
        boolean bl2 = false;
        while (n4 != n2) {
            int n6;
            int n7;
            if ((n7 = nArray[n4++]) == 0) {
                switch (nArray[n4++]) {
                    case 0: {
                        break;
                    }
                    case 1: {
                        bl2 = true;
                        break;
                    }
                    case 2: {
                        int n8 = nArray[n4++];
                        n6 = nArray[n4];
                        n5 += n8 + n6 * this.width;
                        break;
                    }
                    default: {
                        int n9 = nArray[n4 - 1];
                        int n10 = 0;
                        while (n10 < n9) {
                            nArray2[n5++] = this.isEven(n10) ? (nArray[n4] & 0xF0) >> 4 : nArray[n4++] & 0xF;
                            ++n10;
                        }
                        if (!this.isEven(n9)) {
                            ++n4;
                        }
                        if (!this.isEven((int)Math.ceil(n9 / 2))) {
                            ++n4;
                            break;
                        } else {
                            break;
                        }
                    }
                }
            } else {
                int[] nArray3 = new int[]{(nArray[n4] & 0xF0) >> 4, nArray[n4] & 0xF};
                n6 = 0;
                while (n6 < n7) {
                    nArray2[n5++] = nArray3[n6 % 2];
                    ++n6;
                }
                ++n4;
            }
            if (bl2) break;
        }
        return nArray2;
    }

    private boolean isEven(int n2) {
        return n2 % 2 == 0;
    }

    private int readUnsignedByte(InputStream inputStream) throws IOException {
        return inputStream.read() & 0xFF;
    }

    private int readUnsignedShort(InputStream inputStream) throws IOException {
        int n2 = this.readUnsignedByte(inputStream);
        int n3 = this.readUnsignedByte(inputStream);
        return (n3 << 8 | n2) & 0xFFFF;
    }

    private int readShort(InputStream inputStream) throws IOException {
        int n2 = this.readUnsignedByte(inputStream);
        int n3 = this.readUnsignedByte(inputStream);
        return n3 << 8 | n2;
    }

    private int readWord(InputStream inputStream) throws IOException {
        return this.readUnsignedShort(inputStream);
    }

    private long readUnsignedInt(InputStream inputStream) throws IOException {
        int n2 = this.readUnsignedByte(inputStream);
        int n3 = this.readUnsignedByte(inputStream);
        int n4 = this.readUnsignedByte(inputStream);
        int n5 = this.readUnsignedByte(inputStream);
        long l2 = n5 << 24 | n4 << 16 | n3 << 8 | n2;
        return l2 & 0xFFFFFFFFFFFFFFFFL;
    }

    private int readInt(InputStream inputStream) throws IOException {
        int n2 = this.readUnsignedByte(inputStream);
        int n3 = this.readUnsignedByte(inputStream);
        int n4 = this.readUnsignedByte(inputStream);
        int n5 = this.readUnsignedByte(inputStream);
        return n5 << 24 | n4 << 16 | n3 << 8 | n2;
    }

    private long readDWord(InputStream inputStream) throws IOException {
        return this.readUnsignedInt(inputStream);
    }

    private int readLong(InputStream inputStream) throws IOException {
        return this.readInt(inputStream);
    }

    private synchronized Raster computeTile(int n2, int n3) {
        if (this.theTile != null) {
            return this.theTile;
        }
        Point point = new Point(this.tileXToX(n2), this.tileYToY(n3));
        WritableRaster writableRaster = RasterFactory.createWritableRaster(this.sampleModel, point);
        byte[] byArray = null;
        short[] sArray = null;
        int[] nArray = null;
        if (this.sampleModel.getDataType() == 0) {
            byArray = ((DataBufferByte)writableRaster.getDataBuffer()).getData();
        } else if (this.sampleModel.getDataType() == 1) {
            sArray = ((DataBufferUShort)writableRaster.getDataBuffer()).getData();
        } else if (this.sampleModel.getDataType() == 3) {
            nArray = ((DataBufferInt)writableRaster.getDataBuffer()).getData();
        }
        block0 : switch (this.imageType) {
            case 0: {
                this.read1Bit(byArray, 3);
                break;
            }
            case 1: {
                this.read4Bit(byArray, 3);
                break;
            }
            case 2: {
                this.read8Bit(byArray, 3);
                break;
            }
            case 3: {
                this.read24Bit(byArray);
                break;
            }
            case 4: {
                this.read1Bit(byArray, 4);
                break;
            }
            case 5: {
                switch ((int)this.compression) {
                    case 0: {
                        this.read4Bit(byArray, 4);
                        break block0;
                    }
                    case 2: {
                        int[] nArray2 = this.readRLE4();
                        writableRaster.setPixels(0, 0, this.width, this.height, nArray2);
                        break block0;
                    }
                }
                throw new RuntimeException(JaiI18N.getString("BMPImageDecoder3"));
            }
            case 6: {
                switch ((int)this.compression) {
                    case 0: {
                        this.read8Bit(byArray, 4);
                        break block0;
                    }
                    case 1: {
                        this.readRLE8(byArray);
                        break block0;
                    }
                }
                throw new RuntimeException(JaiI18N.getString("BMPImageDecoder3"));
            }
            case 7: {
                this.read24Bit(byArray);
                break;
            }
            case 8: {
                this.read16Bit(sArray);
                break;
            }
            case 9: {
                this.read32Bit(nArray);
                break;
            }
            case 10: {
                this.read1Bit(byArray, 4);
                break;
            }
            case 11: {
                switch ((int)this.compression) {
                    case 0: {
                        this.read4Bit(byArray, 4);
                        break;
                    }
                    case 2: {
                        int[] nArray3 = this.readRLE4();
                        writableRaster.setPixels(0, 0, this.width, this.height, nArray3);
                        break;
                    }
                    default: {
                        throw new RuntimeException(JaiI18N.getString("BMPImageDecoder3"));
                    }
                }
            }
            case 12: {
                switch ((int)this.compression) {
                    case 0: {
                        this.read8Bit(byArray, 4);
                        break block0;
                    }
                    case 1: {
                        this.readRLE8(byArray);
                        break block0;
                    }
                }
                throw new RuntimeException(JaiI18N.getString("BMPImageDecoder3"));
            }
            case 13: {
                this.read16Bit(sArray);
                break;
            }
            case 14: {
                this.read24Bit(byArray);
                break;
            }
            case 15: {
                this.read32Bit(nArray);
            }
        }
        this.theTile = writableRaster;
        return writableRaster;
    }

    public synchronized Raster getTile(int n2, int n3) {
        if (n2 != 0 || n3 != 0) {
            throw new IllegalArgumentException(JaiI18N.getString("BMPImageDecoder7"));
        }
        return this.computeTile(n2, n3);
    }
}

