/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jai.codecimpl;

import com.sun.media.jai.codec.ImageDecodeParam;
import com.sun.media.jai.codec.ImageDecoderImpl;
import com.sun.media.jai.codec.SeekableStream;
import com.sun.media.jai.codecimpl.GIFImage;
import com.sun.media.jai.codecimpl.ImagingListenerProxy;
import com.sun.media.jai.codecimpl.JaiI18N;
import com.sun.media.jai.codecimpl.util.ImagingException;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;

public class GIFImageDecoder
extends ImageDecoderImpl {
    private byte[] globalColorTable = null;
    private boolean maxPageFound = false;
    private int maxPage;
    private int prevPage = -1;
    private int prevSyncedPage = -1;
    private HashMap images = new HashMap();
    static /* synthetic */ Class class$com$sun$media$jai$codecimpl$GIFImageDecoder;

    private static byte[] readHeader(SeekableStream seekableStream) throws IOException {
        byte[] byArray = null;
        try {
            seekableStream.skipBytes(10);
            int n2 = seekableStream.readUnsignedByte();
            boolean bl2 = (n2 & 0x80) != 0;
            int n3 = 1 << (n2 & 7) + 1;
            int n4 = seekableStream.readUnsignedByte();
            seekableStream.read();
            if (bl2) {
                byArray = new byte[3 * n3];
                seekableStream.readFully(byArray);
            } else {
                byArray = null;
            }
        }
        catch (IOException iOException) {
            String string = JaiI18N.getString("GIFImageDecoder0");
            ImagingListenerProxy.errorOccurred(string, new ImagingException(string, iOException), class$com$sun$media$jai$codecimpl$GIFImageDecoder == null ? (class$com$sun$media$jai$codecimpl$GIFImageDecoder = GIFImageDecoder.class$("com.sun.media.jai.codecimpl.GIFImageDecoder")) : class$com$sun$media$jai$codecimpl$GIFImageDecoder, false);
        }
        return byArray;
    }

    public GIFImageDecoder(SeekableStream seekableStream, ImageDecodeParam imageDecodeParam) {
        super(seekableStream, imageDecodeParam);
    }

    public GIFImageDecoder(InputStream inputStream, ImageDecodeParam imageDecodeParam) {
        super(inputStream, imageDecodeParam);
    }

    public int getNumPages() throws IOException {
        int n2 = this.prevPage + 1;
        while (!this.maxPageFound) {
            try {
                this.decodeAsRenderedImage(n2++);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return this.maxPage + 1;
    }

    public synchronized RenderedImage decodeAsRenderedImage(int n2) throws IOException {
        if (n2 < 0 || this.maxPageFound && n2 > this.maxPage) {
            throw new IOException(JaiI18N.getString("GIFImageDecoder1"));
        }
        Integer n3 = new Integer(n2);
        if (this.images.containsKey(n3)) {
            return (RenderedImage)this.images.get(n3);
        }
        if (this.prevPage == -1) {
            try {
                this.globalColorTable = GIFImageDecoder.readHeader(this.input);
            }
            catch (IOException iOException) {
                this.maxPageFound = true;
                this.maxPage = -1;
                throw iOException;
            }
        }
        if (n2 > 0) {
            int n4 = this.prevSyncedPage + 1;
            while (n4 < n2) {
                RenderedImage renderedImage = (RenderedImage)this.images.get(new Integer(n4));
                renderedImage.getTile(0, 0);
                this.prevSyncedPage = n4++;
            }
        }
        GIFImage gIFImage = null;
        while (this.prevPage < n2) {
            int n5 = this.prevPage + 1;
            GIFImage gIFImage2 = null;
            try {
                gIFImage2 = new GIFImage(this.input, this.globalColorTable);
                this.images.put(new Integer(n5), gIFImage2);
                if (n5 < n2) {
                    gIFImage2.getTile(0, 0);
                    this.prevSyncedPage = n5;
                }
                this.prevPage = n5;
                if (n5 != n2) continue;
                gIFImage = gIFImage2;
                break;
            }
            catch (IOException iOException) {
                this.maxPageFound = true;
                this.maxPage = this.prevPage;
                String string = JaiI18N.getString("GIFImage3");
                ImagingListenerProxy.errorOccurred(string, new ImagingException(string, iOException), this, false);
            }
        }
        return gIFImage;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

