/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jai.codecimpl;

import com.sun.media.jai.codec.ImageCodec;
import com.sun.media.jai.codec.SeekableStream;
import com.sun.media.jai.codecimpl.ImagingListenerProxy;
import com.sun.media.jai.codecimpl.JaiI18N;
import com.sun.media.jai.codecimpl.SimpleRenderedImage;
import com.sun.media.jai.codecimpl.util.ImagingException;
import com.sun.media.jai.codecimpl.util.RasterFactory;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferInt;
import java.awt.image.DataBufferUShort;
import java.awt.image.MultiPixelPackedSampleModel;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import java.io.IOException;
import java.security.AccessController;
import sun.security.action.GetPropertyAction;

class PNMImage
extends SimpleRenderedImage {
    private static final int PBM_ASCII = 49;
    private static final int PGM_ASCII = 50;
    private static final int PPM_ASCII = 51;
    private static final int PBM_RAW = 52;
    private static final int PGM_RAW = 53;
    private static final int PPM_RAW = 54;
    private static final int LINE_FEED = 10;
    private SeekableStream input;
    private byte[] lineSeparator;
    private int variant;
    private int maxValue;
    private Raster theTile = null;
    private int numBands;
    private int dataType;

    public PNMImage(SeekableStream seekableStream) {
        this.input = seekableStream;
        String string = AccessController.doPrivileged(new GetPropertyAction("line.separator"));
        this.lineSeparator = string.getBytes();
        try {
            if (this.input.read() != 80) {
                throw new RuntimeException(JaiI18N.getString("PNMImageDecoder0"));
            }
            this.variant = this.input.read();
            if (this.variant < 49 || this.variant > 54) {
                throw new RuntimeException(JaiI18N.getString("PNMImageDecoder1"));
            }
            this.width = this.readInteger(this.input);
            this.height = this.readInteger(this.input);
            this.maxValue = this.variant == 49 || this.variant == 52 ? 1 : this.readInteger(this.input);
        }
        catch (IOException iOException) {
            String string2 = JaiI18N.getString("PNMImageDecoder6");
            this.sendExceptionToListener(string2, iOException);
        }
        if (this.isRaw(this.variant) && this.maxValue >= 256) {
            this.maxValue = 255;
        }
        this.tileWidth = this.width;
        this.tileHeight = this.height;
        this.numBands = this.variant == 51 || this.variant == 54 ? 3 : 1;
        this.dataType = this.maxValue < 256 ? 0 : (this.maxValue < 65536 ? 1 : 3);
        if (this.variant == 49 || this.variant == 52) {
            this.sampleModel = new MultiPixelPackedSampleModel(0, this.width, this.height, 1);
            this.colorModel = ImageCodec.createGrayIndexColorModel(this.sampleModel, false);
        } else {
            int[] nArray;
            if (this.numBands == 1) {
                int[] nArray2 = new int[1];
                nArray = nArray2;
                nArray2[0] = 0;
            } else {
                int[] nArray3 = new int[3];
                nArray3[0] = 0;
                nArray3[1] = 1;
                nArray = nArray3;
                nArray3[2] = 2;
            }
            int[] nArray4 = nArray;
            this.sampleModel = RasterFactory.createPixelInterleavedSampleModel(this.dataType, this.tileWidth, this.tileHeight, this.numBands, this.tileWidth * this.numBands, nArray4);
            this.colorModel = ImageCodec.createComponentColorModel(this.sampleModel);
        }
    }

    private boolean isRaw(int n2) {
        return n2 >= 52;
    }

    private int readInteger(SeekableStream seekableStream) throws IOException {
        int n2;
        int n3 = 0;
        boolean bl2 = false;
        while ((n2 = seekableStream.read()) != -1) {
            char c2 = (char)n2;
            if (Character.isDigit(c2)) {
                n3 = n3 * 10 + Character.digit(c2, 10);
                bl2 = true;
                continue;
            }
            if (c2 == '#') {
                int n4 = this.lineSeparator.length;
                while ((n2 = seekableStream.read()) != -1) {
                    boolean bl3 = false;
                    int n5 = 0;
                    while (n5 < n4) {
                        if (n2 == this.lineSeparator[n5]) {
                            bl3 = true;
                            break;
                        }
                        ++n5;
                    }
                    if (bl3) break;
                }
                if (n2 == -1) break;
            }
            if (bl2) break;
        }
        return n3;
    }

    private Raster computeTile(int n2, int n3) {
        Point point = new Point(this.tileXToX(n2), this.tileYToY(n3));
        WritableRaster writableRaster = Raster.createWritableRaster(this.sampleModel, point);
        Rectangle rectangle = writableRaster.getBounds();
        try {
            block18: {
                block1 : switch (this.variant) {
                    case 49: 
                    case 52: {
                        DataBuffer dataBuffer = writableRaster.getDataBuffer();
                        if (this.isRaw(this.variant)) {
                            byte[] byArray = ((DataBufferByte)dataBuffer).getData();
                            this.input.readFully(byArray, 0, byArray.length);
                            break;
                        }
                        byte[] byArray = new byte[8 * this.width];
                        boolean bl2 = false;
                        int n4 = 0;
                        while (n4 < this.tileHeight) {
                            int n5 = Math.min(8, this.tileHeight - n4);
                            int n6 = (n5 * this.width + 7) / 8;
                            int n7 = 0;
                            while (n7 < n5 * this.width) {
                                byArray[n7] = (byte)this.readInteger(this.input);
                                ++n7;
                            }
                            this.sampleModel.setDataElements(rectangle.x, n4, rectangle.width, n5, byArray, dataBuffer);
                            n4 += 8;
                        }
                        break;
                    }
                    case 50: 
                    case 51: 
                    case 53: 
                    case 54: {
                        int n8 = this.width * this.height * this.numBands;
                        switch (this.dataType) {
                            case 0: {
                                DataBufferByte dataBufferByte = (DataBufferByte)writableRaster.getDataBuffer();
                                byte[] byArray = dataBufferByte.getData();
                                if (this.isRaw(this.variant)) {
                                    this.input.readFully(byArray);
                                    break block1;
                                }
                                int n9 = 0;
                                while (n9 < n8) {
                                    byArray[n9] = (byte)this.readInteger(this.input);
                                    ++n9;
                                }
                                break block18;
                            }
                            case 1: {
                                DataBufferUShort dataBufferUShort = (DataBufferUShort)writableRaster.getDataBuffer();
                                short[] sArray = dataBufferUShort.getData();
                                int n10 = 0;
                                while (n10 < n8) {
                                    sArray[n10] = (short)this.readInteger(this.input);
                                    ++n10;
                                }
                                break block18;
                            }
                            case 3: {
                                DataBufferInt dataBufferInt = (DataBufferInt)writableRaster.getDataBuffer();
                                int[] nArray = dataBufferInt.getData();
                                int n11 = 0;
                                while (n11 < n8) {
                                    nArray[n11] = this.readInteger(this.input);
                                    ++n11;
                                }
                                break block1;
                            }
                        }
                    }
                }
            }
            this.input.close();
        }
        catch (IOException iOException) {
            String string = JaiI18N.getString("PNMImageDecoder7");
            this.sendExceptionToListener(string, iOException);
        }
        return writableRaster;
    }

    public synchronized Raster getTile(int n2, int n3) {
        if (n2 != 0 || n3 != 0) {
            throw new IllegalArgumentException(JaiI18N.getString("PNMImageDecoder4"));
        }
        if (this.theTile == null) {
            this.theTile = this.computeTile(n2, n3);
        }
        return this.theTile;
    }

    private void sendExceptionToListener(String string, Exception exception) {
        ImagingListenerProxy.errorOccurred(string, new ImagingException(string, exception), this, false);
    }
}

