/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jai.codecimpl;

import com.sun.image.codec.jpeg.JPEGCodec;
import com.sun.image.codec.jpeg.JPEGDecodeParam;
import com.sun.image.codec.jpeg.JPEGImageDecoder;
import com.sun.media.jai.codec.ImageCodec;
import com.sun.media.jai.codec.SeekableStream;
import com.sun.media.jai.codec.TIFFDecodeParam;
import com.sun.media.jai.codec.TIFFDirectory;
import com.sun.media.jai.codec.TIFFField;
import com.sun.media.jai.codecimpl.ImagingListenerProxy;
import com.sun.media.jai.codecimpl.JaiI18N;
import com.sun.media.jai.codecimpl.SimpleRenderedImage;
import com.sun.media.jai.codecimpl.TIFFFaxDecoder;
import com.sun.media.jai.codecimpl.TIFFLZWDecoder;
import com.sun.media.jai.codecimpl.util.DataBufferFloat;
import com.sun.media.jai.codecimpl.util.FloatDoubleColorModel;
import com.sun.media.jai.codecimpl.util.ImagingException;
import com.sun.media.jai.codecimpl.util.RasterFactory;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.color.ColorSpace;
import java.awt.image.ComponentColorModel;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferInt;
import java.awt.image.DataBufferShort;
import java.awt.image.DataBufferUShort;
import java.awt.image.IndexColorModel;
import java.awt.image.MultiPixelPackedSampleModel;
import java.awt.image.Raster;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.text.MessageFormat;
import java.util.Locale;
import java.util.zip.DataFormatException;
import java.util.zip.Inflater;

public class TIFFImage
extends SimpleRenderedImage {
    public static final int COMP_NONE = 1;
    public static final int COMP_FAX_G3_1D = 2;
    public static final int COMP_FAX_G3_2D = 3;
    public static final int COMP_FAX_G4_2D = 4;
    public static final int COMP_LZW = 5;
    public static final int COMP_JPEG_OLD = 6;
    public static final int COMP_JPEG_TTN2 = 7;
    public static final int COMP_PACKBITS = 32773;
    public static final int COMP_DEFLATE = 32946;
    private static final int TYPE_UNSUPPORTED = -1;
    private static final int TYPE_BILEVEL = 0;
    private static final int TYPE_GRAY_4BIT = 1;
    private static final int TYPE_GRAY = 2;
    private static final int TYPE_GRAY_ALPHA = 3;
    private static final int TYPE_PALETTE = 4;
    private static final int TYPE_RGB = 5;
    private static final int TYPE_RGB_ALPHA = 6;
    private static final int TYPE_YCBCR_SUB = 7;
    private static final int TYPE_GENERIC = 8;
    private static final int TIFF_JPEG_TABLES = 347;
    private static final int TIFF_YCBCR_SUBSAMPLING = 530;
    SeekableStream stream;
    private boolean isTiled;
    int tileSize;
    int tilesX;
    int tilesY;
    long[] tileOffsets;
    long[] tileByteCounts;
    char[] colormap;
    int sampleSize;
    int compression;
    byte[] palette;
    int numBands;
    int chromaSubH;
    int chromaSubV;
    long tiffT4Options;
    long tiffT6Options;
    int fillOrder;
    int predictor;
    JPEGDecodeParam decodeParam = null;
    boolean colorConvertJPEG = false;
    Inflater inflater = null;
    boolean isBigEndian;
    int imageType;
    boolean isWhiteZero = false;
    int dataType;
    boolean decodePaletteAsShorts;
    private TIFFFaxDecoder decoder = null;
    private TIFFLZWDecoder lzwDecoder = null;
    static /* synthetic */ Class class$com$sun$media$jai$codecimpl$TIFFImage;
    static /* synthetic */ Class array$I;

    private static final Raster decodeJPEG(byte[] byArray, JPEGDecodeParam jPEGDecodeParam, boolean bl2, int n2, int n3) {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        JPEGImageDecoder jPEGImageDecoder = jPEGDecodeParam == null ? JPEGCodec.createJPEGDecoder((InputStream)byteArrayInputStream) : JPEGCodec.createJPEGDecoder((InputStream)byteArrayInputStream, (JPEGDecodeParam)jPEGDecodeParam);
        Raster raster = null;
        try {
            raster = bl2 ? jPEGImageDecoder.decodeAsBufferedImage().getWritableTile(0, 0) : jPEGImageDecoder.decodeAsRaster();
        }
        catch (IOException iOException) {
            String string = JaiI18N.getString("TIFFImage13");
            ImagingListenerProxy.errorOccurred(string, new ImagingException(string, iOException), class$com$sun$media$jai$codecimpl$TIFFImage == null ? (class$com$sun$media$jai$codecimpl$TIFFImage = TIFFImage.class$("com.sun.media.jai.codecimpl.TIFFImage")) : class$com$sun$media$jai$codecimpl$TIFFImage, false);
        }
        return raster.createTranslatedChild(n2, n3);
    }

    private final void inflate(byte[] byArray, byte[] byArray2) {
        this.inflater.setInput(byArray);
        try {
            this.inflater.inflate(byArray2);
        }
        catch (DataFormatException dataFormatException) {
            String string = JaiI18N.getString("TIFFImage17");
            ImagingListenerProxy.errorOccurred(string, new ImagingException(string, dataFormatException), this, false);
        }
        this.inflater.reset();
    }

    private static final SampleModel createPixelInterleavedSampleModel(int n2, int n3, int n4, int n5, int n6, int[] nArray) {
        SampleModel sampleModel = null;
        if (n2 == 4) {
            try {
                Class<?> clazz = Class.forName("javax.media.jai.RasterFactory");
                Class[] classArray = new Class[]{Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, array$I == null ? (array$I = TIFFImage.class$("[I")) : array$I};
                Method method = clazz.getMethod("createPixelInterleavedSampleModel", classArray);
                Object[] objectArray = new Object[]{new Integer(n2), new Integer(n3), new Integer(n4), new Integer(n5), new Integer(n6), nArray};
                sampleModel = (SampleModel)method.invoke(null, objectArray);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (n2 != 4 || sampleModel == null) {
            sampleModel = RasterFactory.createPixelInterleavedSampleModel(n2, n3, n4, n5, n6, nArray);
        }
        return sampleModel;
    }

    private final long[] getFieldAsLongs(TIFFField tIFFField) {
        long[] lArray = null;
        if (tIFFField.getType() == 3) {
            char[] cArray = tIFFField.getAsChars();
            lArray = new long[cArray.length];
            int n2 = 0;
            while (n2 < cArray.length) {
                lArray[n2] = cArray[n2] & 0xFFFF;
                ++n2;
            }
        } else if (tIFFField.getType() == 4) {
            lArray = tIFFField.getAsLongs();
        } else {
            throw new RuntimeException();
        }
        return lArray;
    }

    private TIFFField getField(TIFFDirectory tIFFDirectory, int n2, String string) {
        TIFFField tIFFField = tIFFDirectory.getField(n2);
        if (tIFFField == null) {
            MessageFormat messageFormat = new MessageFormat(JaiI18N.getString("TIFFImage5"));
            messageFormat.setLocale(Locale.getDefault());
            throw new RuntimeException(messageFormat.format(new Object[]{string}));
        }
        return tIFFField;
    }

    public TIFFImage(SeekableStream seekableStream, TIFFDecodeParam tIFFDecodeParam, int n2) throws IOException {
        int n3;
        int n4;
        Object object;
        TIFFField tIFFField;
        TIFFField tIFFField2;
        int n5;
        TIFFField tIFFField3;
        int n6;
        char[] cArray;
        char[] cArray2;
        this.stream = seekableStream;
        if (tIFFDecodeParam == null) {
            tIFFDecodeParam = new TIFFDecodeParam();
        }
        this.decodePaletteAsShorts = tIFFDecodeParam.getDecodePaletteAsShorts();
        TIFFDirectory tIFFDirectory = tIFFDecodeParam.getIFDOffset() == null ? new TIFFDirectory(seekableStream, n2) : new TIFFDirectory(seekableStream, tIFFDecodeParam.getIFDOffset(), n2);
        this.properties.put("tiff_directory", tIFFDirectory);
        TIFFField tIFFField4 = tIFFDirectory.getField(277);
        int n7 = tIFFField4 == null ? 1 : (int)tIFFField4.getAsLong(0);
        TIFFField tIFFField5 = tIFFDirectory.getField(284);
        if (tIFFField5 == null) {
            char[] cArray3 = new char[1];
            cArray2 = cArray3;
            cArray3[0] = '\u0001';
        } else {
            cArray2 = cArray = tIFFField5.getAsChars();
        }
        if (cArray[0] != '\u0001' && n7 != 1) {
            throw new RuntimeException(JaiI18N.getString("TIFFImage0"));
        }
        TIFFField tIFFField6 = tIFFDirectory.getField(258);
        char[] cArray4 = null;
        if (tIFFField6 != null) {
            cArray4 = tIFFField6.getAsChars();
        } else {
            cArray4 = new char[]{'\u0001'};
            int n8 = 1;
            while (n8 < cArray4.length) {
                if (cArray4[n8] != cArray4[0]) {
                    throw new RuntimeException(JaiI18N.getString("TIFFImage1"));
                }
                ++n8;
            }
        }
        this.sampleSize = cArray4[0];
        TIFFField tIFFField7 = tIFFDirectory.getField(339);
        char[] cArray5 = null;
        if (tIFFField7 != null) {
            cArray5 = tIFFField7.getAsChars();
            n6 = 1;
            while (n6 < cArray5.length) {
                if (cArray5[n6] != cArray5[0]) {
                    throw new RuntimeException(JaiI18N.getString("TIFFImage2"));
                }
                ++n6;
            }
        } else {
            cArray5 = new char[]{'\u0001'};
        }
        n6 = 0;
        switch (this.sampleSize) {
            case 1: 
            case 4: 
            case 8: {
                if (cArray5[0] == '\u0003') break;
                this.dataType = 0;
                n6 = 1;
                break;
            }
            case 16: {
                if (cArray5[0] == '\u0003') break;
                this.dataType = cArray5[0] == '\u0002' ? 2 : 1;
                n6 = 1;
                break;
            }
            case 32: {
                this.dataType = cArray5[0] == '\u0003' ? 4 : 3;
                n6 = 1;
            }
        }
        if (n6 == 0) {
            throw new RuntimeException(JaiI18N.getString("TIFFImage3"));
        }
        TIFFField tIFFField8 = tIFFDirectory.getField(259);
        this.compression = tIFFField8 == null ? 1 : tIFFField8.getAsInt(0);
        TIFFField tIFFField9 = tIFFDirectory.getField(262);
        int n9 = tIFFField9 != null ? (int)tIFFField9.getAsLong(0) : (tIFFDirectory.getField(320) != null ? 3 : (this.sampleSize == 1 ? (this.compression == 2 || this.compression == 3 || this.compression == 4 ? 0 : 1) : (n7 == 3 || n7 == 4 ? 2 : 1)));
        this.imageType = -1;
        switch (n9) {
            case 0: {
                this.isWhiteZero = true;
            }
            case 1: {
                if (this.sampleSize == 1 && n7 == 1) {
                    this.imageType = 0;
                    break;
                }
                if (this.sampleSize == 4 && n7 == 1) {
                    this.imageType = 1;
                    break;
                }
                if (this.sampleSize % 8 != 0) break;
                if (n7 == 1) {
                    this.imageType = 2;
                    break;
                }
                if (n7 == 2) {
                    this.imageType = 3;
                    break;
                }
                this.imageType = 8;
                break;
            }
            case 2: {
                if (this.sampleSize % 8 != 0) break;
                if (n7 == 3) {
                    this.imageType = 5;
                    break;
                }
                if (n7 == 4) {
                    this.imageType = 6;
                    break;
                }
                this.imageType = 8;
                break;
            }
            case 3: {
                if (n7 != 1 || this.sampleSize != 4 && this.sampleSize != 8 && this.sampleSize != 16) break;
                this.imageType = 4;
                break;
            }
            case 4: {
                if (this.sampleSize != 1 || n7 != 1) break;
                this.imageType = 0;
                break;
            }
            case 6: {
                if (this.compression == 7 && this.sampleSize == 8 && n7 == 3) {
                    this.colorConvertJPEG = tIFFDecodeParam.getJPEGDecompressYCbCrToRGB();
                    this.imageType = this.colorConvertJPEG ? 5 : 8;
                    break;
                }
                tIFFField3 = tIFFDirectory.getField(530);
                if (tIFFField3 != null) {
                    this.chromaSubH = tIFFField3.getAsInt(0);
                    this.chromaSubV = tIFFField3.getAsInt(1);
                } else {
                    this.chromaSubV = 2;
                    this.chromaSubH = 2;
                }
                if (this.chromaSubH * this.chromaSubV == 1) {
                    this.imageType = 8;
                    break;
                }
                if (this.sampleSize != 8 || n7 != 3) break;
                this.imageType = 7;
                break;
            }
            default: {
                if (this.sampleSize % 8 != 0) break;
                this.imageType = 8;
            }
        }
        if (this.imageType == -1) {
            throw new RuntimeException(JaiI18N.getString("TIFFImage4"));
        }
        this.minY = 0;
        this.minX = 0;
        this.width = (int)this.getField(tIFFDirectory, 256, "Image Width").getAsLong(0);
        this.height = (int)this.getField(tIFFDirectory, 257, "Image Length").getAsLong(0);
        this.numBands = n7;
        tIFFField3 = tIFFDirectory.getField(338);
        int n10 = n5 = tIFFField3 == null ? 0 : (int)tIFFField3.getAsLong(0);
        if (tIFFDirectory.getField(324) != null) {
            this.isTiled = true;
            this.tileWidth = (int)this.getField(tIFFDirectory, 322, "Tile Width").getAsLong(0);
            this.tileHeight = (int)this.getField(tIFFDirectory, 323, "Tile Length").getAsLong(0);
            this.tileOffsets = this.getField(tIFFDirectory, 324, "Tile Offsets").getAsLongs();
            this.tileByteCounts = this.getFieldAsLongs(this.getField(tIFFDirectory, 325, "Tile Byte Counts"));
        } else {
            this.isTiled = false;
            this.tileWidth = tIFFDirectory.getField(322) != null ? (int)tIFFDirectory.getFieldAsLong(322) : this.width;
            tIFFField2 = tIFFDirectory.getField(278);
            if (tIFFField2 == null) {
                this.tileHeight = tIFFDirectory.getField(323) != null ? (int)tIFFDirectory.getFieldAsLong(323) : this.height;
            } else {
                long l2 = tIFFField2.getAsLong(0);
                long l3 = 1L;
                this.tileHeight = l2 == (l3 = (l3 << 32) - 1L) || l2 > (long)this.height ? this.height : (int)l2;
            }
            tIFFField = this.getField(tIFFDirectory, 273, "Strip Offsets");
            this.tileOffsets = this.getFieldAsLongs(tIFFField);
            object = tIFFDirectory.getField(279);
            if (object == null) {
                if (this.compression == 1) {
                    int n11 = (this.sampleSize + 7) / 8 * this.numBands * this.width * this.height;
                    n4 = (this.sampleSize + 7) / 8 * this.numBands * this.width * this.tileHeight;
                    int n12 = 0;
                    this.tileByteCounts = new long[this.tileOffsets.length];
                    n3 = 0;
                    while (n3 < this.tileOffsets.length) {
                        this.tileByteCounts[n3] = Math.min(n11 - n12, n4);
                        n12 += n4;
                        ++n3;
                    }
                } else {
                    object = this.getField(tIFFDirectory, 279, "Strip Byte Counts");
                }
            } else {
                this.tileByteCounts = this.getFieldAsLongs((TIFFField)object);
            }
            int n13 = this.width * this.height * this.numBands * ((this.sampleSize + 7) / 8);
            if (this.tileByteCounts.length == 1 && this.compression == 1 && this.tileByteCounts[0] > (long)n13) {
                this.tileByteCounts[0] = n13;
            }
        }
        this.tilesX = (this.width + this.tileWidth - 1) / this.tileWidth;
        this.tilesY = (this.height + this.tileHeight - 1) / this.tileHeight;
        this.tileSize = this.tileWidth * this.tileHeight * this.numBands;
        this.isBigEndian = tIFFDirectory.isBigEndian();
        tIFFField2 = tIFFDirectory.getField(266);
        this.fillOrder = tIFFField2 != null ? tIFFField2.getAsInt(0) : 1;
        switch (this.compression) {
            case 1: 
            case 32773: {
                break;
            }
            case 32946: {
                this.inflater = new Inflater();
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                if (this.sampleSize != 1) {
                    throw new RuntimeException(JaiI18N.getString("TIFFImage7"));
                }
                if (this.compression == 3) {
                    tIFFField = tIFFDirectory.getField(292);
                    this.tiffT4Options = tIFFField != null ? tIFFField.getAsLong(0) : 0L;
                }
                if (this.compression == 4) {
                    tIFFField = tIFFDirectory.getField(293);
                    this.tiffT6Options = tIFFField != null ? tIFFField.getAsLong(0) : 0L;
                }
                this.decoder = new TIFFFaxDecoder(this.fillOrder, this.tileWidth, this.tileHeight);
                break;
            }
            case 5: {
                tIFFField = tIFFDirectory.getField(317);
                if (tIFFField == null) {
                    this.predictor = 1;
                } else {
                    this.predictor = tIFFField.getAsInt(0);
                    if (this.predictor != 1 && this.predictor != 2) {
                        throw new RuntimeException(JaiI18N.getString("TIFFImage8"));
                    }
                    if (this.predictor == 2 && this.sampleSize != 8) {
                        throw new RuntimeException(this.sampleSize + JaiI18N.getString("TIFFImage9"));
                    }
                }
                this.lzwDecoder = new TIFFLZWDecoder(this.tileWidth, this.predictor, n7);
                break;
            }
            case 6: {
                throw new RuntimeException(JaiI18N.getString("TIFFImage15"));
            }
            case 7: {
                if (!(this.sampleSize == 8 && (this.imageType == 2 && n7 == 1 || this.imageType == 4 && n7 == 1 || this.imageType == 5 && n7 == 3))) {
                    throw new RuntimeException(JaiI18N.getString("TIFFImage16"));
                }
                if (!tIFFDirectory.isTagPresent(347)) break;
                object = tIFFDirectory.getField(347);
                byte[] byArray = ((TIFFField)object).getAsBytes();
                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
                JPEGImageDecoder jPEGImageDecoder = JPEGCodec.createJPEGDecoder((InputStream)byteArrayInputStream);
                jPEGImageDecoder.decodeAsRaster();
                this.decodeParam = jPEGImageDecoder.getJPEGDecodeParam();
                break;
            }
            default: {
                throw new RuntimeException(JaiI18N.getString("TIFFImage10"));
            }
        }
        switch (this.imageType) {
            case 0: 
            case 1: {
                this.sampleModel = new MultiPixelPackedSampleModel(this.dataType, this.tileWidth, this.tileHeight, this.sampleSize);
                if (this.imageType == 0) {
                    object = new byte[]{this.isWhiteZero ? (byte)-1 : 0, this.isWhiteZero ? (byte)0 : -1};
                    this.colorModel = new IndexColorModel(1, 2, (byte[])object, (byte[])object, (byte[])object);
                    break;
                }
                this.colorModel = ImageCodec.createGrayIndexColorModel(this.sampleModel, !this.isWhiteZero);
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: {
                int n14;
                object = new int[this.numBands];
                if (this.compression == 7) {
                    n14 = 0;
                    while (n14 < this.numBands) {
                        object[n14] = this.numBands - 1 - n14;
                        ++n14;
                    }
                } else {
                    n14 = 0;
                    while (n14 < this.numBands) {
                        object[n14] = n14;
                        ++n14;
                    }
                }
                this.sampleModel = TIFFImage.createPixelInterleavedSampleModel(this.dataType, this.tileWidth, this.tileHeight, this.numBands, this.numBands * this.tileWidth, (int[])object);
                if (this.imageType == 2 || this.imageType == 5) {
                    this.colorModel = ImageCodec.createComponentColorModel(this.sampleModel);
                    break;
                }
                n14 = 1;
                if (n5 == 1 || n5 == 2) {
                    n14 = 3;
                }
                this.colorModel = this.createAlphaComponentColorModel(this.dataType, this.numBands, n5 == 1, n14);
                break;
            }
            case 7: 
            case 8: {
                int[] nArray = new int[this.numBands];
                n4 = 0;
                while (n4 < this.numBands) {
                    nArray[n4] = n4;
                    ++n4;
                }
                this.sampleModel = TIFFImage.createPixelInterleavedSampleModel(this.dataType, this.tileWidth, this.tileHeight, this.numBands, this.numBands * this.tileWidth, nArray);
                this.colorModel = null;
                break;
            }
            case 4: {
                TIFFField tIFFField10 = this.getField(tIFFDirectory, 320, "Colormap");
                this.colormap = tIFFField10.getAsChars();
                if (this.decodePaletteAsShorts) {
                    this.numBands = 3;
                    if (this.dataType == 0) {
                        this.dataType = 1;
                    }
                    this.sampleModel = RasterFactory.createPixelInterleavedSampleModel(this.dataType, this.tileWidth, this.tileHeight, this.numBands);
                    this.colorModel = ImageCodec.createComponentColorModel(this.sampleModel);
                    break;
                }
                this.numBands = 1;
                if (this.sampleSize == 4) {
                    this.sampleModel = new MultiPixelPackedSampleModel(0, this.tileWidth, this.tileHeight, this.sampleSize);
                } else if (this.sampleSize == 8) {
                    this.sampleModel = RasterFactory.createPixelInterleavedSampleModel(0, this.tileWidth, this.tileHeight, this.numBands);
                } else if (this.sampleSize == 16) {
                    this.dataType = 1;
                    this.sampleModel = RasterFactory.createPixelInterleavedSampleModel(1, this.tileWidth, this.tileHeight, this.numBands);
                }
                n3 = this.colormap.length / 3;
                byte[] byArray = new byte[n3];
                byte[] byArray2 = new byte[n3];
                byte[] byArray3 = new byte[n3];
                int n15 = n3;
                int n16 = n3 * 2;
                if (this.dataType == 2) {
                    int n17 = 0;
                    while (n17 < n3) {
                        byArray[n17] = tIFFDecodeParam.decodeSigned16BitsTo8Bits((short)this.colormap[n17]);
                        byArray2[n17] = tIFFDecodeParam.decodeSigned16BitsTo8Bits((short)this.colormap[n15 + n17]);
                        byArray3[n17] = tIFFDecodeParam.decodeSigned16BitsTo8Bits((short)this.colormap[n16 + n17]);
                        ++n17;
                    }
                } else {
                    int n18 = 0;
                    while (n18 < n3) {
                        byArray[n18] = tIFFDecodeParam.decode16BitsTo8Bits(this.colormap[n18] & 0xFFFF);
                        byArray2[n18] = tIFFDecodeParam.decode16BitsTo8Bits(this.colormap[n15 + n18] & 0xFFFF);
                        byArray3[n18] = tIFFDecodeParam.decode16BitsTo8Bits(this.colormap[n16 + n18] & 0xFFFF);
                        ++n18;
                    }
                }
                this.colorModel = new IndexColorModel(this.sampleSize, n3, byArray, byArray2, byArray3);
                break;
            }
            default: {
                throw new RuntimeException("TIFFImage4");
            }
        }
    }

    public TIFFDirectory getPrivateIFD(long l2) throws IOException {
        return new TIFFDirectory(this.stream, l2, 0);
    }

    public synchronized Raster getTile(int n2, int n3) {
        byte[] byArray;
        Object object;
        Object object2;
        if (n2 < 0 || n2 >= this.tilesX || n3 < 0 || n3 >= this.tilesY) {
            throw new IllegalArgumentException(JaiI18N.getString("TIFFImage12"));
        }
        byte[] byArray2 = null;
        short[] sArray = null;
        int[] nArray = null;
        float[] fArray = null;
        DataBuffer dataBuffer = this.sampleModel.createDataBuffer();
        int n4 = this.sampleModel.getDataType();
        if (n4 == 0) {
            byArray2 = ((DataBufferByte)dataBuffer).getData();
        } else if (n4 == 1) {
            sArray = ((DataBufferUShort)dataBuffer).getData();
        } else if (n4 == 2) {
            sArray = ((DataBufferShort)dataBuffer).getData();
        } else if (n4 == 3) {
            nArray = ((DataBufferInt)dataBuffer).getData();
        } else if (n4 == 4) {
            if (dataBuffer instanceof DataBufferFloat) {
                fArray = ((DataBufferFloat)dataBuffer).getData();
            } else {
                try {
                    object2 = dataBuffer.getClass().getMethod("getData", null);
                    fArray = (float[])((Method)object2).invoke((Object)dataBuffer, null);
                }
                catch (Exception exception) {
                    String string = JaiI18N.getString("TIFFImage18");
                    ImagingListenerProxy.errorOccurred(string, new ImagingException(string, exception), this, false);
                }
            }
        }
        object2 = RasterFactory.createWritableRaster(this.sampleModel, dataBuffer, new Point(this.tileXToX(n2), this.tileYToY(n3)));
        long l2 = 0L;
        try {
            l2 = this.stream.getFilePointer();
            this.stream.seek(this.tileOffsets[n3 * this.tilesX + n2]);
        }
        catch (IOException iOException) {
            object = JaiI18N.getString("TIFFImage13");
            ImagingListenerProxy.errorOccurred((String)object, new ImagingException((String)object, iOException), this, false);
        }
        int n5 = (int)this.tileByteCounts[n3 * this.tilesX + n2];
        object = new Rectangle(this.tileXToX(n2), this.tileYToY(n3), this.tileWidth, this.tileHeight);
        Object object3 = this.isTiled ? object : ((Rectangle)object).intersection(this.getBounds());
        int n6 = ((Rectangle)object3).width * ((Rectangle)object3).height * this.numBands;
        Object object4 = byArray = (Object)(this.compression != 1 || this.imageType == 4 ? new byte[n5] : null);
        if (this.imageType == 0) {
            try {
                if (this.compression == 32773) {
                    this.stream.readFully(byArray, 0, n5);
                    int n7 = ((Rectangle)object3).width % 8 == 0 ? ((Rectangle)object3).width / 8 * ((Rectangle)object3).height : (((Rectangle)object3).width / 8 + 1) * ((Rectangle)object3).height;
                    this.decodePackbits(byArray, n7, byArray2);
                } else if (this.compression == 5) {
                    this.stream.readFully(byArray, 0, n5);
                    this.lzwDecoder.decode(byArray, byArray2, ((Rectangle)object3).height);
                } else if (this.compression == 2) {
                    this.stream.readFully(byArray, 0, n5);
                    this.decoder.decode1D(byArray2, byArray, 0, ((Rectangle)object3).height);
                } else if (this.compression == 3) {
                    this.stream.readFully(byArray, 0, n5);
                    this.decoder.decode2D(byArray2, byArray, 0, ((Rectangle)object3).height, this.tiffT4Options);
                } else if (this.compression == 4) {
                    this.stream.readFully(byArray, 0, n5);
                    this.decoder.decodeT6(byArray2, byArray, 0, ((Rectangle)object3).height, this.tiffT6Options);
                } else if (this.compression == 32946) {
                    this.stream.readFully(byArray, 0, n5);
                    this.inflate(byArray, byArray2);
                } else if (this.compression == 1) {
                    this.stream.readFully(byArray2, 0, n5);
                }
                this.stream.seek(l2);
            }
            catch (IOException iOException) {
                String string = JaiI18N.getString("TIFFImage13");
                ImagingListenerProxy.errorOccurred(string, new ImagingException(string, iOException), this, false);
            }
        } else if (this.imageType == 4) {
            if (this.sampleSize == 16) {
                if (this.decodePaletteAsShorts) {
                    short[] sArray2 = null;
                    int n8 = n6 / 3;
                    int n9 = n8 * 2;
                    try {
                        byte[] byArray3;
                        if (this.compression == 32773) {
                            this.stream.readFully(byArray, 0, n5);
                            byArray3 = new byte[n9];
                            this.decodePackbits(byArray, n9, byArray3);
                            sArray2 = new short[n8];
                            this.interpretBytesAsShorts(byArray3, sArray2, n8);
                        } else if (this.compression == 5) {
                            this.stream.readFully(byArray, 0, n5);
                            byArray3 = new byte[n9];
                            this.lzwDecoder.decode(byArray, byArray3, ((Rectangle)object3).height);
                            sArray2 = new short[n8];
                            this.interpretBytesAsShorts(byArray3, sArray2, n8);
                        } else if (this.compression == 32946) {
                            this.stream.readFully(byArray, 0, n5);
                            byArray3 = new byte[n9];
                            this.inflate(byArray, byArray3);
                            sArray2 = new short[n8];
                            this.interpretBytesAsShorts(byArray3, sArray2, n8);
                        } else if (this.compression == 1) {
                            sArray2 = new short[n5 / 2];
                            this.readShorts(n5 / 2, sArray2);
                        }
                        this.stream.seek(l2);
                    }
                    catch (IOException iOException) {
                        String string = JaiI18N.getString("TIFFImage13");
                        ImagingListenerProxy.errorOccurred(string, new ImagingException(string, iOException), this, false);
                    }
                    if (n4 == 1) {
                        int n10 = 0;
                        int n11 = this.colormap.length / 3;
                        int n12 = n11 * 2;
                        int n13 = 0;
                        while (n13 < n8) {
                            int n14 = sArray2[n13] & 0xFFFF;
                            char c2 = this.colormap[n14 + n12];
                            sArray[n10++] = (short)(c2 & 0xFFFF);
                            c2 = this.colormap[n14 + n11];
                            sArray[n10++] = (short)(c2 & 0xFFFF);
                            c2 = this.colormap[n14];
                            sArray[n10++] = (short)(c2 & 0xFFFF);
                            ++n13;
                        }
                    } else if (n4 == 2) {
                        int n15 = 0;
                        int n16 = this.colormap.length / 3;
                        int n17 = n16 * 2;
                        int n18 = 0;
                        while (n18 < n8) {
                            int n19 = sArray2[n18] & 0xFFFF;
                            char c3 = this.colormap[n19 + n17];
                            sArray[n15++] = (short)c3;
                            c3 = this.colormap[n19 + n16];
                            sArray[n15++] = (short)c3;
                            c3 = this.colormap[n19];
                            sArray[n15++] = (short)c3;
                            ++n18;
                        }
                    }
                } else {
                    try {
                        if (this.compression == 32773) {
                            this.stream.readFully(byArray, 0, n5);
                            int n20 = n6 * 2;
                            byte[] byArray4 = new byte[n20];
                            this.decodePackbits(byArray, n20, byArray4);
                            this.interpretBytesAsShorts(byArray4, sArray, n6);
                        } else if (this.compression == 5) {
                            this.stream.readFully(byArray, 0, n5);
                            byte[] byArray5 = new byte[n6 * 2];
                            this.lzwDecoder.decode(byArray, byArray5, ((Rectangle)object3).height);
                            this.interpretBytesAsShorts(byArray5, sArray, n6);
                        } else if (this.compression == 32946) {
                            this.stream.readFully(byArray, 0, n5);
                            byte[] byArray6 = new byte[n6 * 2];
                            this.inflate(byArray, byArray6);
                            this.interpretBytesAsShorts(byArray6, sArray, n6);
                        } else if (this.compression == 1) {
                            this.readShorts(n5 / 2, sArray);
                        }
                        this.stream.seek(l2);
                    }
                    catch (IOException iOException) {
                        String string = JaiI18N.getString("TIFFImage13");
                        ImagingListenerProxy.errorOccurred(string, new ImagingException(string, iOException), this, false);
                    }
                }
            } else if (this.sampleSize == 8) {
                if (this.decodePaletteAsShorts) {
                    int n21;
                    Object object5;
                    byte[] byArray7 = null;
                    int n22 = n6 / 3;
                    try {
                        if (this.compression == 32773) {
                            this.stream.readFully(byArray, 0, n5);
                            byArray7 = new byte[n22];
                            this.decodePackbits(byArray, n22, byArray7);
                        } else if (this.compression == 5) {
                            this.stream.readFully(byArray, 0, n5);
                            byArray7 = new byte[n22];
                            this.lzwDecoder.decode(byArray, byArray7, ((Rectangle)object3).height);
                        } else if (this.compression == 7) {
                            this.stream.readFully(byArray, 0, n5);
                            Raster raster = TIFFImage.decodeJPEG(byArray, this.decodeParam, this.colorConvertJPEG, ((Raster)object2).getMinX(), ((Raster)object2).getMinY());
                            object5 = new int[n22];
                            raster.getPixels(((Raster)object2).getMinX(), ((Raster)object2).getMinY(), ((Raster)object2).getWidth(), ((Raster)object2).getHeight(), (int[])object5);
                            byArray7 = new byte[n22];
                            n21 = 0;
                            while (n21 < n22) {
                                byArray7[n21] = (byte)object5[n21];
                                ++n21;
                            }
                        } else if (this.compression == 32946) {
                            this.stream.readFully(byArray, 0, n5);
                            byArray7 = new byte[n22];
                            this.inflate(byArray, byArray7);
                        } else if (this.compression == 1) {
                            byArray7 = new byte[n5];
                            this.stream.readFully(byArray7, 0, n5);
                        }
                        this.stream.seek(l2);
                    }
                    catch (IOException iOException) {
                        object5 = JaiI18N.getString("TIFFImage13");
                        ImagingListenerProxy.errorOccurred((String)object5, new ImagingException((String)object5, iOException), this, false);
                    }
                    int n23 = 0;
                    int n24 = this.colormap.length / 3;
                    int n25 = n24 * 2;
                    int n26 = 0;
                    while (n26 < n22) {
                        n21 = byArray7[n26] & 0xFF;
                        char c4 = this.colormap[n21 + n25];
                        sArray[n23++] = (short)(c4 & 0xFFFF);
                        c4 = this.colormap[n21 + n24];
                        sArray[n23++] = (short)(c4 & 0xFFFF);
                        c4 = this.colormap[n21];
                        sArray[n23++] = (short)(c4 & 0xFFFF);
                        ++n26;
                    }
                } else {
                    try {
                        if (this.compression == 32773) {
                            this.stream.readFully(byArray, 0, n5);
                            this.decodePackbits(byArray, n6, byArray2);
                        } else if (this.compression == 5) {
                            this.stream.readFully(byArray, 0, n5);
                            this.lzwDecoder.decode(byArray, byArray2, ((Rectangle)object3).height);
                        } else if (this.compression == 7) {
                            this.stream.readFully(byArray, 0, n5);
                            ((WritableRaster)object2).setRect(TIFFImage.decodeJPEG(byArray, this.decodeParam, this.colorConvertJPEG, ((Raster)object2).getMinX(), ((Raster)object2).getMinY()));
                        } else if (this.compression == 32946) {
                            this.stream.readFully(byArray, 0, n5);
                            this.inflate(byArray, byArray2);
                        } else if (this.compression == 1) {
                            this.stream.readFully(byArray2, 0, n5);
                        }
                        this.stream.seek(l2);
                    }
                    catch (IOException iOException) {
                        String string = JaiI18N.getString("TIFFImage13");
                        ImagingListenerProxy.errorOccurred(string, new ImagingException(string, iOException), this, false);
                    }
                }
            } else if (this.sampleSize == 4) {
                int n27 = ((Rectangle)object3).width % 2 == 0 ? 0 : 1;
                int n28 = (((Rectangle)object3).width / 2 + n27) * ((Rectangle)object3).height;
                if (this.decodePaletteAsShorts) {
                    int n29;
                    byte[] byArray8 = null;
                    try {
                        this.stream.readFully(byArray, 0, n5);
                        this.stream.seek(l2);
                    }
                    catch (IOException iOException) {
                        String string = JaiI18N.getString("TIFFImage13");
                        ImagingListenerProxy.errorOccurred(string, new ImagingException(string, iOException), this, false);
                    }
                    if (this.compression == 32773) {
                        byArray8 = new byte[n28];
                        this.decodePackbits(byArray, n28, byArray8);
                    } else if (this.compression == 5) {
                        byArray8 = new byte[n28];
                        this.lzwDecoder.decode(byArray, byArray8, ((Rectangle)object3).height);
                    } else if (this.compression == 32946) {
                        byArray8 = new byte[n28];
                        this.inflate(byArray, byArray8);
                    } else if (this.compression == 1) {
                        byArray8 = byArray;
                    }
                    int n30 = n6 / 3;
                    byArray = new byte[n30];
                    int n31 = 0;
                    int n32 = 0;
                    int n33 = 0;
                    while (n33 < ((Rectangle)object3).height) {
                        n29 = 0;
                        while (n29 < ((Rectangle)object3).width / 2) {
                            byArray[n32++] = (byte)((byArray8[n31] & 0xF0) >> 4);
                            byArray[n32++] = (byte)(byArray8[n31++] & 0xF);
                            ++n29;
                        }
                        if (n27 == 1) {
                            byArray[n32++] = (byte)((byArray8[n31++] & 0xF0) >> 4);
                        }
                        ++n33;
                    }
                    n29 = this.colormap.length / 3;
                    int n34 = n29 * 2;
                    int n35 = 0;
                    int n36 = 0;
                    while (n36 < n30) {
                        int n37 = byArray[n36] & 0xFF;
                        char c5 = this.colormap[n37 + n34];
                        sArray[n35++] = (short)(c5 & 0xFFFF);
                        c5 = this.colormap[n37 + n29];
                        sArray[n35++] = (short)(c5 & 0xFFFF);
                        c5 = this.colormap[n37];
                        sArray[n35++] = (short)(c5 & 0xFFFF);
                        ++n36;
                    }
                } else {
                    try {
                        if (this.compression == 32773) {
                            this.stream.readFully(byArray, 0, n5);
                            this.decodePackbits(byArray, n28, byArray2);
                        } else if (this.compression == 5) {
                            this.stream.readFully(byArray, 0, n5);
                            this.lzwDecoder.decode(byArray, byArray2, ((Rectangle)object3).height);
                        } else if (this.compression == 32946) {
                            this.stream.readFully(byArray, 0, n5);
                            this.inflate(byArray, byArray2);
                        } else if (this.compression == 1) {
                            this.stream.readFully(byArray2, 0, n5);
                        }
                        this.stream.seek(l2);
                    }
                    catch (IOException iOException) {
                        String string = JaiI18N.getString("TIFFImage13");
                        ImagingListenerProxy.errorOccurred(string, new ImagingException(string, iOException), this, false);
                    }
                }
            }
        } else if (this.imageType == 1) {
            try {
                if (this.compression == 32773) {
                    this.stream.readFully(byArray, 0, n5);
                    int n38 = ((Rectangle)object3).width % 8 == 0 ? ((Rectangle)object3).width / 2 * ((Rectangle)object3).height : (((Rectangle)object3).width / 2 + 1) * ((Rectangle)object3).height;
                    this.decodePackbits(byArray, n38, byArray2);
                } else if (this.compression == 5) {
                    this.stream.readFully(byArray, 0, n5);
                    this.lzwDecoder.decode(byArray, byArray2, ((Rectangle)object3).height);
                } else if (this.compression == 32946) {
                    this.stream.readFully(byArray, 0, n5);
                    this.inflate(byArray, byArray2);
                } else {
                    this.stream.readFully(byArray2, 0, n5);
                }
                this.stream.seek(l2);
            }
            catch (IOException iOException) {
                String string = JaiI18N.getString("TIFFImage13");
                ImagingListenerProxy.errorOccurred(string, new ImagingException(string, iOException), this, false);
            }
        } else {
            Object object6;
            try {
                if (this.sampleSize == 8) {
                    if (this.compression == 1) {
                        this.stream.readFully(byArray2, 0, n5);
                    } else if (this.compression == 5) {
                        this.stream.readFully(byArray, 0, n5);
                        this.lzwDecoder.decode(byArray, byArray2, ((Rectangle)object3).height);
                    } else if (this.compression == 32773) {
                        this.stream.readFully(byArray, 0, n5);
                        this.decodePackbits(byArray, n6, byArray2);
                    } else if (this.compression == 7) {
                        this.stream.readFully(byArray, 0, n5);
                        ((WritableRaster)object2).setRect(TIFFImage.decodeJPEG(byArray, this.decodeParam, this.colorConvertJPEG, ((Raster)object2).getMinX(), ((Raster)object2).getMinY()));
                    } else if (this.compression == 32946) {
                        this.stream.readFully(byArray, 0, n5);
                        this.inflate(byArray, byArray2);
                    }
                } else if (this.sampleSize == 16) {
                    if (this.compression == 1) {
                        this.readShorts(n5 / 2, sArray);
                    } else if (this.compression == 5) {
                        this.stream.readFully(byArray, 0, n5);
                        byte[] byArray9 = new byte[n6 * 2];
                        this.lzwDecoder.decode(byArray, byArray9, ((Rectangle)object3).height);
                        this.interpretBytesAsShorts(byArray9, sArray, n6);
                    } else if (this.compression == 32773) {
                        this.stream.readFully(byArray, 0, n5);
                        int n39 = n6 * 2;
                        object6 = new byte[n39];
                        this.decodePackbits(byArray, n39, (byte[])object6);
                        this.interpretBytesAsShorts((byte[])object6, sArray, n6);
                    } else if (this.compression == 32946) {
                        this.stream.readFully(byArray, 0, n5);
                        byte[] byArray10 = new byte[n6 * 2];
                        this.inflate(byArray, byArray10);
                        this.interpretBytesAsShorts(byArray10, sArray, n6);
                    }
                } else if (this.sampleSize == 32 && n4 == 3) {
                    if (this.compression == 1) {
                        this.readInts(n5 / 4, nArray);
                    } else if (this.compression == 5) {
                        this.stream.readFully(byArray, 0, n5);
                        byte[] byArray11 = new byte[n6 * 4];
                        this.lzwDecoder.decode(byArray, byArray11, ((Rectangle)object3).height);
                        this.interpretBytesAsInts(byArray11, nArray, n6);
                    } else if (this.compression == 32773) {
                        this.stream.readFully(byArray, 0, n5);
                        int n40 = n6 * 4;
                        object6 = new byte[n40];
                        this.decodePackbits(byArray, n40, (byte[])object6);
                        this.interpretBytesAsInts((byte[])object6, nArray, n6);
                    } else if (this.compression == 32946) {
                        this.stream.readFully(byArray, 0, n5);
                        byte[] byArray12 = new byte[n6 * 4];
                        this.inflate(byArray, byArray12);
                        this.interpretBytesAsInts(byArray12, nArray, n6);
                    }
                } else if (this.sampleSize == 32 && n4 == 4) {
                    if (this.compression == 1) {
                        this.readFloats(n5 / 4, fArray);
                    } else if (this.compression == 5) {
                        this.stream.readFully(byArray, 0, n5);
                        byte[] byArray13 = new byte[n6 * 4];
                        this.lzwDecoder.decode(byArray, byArray13, ((Rectangle)object3).height);
                        this.interpretBytesAsFloats(byArray13, fArray, n6);
                    } else if (this.compression == 32773) {
                        this.stream.readFully(byArray, 0, n5);
                        int n41 = n6 * 4;
                        object6 = new byte[n41];
                        this.decodePackbits(byArray, n41, (byte[])object6);
                        this.interpretBytesAsFloats((byte[])object6, fArray, n6);
                    } else if (this.compression == 32946) {
                        this.stream.readFully(byArray, 0, n5);
                        byte[] byArray14 = new byte[n6 * 4];
                        this.inflate(byArray, byArray14);
                        this.interpretBytesAsFloats(byArray14, fArray, n6);
                    }
                }
                this.stream.seek(l2);
            }
            catch (IOException iOException) {
                object6 = JaiI18N.getString("TIFFImage13");
                ImagingListenerProxy.errorOccurred((String)object6, new ImagingException((String)object6, iOException), this, false);
            }
            switch (this.imageType) {
                case 2: 
                case 3: {
                    if (!this.isWhiteZero) break;
                    if (n4 == 0 && !(this.colorModel instanceof IndexColorModel)) {
                        int n42 = 0;
                        while (n42 < byArray2.length) {
                            byArray2[n42] = (byte)(255 - byArray2[n42]);
                            n42 += this.numBands;
                        }
                    } else if (n4 == 1) {
                        int n43 = 65535;
                        int n44 = 0;
                        while (n44 < sArray.length) {
                            sArray[n44] = (short)(n43 - sArray[n44]);
                            n44 += this.numBands;
                        }
                    } else if (n4 == 2) {
                        int n45 = 0;
                        while (n45 < sArray.length) {
                            sArray[n45] = ~sArray[n45];
                            n45 += this.numBands;
                        }
                    } else {
                        if (n4 != 3) break;
                        long l3 = -1L;
                        int n46 = 0;
                        while (n46 < nArray.length) {
                            nArray[n46] = (int)(l3 - (long)nArray[n46]);
                            n46 += this.numBands;
                        }
                    }
                    break;
                }
                case 7: {
                    int n47 = this.chromaSubH * this.chromaSubV;
                    int n48 = ((Rectangle)object3).width / this.chromaSubH;
                    int n49 = ((Rectangle)object3).height / this.chromaSubV;
                    byte[] byArray15 = new byte[n48 * n49 * (n47 + 2)];
                    System.arraycopy(byArray2, 0, byArray15, 0, byArray15.length);
                    int n50 = n47 * 3;
                    int[] nArray2 = new int[n50];
                    int n51 = 0;
                    int n52 = n47;
                    int n53 = n52 + 1;
                    int n54 = ((Rectangle)object3).y;
                    int n55 = 0;
                    while (n55 < n49) {
                        int n56 = ((Rectangle)object3).x;
                        int n57 = 0;
                        while (n57 < n48) {
                            int n58 = byArray15[n51 + n52];
                            int n59 = byArray15[n51 + n53];
                            int n60 = 0;
                            while (n60 < n50) {
                                nArray2[n60++] = byArray15[n51++];
                                nArray2[n60++] = n58;
                                nArray2[n60++] = n59;
                            }
                            n51 += 2;
                            ((WritableRaster)object2).setPixels(n56, n54, this.chromaSubH, this.chromaSubV, nArray2);
                            n56 += this.chromaSubH;
                            ++n57;
                        }
                        n54 += this.chromaSubV;
                        ++n55;
                    }
                    break;
                }
            }
        }
        return object2;
    }

    private void readShorts(int n2, short[] sArray) {
        int n3 = 2 * n2;
        byte[] byArray = new byte[n3];
        try {
            this.stream.readFully(byArray, 0, n3);
        }
        catch (IOException iOException) {
            String string = JaiI18N.getString("TIFFImage13");
            ImagingListenerProxy.errorOccurred(string, new ImagingException(string, iOException), this, false);
        }
        this.interpretBytesAsShorts(byArray, sArray, n2);
    }

    private void readInts(int n2, int[] nArray) {
        int n3 = 4 * n2;
        byte[] byArray = new byte[n3];
        try {
            this.stream.readFully(byArray, 0, n3);
        }
        catch (IOException iOException) {
            String string = JaiI18N.getString("TIFFImage13");
            ImagingListenerProxy.errorOccurred(string, new ImagingException(string, iOException), this, false);
        }
        this.interpretBytesAsInts(byArray, nArray, n2);
    }

    private void readFloats(int n2, float[] fArray) {
        int n3 = 4 * n2;
        byte[] byArray = new byte[n3];
        try {
            this.stream.readFully(byArray, 0, n3);
        }
        catch (IOException iOException) {
            String string = JaiI18N.getString("TIFFImage13");
            ImagingListenerProxy.errorOccurred(string, new ImagingException(string, iOException), this, false);
        }
        this.interpretBytesAsFloats(byArray, fArray, n2);
    }

    private void interpretBytesAsShorts(byte[] byArray, short[] sArray, int n2) {
        int n3 = 0;
        if (this.isBigEndian) {
            int n4 = 0;
            while (n4 < n2) {
                int n5 = byArray[n3++] & 0xFF;
                int n6 = byArray[n3++] & 0xFF;
                sArray[n4] = (short)((n5 << 8) + n6);
                ++n4;
            }
        } else {
            int n7 = 0;
            while (n7 < n2) {
                int n8 = byArray[n3++] & 0xFF;
                int n9 = byArray[n3++] & 0xFF;
                sArray[n7] = (short)((n9 << 8) + n8);
                ++n7;
            }
        }
    }

    private void interpretBytesAsInts(byte[] byArray, int[] nArray, int n2) {
        int n3 = 0;
        if (this.isBigEndian) {
            int n4 = 0;
            while (n4 < n2) {
                nArray[n4] = (byArray[n3++] & 0xFF) << 24 | (byArray[n3++] & 0xFF) << 16 | (byArray[n3++] & 0xFF) << 8 | byArray[n3++] & 0xFF;
                ++n4;
            }
        } else {
            int n5 = 0;
            while (n5 < n2) {
                nArray[n5] = byArray[n3++] & 0xFF | (byArray[n3++] & 0xFF) << 8 | (byArray[n3++] & 0xFF) << 16 | (byArray[n3++] & 0xFF) << 24;
                ++n5;
            }
        }
    }

    private void interpretBytesAsFloats(byte[] byArray, float[] fArray, int n2) {
        int n3 = 0;
        if (this.isBigEndian) {
            int n4 = 0;
            while (n4 < n2) {
                int n5 = (byArray[n3++] & 0xFF) << 24 | (byArray[n3++] & 0xFF) << 16 | (byArray[n3++] & 0xFF) << 8 | byArray[n3++] & 0xFF;
                fArray[n4] = Float.intBitsToFloat(n5);
                ++n4;
            }
        } else {
            int n6 = 0;
            while (n6 < n2) {
                int n7 = byArray[n3++] & 0xFF | (byArray[n3++] & 0xFF) << 8 | (byArray[n3++] & 0xFF) << 16 | (byArray[n3++] & 0xFF) << 24;
                fArray[n6] = Float.intBitsToFloat(n7);
                ++n6;
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    private byte[] decodePackbits(byte[] var1_1, int var2_2, byte[] var3_3) {
        if (var3_3 == null) {
            var3_3 = new byte[var2_2];
        }
        var4_4 = 0;
        var5_5 = 0;
lbl5:
        // 3 sources

        try {
            while (var5_5 < var2_2) {
                block7: {
                    block6: {
                        if ((var7_7 = var1_1[var4_4++]) < 0 || var7_7 > 127) break block6;
                        var8_8 = 0;
                        while (var8_8 < var7_7 + 1) {
                            var3_3[var5_5++] = var1_1[var4_4++];
                            ++var8_8;
                        }
                        ** GOTO lbl5
                    }
                    if (var7_7 > -1 || var7_7 < -127) break block7;
                    var6_6 = var1_1[var4_4++];
                    var8_8 = 0;
                    while (var8_8 < -var7_7 + 1) {
                        var3_3[var5_5++] = var6_6;
                        ++var8_8;
                    }
                    ** GOTO lbl5
                }
                ++var4_4;
            }
        }
        catch (ArrayIndexOutOfBoundsException var8_9) {
            var9_10 = JaiI18N.getString("TIFFImage14");
            ImagingListenerProxy.errorOccurred(var9_10, new ImagingException(var9_10, var8_9), this, false);
        }
        return var3_3;
    }

    private ComponentColorModel createAlphaComponentColorModel(int n2, int n3, boolean bl2, int n4) {
        ComponentColorModel componentColorModel = null;
        int[] nArray = null;
        ColorSpace colorSpace = null;
        switch (n3) {
            case 2: {
                colorSpace = ColorSpace.getInstance(1003);
                break;
            }
            case 4: {
                colorSpace = ColorSpace.getInstance(1000);
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        if (n2 == 4) {
            componentColorModel = new FloatDoubleColorModel(colorSpace, true, bl2, n4, n2);
        } else {
            int n5 = 0;
            switch (n2) {
                case 0: {
                    n5 = 8;
                    break;
                }
                case 1: 
                case 2: {
                    n5 = 16;
                    break;
                }
                case 3: {
                    n5 = 32;
                    break;
                }
                default: {
                    throw new IllegalArgumentException();
                }
            }
            nArray = new int[n3];
            int n6 = 0;
            while (n6 < n3) {
                nArray[n6] = n5;
                ++n6;
            }
            componentColorModel = new ComponentColorModel(colorSpace, nArray, true, bl2, n4, n2);
        }
        return componentColorModel;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

