/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jai.codecimpl;

import com.sun.media.jai.codec.ImageEncodeParam;
import com.sun.media.jai.codec.ImageEncoderImpl;
import com.sun.media.jai.codecimpl.JaiI18N;
import java.awt.Point;
import java.awt.image.DataBufferByte;
import java.awt.image.IndexColorModel;
import java.awt.image.MultiPixelPackedSampleModel;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import java.io.IOException;
import java.io.OutputStream;

final class WBMPImageEncoder
extends ImageEncoderImpl {
    private static int getNumBits(int n2) {
        int n3 = 32;
        int n4 = Integer.MIN_VALUE;
        while (n4 != 0 && (n2 & n4) == 0) {
            --n3;
            n4 >>>= 1;
        }
        return n3;
    }

    private static byte[] intToMultiByte(int n2) {
        int n3 = WBMPImageEncoder.getNumBits(n2);
        byte[] byArray = new byte[(n3 + 6) / 7];
        int n4 = byArray.length - 1;
        int n5 = 0;
        while (n5 <= n4) {
            byArray[n5] = (byte)(n2 >>> (n4 - n5) * 7 & 0x7F);
            if (n5 != n4) {
                int n6 = n5;
                byArray[n6] = (byte)(byArray[n6] | 0xFFFFFF80);
            }
            ++n5;
        }
        return byArray;
    }

    public WBMPImageEncoder(OutputStream outputStream, ImageEncodeParam imageEncodeParam) {
        super(outputStream, imageEncodeParam);
    }

    public void encode(RenderedImage renderedImage) throws IOException {
        Object object;
        SampleModel sampleModel = renderedImage.getSampleModel();
        int n2 = sampleModel.getTransferType();
        if (n2 == 4 || n2 == 5) {
            throw new IllegalArgumentException(JaiI18N.getString("WBMPImageEncoder0"));
        }
        if (sampleModel.getNumBands() != 1) {
            throw new IllegalArgumentException(JaiI18N.getString("WBMPImageEncoder1"));
        }
        if (sampleModel.getSampleSize(0) != 1) {
            throw new IllegalArgumentException(JaiI18N.getString("WBMPImageEncoder2"));
        }
        int n3 = renderedImage.getWidth();
        int n4 = renderedImage.getHeight();
        this.output.write(0);
        this.output.write(0);
        this.output.write(WBMPImageEncoder.intToMultiByte(n3));
        this.output.write(WBMPImageEncoder.intToMultiByte(n4));
        Object object2 = null;
        if (sampleModel.getDataType() != 0 || !(sampleModel instanceof MultiPixelPackedSampleModel) || ((MultiPixelPackedSampleModel)sampleModel).getDataBitOffset() != 0) {
            MultiPixelPackedSampleModel multiPixelPackedSampleModel = new MultiPixelPackedSampleModel(0, n3, n4, 1, (n3 + 7) / 8, 0);
            object = Raster.createWritableRaster(multiPixelPackedSampleModel, new Point(renderedImage.getMinX(), renderedImage.getMinY()));
            ((WritableRaster)object).setRect(renderedImage.getData());
            object2 = object;
        } else {
            object2 = renderedImage.getNumXTiles() == 1 && renderedImage.getNumYTiles() == 1 ? renderedImage.getTile(renderedImage.getMinTileX(), renderedImage.getMinTileY()) : renderedImage.getData();
        }
        boolean bl2 = false;
        if (renderedImage.getColorModel() instanceof IndexColorModel) {
            object = (IndexColorModel)renderedImage.getColorModel();
            bl2 = ((IndexColorModel)object).getRed(0) + ((IndexColorModel)object).getGreen(0) + ((IndexColorModel)object).getBlue(0) > ((IndexColorModel)object).getRed(1) + ((IndexColorModel)object).getGreen(1) + ((IndexColorModel)object).getBlue(1);
        }
        int n5 = ((MultiPixelPackedSampleModel)sampleModel).getScanlineStride();
        int n6 = (n3 + 7) / 8;
        byte[] byArray = ((DataBufferByte)((Raster)object2).getDataBuffer()).getData();
        if (!bl2 && n5 == n6) {
            this.output.write(byArray, 0, n4 * n6);
        } else {
            int n7 = 0;
            if (!bl2) {
                int n8 = 0;
                while (n8 < n4) {
                    this.output.write(byArray, n7, n6);
                    n7 += n5;
                    ++n8;
                }
            } else {
                byte[] byArray2 = new byte[n6];
                int n9 = 0;
                while (n9 < n4) {
                    int n10 = 0;
                    while (n10 < n6) {
                        byArray2[n10] = ~byArray[n10 + n7];
                        ++n10;
                    }
                    this.output.write(byArray2, 0, n6);
                    n7 += n5;
                    ++n9;
                }
            }
        }
    }
}

