/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jai.codecimpl.fpx;

import com.sun.image.codec.jpeg.JPEGCodec;
import com.sun.image.codec.jpeg.JPEGDecodeParam;
import com.sun.image.codec.jpeg.JPEGImageDecoder;
import com.sun.media.jai.codec.FPXDecodeParam;
import com.sun.media.jai.codec.ImageCodec;
import com.sun.media.jai.codec.SeekableStream;
import com.sun.media.jai.codecimpl.ImagingListenerProxy;
import com.sun.media.jai.codecimpl.SimpleRenderedImage;
import com.sun.media.jai.codecimpl.fpx.FPXUtils;
import com.sun.media.jai.codecimpl.fpx.JaiI18N;
import com.sun.media.jai.codecimpl.fpx.PropertySet;
import com.sun.media.jai.codecimpl.fpx.StructuredStorage;
import com.sun.media.jai.codecimpl.util.RasterFactory;
import java.awt.Point;
import java.awt.color.ColorSpace;
import java.awt.image.ComponentColorModel;
import java.awt.image.DataBufferByte;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Hashtable;

public class FPXImage
extends SimpleRenderedImage {
    private static final int SUBIMAGE_COLOR_SPACE_COLORLESS = 0;
    private static final int SUBIMAGE_COLOR_SPACE_MONOCHROME = 0;
    private static final int SUBIMAGE_COLOR_SPACE_PHOTOYCC = 0;
    private static final int SUBIMAGE_COLOR_SPACE_NIFRGB = 0;
    private static final String[] COLORSPACE_NAME = new String[]{"Colorless", "Monochrome", "PhotoYCC", "NIF RGB"};
    StructuredStorage storage;
    int numResolutions;
    int highestResWidth;
    int highestResHeight;
    float defaultDisplayHeight;
    float defaultDisplayWidth;
    int displayHeightWidthUnits;
    boolean[] subimageValid;
    int[] subimageWidth;
    int[] subimageHeight;
    int[][] subimageColor;
    int[] decimationMethod;
    float[] decimationPrefilterWidth;
    int highestResolution = -1;
    int maxJPEGTableIndex;
    byte[][] JPEGTable;
    int numChannels;
    int tileHeaderTableOffset;
    int tileHeaderEntryLength;
    SeekableStream subimageHeaderStream;
    SeekableStream subimageDataStream;
    int resolution;
    int tilesAcross;
    int[] bandOffsets = new int[]{0, 1, 2};
    private static final int[] RGBBits8 = new int[]{8, 8, 8};
    private static final ComponentColorModel colorModelRGB8 = new ComponentColorModel(ColorSpace.getInstance(1004), RGBBits8, false, false, 1, 0);
    private static final byte[] PhotoYCCToRGBLUT = new byte[]{0, 1, 1, 2, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 22, 23, 24, 25, 26, 28, 29, 30, 31, 33, 34, 35, 36, 38, 39, 40, 41, 43, 44, 45, 47, 48, 49, 51, 52, 53, 55, 56, 57, 59, 60, 61, 63, 64, 65, 67, 68, 70, 71, 72, 74, 75, 76, 78, 79, 81, 82, 83, 85, 86, 88, 89, 91, 92, 93, 95, 96, 98, 99, 101, 102, 103, 105, 106, 108, 109, 111, 112, 113, 115, 116, 118, 119, 121, 122, 123, 125, 126, -128, -127, -126, -124, -123, -122, -120, -119, -118, -116, -115, -114, -112, -111, -110, -108, -107, -106, -104, -103, -102, -101, -99, -98, -97, -96, -94, -93, -92, -91, -90, -88, -87, -86, -85, -84, -82, -81, -80, -79, -78, -77, -76, -74, -73, -72, -71, -70, -69, -68, -67, -66, -65, -64, -62, -61, -60, -59, -58, -57, -56, -55, -54, -53, -52, -52, -51, -50, -49, -48, -47, -46, -45, -44, -43, -43, -42, -41, -40, -39, -39, -38, -37, -36, -35, -35, -34, -33, -33, -32, -31, -31, -30, -29, -29, -28, -27, -27, -26, -26, -25, -25, -24, -23, -23, -22, -22, -21, -21, -20, -20, -20, -19, -19, -18, -18, -18, -17, -17, -16, -16, -16, -15, -15, -15, -14, -14, -14, -14, -13, -13, -13, -12, -12, -12, -12, -11, -11, -11, -11, -11, -10, -10, -10, -10, -10, -9, -9, -9, -9, -9, -9, -8, -8, -8, -8, -8, -8, -7, -7, -7, -7, -7, -7, -7, -7, -7, -6, -6, -6, -6, -6, -6, -6, -6, -6, -6, -5, -5, -5, -5, -5, -5, -5, -5, -5, -5, -5, -5, -5, -5, -4, -4, -4, -4, -4, -4, -4, -4, -4, -4, -4, -4, -4, -4, -4, -4, -4, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1};
    Hashtable properties = null;
    static /* synthetic */ Class class$com$sun$media$jai$codec$ImageCodec;

    public FPXImage(SeekableStream seekableStream, FPXDecodeParam fPXDecodeParam) throws IOException {
        this.storage = new StructuredStorage(seekableStream);
        this.readImageContents();
        if (fPXDecodeParam == null) {
            fPXDecodeParam = new FPXDecodeParam();
        }
        this.resolution = fPXDecodeParam.getResolution();
        this.readResolution();
        this.bandOffsets = new int[this.numChannels];
        int n2 = 0;
        while (n2 < this.numChannels) {
            this.bandOffsets[n2] = n2;
            ++n2;
        }
        this.minX = 0;
        this.minY = 0;
        this.sampleModel = RasterFactory.createPixelInterleavedSampleModel(0, this.tileWidth, this.tileHeight, this.numChannels, this.numChannels * this.tileWidth, this.bandOffsets);
        this.colorModel = ImageCodec.createComponentColorModel(this.sampleModel);
    }

    private void readImageContents() throws IOException {
        int n2;
        this.storage.changeDirectoryToRoot();
        this.storage.changeDirectory("Data Object Store 000001");
        SeekableStream seekableStream = this.storage.getStream("\u0005Image Contents");
        PropertySet propertySet = new PropertySet(seekableStream);
        this.numResolutions = (int)propertySet.getUI4(0x1000000);
        this.highestResWidth = (int)propertySet.getUI4(0x1000002);
        this.highestResHeight = (int)propertySet.getUI4(0x1000003);
        this.displayHeightWidthUnits = (int)propertySet.getUI4(0x1000006, 0L);
        this.subimageValid = new boolean[this.numResolutions];
        this.subimageWidth = new int[this.numResolutions];
        this.subimageHeight = new int[this.numResolutions];
        this.subimageColor = new int[this.numResolutions][];
        this.decimationMethod = new int[this.numResolutions];
        this.decimationPrefilterWidth = new float[this.numResolutions];
        int n3 = 0;
        while (n3 < this.numResolutions) {
            n2 = n3 << 16;
            if (!propertySet.hasProperty(0x2000000 | n2)) break;
            this.highestResolution = n3;
            this.subimageValid[n3] = true;
            this.subimageWidth[n3] = (int)propertySet.getUI4(0x2000000 | n2);
            this.subimageHeight[n3] = (int)propertySet.getUI4(0x2000001 | n2);
            byte[] byArray = propertySet.getBlob(0x2000002 | n2);
            this.decimationMethod[n3] = propertySet.getI4(0x2000004 | n2);
            int n4 = FPXUtils.getIntLE(byArray, 0);
            int n5 = FPXUtils.getIntLE(byArray, 4);
            this.subimageColor[n3] = new int[n5];
            int n6 = 0;
            while (n6 < n5) {
                int n7 = FPXUtils.getIntLE(byArray, 8 + 4 * n6);
                this.subimageColor[n3][n6] = n7 & Integer.MAX_VALUE;
                ++n6;
            }
            ++n3;
        }
        this.maxJPEGTableIndex = (int)propertySet.getUI4(0x3000002, -1L);
        this.JPEGTable = new byte[this.maxJPEGTableIndex + 1][];
        n2 = 0;
        while (n2 <= this.maxJPEGTableIndex) {
            int n8 = n2 << 16;
            this.JPEGTable[n2] = (byte[])(propertySet.hasProperty(0x3000001 | n8) ? propertySet.getBlob(0x3000001 | n8) : null);
            ++n2;
        }
    }

    private void readResolution() throws IOException {
        if (this.resolution == -1) {
            this.resolution = this.highestResolution;
        }
        this.storage.changeDirectoryToRoot();
        this.storage.changeDirectory("Data Object Store 000001");
        this.storage.changeDirectory("Resolution 000" + this.resolution);
        this.subimageHeaderStream = this.storage.getStream("Subimage 0000 Header");
        this.subimageHeaderStream.skip(28L);
        int n2 = this.subimageHeaderStream.readIntLE();
        this.width = this.subimageHeaderStream.readIntLE();
        this.height = this.subimageHeaderStream.readIntLE();
        int n3 = this.subimageHeaderStream.readIntLE();
        this.tileWidth = this.subimageHeaderStream.readIntLE();
        this.tileHeight = this.subimageHeaderStream.readIntLE();
        this.numChannels = this.subimageHeaderStream.readIntLE();
        this.tileHeaderTableOffset = this.subimageHeaderStream.readIntLE() + 28;
        this.tileHeaderEntryLength = this.subimageHeaderStream.readIntLE();
        this.subimageDataStream = this.storage.getStream("Subimage 0000 Data");
        this.tilesAcross = (this.width + this.tileWidth - 1) / this.tileWidth;
    }

    private int getTileOffset(int n2) throws IOException {
        this.subimageHeaderStream.seek(this.tileHeaderTableOffset + 16 * n2);
        return this.subimageHeaderStream.readIntLE() + 28;
    }

    private int getTileSize(int n2) throws IOException {
        this.subimageHeaderStream.seek(this.tileHeaderTableOffset + 16 * n2 + 4);
        return this.subimageHeaderStream.readIntLE();
    }

    private int getCompressionType(int n2) throws IOException {
        this.subimageHeaderStream.seek(this.tileHeaderTableOffset + 16 * n2 + 8);
        return this.subimageHeaderStream.readIntLE();
    }

    private int getCompressionSubtype(int n2) throws IOException {
        this.subimageHeaderStream.seek(this.tileHeaderTableOffset + 16 * n2 + 12);
        return this.subimageHeaderStream.readIntLE();
    }

    private final byte PhotoYCCToNIFRed(float f2, float f3, float f4) {
        float f5 = f2 + 1.8215f * f4 - 249.55f;
        if (f5 < 0.0f) {
            return 0;
        }
        if (f5 > 360.0f) {
            return -1;
        }
        byte by2 = PhotoYCCToRGBLUT[(int)f5];
        return by2;
    }

    private final byte PhotoYCCToNIFGreen(float f2, float f3, float f4) {
        float f5 = f2 - 0.43031f * f3 - 0.9271f * f4 + 194.14f;
        if (f5 < 0.0f) {
            return 0;
        }
        if (f5 > 360.0f) {
            return -1;
        }
        byte by2 = PhotoYCCToRGBLUT[(int)f5];
        return by2;
    }

    private final byte PhotoYCCToNIFBlue(float f2, float f3, float f4) {
        float f5 = f2 + 2.2179f * f3 - 345.99f;
        if (f5 < 0.0f) {
            return 0;
        }
        if (f5 > 360.0f) {
            return -1;
        }
        byte by2 = PhotoYCCToRGBLUT[(int)f5];
        return by2;
    }

    private final byte YCCToNIFRed(float f2, float f3, float f4) {
        float f5 = f2 + 1.402f * f4 - 178.75499f;
        if (f5 < 0.0f) {
            return 0;
        }
        if (f5 > 255.0f) {
            return -1;
        }
        return (byte)f5;
    }

    private final byte YCCToNIFGreen(float f2, float f3, float f4) {
        float f5 = f2 - 0.34414f * f3 - 0.71414f * f4 + 134.9307f;
        if (f5 < 0.0f) {
            return 0;
        }
        if (f5 > 255.0f) {
            return -1;
        }
        return (byte)f5;
    }

    private final byte YCCToNIFBlue(float f2, float f3, float f4) {
        float f5 = f2 + 1.772f * f3 - 225.93f;
        if (f5 < 0.0f) {
            return 0;
        }
        if (f5 > 255.0f) {
            return -1;
        }
        return (byte)f5;
    }

    private Raster getUncompressedTile(int n2, int n3) throws IOException {
        int n4 = this.tileXToX(n2);
        int n5 = this.tileYToY(n3);
        WritableRaster writableRaster = RasterFactory.createInterleavedRaster(0, this.tileWidth, this.tileHeight, this.numChannels * this.tileWidth, this.numChannels, this.bandOffsets, new Point(n4, n5));
        DataBufferByte dataBufferByte = (DataBufferByte)writableRaster.getDataBuffer();
        byte[] byArray = dataBufferByte.getData();
        int n6 = n3 * this.tilesAcross + n2;
        this.subimageDataStream.seek(this.getTileOffset(n6));
        this.subimageDataStream.readFully(byArray, 0, this.numChannels * this.tileWidth * this.tileHeight);
        if (this.subimageColor[this.resolution][0] >> 16 == 2) {
            int n7 = this.tileWidth * this.tileHeight;
            int n8 = 0;
            while (n8 < n7) {
                float f2 = byArray[3 * n8] & 0xFF;
                float f3 = byArray[3 * n8 + 1] & 0xFF;
                float f4 = byArray[3 * n8 + 2] & 0xFF;
                float f5 = f2 * 1.3584f;
                byte by2 = this.PhotoYCCToNIFRed(f5, f3, f4);
                byte by3 = this.PhotoYCCToNIFGreen(f5, f3, f4);
                byte by4 = this.PhotoYCCToNIFBlue(f5, f3, f4);
                byArray[3 * n8] = by2;
                byArray[3 * n8 + 1] = by3;
                byArray[3 * n8 + 2] = by4;
                ++n8;
            }
        }
        return writableRaster;
    }

    private Raster getSingleColorCompressedTile(int n2, int n3) throws IOException {
        WritableRaster writableRaster;
        block4: {
            int n4;
            byte by2;
            byte by3;
            byte by4;
            byte by5;
            block5: {
                int n5 = this.tileXToX(n2);
                int n6 = this.tileYToY(n3);
                writableRaster = RasterFactory.createInterleavedRaster(0, this.tileWidth, this.tileHeight, this.numChannels * this.tileWidth, this.numChannels, this.bandOffsets, new Point(n5, n6));
                int n7 = this.subimageColor[this.resolution][0] >> 16;
                DataBufferByte dataBufferByte = (DataBufferByte)writableRaster.getDataBuffer();
                byte[] byArray = dataBufferByte.getData();
                int n8 = n3 * this.tilesAcross + n2;
                int n9 = this.getCompressionSubtype(n8);
                byte by6 = (byte)(n9 >> 0 & 0xFF);
                byte by7 = (byte)(n9 >> 8 & 0xFF);
                byte by8 = (byte)(n9 >> 16 & 0xFF);
                by5 = (byte)(n9 >> 24 & 0xFF);
                if (this.subimageColor[this.resolution][0] >> 16 == 2) {
                    float f2 = by6 & 0xFF;
                    float f3 = by7 & 0xFF;
                    float f4 = by8 & 0xFF;
                    float f5 = f2 * 1.3584f;
                    by4 = this.PhotoYCCToNIFRed(f5, f3, f4);
                    by3 = this.PhotoYCCToNIFGreen(f5, f3, f4);
                    by2 = this.PhotoYCCToNIFBlue(f5, f3, f4);
                } else {
                    by4 = by6;
                    by3 = by7;
                    by2 = by8;
                }
                int n10 = 0;
                n4 = this.tileWidth * this.tileHeight;
                if (this.numChannels == 1 || this.numChannels == 2) break block4;
                if (this.numChannels != 3) break block5;
                int n11 = 0;
                while (n11 < n4) {
                    byArray[n10 + 0] = by4;
                    byArray[n10 + 1] = by3;
                    byArray[n10 + 2] = by2;
                    n10 += 3;
                    ++n11;
                }
                break block4;
            }
            if (this.numChannels != 4) break block4;
            int n12 = 0;
            while (n12 < n4) {
                byArray[n10 + 0] = by4;
                byArray[n10 + 1] = by3;
                byArray[n10 + 2] = by2;
                byArray[n10 + 3] = by5;
                n10 += 4;
                ++n12;
            }
        }
        return writableRaster;
    }

    private Raster getJPEGCompressedTile(int n2, int n3) throws IOException {
        byte by2;
        byte by3;
        float f2;
        float f3;
        float f4;
        int n4;
        int n5;
        Object object;
        JPEGImageDecoder jPEGImageDecoder;
        Object object2;
        int n6 = n3 * this.tilesAcross + n2;
        int n7 = this.tileXToX(n2);
        int n8 = this.tileYToY(n3);
        int n9 = this.getCompressionSubtype(n6);
        int n10 = n9 >> 0 & 0xFF;
        int n11 = n9 >> 8 & 0xFF;
        int n12 = n9 >> 16 & 0xFF;
        int n13 = n9 >> 24 & 0xFF;
        JPEGDecodeParam jPEGDecodeParam = null;
        if (n13 != 0) {
            object2 = new ByteArrayInputStream(this.JPEGTable[n13]);
            jPEGImageDecoder = JPEGCodec.createJPEGDecoder((InputStream)object2);
            object = jPEGImageDecoder.decodeAsRaster();
            jPEGDecodeParam = jPEGImageDecoder.getJPEGDecodeParam();
        }
        this.subimageDataStream.seek(this.getTileOffset(n6));
        jPEGImageDecoder = jPEGDecodeParam != null ? JPEGCodec.createJPEGDecoder((InputStream)this.subimageDataStream, jPEGDecodeParam) : JPEGCodec.createJPEGDecoder((InputStream)this.subimageDataStream);
        object2 = jPEGImageDecoder.decodeAsRaster().createTranslatedChild(n7, n8);
        object = (DataBufferByte)((Raster)object2).getDataBuffer();
        byte[] byArray = ((DataBufferByte)object).getData();
        int n14 = this.subimageColor[this.resolution][0] >> 16;
        int n15 = this.tileWidth * this.tileHeight;
        if (n12 == 0 && n14 == 2) {
            n5 = 0;
            n4 = 0;
            while (n4 < n15) {
                f4 = byArray[n5] & 0xFF;
                f3 = byArray[n5 + 1] & 0xFF;
                f2 = byArray[n5 + 2] & 0xFF;
                float f5 = f4 * 1.3584f;
                by3 = this.PhotoYCCToNIFRed(f5, f3, f2);
                by2 = this.PhotoYCCToNIFGreen(f5, f3, f2);
                byte by4 = this.PhotoYCCToNIFBlue(f5, f3, f2);
                byArray[n5] = by3;
                byArray[n5 + 1] = by2;
                byArray[n5 + 2] = by4;
                n5 += this.numChannels;
                ++n4;
            }
        } else if (n12 == 1 && n14 == 3) {
            n5 = 0;
            n4 = 0;
            while (n4 < n15) {
                f4 = byArray[n5] & 0xFF;
                f3 = byArray[n5 + 1] & 0xFF;
                f2 = byArray[n5 + 2] & 0xFF;
                byte by5 = this.YCCToNIFRed(f4, f3, f2);
                by3 = this.YCCToNIFGreen(f4, f3, f2);
                by2 = this.YCCToNIFBlue(f4, f3, f2);
                byArray[n5] = by5;
                byArray[n5 + 1] = by3;
                byArray[n5 + 2] = by2;
                n5 += this.numChannels;
                ++n4;
            }
        }
        if (n12 == 1 && n14 == 3 && this.numChannels == 4) {
            n5 = 0;
            n4 = 0;
            while (n4 < n15) {
                byArray[n5 + 0] = (byte)(255 - byArray[n5 + 0]);
                byArray[n5 + 1] = (byte)(255 - byArray[n5 + 1]);
                byArray[n5 + 2] = (byte)(255 - byArray[n5 + 2]);
                n5 += 4;
                ++n4;
            }
        }
        return object2;
    }

    public synchronized Raster getTile(int n2, int n3) {
        int n4 = n3 * this.tilesAcross + n2;
        try {
            int n5 = this.getCompressionType(n4);
            if (n5 == 0) {
                return this.getUncompressedTile(n2, n3);
            }
            if (n5 == 1) {
                return this.getSingleColorCompressedTile(n2, n3);
            }
            if (n5 == 2) {
                return this.getJPEGCompressedTile(n2, n3);
            }
            return null;
        }
        catch (IOException iOException) {
            ImagingListenerProxy.errorOccurred(JaiI18N.getString("FPXImage0"), iOException, class$com$sun$media$jai$codec$ImageCodec == null ? (class$com$sun$media$jai$codec$ImageCodec = FPXImage.class$("com.sun.media.jai.codec.ImageCodec")) : class$com$sun$media$jai$codec$ImageCodec, false);
            return null;
        }
    }

    private void addLPSTRProperty(String string, PropertySet propertySet, int n2) {
        String string2 = propertySet.getLPSTR(n2);
        if (string2 != null) {
            this.properties.put(string.toLowerCase(), string2);
        }
    }

    private void addLPWSTRProperty(String string, PropertySet propertySet, int n2) {
        String string2 = propertySet.getLPWSTR(n2);
        if (string2 != null) {
            this.properties.put(string.toLowerCase(), string2);
        }
    }

    private void addUI4Property(String string, PropertySet propertySet, int n2) {
        if (propertySet.hasProperty(n2)) {
            long l2 = propertySet.getUI4(n2);
            this.properties.put(string.toLowerCase(), new Integer((int)l2));
        }
    }

    private void getSummaryInformation() {
        SeekableStream seekableStream = null;
        PropertySet propertySet = null;
        try {
            this.storage.changeDirectoryToRoot();
            seekableStream = this.storage.getStream("\u0005SummaryInformation");
            propertySet = new PropertySet(seekableStream);
        }
        catch (IOException iOException) {
            ImagingListenerProxy.errorOccurred(JaiI18N.getString("FPXImage1"), iOException, class$com$sun$media$jai$codec$ImageCodec == null ? (class$com$sun$media$jai$codec$ImageCodec = FPXImage.class$("com.sun.media.jai.codec.ImageCodec")) : class$com$sun$media$jai$codec$ImageCodec, false);
            return;
        }
        this.addLPSTRProperty("title", propertySet, 2);
        this.addLPSTRProperty("subject", propertySet, 3);
        this.addLPSTRProperty("author", propertySet, 4);
        this.addLPSTRProperty("keywords", propertySet, 5);
        this.addLPSTRProperty("comments", propertySet, 6);
        this.addLPSTRProperty("template", propertySet, 7);
        this.addLPSTRProperty("last saved by", propertySet, 8);
        this.addLPSTRProperty("revision number", propertySet, 9);
    }

    private void getImageInfo() {
        SeekableStream seekableStream = null;
        PropertySet propertySet = null;
        try {
            this.storage.changeDirectoryToRoot();
            seekableStream = this.storage.getStream("\u0005Image Info");
            if (seekableStream == null) {
                return;
            }
            propertySet = new PropertySet(seekableStream);
        }
        catch (IOException iOException) {
            ImagingListenerProxy.errorOccurred(JaiI18N.getString("FPXImage2"), iOException, class$com$sun$media$jai$codec$ImageCodec == null ? (class$com$sun$media$jai$codec$ImageCodec = FPXImage.class$("com.sun.media.jai.codec.ImageCodec")) : class$com$sun$media$jai$codec$ImageCodec, false);
            return;
        }
        this.addUI4Property("file source", propertySet, 0x21000000);
        this.addUI4Property("scene type", propertySet, 0x21000001);
        this.addLPWSTRProperty("software name/manufacturer/release", propertySet, 553648131);
        this.addLPWSTRProperty("user defined id", propertySet, 553648132);
        this.addLPWSTRProperty("copyright message", propertySet, 0x22000000);
        this.addLPWSTRProperty("legal broker for the original image", propertySet, 0x22000001);
        this.addLPWSTRProperty("legal broker for the digital image", propertySet, 0x22000002);
        this.addLPWSTRProperty("authorship", propertySet, 0x22000003);
        this.addLPWSTRProperty("intellectual property notes", propertySet, 0x22000004);
    }

    private synchronized void getProperties() {
        if (this.properties != null) {
            return;
        }
        this.properties = new Hashtable();
        this.getSummaryInformation();
        this.getImageInfo();
        this.properties.put("max_resolution", new Integer(this.highestResolution));
    }

    public String[] getPropertyNames() {
        this.getProperties();
        int n2 = this.properties.size();
        String[] stringArray = new String[n2];
        Enumeration enumeration = this.properties.keys();
        int n3 = 0;
        while (enumeration.hasMoreElements()) {
            stringArray[n3++] = (String)enumeration.nextElement();
        }
        return stringArray;
    }

    public Object getProperty(String string) {
        this.getProperties();
        return this.properties.get(string.toLowerCase());
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

