/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jai.codecimpl.fpx;

import com.sun.media.jai.codec.SeekableStream;
import com.sun.media.jai.codecimpl.ImagingListenerProxy;
import com.sun.media.jai.codecimpl.fpx.JaiI18N;
import com.sun.media.jai.codecimpl.fpx.Property;
import java.io.IOException;
import java.util.Date;
import java.util.Hashtable;

class PropertySet {
    private static final int TYPE_VT_EMPTY = -1;
    private static final int TYPE_VT_NULL = -1;
    private static final int TYPE_VT_I2 = 2;
    private static final int TYPE_VT_I4 = 3;
    private static final int TYPE_VT_R4 = -1;
    private static final int TYPE_VT_R8 = -1;
    private static final int TYPE_VT_CY = -1;
    private static final int TYPE_VT_DATE = -1;
    private static final int TYPE_VT_BSTR = -1;
    private static final int TYPE_VT_ERROR = -1;
    private static final int TYPE_VT_BOOL = -1;
    private static final int TYPE_VT_VARIANT = -1;
    private static final int TYPE_VT_UI1 = -1;
    private static final int TYPE_VT_UI2 = -1;
    private static final int TYPE_VT_UI4 = 19;
    private static final int TYPE_VT_I8 = -1;
    private static final int TYPE_VT_UI8 = -1;
    private static final int TYPE_VT_LPSTR = 30;
    private static final int TYPE_VT_LPWSTR = 31;
    private static final int TYPE_VT_FILETIME = 64;
    private static final int TYPE_VT_BLOB = 65;
    private static final int TYPE_VT_STREAM = -1;
    private static final int TYPE_VT_STORAGE = -1;
    private static final int TYPE_VT_STREAMED_OBJECT = -1;
    private static final int TYPE_VT_STORED_OBJECT = -1;
    private static final int TYPE_VT_BLOB_OBJECT = -1;
    private static final int TYPE_VT_CF = 71;
    private static final int TYPE_VT_CLSID = 72;
    private static final int TYPE_VT_VECTOR = 4096;
    SeekableStream stream;
    Hashtable properties = new Hashtable();

    public PropertySet(SeekableStream seekableStream) throws IOException {
        this.stream = seekableStream;
        seekableStream.seek(44L);
        int n2 = seekableStream.readIntLE();
        seekableStream.seek(n2);
        int n3 = seekableStream.readIntLE();
        int n4 = seekableStream.readIntLE();
        int n5 = 0;
        while (n5 < n4) {
            seekableStream.seek(n2 + 8 * n5 + 8);
            int n6 = seekableStream.readIntLE();
            int n7 = seekableStream.readIntLE();
            seekableStream.seek(n2 + n7);
            int n8 = seekableStream.readIntLE();
            Property property = new Property(n8, n2 + n7 + 4);
            this.properties.put(new Integer(n6), property);
            ++n5;
        }
    }

    public boolean hasProperty(int n2) {
        Property property = (Property)this.properties.get(new Integer(n2));
        return property != null;
    }

    public int getI4(int n2) {
        Property property = (Property)this.properties.get(new Integer(n2));
        try {
            int n3 = property.getOffset();
            this.stream.seek(n3);
            return this.stream.readIntLE();
        }
        catch (IOException iOException) {
            ImagingListenerProxy.errorOccurred(JaiI18N.getString("PropertySet1"), iOException, this, false);
            return -1;
        }
    }

    public int getUI1(int n2) {
        Property property = (Property)this.properties.get(new Integer(n2));
        try {
            int n3 = property.getOffset();
            this.stream.seek(n3);
            return this.stream.readUnsignedByte();
        }
        catch (IOException iOException) {
            ImagingListenerProxy.errorOccurred(JaiI18N.getString("PropertySet1"), iOException, this, false);
            return -1;
        }
    }

    public int getUI2(int n2) {
        Property property = (Property)this.properties.get(new Integer(n2));
        try {
            int n3 = property.getOffset();
            this.stream.seek(n3);
            return this.stream.readUnsignedShortLE();
        }
        catch (IOException iOException) {
            ImagingListenerProxy.errorOccurred(JaiI18N.getString("PropertySet2"), iOException, this, false);
            return -1;
        }
    }

    public long getUI4(int n2) {
        Property property = (Property)this.properties.get(new Integer(n2));
        try {
            int n3 = property.getOffset();
            this.stream.seek(n3);
            return this.stream.readUnsignedIntLE();
        }
        catch (IOException iOException) {
            ImagingListenerProxy.errorOccurred(JaiI18N.getString("PropertySet4"), iOException, this, false);
            return -1L;
        }
    }

    public long getUI4(int n2, long l2) {
        Property property = (Property)this.properties.get(new Integer(n2));
        if (property == null) {
            return l2;
        }
        try {
            int n3 = property.getOffset();
            this.stream.seek(n3);
            return this.stream.readUnsignedIntLE();
        }
        catch (IOException iOException) {
            ImagingListenerProxy.errorOccurred(JaiI18N.getString("PropertySet4"), iOException, this, false);
            return -1L;
        }
    }

    public String getLPSTR(int n2) {
        Property property = (Property)this.properties.get(new Integer(n2));
        if (property == null) {
            return null;
        }
        try {
            int n3 = property.getOffset();
            this.stream.seek(n3);
            int n4 = this.stream.readIntLE();
            StringBuffer stringBuffer = new StringBuffer(n4);
            int n5 = 0;
            while (n5 < n4) {
                stringBuffer.append((char)this.stream.read());
                ++n5;
            }
            return stringBuffer.toString();
        }
        catch (IOException iOException) {
            ImagingListenerProxy.errorOccurred(JaiI18N.getString("PropertySet5"), iOException, this, false);
            return null;
        }
    }

    public String getLPWSTR(int n2) {
        Property property = (Property)this.properties.get(new Integer(n2));
        try {
            int n3 = property.getOffset();
            this.stream.seek(n3);
            int n4 = this.stream.readIntLE();
            StringBuffer stringBuffer = new StringBuffer(n4);
            int n5 = 0;
            while (n5 < n4) {
                stringBuffer.append(this.stream.readCharLE());
                ++n5;
            }
            return stringBuffer.toString();
        }
        catch (IOException iOException) {
            ImagingListenerProxy.errorOccurred(JaiI18N.getString("PropertySet5"), iOException, this, false);
            return null;
        }
    }

    public float getR4(int n2) {
        Property property = (Property)this.properties.get(new Integer(n2));
        try {
            int n3 = property.getOffset();
            this.stream.seek(n3);
            return this.stream.readFloatLE();
        }
        catch (IOException iOException) {
            ImagingListenerProxy.errorOccurred(JaiI18N.getString("PropertySet6"), iOException, this, false);
            return -1.0f;
        }
    }

    public Date getDate(int n2) {
        throw new RuntimeException(JaiI18N.getString("PropertySet0"));
    }

    public Date getFiletime(int n2) {
        throw new RuntimeException(JaiI18N.getString("PropertySet0"));
    }

    public byte[] getBlob(int n2) {
        Property property = (Property)this.properties.get(new Integer(n2));
        try {
            int n3 = property.getOffset();
            this.stream.seek(n3);
            int n4 = this.stream.readIntLE();
            byte[] byArray = new byte[n4];
            this.stream.seek(n3 + 4);
            this.stream.readFully(byArray);
            return byArray;
        }
        catch (IOException iOException) {
            ImagingListenerProxy.errorOccurred(JaiI18N.getString("PropertySet7"), iOException, this, false);
            return null;
        }
    }

    public int[] getUI1Vector(int n2) {
        throw new RuntimeException(JaiI18N.getString("PropertySet0"));
    }

    public int[] getUI2Vector(int n2) {
        throw new RuntimeException(JaiI18N.getString("PropertySet0"));
    }

    public long[] getUI4Vector(int n2) {
        throw new RuntimeException(JaiI18N.getString("PropertySet0"));
    }

    public float[] getR4Vector(int n2) {
        throw new RuntimeException(JaiI18N.getString("PropertySet0"));
    }

    public String[] getLPWSTRVector(int n2) {
        throw new RuntimeException(JaiI18N.getString("PropertySet0"));
    }
}

