/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jai.codecimpl.util;

import com.sun.media.jai.codecimpl.util.DataBufferUtils;
import com.sun.media.jai.codecimpl.util.JaiI18N;
import java.awt.image.ComponentSampleModel;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferInt;
import java.awt.image.DataBufferShort;
import java.awt.image.DataBufferUShort;
import java.awt.image.SampleModel;

public class ComponentSampleModelJAI
extends ComponentSampleModel {
    public ComponentSampleModelJAI(int n2, int n3, int n4, int n5, int n6, int[] nArray) {
        super(n2, n3, n4, n5, n6, nArray);
    }

    public ComponentSampleModelJAI(int n2, int n3, int n4, int n5, int n6, int[] nArray, int[] nArray2) {
        super(n2, n3, n4, n5, n6, nArray, nArray2);
    }

    private long getBufferSize() {
        int n2 = this.bandOffsets[0];
        int n3 = 1;
        while (n3 < this.bandOffsets.length) {
            n2 = Math.max(n2, this.bandOffsets[n3]);
            ++n3;
        }
        long l2 = 0L;
        if (n2 >= 0) {
            l2 += (long)(n2 + 1);
        }
        if (this.pixelStride > 0) {
            l2 += (long)(this.pixelStride * (this.width - 1));
        }
        if (this.scanlineStride > 0) {
            l2 += (long)(this.scanlineStride * (this.height - 1));
        }
        return l2;
    }

    private int[] JAIorderBands(int[] nArray, int n2) {
        int[] nArray2 = new int[nArray.length];
        int[] nArray3 = new int[nArray.length];
        int n3 = 0;
        while (n3 < nArray2.length) {
            nArray2[n3] = n3;
            ++n3;
        }
        int n4 = 0;
        while (n4 < nArray3.length) {
            int n5 = n4;
            int n6 = n4 + 1;
            while (n6 < nArray3.length) {
                if (nArray[nArray2[n5]] > nArray[nArray2[n6]]) {
                    n5 = n6;
                }
                ++n6;
            }
            nArray3[nArray2[n5]] = n4 * n2;
            nArray2[n5] = nArray2[n4];
            ++n4;
        }
        return nArray3;
    }

    public SampleModel createCompatibleSampleModel(int n2, int n3) {
        int n4;
        int[] nArray;
        Object var3_3 = null;
        int n5 = this.bandOffsets[0];
        int n6 = this.bandOffsets[0];
        int n7 = 1;
        while (n7 < this.bandOffsets.length) {
            n5 = Math.min(n5, this.bandOffsets[n7]);
            n6 = Math.max(n6, this.bandOffsets[n7]);
            ++n7;
        }
        int n8 = this.bandOffsets.length;
        int n9 = Math.abs(this.pixelStride);
        int n10 = Math.abs(this.scanlineStride);
        int n11 = Math.abs(n6 -= n5);
        if (n9 > n10) {
            if (n9 > n11) {
                if (n10 > n11) {
                    nArray = new int[this.bandOffsets.length];
                    n4 = 0;
                    while (n4 < n8) {
                        nArray[n4] = this.bandOffsets[n4] - n5;
                        ++n4;
                    }
                    n10 = n11 + 1;
                    n9 = n10 * n3;
                } else {
                    nArray = this.JAIorderBands(this.bandOffsets, n10 * n3);
                    n9 = n8 * n10 * n3;
                }
            } else {
                n9 = n10 * n3;
                nArray = this.JAIorderBands(this.bandOffsets, n9 * n2);
            }
        } else if (n9 > n11) {
            nArray = new int[this.bandOffsets.length];
            n4 = 0;
            while (n4 < n8) {
                nArray[n4] = this.bandOffsets[n4] - n5;
                ++n4;
            }
            n9 = n11 + 1;
            n10 = n9 * n2;
        } else if (n10 > n11) {
            nArray = this.JAIorderBands(this.bandOffsets, n9 * n2);
            n10 = n8 * n9 * n2;
        } else {
            n10 = n9 * n2;
            nArray = this.JAIorderBands(this.bandOffsets, n10 * n3);
        }
        n4 = 0;
        if (this.scanlineStride < 0) {
            n4 += n10 * n3;
            n10 *= -1;
        }
        if (this.pixelStride < 0) {
            n4 += n9 * n2;
            n9 *= -1;
        }
        int n12 = 0;
        while (n12 < n8) {
            int n13 = n12++;
            nArray[n13] = nArray[n13] + n4;
        }
        return new ComponentSampleModelJAI(this.dataType, n2, n3, n9, n10, this.bankIndices, nArray);
    }

    public SampleModel createSubsetSampleModel(int[] nArray) {
        int[] nArray2 = new int[nArray.length];
        int[] nArray3 = new int[nArray.length];
        int n2 = 0;
        while (n2 < nArray.length) {
            int n3 = nArray[n2];
            nArray2[n2] = this.bankIndices[n3];
            nArray3[n2] = this.bandOffsets[n3];
            ++n2;
        }
        return new ComponentSampleModelJAI(this.dataType, this.width, this.height, this.pixelStride, this.scanlineStride, nArray2, nArray3);
    }

    public DataBuffer createDataBuffer() {
        DataBuffer dataBuffer = null;
        int n2 = (int)this.getBufferSize();
        switch (this.dataType) {
            case 0: {
                dataBuffer = new DataBufferByte(n2, this.numBanks);
                break;
            }
            case 1: {
                dataBuffer = new DataBufferUShort(n2, this.numBanks);
                break;
            }
            case 3: {
                dataBuffer = new DataBufferInt(n2, this.numBanks);
                break;
            }
            case 2: {
                dataBuffer = new DataBufferShort(n2, this.numBanks);
                break;
            }
            case 4: {
                dataBuffer = DataBufferUtils.createDataBufferFloat(n2, this.numBanks);
                break;
            }
            case 5: {
                dataBuffer = DataBufferUtils.createDataBufferDouble(n2, this.numBanks);
                break;
            }
            default: {
                throw new RuntimeException(JaiI18N.getString("RasterFactory3"));
            }
        }
        return dataBuffer;
    }

    public Object getDataElements(int n2, int n3, Object object, DataBuffer dataBuffer) {
        int n4 = this.getTransferType();
        int n5 = this.getNumDataElements();
        int n6 = n3 * this.scanlineStride + n2 * this.pixelStride;
        switch (n4) {
            case 0: {
                byte[] byArray = object == null ? new byte[n5] : (byte[])object;
                int n7 = 0;
                while (n7 < n5) {
                    byArray[n7] = (byte)dataBuffer.getElem(this.bankIndices[n7], n6 + this.bandOffsets[n7]);
                    ++n7;
                }
                object = byArray;
                break;
            }
            case 1: {
                short[] sArray = object == null ? new short[n5] : (short[])object;
                int n8 = 0;
                while (n8 < n5) {
                    sArray[n8] = (short)dataBuffer.getElem(this.bankIndices[n8], n6 + this.bandOffsets[n8]);
                    ++n8;
                }
                object = sArray;
                break;
            }
            case 3: {
                int[] nArray = object == null ? new int[n5] : (int[])object;
                int n9 = 0;
                while (n9 < n5) {
                    nArray[n9] = dataBuffer.getElem(this.bankIndices[n9], n6 + this.bandOffsets[n9]);
                    ++n9;
                }
                object = nArray;
                break;
            }
            case 2: {
                short[] sArray = object == null ? new short[n5] : (short[])object;
                int n10 = 0;
                while (n10 < n5) {
                    sArray[n10] = (short)dataBuffer.getElem(this.bankIndices[n10], n6 + this.bandOffsets[n10]);
                    ++n10;
                }
                object = sArray;
                break;
            }
            case 4: {
                float[] fArray = object == null ? new float[n5] : (float[])object;
                int n11 = 0;
                while (n11 < n5) {
                    fArray[n11] = dataBuffer.getElemFloat(this.bankIndices[n11], n6 + this.bandOffsets[n11]);
                    ++n11;
                }
                object = fArray;
                break;
            }
            case 5: {
                double[] dArray = object == null ? new double[n5] : (double[])object;
                int n12 = 0;
                while (n12 < n5) {
                    dArray[n12] = dataBuffer.getElemDouble(this.bankIndices[n12], n6 + this.bandOffsets[n12]);
                    ++n12;
                }
                object = dArray;
                break;
            }
            default: {
                throw new RuntimeException(JaiI18N.getString("RasterFactory3"));
            }
        }
        return object;
    }

    public Object getDataElements(int n2, int n3, int n4, int n5, Object object, DataBuffer dataBuffer) {
        int n6 = this.getTransferType();
        int n7 = this.getNumDataElements();
        int n8 = 0;
        Object object2 = null;
        switch (n6) {
            case 0: {
                byte[] byArray = object == null ? new byte[n7 * n4 * n5] : (byte[])object;
                int n9 = n3;
                while (n9 < n3 + n5) {
                    int n10 = n2;
                    while (n10 < n2 + n4) {
                        object2 = this.getDataElements(n10, n9, object2, dataBuffer);
                        byte[] byArray2 = (byte[])object2;
                        int n11 = 0;
                        while (n11 < n7) {
                            byArray[n8++] = byArray2[n11];
                            ++n11;
                        }
                        ++n10;
                    }
                    ++n9;
                }
                object = byArray;
                break;
            }
            case 1: {
                short[] sArray = object == null ? new short[n7 * n4 * n5] : (short[])object;
                int n12 = n3;
                while (n12 < n3 + n5) {
                    int n13 = n2;
                    while (n13 < n2 + n4) {
                        object2 = this.getDataElements(n13, n12, object2, dataBuffer);
                        short[] sArray2 = (short[])object2;
                        int n14 = 0;
                        while (n14 < n7) {
                            sArray[n8++] = sArray2[n14];
                            ++n14;
                        }
                        ++n13;
                    }
                    ++n12;
                }
                object = sArray;
                break;
            }
            case 3: {
                int[] nArray = object == null ? new int[n7 * n4 * n5] : (int[])object;
                int n15 = n3;
                while (n15 < n3 + n5) {
                    int n16 = n2;
                    while (n16 < n2 + n4) {
                        object2 = this.getDataElements(n16, n15, object2, dataBuffer);
                        int[] nArray2 = (int[])object2;
                        int n17 = 0;
                        while (n17 < n7) {
                            nArray[n8++] = nArray2[n17];
                            ++n17;
                        }
                        ++n16;
                    }
                    ++n15;
                }
                object = nArray;
                break;
            }
            case 2: {
                short[] sArray = object == null ? new short[n7 * n4 * n5] : (short[])object;
                int n18 = n3;
                while (n18 < n3 + n5) {
                    int n19 = n2;
                    while (n19 < n2 + n4) {
                        object2 = this.getDataElements(n19, n18, object2, dataBuffer);
                        short[] sArray3 = (short[])object2;
                        int n20 = 0;
                        while (n20 < n7) {
                            sArray[n8++] = sArray3[n20];
                            ++n20;
                        }
                        ++n19;
                    }
                    ++n18;
                }
                object = sArray;
                break;
            }
            case 4: {
                float[] fArray = object == null ? new float[n7 * n4 * n5] : (float[])object;
                int n21 = n3;
                while (n21 < n3 + n5) {
                    int n22 = n2;
                    while (n22 < n2 + n4) {
                        object2 = this.getDataElements(n22, n21, object2, dataBuffer);
                        float[] fArray2 = (float[])object2;
                        int n23 = 0;
                        while (n23 < n7) {
                            fArray[n8++] = fArray2[n23];
                            ++n23;
                        }
                        ++n22;
                    }
                    ++n21;
                }
                object = fArray;
                break;
            }
            case 5: {
                double[] dArray = object == null ? new double[n7 * n4 * n5] : (double[])object;
                int n24 = n3;
                while (n24 < n3 + n5) {
                    int n25 = n2;
                    while (n25 < n2 + n4) {
                        object2 = this.getDataElements(n25, n24, object2, dataBuffer);
                        double[] dArray2 = (double[])object2;
                        int n26 = 0;
                        while (n26 < n7) {
                            dArray[n8++] = dArray2[n26];
                            ++n26;
                        }
                        ++n25;
                    }
                    ++n24;
                }
                object = dArray;
                break;
            }
            default: {
                throw new RuntimeException(JaiI18N.getString("RasterFactory3"));
            }
        }
        return object;
    }

    public void setDataElements(int n2, int n3, Object object, DataBuffer dataBuffer) {
        int n4 = this.getTransferType();
        int n5 = this.getNumDataElements();
        int n6 = n3 * this.scanlineStride + n2 * this.pixelStride;
        switch (n4) {
            case 0: {
                byte[] byArray = (byte[])object;
                int n7 = 0;
                while (n7 < n5) {
                    dataBuffer.setElem(this.bankIndices[n7], n6 + this.bandOffsets[n7], byArray[n7] & 0xFF);
                    ++n7;
                }
                break;
            }
            case 1: {
                short[] sArray = (short[])object;
                int n8 = 0;
                while (n8 < n5) {
                    dataBuffer.setElem(this.bankIndices[n8], n6 + this.bandOffsets[n8], sArray[n8] & 0xFFFF);
                    ++n8;
                }
                break;
            }
            case 3: {
                int[] nArray = (int[])object;
                int n9 = 0;
                while (n9 < n5) {
                    dataBuffer.setElem(this.bankIndices[n9], n6 + this.bandOffsets[n9], nArray[n9]);
                    ++n9;
                }
                break;
            }
            case 2: {
                short[] sArray = (short[])object;
                int n10 = 0;
                while (n10 < n5) {
                    dataBuffer.setElem(this.bankIndices[n10], n6 + this.bandOffsets[n10], sArray[n10]);
                    ++n10;
                }
                break;
            }
            case 4: {
                float[] fArray = (float[])object;
                int n11 = 0;
                while (n11 < n5) {
                    dataBuffer.setElemFloat(this.bankIndices[n11], n6 + this.bandOffsets[n11], fArray[n11]);
                    ++n11;
                }
                break;
            }
            case 5: {
                double[] dArray = (double[])object;
                int n12 = 0;
                while (n12 < n5) {
                    dataBuffer.setElemDouble(this.bankIndices[n12], n6 + this.bandOffsets[n12], dArray[n12]);
                    ++n12;
                }
                break;
            }
            default: {
                throw new RuntimeException(JaiI18N.getString("RasterFactory3"));
            }
        }
    }

    public void setDataElements(int n2, int n3, int n4, int n5, Object object, DataBuffer dataBuffer) {
        int n6 = 0;
        Object var8_8 = null;
        int n7 = this.getTransferType();
        int n8 = this.getNumDataElements();
        switch (n7) {
            case 0: {
                byte[] byArray = (byte[])object;
                byte[] byArray2 = new byte[n8];
                int n9 = n3;
                while (n9 < n3 + n5) {
                    int n10 = n2;
                    while (n10 < n2 + n4) {
                        int n11 = 0;
                        while (n11 < n8) {
                            byArray2[n11] = byArray[n6++];
                            ++n11;
                        }
                        this.setDataElements(n10, n9, byArray2, dataBuffer);
                        ++n10;
                    }
                    ++n9;
                }
                break;
            }
            case 1: {
                short[] sArray = (short[])object;
                short[] sArray2 = new short[n8];
                int n12 = n3;
                while (n12 < n3 + n5) {
                    int n13 = n2;
                    while (n13 < n2 + n4) {
                        int n14 = 0;
                        while (n14 < n8) {
                            sArray2[n14] = sArray[n6++];
                            ++n14;
                        }
                        this.setDataElements(n13, n12, sArray2, dataBuffer);
                        ++n13;
                    }
                    ++n12;
                }
                break;
            }
            case 3: {
                int[] nArray = (int[])object;
                int[] nArray2 = new int[n8];
                int n15 = n3;
                while (n15 < n3 + n5) {
                    int n16 = n2;
                    while (n16 < n2 + n4) {
                        int n17 = 0;
                        while (n17 < n8) {
                            nArray2[n17] = nArray[n6++];
                            ++n17;
                        }
                        this.setDataElements(n16, n15, nArray2, dataBuffer);
                        ++n16;
                    }
                    ++n15;
                }
                break;
            }
            case 2: {
                short[] sArray = (short[])object;
                short[] sArray3 = new short[n8];
                int n18 = n3;
                while (n18 < n3 + n5) {
                    int n19 = n2;
                    while (n19 < n2 + n4) {
                        int n20 = 0;
                        while (n20 < n8) {
                            sArray3[n20] = sArray[n6++];
                            ++n20;
                        }
                        this.setDataElements(n19, n18, sArray3, dataBuffer);
                        ++n19;
                    }
                    ++n18;
                }
                break;
            }
            case 4: {
                float[] fArray = (float[])object;
                float[] fArray2 = new float[n8];
                int n21 = n3;
                while (n21 < n3 + n5) {
                    int n22 = n2;
                    while (n22 < n2 + n4) {
                        int n23 = 0;
                        while (n23 < n8) {
                            fArray2[n23] = fArray[n6++];
                            ++n23;
                        }
                        this.setDataElements(n22, n21, fArray2, dataBuffer);
                        ++n22;
                    }
                    ++n21;
                }
                break;
            }
            case 5: {
                double[] dArray = (double[])object;
                double[] dArray2 = new double[n8];
                int n24 = n3;
                while (n24 < n3 + n5) {
                    int n25 = n2;
                    while (n25 < n2 + n4) {
                        int n26 = 0;
                        while (n26 < n8) {
                            dArray2[n26] = dArray[n6++];
                            ++n26;
                        }
                        this.setDataElements(n25, n24, dArray2, dataBuffer);
                        ++n25;
                    }
                    ++n24;
                }
                break;
            }
            default: {
                throw new RuntimeException(JaiI18N.getString("RasterFactory3"));
            }
        }
    }

    public void setSample(int n2, int n3, int n4, float f2, DataBuffer dataBuffer) {
        dataBuffer.setElemFloat(this.bankIndices[n4], n3 * this.scanlineStride + n2 * this.pixelStride + this.bandOffsets[n4], f2);
    }

    public float getSampleFloat(int n2, int n3, int n4, DataBuffer dataBuffer) {
        float f2 = dataBuffer.getElemFloat(this.bankIndices[n4], n3 * this.scanlineStride + n2 * this.pixelStride + this.bandOffsets[n4]);
        return f2;
    }

    public void setSample(int n2, int n3, int n4, double d2, DataBuffer dataBuffer) {
        dataBuffer.setElemDouble(this.bankIndices[n4], n3 * this.scanlineStride + n2 * this.pixelStride + this.bandOffsets[n4], d2);
    }

    public double getSampleDouble(int n2, int n3, int n4, DataBuffer dataBuffer) {
        double d2 = dataBuffer.getElemDouble(this.bankIndices[n4], n3 * this.scanlineStride + n2 * this.pixelStride + this.bandOffsets[n4]);
        return d2;
    }

    public double[] getPixels(int n2, int n3, int n4, int n5, double[] dArray, DataBuffer dataBuffer) {
        int n6 = 0;
        double[] dArray2 = dArray != null ? dArray : new double[this.numBands * n4 * n5];
        int n7 = n3;
        while (n7 < n5 + n3) {
            int n8 = n2;
            while (n8 < n4 + n2) {
                int n9 = 0;
                while (n9 < this.numBands) {
                    dArray2[n6++] = this.getSampleDouble(n8, n7, n9, dataBuffer);
                    ++n9;
                }
                ++n8;
            }
            ++n7;
        }
        return dArray2;
    }

    public String toString() {
        String string = "ComponentSampleModelJAI:   dataType=" + this.getDataType() + "  numBands=" + this.getNumBands() + "  width=" + this.getWidth() + "  height=" + this.getHeight() + "  bandOffsets=[ ";
        int n2 = 0;
        while (n2 < this.numBands) {
            string = string + this.getBandOffsets()[n2] + " ";
            ++n2;
        }
        string = string + "]";
        return string;
    }
}

