/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jai.imageioimpl;

import com.sun.media.jai.imageioimpl.I18N;
import com.sun.media.jai.imageioimpl.PixelReplacementImage;
import java.awt.Dimension;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.awt.image.renderable.ParameterBlock;
import java.awt.image.renderable.RenderContext;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.net.Socket;
import java.util.Arrays;
import java.util.EventListener;
import java.util.Iterator;
import java.util.Locale;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import javax.imageio.event.IIOWriteProgressListener;
import javax.imageio.event.IIOWriteWarningListener;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.stream.ImageInputStream;
import javax.imageio.stream.ImageOutputStream;
import javax.media.jai.CRIFImpl;
import javax.media.jai.JAI;
import javax.media.jai.PlanarImage;
import javax.media.jai.RenderableOp;
import javax.media.jai.RenderedImageAdapter;
import javax.media.jai.WritablePropertySource;

public final class ImageWriteCRIF
extends CRIFImpl {
    public static void main(String[] stringArray) throws Throwable {
        Cloneable cloneable;
        File file = new File(stringArray[0]);
        File file2 = new File(stringArray[1]);
        String string = stringArray.length > 2 ? stringArray[2] : "png";
        String string2 = stringArray.length > 3 ? stringArray[3] : "rendered";
        int n2 = 0;
        ImageInputStream imageInputStream = ImageIO.createImageInputStream(file);
        Iterator<ImageReader> iterator = ImageIO.getImageReaders(imageInputStream);
        ImageReader imageReader = iterator.next();
        imageReader.setInput(imageInputStream);
        BufferedImage bufferedImage = imageReader.read(n2);
        IIOMetadata iIOMetadata = imageReader.getStreamMetadata();
        IIOMetadata iIOMetadata2 = imageReader.getImageMetadata(n2);
        BufferedImage[] bufferedImageArray = null;
        if (imageReader.hasThumbnails(n2)) {
            int n3 = imageReader.getNumThumbnails(n2);
            bufferedImageArray = new BufferedImage[n3];
            for (int i2 = 0; i2 < n3; ++i2) {
                bufferedImageArray[i2] = imageReader.readThumbnail(n2, i2);
            }
        }
        ImageWriteCRIF imageWriteCRIF = new ImageWriteCRIF();
        ParameterBlock parameterBlock = new ParameterBlock();
        if (string2.equalsIgnoreCase("rendered")) {
            parameterBlock.addSource(bufferedImage);
        } else if (string2.equalsIgnoreCase("renderable")) {
            cloneable = new ParameterBlock();
            cloneable.addSource(bufferedImage);
            RenderableOp renderableOp = JAI.createRenderable("renderable", cloneable);
            parameterBlock.addSource(renderableOp);
        }
        parameterBlock.add(file2);
        parameterBlock.add(string);
        parameterBlock.add(Boolean.TRUE);
        parameterBlock.add(Boolean.TRUE);
        parameterBlock.add(Boolean.TRUE);
        parameterBlock.add(Boolean.TRUE);
        parameterBlock.add(null);
        parameterBlock.add(iIOMetadata);
        parameterBlock.add(iIOMetadata2);
        parameterBlock.add(bufferedImageArray);
        parameterBlock.add(null);
        parameterBlock.add(null);
        parameterBlock.add(null);
        parameterBlock.add(null);
        if (string2.equalsIgnoreCase("rendered")) {
            imageWriteCRIF.create(parameterBlock, null);
        } else if (string2.equalsIgnoreCase("renderable")) {
            cloneable = new AffineTransform(256.0f, 0.0f, 0.0f, 512.0f, 0.0f, 0.0f);
            imageWriteCRIF.create(new RenderContext((AffineTransform)cloneable), parameterBlock);
        }
    }

    static ImageOutputStream getImageOutputStream(Object object) {
        ImageOutputStream imageOutputStream = null;
        if (object instanceof ImageOutputStream) {
            imageOutputStream = (ImageOutputStream)object;
        } else {
            if (object instanceof String) {
                try {
                    object = new RandomAccessFile((String)object, "rw");
                }
                catch (Exception exception) {
                    throw new RuntimeException(I18N.getString("ImageWriteCRIF0") + " " + object);
                }
            }
            if (object instanceof Socket) {
                try {
                    object = ((Socket)object).getOutputStream();
                }
                catch (Exception exception) {
                    throw new RuntimeException(I18N.getString("ImageWriteCRIF1") + " " + object);
                }
            }
            try {
                imageOutputStream = ImageIO.createImageOutputStream(object);
            }
            catch (IOException iOException) {
                throw new RuntimeException(iOException);
            }
        }
        return imageOutputStream;
    }

    public RenderedImage create(ParameterBlock parameterBlock, RenderingHints renderingHints) {
        return ImageWriteCRIF.create(0, false, parameterBlock, renderingHints);
    }

    private static ImageWriteParam getWriteParam(ImageWriteParam imageWriteParam, ImageWriter imageWriter) {
        ImageWriteParam imageWriteParam2 = imageWriteParam;
        if (imageWriteParam == null) {
            imageWriteParam2 = imageWriter.getDefaultWriteParam();
        } else if (imageWriteParam.getClass().getName().equals("javax.imageio.ImageWriteParam")) {
            int n2;
            imageWriteParam2 = imageWriter.getDefaultWriteParam();
            if (imageWriteParam.hasController()) {
                imageWriteParam2.setController(imageWriteParam.getController());
            }
            imageWriteParam2.setDestinationOffset(imageWriteParam.getDestinationOffset());
            imageWriteParam2.setDestinationType(imageWriteParam.getDestinationType());
            imageWriteParam2.setSourceBands(imageWriteParam.getSourceBands());
            imageWriteParam2.setSourceRegion(imageWriteParam.getSourceRegion());
            imageWriteParam2.setSourceSubsampling(imageWriteParam.getSourceXSubsampling(), imageWriteParam.getSourceYSubsampling(), imageWriteParam.getSubsamplingXOffset(), imageWriteParam.getSubsamplingYOffset());
            if (imageWriteParam.canWriteCompressed()) {
                n2 = imageWriteParam.getCompressionMode();
                imageWriteParam2.setCompressionMode(n2);
                if (n2 == 2) {
                    imageWriteParam2.setCompressionQuality(imageWriteParam.getCompressionQuality());
                    imageWriteParam2.setCompressionType(imageWriteParam.getCompressionType());
                }
            }
            if (imageWriteParam.canWriteProgressive()) {
                imageWriteParam2.setProgressiveMode(imageWriteParam.getProgressiveMode());
            }
            if (imageWriteParam.canWriteTiles()) {
                n2 = imageWriteParam.getTilingMode();
                imageWriteParam2.setTilingMode(n2);
                if (n2 == 2) {
                    imageWriteParam2.setTiling(imageWriteParam.getTileWidth(), imageWriteParam.getTileHeight(), imageWriteParam.getTileGridXOffset(), imageWriteParam.getTileGridYOffset());
                }
            }
        }
        return imageWriteParam2;
    }

    private static ImageWriteParam setTileSize(ImageWriteParam imageWriteParam, ImageWriter imageWriter, Dimension dimension, RenderedImage renderedImage) {
        ImageWriteParam imageWriteParam2 = ImageWriteCRIF.getWriteParam(imageWriteParam, imageWriter);
        if (imageWriteParam2.canWriteTiles()) {
            if (dimension != null) {
                if (dimension.width <= 0 || dimension.height <= 0) {
                    throw new IllegalArgumentException("tileSize.width <= 0 || tileSize.height <= 0");
                }
                imageWriteParam2.setTilingMode(2);
                imageWriteParam2.setTiling(dimension.width, dimension.height, 0, 0);
            } else if (imageWriteParam == null) {
                if (renderedImage.getNumXTiles() > 1 || renderedImage.getNumYTiles() > 1) {
                    imageWriteParam2.setTilingMode(2);
                    imageWriteParam2.setTiling(renderedImage.getTileWidth(), renderedImage.getTileHeight(), 0, 0);
                }
            } else if (imageWriteParam2.getTilingMode() == 2) {
                boolean bl2 = false;
                Dimension[] dimensionArray = imageWriteParam2.getPreferredTileSizes();
                int n2 = 0;
                try {
                    n2 = imageWriteParam2.getTileWidth();
                }
                catch (IllegalStateException illegalStateException) {
                    bl2 = true;
                    n2 = dimensionArray != null && dimensionArray.length >= 2 && dimensionArray[0].width > 0 && dimensionArray[1].width > 0 ? (dimensionArray[0].width + dimensionArray[1].width) / 2 : renderedImage.getTileWidth();
                }
                int n3 = 0;
                try {
                    n3 = imageWriteParam2.getTileHeight();
                }
                catch (IllegalStateException illegalStateException) {
                    bl2 = true;
                    n3 = dimensionArray != null && dimensionArray.length >= 2 && dimensionArray[0].height > 0 && dimensionArray[1].height > 0 ? (dimensionArray[0].height + dimensionArray[1].height) / 2 : renderedImage.getTileHeight();
                }
                if (bl2) {
                    imageWriteParam2.setTiling(n2, n3, 0, 0);
                }
            }
        }
        return imageWriteParam2;
    }

    static RenderedImage create(int n2, boolean bl2, ParameterBlock parameterBlock, RenderingHints renderingHints) {
        Object object;
        Object object2;
        ImageWriter imageWriter;
        RenderedImage renderedImage = null;
        RenderedImage renderedImage2 = parameterBlock.getRenderedSource(0);
        ImageWriteParam imageWriteParam = (ImageWriteParam)parameterBlock.getObjectParameter(12);
        ImageTypeSpecifier imageTypeSpecifier = null;
        if (imageWriteParam != null) {
            imageTypeSpecifier = imageWriteParam.getDestinationType();
        }
        if (imageTypeSpecifier == null) {
            imageTypeSpecifier = new ImageTypeSpecifier(renderedImage2);
        }
        if ((imageWriter = (ImageWriter)parameterBlock.getObjectParameter(13)) == null && (object2 = ImageIO.getImageWriters(imageTypeSpecifier, (String)(object = (String)parameterBlock.getObjectParameter(1)))) != null && object2.hasNext()) {
            imageWriter = (ImageWriter)object2.next();
        }
        if (imageWriter != null) {
            EventListener[] eventListenerArray;
            Object object3;
            BufferedImage[] bufferedImageArray;
            Object object4;
            object = null;
            if (!bl2) {
                object2 = parameterBlock.getObjectParameter(0);
                ImageOutputStream imageOutputStream = ImageWriteCRIF.getImageOutputStream(object2);
                object = imageOutputStream != object2 ? imageOutputStream : null;
                imageWriter.setOutput(imageOutputStream != null ? imageOutputStream : object2);
            }
            boolean bl3 = (Boolean)parameterBlock.getObjectParameter(2);
            boolean bl4 = (Boolean)parameterBlock.getObjectParameter(3);
            IIOMetadata iIOMetadata = null;
            if (!bl2) {
                iIOMetadata = (IIOMetadata)parameterBlock.getObjectParameter(7);
                if (iIOMetadata == null && bl3 && (object4 = renderedImage2.getProperty("JAI.StreamMetadata")) instanceof IIOMetadata) {
                    iIOMetadata = (IIOMetadata)object4;
                }
                if (iIOMetadata != null && bl4) {
                    iIOMetadata = imageWriter.convertStreamMetadata(iIOMetadata, imageWriteParam);
                }
            }
            if ((object4 = (IIOMetadata)parameterBlock.getObjectParameter(8)) == null && bl3 && (bufferedImageArray = renderedImage2.getProperty("JAI.ImageMetadata")) instanceof IIOMetadata) {
                object4 = (IIOMetadata)bufferedImageArray;
            }
            if (object4 != null && bl4) {
                object4 = imageWriter.convertImageMetadata((IIOMetadata)object4, imageTypeSpecifier, imageWriteParam);
            }
            bufferedImageArray = null;
            if (imageWriter.getNumThumbnailsSupported(imageTypeSpecifier, imageWriteParam, iIOMetadata, (IIOMetadata)object4) > 0 && (bufferedImageArray = (BufferedImage[])parameterBlock.getObjectParameter(9)) == null && bl3 && (object3 = renderedImage2.getProperty("JAI.ImageMetadata")) instanceof BufferedImage[]) {
                bufferedImageArray = (BufferedImage[])object3;
            }
            if ((object3 = (Locale)parameterBlock.getObjectParameter(11)) != null) {
                imageWriter.setLocale((Locale)object3);
            }
            if ((eventListenerArray = (EventListener[])parameterBlock.getObjectParameter(10)) != null) {
                for (int i2 = 0; i2 < eventListenerArray.length; ++i2) {
                    EventListener eventListener = eventListenerArray[i2];
                    if (eventListener instanceof IIOWriteProgressListener) {
                        imageWriter.addIIOWriteProgressListener((IIOWriteProgressListener)eventListener);
                    }
                    if (!(eventListener instanceof IIOWriteWarningListener)) continue;
                    imageWriter.addIIOWriteWarningListener((IIOWriteWarningListener)eventListener);
                }
            }
            imageWriteParam = ImageWriteCRIF.setTileSize(imageWriteParam, imageWriter, (Dimension)parameterBlock.getObjectParameter(6), renderedImage2);
            IIOImage iIOImage = new IIOImage(renderedImage2, bufferedImageArray != null ? Arrays.asList(bufferedImageArray) : null, (IIOMetadata)object4);
            try {
                Object object5;
                if (bl2) {
                    imageWriter.writeToSequence(iIOImage, imageWriteParam);
                } else {
                    imageWriter.write(iIOMetadata, iIOImage, imageWriteParam);
                }
                boolean bl5 = (Boolean)parameterBlock.getObjectParameter(5);
                if (bl5 && renderedImage2 instanceof PlanarImage && imageWriter.canReplacePixels(n2)) {
                    renderedImage = new PixelReplacementImage(renderedImage2, renderingHints, imageWriteParam, imageWriter, n2, (ImageOutputStream)object);
                    ((PlanarImage)renderedImage2).addSink(renderedImage);
                } else if (!bl2) {
                    object5 = imageWriter.getOutput();
                    if (object5 != parameterBlock.getObjectParameter(0) && object5 instanceof ImageOutputStream) {
                        ((ImageOutputStream)object5).flush();
                    }
                    renderedImage = renderedImage2 instanceof WritablePropertySource ? renderedImage2 : new RenderedImageAdapter(renderedImage2);
                }
                object5 = (WritablePropertySource)((Object)renderedImage);
                object5.setProperty("JAI.ImageWriteParam", imageWriteParam);
                object5.setProperty("JAI.ImageWriter", imageWriter);
                if (iIOMetadata != null) {
                    object5.setProperty("JAI.StreamMetadata", iIOMetadata);
                }
                if (object4 != null) {
                    object5.setProperty("JAI.ImageMetadata", object4);
                }
                if (bufferedImageArray != null) {
                    object5.setProperty("JAI.Thumbnails", bufferedImageArray);
                }
            }
            catch (IOException iOException) {
                throw new RuntimeException(iOException);
            }
        }
        return renderedImage;
    }
}

