/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jai.iterator;

import com.sun.media.jai.iterator.JaiI18N;
import com.sun.media.jai.iterator.RectIterFallback;
import java.awt.Rectangle;
import java.awt.image.ComponentSampleModel;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import javax.media.jai.PlanarImage;

public abstract class RectIterCSM
extends RectIterFallback {
    protected int[] bankIndices;
    protected int scanlineStride;
    protected int pixelStride;
    protected int[] bandOffsets;
    protected int[] DBOffsets;
    protected int offset;
    protected int bandOffset;

    public RectIterCSM(RenderedImage renderedImage, Rectangle rectangle) {
        super(renderedImage, rectangle);
        ComponentSampleModel componentSampleModel = (ComponentSampleModel)this.sampleModel;
        this.scanlineStride = componentSampleModel.getScanlineStride();
        this.pixelStride = componentSampleModel.getPixelStride();
        this.bankIndices = componentSampleModel.getBankIndices();
        int[] nArray = componentSampleModel.getBandOffsets();
        this.bandOffsets = new int[this.numBands + 1];
        int n2 = 0;
        while (n2 < this.numBands) {
            this.bandOffsets[n2] = nArray[n2];
            ++n2;
        }
        this.bandOffsets[this.numBands] = 0;
        this.DBOffsets = new int[this.numBands];
        this.offset = (this.y - this.sampleModelTranslateY) * this.scanlineStride + (this.x - this.sampleModelTranslateX) * this.pixelStride;
        this.bandOffset = this.bandOffsets[0];
    }

    protected void dataBufferChanged() {
    }

    protected void adjustBandOffsets() {
        int[] nArray = this.dataBuffer.getOffsets();
        int n2 = 0;
        while (n2 < this.numBands) {
            int n3 = this.bankIndices[n2];
            int n4 = n2++;
            this.bandOffsets[n4] = this.bandOffsets[n4] + (nArray[n3] - this.DBOffsets[n3]);
        }
        this.DBOffsets = nArray;
    }

    protected void setDataBuffer() {
        Raster raster = this.im.getTile(this.tileX, this.tileY);
        this.dataBuffer = raster.getDataBuffer();
        this.dataBufferChanged();
        int n2 = raster.getSampleModelTranslateX();
        int n3 = raster.getSampleModelTranslateY();
        int n4 = this.sampleModelTranslateX - n2;
        int n5 = this.sampleModelTranslateY - n3;
        this.offset += n5 * this.scanlineStride + n4 * this.pixelStride;
        this.sampleModelTranslateX = n2;
        this.sampleModelTranslateY = n3;
    }

    public void startLines() {
        this.offset += (this.bounds.y - this.y) * this.scanlineStride;
        this.y = this.bounds.y;
        this.tileY = this.startTileY;
        this.setTileYBounds();
        this.setDataBuffer();
    }

    public void nextLine() {
        ++this.y;
        this.offset += this.scanlineStride;
    }

    public void jumpLines(int n2) {
        int n3 = this.y + n2;
        if (n3 < this.bounds.y || n3 > this.lastY) {
            throw new IndexOutOfBoundsException(JaiI18N.getString("RectIterFallback1"));
        }
        this.y = n3;
        this.offset += n2 * this.scanlineStride;
        if (this.y < this.prevYBoundary || this.y > this.nextYBoundary) {
            this.tileY = PlanarImage.YToTileY(this.y, this.tileGridYOffset, this.tileHeight);
            this.setTileYBounds();
            this.setDataBuffer();
        }
    }

    public void startPixels() {
        this.offset += (this.bounds.x - this.x) * this.pixelStride;
        this.x = this.bounds.x;
        this.tileX = this.startTileX;
        this.setTileXBounds();
        this.setDataBuffer();
    }

    public void nextPixel() {
        ++this.x;
        this.offset += this.pixelStride;
    }

    public void jumpPixels(int n2) {
        int n3 = this.x + n2;
        if (n3 < this.bounds.x || n3 > this.lastX) {
            throw new IndexOutOfBoundsException(JaiI18N.getString("RectIterFallback0"));
        }
        this.x = n3;
        this.offset += n2 * this.pixelStride;
        if (this.x < this.prevXBoundary || this.x > this.nextXBoundary) {
            this.tileX = PlanarImage.XToTileX(this.x, this.tileGridXOffset, this.tileWidth);
            this.setTileXBounds();
            this.setDataBuffer();
        }
    }

    public void startBands() {
        this.b = 0;
        this.bandOffset = this.bandOffsets[0];
    }

    public void nextBand() {
        ++this.b;
        this.bandOffset = this.bandOffsets[this.b];
    }
}

