/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jai.iterator;

import com.sun.media.jai.iterator.RectIterCSM;
import com.sun.media.jai.util.DataBufferUtils;
import java.awt.Rectangle;
import java.awt.image.RenderedImage;

public class RectIterCSMFloat
extends RectIterCSM {
    float[][] bankData;
    float[] bank;

    public RectIterCSMFloat(RenderedImage renderedImage, Rectangle rectangle) {
        super(renderedImage, rectangle);
        this.bankData = new float[this.numBands + 1][];
        this.dataBufferChanged();
    }

    protected final void dataBufferChanged() {
        if (this.bankData == null) {
            return;
        }
        float[][] fArray = DataBufferUtils.getBankDataFloat(this.dataBuffer);
        int n2 = 0;
        while (n2 < this.numBands) {
            this.bankData[n2] = fArray[this.bankIndices[n2]];
            ++n2;
        }
        this.bank = this.bankData[this.b];
        this.adjustBandOffsets();
    }

    public void startBands() {
        super.startBands();
        this.bank = this.bankData[0];
    }

    public void nextBand() {
        super.nextBand();
        this.bank = this.bankData[this.b];
    }

    public final int getSample() {
        return (int)this.bank[this.offset + this.bandOffset];
    }

    public final int getSample(int n2) {
        return (int)this.bankData[n2][this.offset + this.bandOffsets[n2]];
    }

    public final float getSampleFloat() {
        return this.bank[this.offset + this.bandOffset];
    }

    public final float getSampleFloat(int n2) {
        return this.bankData[n2][this.offset + this.bandOffsets[n2]];
    }

    public final double getSampleDouble() {
        return this.bank[this.offset + this.bandOffset];
    }

    public final double getSampleDouble(int n2) {
        return this.bankData[n2][this.offset + this.bandOffsets[n2]];
    }

    public int[] getPixel(int[] nArray) {
        if (nArray == null) {
            nArray = new int[this.numBands];
        }
        int n2 = 0;
        while (n2 < this.numBands) {
            nArray[n2] = (int)this.bankData[n2][this.offset + this.bandOffsets[n2]];
            ++n2;
        }
        return nArray;
    }

    public float[] getPixel(float[] fArray) {
        if (fArray == null) {
            fArray = new float[this.numBands];
        }
        int n2 = 0;
        while (n2 < this.numBands) {
            fArray[n2] = this.bankData[n2][this.offset + this.bandOffsets[n2]];
            ++n2;
        }
        return fArray;
    }

    public double[] getPixel(double[] dArray) {
        if (dArray == null) {
            dArray = new double[this.numBands];
        }
        int n2 = 0;
        while (n2 < this.numBands) {
            dArray[n2] = this.bankData[n2][this.offset + this.bandOffsets[n2]];
            ++n2;
        }
        return dArray;
    }
}

