/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jai.mlib;

import com.sun.media.jai.mlib.JaiI18N;
import com.sun.media.jai.opimage.FFT;
import com.sun.media.jai.util.MathJAI;
import com.sun.medialib.mlib.Image;

public class FFTmediaLib
extends FFT {
    private boolean specialUnitaryScaling = false;
    private static final double SQUARE_ROOT_OF_2 = Math.sqrt(2.0);

    public FFTmediaLib(boolean bl2, Integer n2, int n3) {
        super(bl2, n2, n3);
    }

    public void setLength(int n2) {
        if (this.lengthIsSet && n2 == this.length) {
            return;
        }
        if (!MathJAI.isPositivePowerOf2(n2)) {
            throw new RuntimeException(JaiI18N.getString("FFTmediaLib0"));
        }
        this.length = n2;
        if (!this.lengthIsSet || n2 != this.real.length) {
            this.real = new double[n2];
            this.imag = new double[n2];
        }
        this.lengthIsSet = true;
        if (this.scaleType == FFT.SCALING_UNITARY) {
            int n3 = 0;
            int n4 = 1;
            while (n4 < n2) {
                n4 <<= 1;
                ++n3;
            }
            this.specialUnitaryScaling = n3 % 2 != 0;
        }
    }

    public void getData(int n2, Object object, int n3, int n4, Object object2, int n5, int n6) {
        switch (n2) {
            case 4: {
                float[] fArray = (float[])object;
                if (object2 != null) {
                    float[] fArray2 = (float[])object2;
                    if (n3 == n5 && n4 == n6) {
                        int n7 = 0;
                        while (n7 < this.length) {
                            fArray[n3] = (float)this.real[n7];
                            fArray2[n3] = (float)this.imag[n7];
                            n3 += n4;
                            ++n7;
                        }
                    } else {
                        int n8 = 0;
                        while (n8 < this.length) {
                            fArray[n3] = (float)this.real[n8];
                            fArray2[n5] = (float)this.imag[n8];
                            n3 += n4;
                            n5 += n6;
                            ++n8;
                        }
                    }
                } else {
                    int n9 = 0;
                    while (n9 < this.length) {
                        fArray[n3] = (float)this.real[n9];
                        n3 += n4;
                        ++n9;
                    }
                }
                break;
            }
            case 5: {
                double[] dArray = (double[])object;
                if (object2 != null) {
                    double[] dArray2 = (double[])object2;
                    if (n3 == n5 && n4 == n6) {
                        int n10 = 0;
                        while (n10 < this.length) {
                            dArray[n3] = this.real[n10];
                            dArray2[n3] = this.imag[n10];
                            n3 += n4;
                            ++n10;
                        }
                    } else {
                        int n11 = 0;
                        while (n11 < this.length) {
                            dArray[n3] = this.real[n11];
                            dArray2[n5] = this.imag[n11];
                            n3 += n4;
                            n5 += n6;
                            ++n11;
                        }
                    }
                } else {
                    int n12 = 0;
                    while (n12 < this.length) {
                        dArray[n3] = this.real[n12];
                        n3 += n4;
                        ++n12;
                    }
                }
                break;
            }
            default: {
                throw new RuntimeException(n2 + JaiI18N.getString("FFTmediaLib1"));
            }
        }
    }

    public void transform() {
        if (this.exponentSign < 0) {
            if (this.scaleType == FFT.SCALING_NONE) {
                Image.FFT_1(this.real, this.imag);
            } else if (this.scaleType == FFT.SCALING_UNITARY) {
                Image.FFT_3(this.real, this.imag);
                if (this.specialUnitaryScaling) {
                    int n2 = 0;
                    while (n2 < this.length) {
                        int n3 = n2;
                        this.real[n3] = this.real[n3] * SQUARE_ROOT_OF_2;
                        int n4 = n2++;
                        this.imag[n4] = this.imag[n4] * SQUARE_ROOT_OF_2;
                    }
                }
            } else if (this.scaleType == FFT.SCALING_DIMENSIONS) {
                Image.FFT_2(this.real, this.imag);
            }
        } else if (this.scaleType == FFT.SCALING_NONE) {
            Image.IFFT_2(this.real, this.imag);
        } else if (this.scaleType == FFT.SCALING_UNITARY) {
            Image.IFFT_3(this.real, this.imag);
            if (this.specialUnitaryScaling) {
                int n5 = 0;
                while (n5 < this.length) {
                    int n6 = n5;
                    this.real[n6] = this.real[n6] / SQUARE_ROOT_OF_2;
                    int n7 = n5++;
                    this.imag[n7] = this.imag[n7] / SQUARE_ROOT_OF_2;
                }
            }
        } else if (this.scaleType == FFT.SCALING_DIMENSIONS) {
            Image.IFFT_1(this.real, this.imag);
        }
    }
}

