/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jai.mlib;

import com.sun.media.jai.mlib.JaiI18N;
import com.sun.media.jai.mlib.MediaLibAccessor;
import com.sun.media.jai.util.ImageUtil;
import com.sun.media.jai.util.JDKWorkarounds;
import com.sun.medialib.mlib.Image;
import com.sun.medialib.mlib.mediaLibImage;
import java.awt.Rectangle;
import java.awt.image.ComponentSampleModel;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.util.Map;
import javax.media.jai.ImageLayout;
import javax.media.jai.PointOpImage;
import javax.media.jai.RasterFactory;

final class MlibBandCombineOpImage
extends PointOpImage {
    private double[] cmat = new double[9];
    private double[] offset = new double[3];
    private boolean isOffsetNonZero = false;

    public MlibBandCombineOpImage(RenderedImage renderedImage, Map map, ImageLayout imageLayout, double[][] dArray) {
        super(renderedImage, imageLayout, map, true);
        int n2 = dArray.length;
        if (this.getSampleModel().getNumBands() != n2) {
            this.sampleModel = RasterFactory.createComponentSampleModel(this.sampleModel, this.sampleModel.getDataType(), this.tileWidth, this.tileHeight, n2);
            if (this.colorModel != null && !JDKWorkarounds.areCompatibleDataModels(this.sampleModel, this.colorModel)) {
                this.colorModel = ImageUtil.getCompatibleColorModel(this.sampleModel, map);
            }
        }
        ComponentSampleModel componentSampleModel = (ComponentSampleModel)renderedImage.getSampleModel();
        int[] nArray = componentSampleModel.getBankIndices();
        int[] nArray2 = componentSampleModel.getBandOffsets();
        if (nArray[0] == nArray[1] && nArray[0] == nArray[2] && nArray2[0] > nArray2[2]) {
            int n3 = 0;
            while (n3 < 3) {
                int n4 = 8 - 3 * n3;
                int n5 = 0;
                while (n5 < 3) {
                    this.cmat[n4--] = dArray[n3][n5];
                    ++n5;
                }
                this.offset[2 - n3] = dArray[n3][3];
                if (this.offset[n3] != 0.0) {
                    this.isOffsetNonZero = true;
                }
                ++n3;
            }
        } else {
            int n6 = 0;
            while (n6 < 3) {
                int n7 = 3 * n6;
                int n8 = 0;
                while (n8 < 3) {
                    this.cmat[n7++] = dArray[n6][n8];
                    ++n8;
                }
                this.offset[n6] = dArray[n6][3];
                if (this.offset[n6] != 0.0) {
                    this.isOffsetNonZero = true;
                }
                ++n6;
            }
        }
    }

    protected void computeRect(Raster[] rasterArray, WritableRaster writableRaster, Rectangle rectangle) {
        Raster raster = rasterArray[0];
        Rectangle rectangle2 = this.mapDestRect(rectangle, 0);
        int n2 = MediaLibAccessor.findCompatibleTag(rasterArray, writableRaster);
        MediaLibAccessor mediaLibAccessor = new MediaLibAccessor(raster, rectangle2, n2);
        MediaLibAccessor mediaLibAccessor2 = new MediaLibAccessor(writableRaster, rectangle, n2);
        mediaLibImage[] mediaLibImageArray = mediaLibAccessor.getMediaLibImages();
        mediaLibImage[] mediaLibImageArray2 = mediaLibAccessor2.getMediaLibImages();
        switch (mediaLibAccessor2.getDataType()) {
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                int n3 = 0;
                while (n3 < mediaLibImageArray2.length) {
                    if (this.isOffsetNonZero) {
                        Image.ColorConvert2(mediaLibImageArray2[n3], mediaLibImageArray[n3], this.cmat, this.offset);
                    } else {
                        Image.ColorConvert1(mediaLibImageArray2[n3], mediaLibImageArray[n3], this.cmat);
                    }
                    ++n3;
                }
                break;
            }
            case 4: 
            case 5: {
                int n4 = 0;
                while (n4 < mediaLibImageArray2.length) {
                    if (this.isOffsetNonZero) {
                        Image.ColorConvert2_Fp(mediaLibImageArray2[n4], mediaLibImageArray[n4], this.cmat, this.offset);
                    } else {
                        Image.ColorConvert1_Fp(mediaLibImageArray2[n4], mediaLibImageArray[n4], this.cmat);
                    }
                    ++n4;
                }
                break;
            }
            default: {
                String string = this.getClass().getName();
                throw new RuntimeException(string + JaiI18N.getString("Generic2"));
            }
        }
        if (mediaLibAccessor2.isDataCopy()) {
            mediaLibAccessor2.clampDataArrays();
            mediaLibAccessor2.copyDataToRaster();
        }
    }
}

