/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jai.mlib;

import com.sun.media.jai.mlib.MediaLibAccessor;
import com.sun.media.jai.mlib.MlibBinarizeOpImage;
import com.sun.media.jai.opimage.RIFUtil;
import java.awt.RenderingHints;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.awt.image.renderable.ParameterBlock;
import java.awt.image.renderable.RenderedImageFactory;
import java.util.Map;
import javax.media.jai.ImageLayout;

public class MlibBinarizeRIF
implements RenderedImageFactory {
    public RenderedImage create(ParameterBlock parameterBlock, RenderingHints renderingHints) {
        RenderedImage renderedImage = parameterBlock.getRenderedSource(0);
        SampleModel sampleModel = renderedImage.getSampleModel();
        if (!MediaLibAccessor.isMediaLibCompatible(parameterBlock) || sampleModel.getNumBands() > 1) {
            return null;
        }
        double d2 = parameterBlock.getDoubleParameter(0);
        if ((d2 > 255.0 || d2 <= 0.0) && sampleModel.getDataType() == 0 || (d2 > 32767.0 || d2 <= 0.0) && sampleModel.getDataType() == 2 || (d2 > 2.147483647E9 || d2 <= 0.0) && sampleModel.getDataType() == 3) {
            return null;
        }
        ImageLayout imageLayout = RIFUtil.getImageLayoutHint(renderingHints);
        return new MlibBinarizeOpImage(renderedImage, imageLayout, (Map)renderingHints, d2);
    }
}

