/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jai.mlib;

import com.sun.media.jai.mlib.MediaLibAccessor;
import com.sun.media.jai.mlib.MlibConvolve3x3Or5x5OpImage;
import com.sun.media.jai.mlib.MlibConvolveOpImage;
import com.sun.media.jai.mlib.MlibSeparableConvolveOpImage;
import com.sun.media.jai.opimage.RIFUtil;
import java.awt.RenderingHints;
import java.awt.image.RenderedImage;
import java.awt.image.renderable.ParameterBlock;
import java.awt.image.renderable.RenderedImageFactory;
import javax.media.jai.BorderExtender;
import javax.media.jai.ImageLayout;
import javax.media.jai.KernelJAI;

public class MlibConvolveRIF
implements RenderedImageFactory {
    public RenderedImage create(ParameterBlock parameterBlock, RenderingHints renderingHints) {
        boolean bl2;
        ImageLayout imageLayout = RIFUtil.getImageLayoutHint(renderingHints);
        if (!MediaLibAccessor.isMediaLibCompatible(parameterBlock, imageLayout) || !MediaLibAccessor.hasSameNumBands(parameterBlock, imageLayout)) {
            return null;
        }
        BorderExtender borderExtender = RIFUtil.getBorderExtenderHint(renderingHints);
        RenderedImage renderedImage = parameterBlock.getRenderedSource(0);
        KernelJAI kernelJAI = (KernelJAI)parameterBlock.getObjectParameter(0);
        KernelJAI kernelJAI2 = kernelJAI.getRotatedKernel();
        int n2 = kernelJAI2.getWidth();
        int n3 = kernelJAI2.getHeight();
        if (n2 < 2 || n3 < 2) {
            return null;
        }
        boolean bl3 = bl2 = n2 == kernelJAI2.getXOrigin() * 2 + 1 && n3 == kernelJAI2.getYOrigin() * 2 + 1;
        if (kernelJAI2.isSeparable() && n2 >= 3 && n2 <= 7 && n2 == n3) {
            return new MlibSeparableConvolveOpImage(renderedImage, borderExtender, renderingHints, imageLayout, kernelJAI2);
        }
        if (n2 == 3 && n3 == 3 || n2 == 5 && n3 == 5) {
            return new MlibConvolve3x3Or5x5OpImage(renderedImage, borderExtender, renderingHints, imageLayout, kernelJAI2);
        }
        return new MlibConvolveOpImage(renderedImage, borderExtender, renderingHints, imageLayout, kernelJAI2);
    }
}

