/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jai.mlib;

import com.sun.media.jai.mlib.JaiI18N;
import com.sun.media.jai.mlib.MediaLibAccessor;
import com.sun.medialib.mlib.Image;
import com.sun.medialib.mlib.mediaLibImage;
import java.awt.Rectangle;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.util.Map;
import javax.media.jai.AreaOpImage;
import javax.media.jai.BorderExtender;
import javax.media.jai.ImageLayout;
import javax.media.jai.KernelJAI;

final class MlibGradientOpImage
extends AreaOpImage {
    protected KernelJAI kernel_h;
    protected KernelJAI kernel_v;
    private int kh;
    private int kw;
    private int kx;
    private int ky;
    float[] kernel_h_data;
    float[] kernel_v_data;
    double[] dbl_kh_data;
    double[] dbl_kv_data;

    public MlibGradientOpImage(RenderedImage renderedImage, BorderExtender borderExtender, Map map, ImageLayout imageLayout, KernelJAI kernelJAI, KernelJAI kernelJAI2) {
        super(renderedImage, imageLayout, map, true, borderExtender, kernelJAI.getLeftPadding(), kernelJAI.getRightPadding(), kernelJAI.getTopPadding(), kernelJAI.getBottomPadding());
        this.kernel_h = kernelJAI;
        this.kernel_v = kernelJAI2;
        this.kw = kernelJAI.getWidth();
        this.kh = kernelJAI.getHeight();
        this.kx = this.kw / 2;
        this.ky = this.kh / 2;
        this.kernel_h_data = kernelJAI.getKernelData();
        this.kernel_v_data = kernelJAI2.getKernelData();
        int n2 = this.kw * this.kh;
        this.dbl_kh_data = new double[n2];
        this.dbl_kv_data = new double[n2];
        int n3 = 0;
        while (n3 < n2) {
            this.dbl_kh_data[n3] = this.kernel_h_data[n3];
            this.dbl_kv_data[n3] = this.kernel_v_data[n3];
            ++n3;
        }
    }

    protected void computeRect(Raster[] rasterArray, WritableRaster writableRaster, Rectangle rectangle) {
        Raster raster = rasterArray[0];
        Rectangle rectangle2 = this.mapDestRect(rectangle, 0);
        int n2 = MediaLibAccessor.findCompatibleTag(rasterArray, writableRaster);
        MediaLibAccessor mediaLibAccessor = new MediaLibAccessor(raster, rectangle2, n2);
        MediaLibAccessor mediaLibAccessor2 = new MediaLibAccessor(writableRaster, rectangle, n2);
        int n3 = this.getSampleModel().getNumBands();
        mediaLibImage[] mediaLibImageArray = mediaLibAccessor.getMediaLibImages();
        mediaLibImage[] mediaLibImageArray2 = mediaLibAccessor2.getMediaLibImages();
        int n4 = 0;
        while (n4 < mediaLibImageArray2.length) {
            switch (mediaLibAccessor2.getDataType()) {
                case 0: 
                case 1: 
                case 2: 
                case 3: {
                    Image.GradientMxN(mediaLibImageArray2[n4], mediaLibImageArray[n4], this.dbl_kh_data, this.dbl_kv_data, this.kw, this.kh, this.kx, this.ky, (1 << n3) - 1, 0);
                    break;
                }
                case 4: 
                case 5: {
                    Image.GradientMxN_Fp(mediaLibImageArray2[n4], mediaLibImageArray[n4], this.dbl_kh_data, this.dbl_kv_data, this.kw, this.kh, this.kx, this.ky, (1 << n3) - 1, 0);
                    break;
                }
                default: {
                    String string = this.getClass().getName();
                    throw new RuntimeException(JaiI18N.getString("Generic2"));
                }
            }
            ++n4;
        }
        if (mediaLibAccessor2.isDataCopy()) {
            mediaLibAccessor2.copyDataToRaster();
        }
    }
}

