/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jai.mlib;

import com.sun.media.jai.mlib.FFTmediaLib;
import com.sun.media.jai.mlib.MediaLibAccessor;
import com.sun.media.jai.mlib.MlibDFTOpImage;
import com.sun.media.jai.opimage.DFTOpImage;
import com.sun.media.jai.opimage.RIFUtil;
import com.sun.media.jai.util.MathJAI;
import java.awt.RenderingHints;
import java.awt.image.RenderedImage;
import java.awt.image.renderable.ParameterBlock;
import java.awt.image.renderable.RenderedImageFactory;
import javax.media.jai.BorderExtender;
import javax.media.jai.EnumeratedParameter;
import javax.media.jai.ImageLayout;
import javax.media.jai.JAI;
import javax.media.jai.operator.DFTDescriptor;

public class MlibIDFTRIF
implements RenderedImageFactory {
    public RenderedImage create(ParameterBlock parameterBlock, RenderingHints renderingHints) {
        ImageLayout imageLayout = RIFUtil.getImageLayoutHint(renderingHints);
        if (!MediaLibAccessor.isMediaLibCompatible(new ParameterBlock())) {
            return null;
        }
        RenderedImage renderedImage = parameterBlock.getRenderedSource(0);
        EnumeratedParameter enumeratedParameter = (EnumeratedParameter)parameterBlock.getObjectParameter(0);
        EnumeratedParameter enumeratedParameter2 = (EnumeratedParameter)parameterBlock.getObjectParameter(1);
        boolean bl2 = !enumeratedParameter2.equals(DFTDescriptor.REAL_TO_COMPLEX);
        int n2 = renderedImage.getSampleModel().getNumBands();
        if ((bl2 && n2 == 2 || !bl2 && n2 == 1) && MlibDFTOpImage.isAcceptableSampleModel(renderedImage.getSampleModel())) {
            int n3 = renderedImage.getWidth();
            int n4 = renderedImage.getHeight();
            if (!MathJAI.isPositivePowerOf2(n3) || !MathJAI.isPositivePowerOf2(n4)) {
                ParameterBlock parameterBlock2 = new ParameterBlock();
                parameterBlock2.addSource(renderedImage);
                parameterBlock2.add(0);
                parameterBlock2.add(MathJAI.nextPositivePowerOf2(n3) - n3);
                parameterBlock2.add(0);
                parameterBlock2.add(MathJAI.nextPositivePowerOf2(n4) - n4);
                parameterBlock2.add(BorderExtender.createInstance(0));
                renderedImage = JAI.create("border", parameterBlock2);
            }
            return new MlibDFTOpImage(renderedImage, renderingHints, imageLayout, enumeratedParameter2, false, enumeratedParameter);
        }
        FFTmediaLib fFTmediaLib = new FFTmediaLib(false, new Integer(enumeratedParameter.getValue()), 2);
        return new DFTOpImage(renderedImage, renderingHints, imageLayout, enumeratedParameter2, fFTmediaLib);
    }
}

