/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jai.mlib;

import com.sun.media.jai.mlib.MediaLibAccessor;
import com.sun.media.jai.util.ImageUtil;
import com.sun.media.jai.util.JDKWorkarounds;
import com.sun.medialib.mlib.Image;
import com.sun.medialib.mlib.mediaLibImage;
import java.awt.Rectangle;
import java.awt.image.ComponentSampleModel;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import java.util.Map;
import javax.media.jai.ImageLayout;
import javax.media.jai.LookupTableJAI;
import javax.media.jai.PointOpImage;

final class MlibLookupOpImage
extends PointOpImage {
    private LookupTableJAI table;

    public MlibLookupOpImage(RenderedImage renderedImage, Map map, ImageLayout imageLayout, LookupTableJAI lookupTableJAI) {
        super(renderedImage, imageLayout, map, true);
        this.table = lookupTableJAI;
        SampleModel sampleModel = renderedImage.getSampleModel();
        if (this.sampleModel.getTransferType() != lookupTableJAI.getDataType() || this.sampleModel.getNumBands() != lookupTableJAI.getDestNumBands(sampleModel.getNumBands())) {
            this.sampleModel = lookupTableJAI.getDestSampleModel(sampleModel, this.tileWidth, this.tileHeight);
            if (this.colorModel != null && !JDKWorkarounds.areCompatibleDataModels(this.sampleModel, this.colorModel)) {
                this.colorModel = ImageUtil.getCompatibleColorModel(this.sampleModel, map);
            }
        }
        this.permitInPlaceOperation();
    }

    protected void computeRect(Raster[] rasterArray, WritableRaster writableRaster, Rectangle rectangle) {
        Object object;
        mediaLibImage[] mediaLibImageArray;
        Raster raster = rasterArray[0];
        Rectangle rectangle2 = this.mapDestRect(rectangle, 0);
        int n2 = MediaLibAccessor.findCompatibleTag(null, raster);
        int n3 = MediaLibAccessor.findCompatibleTag(null, writableRaster);
        SampleModel sampleModel = raster.getSampleModel();
        if (sampleModel.getNumBands() > 1) {
            int n4 = n2 & 0x80;
            int n5 = n3 & 0x80;
            int n6 = n2 & 0x7F;
            int n7 = n3 & 0x7F;
            if (!(n4 == 0 && n5 == 0 && MediaLibAccessor.isPixelSequential(sampleModel) && MediaLibAccessor.isPixelSequential(this.sampleModel) && MediaLibAccessor.hasMatchingBandOffsets((ComponentSampleModel)sampleModel, (ComponentSampleModel)this.sampleModel))) {
                n2 = n6 | 0x80;
                n3 = n7 | 0x80;
            }
        }
        MediaLibAccessor mediaLibAccessor = new MediaLibAccessor(raster, rectangle2, n2);
        MediaLibAccessor mediaLibAccessor2 = new MediaLibAccessor(writableRaster, rectangle, n3);
        mediaLibImage[] mediaLibImageArray2 = mediaLibAccessor.getMediaLibImages();
        if (mediaLibImageArray2.length < (mediaLibImageArray = mediaLibAccessor2.getMediaLibImages()).length) {
            object = mediaLibImageArray2[0];
            mediaLibImageArray2 = new mediaLibImage[mediaLibImageArray.length];
            int n8 = 0;
            while (n8 < mediaLibImageArray.length) {
                mediaLibImageArray2[n8] = object;
                ++n8;
            }
        }
        object = mediaLibAccessor2.getBandOffsets();
        Object object2 = this.getTableData((int[])object);
        int[] nArray = this.getTableOffsets((int[])object);
        int n9 = 0;
        while (n9 < mediaLibImageArray.length) {
            Image.LookUp2(mediaLibImageArray[n9], mediaLibImageArray2[n9], object2, nArray);
            ++n9;
        }
        if (mediaLibAccessor2.isDataCopy()) {
            mediaLibAccessor2.copyDataToRaster();
        }
    }

    private Object getTableData(int[] nArray) {
        int n2 = this.table.getNumBands();
        int n3 = this.sampleModel.getNumBands();
        Object object = null;
        switch (this.table.getDataType()) {
            case 0: {
                byte[][] byArrayArray = new byte[n3][];
                if (n2 < n3) {
                    int n4 = 0;
                    while (n4 < n3) {
                        byArrayArray[n4] = this.table.getByteData(0);
                        ++n4;
                    }
                } else {
                    int n5 = 0;
                    while (n5 < n3) {
                        byArrayArray[n5] = this.table.getByteData(nArray[n5]);
                        ++n5;
                    }
                }
                object = byArrayArray;
                break;
            }
            case 1: 
            case 2: {
                short[][] sArrayArray = new short[n3][];
                if (n2 < n3) {
                    int n6 = 0;
                    while (n6 < n3) {
                        sArrayArray[n6] = this.table.getShortData(0);
                        ++n6;
                    }
                } else {
                    int n7 = 0;
                    while (n7 < n3) {
                        sArrayArray[n7] = this.table.getShortData(nArray[n7]);
                        ++n7;
                    }
                }
                object = sArrayArray;
                break;
            }
            case 3: {
                int[][] nArrayArray = new int[n3][];
                if (n2 < n3) {
                    int n8 = 0;
                    while (n8 < n3) {
                        nArrayArray[n8] = this.table.getIntData(0);
                        ++n8;
                    }
                } else {
                    int n9 = 0;
                    while (n9 < n3) {
                        nArrayArray[n9] = this.table.getIntData(nArray[n9]);
                        ++n9;
                    }
                }
                object = nArrayArray;
                break;
            }
            case 4: {
                float[][] fArrayArray = new float[n3][];
                if (n2 < n3) {
                    int n10 = 0;
                    while (n10 < n3) {
                        fArrayArray[n10] = this.table.getFloatData(0);
                        ++n10;
                    }
                } else {
                    int n11 = 0;
                    while (n11 < n3) {
                        fArrayArray[n11] = this.table.getFloatData(nArray[n11]);
                        ++n11;
                    }
                }
                object = fArrayArray;
                break;
            }
            case 5: {
                double[][] dArrayArray = new double[n3][];
                if (n2 < n3) {
                    int n12 = 0;
                    while (n12 < n3) {
                        dArrayArray[n12] = this.table.getDoubleData(0);
                        ++n12;
                    }
                } else {
                    int n13 = 0;
                    while (n13 < n3) {
                        dArrayArray[n13] = this.table.getDoubleData(nArray[n13]);
                        ++n13;
                    }
                }
                object = dArrayArray;
            }
        }
        return object;
    }

    private int[] getTableOffsets(int[] nArray) {
        int n2 = this.table.getNumBands();
        int n3 = this.sampleModel.getNumBands();
        int[] nArray2 = new int[n3];
        if (n2 < n3) {
            int n4 = 0;
            while (n4 < n3) {
                nArray2[n4] = this.table.getOffset(0);
                ++n4;
            }
        } else {
            int n5 = 0;
            while (n5 < n3) {
                nArray2[n5] = this.table.getOffset(nArray[n5]);
                ++n5;
            }
        }
        return nArray2;
    }
}

