/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jai.mlib;

import com.sun.media.jai.mlib.MediaLibAccessor;
import com.sun.media.jai.mlib.MlibMaxFilterOpImage;
import com.sun.media.jai.opimage.RIFUtil;
import java.awt.RenderingHints;
import java.awt.image.RenderedImage;
import java.awt.image.renderable.ParameterBlock;
import java.awt.image.renderable.RenderedImageFactory;
import javax.media.jai.BorderExtender;
import javax.media.jai.ImageLayout;
import javax.media.jai.operator.MaxFilterDescriptor;
import javax.media.jai.operator.MaxFilterShape;

public class MlibMaxFilterRIF
implements RenderedImageFactory {
    public RenderedImage create(ParameterBlock parameterBlock, RenderingHints renderingHints) {
        ImageLayout imageLayout = RIFUtil.getImageLayoutHint(renderingHints);
        if (!MediaLibAccessor.isMediaLibCompatible(parameterBlock, imageLayout) || !MediaLibAccessor.hasSameNumBands(parameterBlock, imageLayout)) {
            return null;
        }
        BorderExtender borderExtender = RIFUtil.getBorderExtenderHint(renderingHints);
        MaxFilterShape maxFilterShape = (MaxFilterShape)parameterBlock.getObjectParameter(0);
        int n2 = parameterBlock.getIntParameter(1);
        RenderedImage renderedImage = parameterBlock.getRenderedSource(0);
        if (maxFilterShape.equals(MaxFilterDescriptor.MAX_MASK_SQUARE) && (n2 == 3 || n2 == 5 || n2 == 7) && renderedImage.getSampleModel().getNumBands() == 1) {
            return new MlibMaxFilterOpImage(renderedImage, borderExtender, renderingHints, imageLayout, maxFilterShape, n2);
        }
        return null;
    }
}

