/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jai.mlib;

import com.sun.media.jai.mlib.JaiI18N;
import com.sun.media.jai.mlib.MediaLibAccessor;
import com.sun.media.jai.opimage.MosaicOpImage;
import com.sun.medialib.mlib.Image;
import com.sun.medialib.mlib.mediaLibImage;
import java.awt.Rectangle;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import java.util.Vector;
import javax.media.jai.ImageLayout;
import javax.media.jai.PlanarImage;
import javax.media.jai.ROI;
import javax.media.jai.operator.MosaicDescriptor;
import javax.media.jai.operator.MosaicType;

final class MlibMosaicOpImage
extends MosaicOpImage {
    private int[] glow;
    private int[] ghigh;
    private int shift;

    public MlibMosaicOpImage(Vector vector, ImageLayout imageLayout, Map map, MosaicType mosaicType, PlanarImage[] planarImageArray, ROI[] rOIArray, double[][] dArray, double[] dArray2) {
        super(vector, imageLayout, map, mosaicType, planarImageArray, rOIArray, dArray, dArray2);
        int n2;
        int n3 = vector.size();
        int n4 = this.sampleModel.getDataType();
        if (n4 == 4 || n4 == 5) {
            throw new UnsupportedOperationException(JaiI18N.getString("MlibMosaicOpImage0"));
        }
        int n5 = 0;
        while (n5 < n3) {
            n2 = 0;
            while (n2 < this.numBands) {
                int[] nArray = this.threshold[n5];
                int n6 = n2++;
                nArray[n6] = nArray[n6] - 1;
            }
            ++n5;
        }
        n2 = -2147483647;
        int n7 = Integer.MAX_VALUE;
        switch (n4) {
            case 0: {
                n2 = 0;
                n7 = 255;
                this.shift = 8;
                break;
            }
            case 1: {
                n2 = 0;
                n7 = 65535;
                this.shift = 16;
                break;
            }
            case 2: {
                n2 = Short.MIN_VALUE;
                n7 = Short.MAX_VALUE;
                this.shift = 16;
                break;
            }
            case 3: {
                n2 = Integer.MIN_VALUE;
                n7 = Integer.MAX_VALUE;
                this.shift = 32;
                break;
            }
        }
        this.glow = new int[this.numBands];
        Arrays.fill(this.glow, n2);
        this.ghigh = new int[this.numBands];
        Arrays.fill(this.ghigh, n7);
    }

    protected void computeRect(Raster[] rasterArray, WritableRaster writableRaster, Rectangle rectangle, Raster[] rasterArray2, Raster[] rasterArray3) {
        int n2 = rasterArray.length;
        ArrayList<Raster> arrayList = new ArrayList<Raster>(n2);
        int n3 = 0;
        while (n3 < n2) {
            if (rasterArray[n3] != null) {
                arrayList.add(rasterArray[n3]);
            }
            ++n3;
        }
        int n4 = arrayList.size();
        Raster[] rasterArray4 = null;
        if (n4 != 0) {
            rasterArray4 = new Raster[n4];
            arrayList.toArray(rasterArray4);
        }
        int n5 = MediaLibAccessor.findCompatibleTag(rasterArray4, writableRaster);
        MediaLibAccessor mediaLibAccessor = new MediaLibAccessor(writableRaster, rectangle, n5);
        mediaLibImage[] mediaLibImageArray = mediaLibAccessor.getMediaLibImages();
        int[] nArray = mediaLibAccessor.getIntParameters(0, this.background);
        if (n4 == 0) {
            Image.Clear(mediaLibImageArray[0], nArray);
            return;
        }
        MediaLibAccessor[] mediaLibAccessorArray = new MediaLibAccessor[n2];
        int n6 = 0;
        while (n6 < n2) {
            if (rasterArray[n6] != null) {
                mediaLibAccessorArray[n6] = new MediaLibAccessor(rasterArray[n6], rectangle, n5);
            }
            ++n6;
        }
        int[][] nArrayArray = new int[n2][];
        mediaLibImage[][] mediaLibImageArrayArray = new mediaLibImage[n2][];
        int n7 = 0;
        while (n7 < n2) {
            if (mediaLibAccessorArray[n7] != null) {
                mediaLibImageArrayArray[n7] = mediaLibAccessorArray[n7].getMediaLibImages();
                nArrayArray[n7] = mediaLibAccessorArray[n7].getIntParameters(0, this.threshold[n7]);
            }
            ++n7;
        }
        mediaLibImage mediaLibImage2 = null;
        mediaLibImage mediaLibImage3 = null;
        mediaLibImage[] mediaLibImageArray2 = new mediaLibImage[]{mediaLibImage2};
        mediaLibImage[] mediaLibImageArray3 = new mediaLibImage[]{mediaLibImage3};
        if (this.mosaicType == MosaicDescriptor.MOSAIC_TYPE_OVERLAY) {
            Image.Clear(mediaLibImageArray[0], nArray);
            int n8 = n2 - 1;
            while (n8 >= 0) {
                if (mediaLibImageArrayArray[n8] != null) {
                    mediaLibImage mediaLibImage4 = this.getWeightImage(rectangle, n5, mediaLibImageArray[0], mediaLibImageArrayArray[n8][0], this.sourceAlpha != null && this.sourceAlpha[n8] != null ? rasterArray2[n8] : null, this.sourceROI != null && this.sourceROI[n8] != null ? rasterArray3[n8] : null, nArrayArray[n8], mediaLibImageArray2, mediaLibImageArray3);
                    Image.Blend2(mediaLibImageArray[0], mediaLibImageArrayArray[n8][0], mediaLibImage4);
                }
                --n8;
            }
        } else if (this.mosaicType == MosaicDescriptor.MOSAIC_TYPE_BLEND) {
            mediaLibImage2 = new mediaLibImage(mediaLibImageArray[0].getType(), 1, mediaLibImageArray[0].getWidth(), mediaLibImageArray[0].getHeight());
            mediaLibImage3 = new mediaLibImage(mediaLibImageArray[0].getType(), mediaLibImageArray[0].getChannels(), mediaLibImageArray[0].getWidth(), mediaLibImageArray[0].getHeight());
            mediaLibImage[] mediaLibImageArray4 = new mediaLibImage[n4];
            mediaLibImage[] mediaLibImageArray5 = new mediaLibImage[n4];
            int n9 = 0;
            int n10 = 0;
            while (n10 < n2) {
                if (mediaLibImageArrayArray[n10] != null) {
                    mediaLibImageArray5[n9] = mediaLibImageArrayArray[n10][0];
                    mediaLibImageArray4[n9] = this.getWeightImage(rectangle, n5, mediaLibImageArray[0], mediaLibImageArrayArray[n10][0], this.sourceAlpha != null && this.sourceAlpha[n10] != null ? rasterArray2[n10] : null, this.sourceROI != null && this.sourceROI[n10] != null ? rasterArray3[n10] : null, nArrayArray[n10], null, null);
                    ++n9;
                }
                ++n10;
            }
            if (n9 != n4) {
                mediaLibImage[] mediaLibImageArray6 = new mediaLibImage[n9];
                System.arraycopy(mediaLibImageArray5, 0, mediaLibImageArray6, 0, n9);
                mediaLibImageArray5 = mediaLibImageArray6;
                mediaLibImage[] mediaLibImageArray7 = new mediaLibImage[n9];
                System.arraycopy(mediaLibImageArray4, 0, mediaLibImageArray7, 0, n9);
                mediaLibImageArray4 = mediaLibImageArray7;
            }
            Image.BlendMulti(mediaLibImageArray[0], mediaLibImageArray5, mediaLibImageArray4, nArray);
        }
        if (mediaLibAccessor.isDataCopy()) {
            mediaLibAccessor.clampDataArrays();
            mediaLibAccessor.copyDataToRaster();
        }
    }

    private mediaLibImage getWeightImage(Rectangle rectangle, int n2, mediaLibImage mediaLibImage2, mediaLibImage mediaLibImage3, Raster raster, Raster raster2, int[] nArray, mediaLibImage[] mediaLibImageArray, mediaLibImage[] mediaLibImageArray2) {
        mediaLibImage mediaLibImage4 = null;
        if (raster != null) {
            MediaLibAccessor mediaLibAccessor = new MediaLibAccessor(raster, rectangle, n2);
            mediaLibImage[] mediaLibImageArray3 = mediaLibAccessor.getMediaLibImages();
            if (this.isAlphaBitmask) {
                if (mediaLibImageArray == null) {
                    mediaLibImageArray = new mediaLibImage[]{null};
                }
                if (mediaLibImageArray[0] == null) {
                    mediaLibImageArray[0] = new mediaLibImage(mediaLibImage3.getType(), 1, mediaLibImage3.getWidth(), mediaLibImage3.getHeight());
                }
                Image.Thresh1(mediaLibImageArray[0], mediaLibImageArray3[0], new int[]{0}, new int[]{this.ghigh[0]}, new int[]{this.glow[0]});
                mediaLibImage4 = mediaLibImageArray[0];
            } else {
                mediaLibImage4 = mediaLibImageArray3[0];
            }
        } else if (raster2 != null) {
            int n3 = MediaLibAccessor.findCompatibleTag(null, raster2);
            MediaLibAccessor mediaLibAccessor = new MediaLibAccessor(raster2, rectangle, n3, true);
            mediaLibImage[] mediaLibImageArray4 = mediaLibAccessor.getMediaLibImages();
            if (mediaLibImageArray == null) {
                mediaLibImageArray = new mediaLibImage[]{null};
            }
            if (mediaLibImageArray[0] == null) {
                mediaLibImageArray[0] = new mediaLibImage(mediaLibImage3.getType(), 1, mediaLibImage3.getWidth(), mediaLibImage3.getHeight());
            }
            if (mediaLibImageArray[0].getType() != mediaLibImageArray4[0].getType()) {
                if (mediaLibImageArray[0] == null) {
                    mediaLibImageArray[0] = new mediaLibImage(mediaLibImage3.getType(), 1, mediaLibImage3.getWidth(), mediaLibImage3.getHeight());
                }
                Image.DataTypeConvert(mediaLibImageArray[0], mediaLibImageArray4[0]);
            } else {
                mediaLibImageArray[0] = mediaLibImageArray4[0];
            }
            Image.Thresh1(mediaLibImageArray[0], new int[]{0}, new int[]{this.ghigh[0]}, new int[]{this.glow[0]});
            mediaLibImage4 = mediaLibImageArray[0];
        } else {
            if (mediaLibImageArray2 == null) {
                mediaLibImageArray2 = new mediaLibImage[]{null};
            }
            if (mediaLibImageArray2[0] == null) {
                mediaLibImageArray2[0] = mediaLibImage2.createCompatibleImage();
            }
            mediaLibImage4 = mediaLibImageArray2[0];
            Image.Thresh1(mediaLibImage4, mediaLibImage3, nArray, this.ghigh, this.glow);
        }
        return mediaLibImage4;
    }
}

