/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jai.mlib;

import com.sun.media.jai.mlib.MediaLibAccessor;
import com.sun.media.jai.mlib.MlibAffineBicubicOpImage;
import com.sun.media.jai.mlib.MlibAffineBilinearOpImage;
import com.sun.media.jai.mlib.MlibAffineNearestOpImage;
import com.sun.media.jai.mlib.MlibAffineTableOpImage;
import com.sun.media.jai.mlib.MlibCopyOpImage;
import com.sun.media.jai.mlib.MlibTransposeOpImage;
import com.sun.media.jai.opimage.RIFUtil;
import com.sun.media.jai.opimage.TranslateIntOpImage;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.image.RenderedImage;
import java.awt.image.renderable.ParameterBlock;
import java.awt.image.renderable.RenderedImageFactory;
import java.util.Map;
import javax.media.jai.BorderExtender;
import javax.media.jai.ImageLayout;
import javax.media.jai.Interpolation;
import javax.media.jai.InterpolationBicubic;
import javax.media.jai.InterpolationBicubic2;
import javax.media.jai.InterpolationBilinear;
import javax.media.jai.InterpolationNearest;
import javax.media.jai.InterpolationTable;
import javax.media.jai.JAI;

public class MlibRotateRIF
implements RenderedImageFactory {
    public RenderedImage create(ParameterBlock parameterBlock, RenderingHints renderingHints) {
        ImageLayout imageLayout = RIFUtil.getImageLayoutHint(renderingHints);
        Interpolation interpolation = (Interpolation)parameterBlock.getObjectParameter(3);
        double[] dArray = (double[])parameterBlock.getObjectParameter(4);
        RenderedImage renderedImage = parameterBlock.getRenderedSource(0);
        if (!MediaLibAccessor.isMediaLibCompatible(parameterBlock, imageLayout) || !MediaLibAccessor.hasSameNumBands(parameterBlock, imageLayout) || renderedImage.getTileWidth() >= 32768 || renderedImage.getTileHeight() >= 32768) {
            return null;
        }
        BorderExtender borderExtender = RIFUtil.getBorderExtenderHint(renderingHints);
        float f2 = parameterBlock.getFloatParameter(0);
        float f3 = parameterBlock.getFloatParameter(1);
        float f4 = parameterBlock.getFloatParameter(2);
        double d2 = (double)(180.0f * f4) / Math.PI;
        double d3 = Math.round(d2);
        if (Math.abs(d3 - d2) < 1.0E-4) {
            int n2 = (int)d3 % 360;
            if (n2 < 0) {
                n2 += 360;
            }
            if (n2 == 0) {
                return new MlibCopyOpImage(renderedImage, renderingHints, imageLayout);
            }
            int n3 = Math.round(f2);
            int n4 = Math.round(f3);
            if (n2 % 90 == 0 && (double)Math.abs(f2 - (float)n3) < 1.0E-4 && (double)Math.abs(f3 - (float)n4) < 1.0E-4) {
                int n5 = -1;
                int n6 = 0;
                int n7 = 0;
                int n8 = renderedImage.getMinX();
                int n9 = renderedImage.getMinY();
                int n10 = n8 + renderedImage.getWidth();
                int n11 = n9 + renderedImage.getHeight();
                if (n2 == 90) {
                    n5 = 4;
                    n6 = n3 - (n11 - n4);
                    n7 = n4 - (n3 - n8);
                } else if (n2 == 180) {
                    n5 = 5;
                    n6 = 2 * n3 - n10;
                    n7 = 2 * n4 - n11;
                } else {
                    n5 = 6;
                    n6 = n3 - (n4 - n9);
                    n7 = n4 - (n10 - n3);
                }
                MlibTransposeOpImage mlibTransposeOpImage = new MlibTransposeOpImage(renderedImage, renderingHints, imageLayout, n5);
                int n12 = mlibTransposeOpImage.getMinX();
                int n13 = mlibTransposeOpImage.getMinY();
                if (imageLayout == null) {
                    return new TranslateIntOpImage(mlibTransposeOpImage, renderingHints, n6 - n12, n7 - n13);
                }
                ParameterBlock parameterBlock2 = new ParameterBlock();
                parameterBlock2.addSource(mlibTransposeOpImage);
                parameterBlock2.add(0.0f);
                parameterBlock2.add(0.0f);
                parameterBlock2.add(n6 - n12);
                parameterBlock2.add(n7 - n13);
                parameterBlock2.add(interpolation);
                return JAI.create("scale", parameterBlock2, renderingHints);
            }
        }
        AffineTransform affineTransform = AffineTransform.getRotateInstance(f4, f2, f3);
        if (interpolation instanceof InterpolationNearest) {
            return new MlibAffineNearestOpImage(renderedImage, borderExtender, (Map)renderingHints, imageLayout, affineTransform, interpolation, dArray);
        }
        if (interpolation instanceof InterpolationBilinear) {
            return new MlibAffineBilinearOpImage(renderedImage, borderExtender, (Map)renderingHints, imageLayout, affineTransform, interpolation, dArray);
        }
        if (interpolation instanceof InterpolationBicubic || interpolation instanceof InterpolationBicubic2) {
            return new MlibAffineBicubicOpImage(renderedImage, borderExtender, (Map)renderingHints, imageLayout, affineTransform, interpolation, dArray);
        }
        if (interpolation instanceof InterpolationTable) {
            return new MlibAffineTableOpImage(renderedImage, borderExtender, (Map)renderingHints, imageLayout, affineTransform, interpolation, dArray);
        }
        return null;
    }
}

