/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jai.mlib;

import com.sun.media.jai.mlib.MediaLibAccessor;
import com.sun.media.jai.mlib.MlibCopyOpImage;
import com.sun.media.jai.mlib.MlibScaleBicubicOpImage;
import com.sun.media.jai.mlib.MlibScaleBilinearOpImage;
import com.sun.media.jai.mlib.MlibScaleNearestOpImage;
import com.sun.media.jai.mlib.MlibScaleTableOpImage;
import com.sun.media.jai.opimage.RIFUtil;
import com.sun.media.jai.opimage.TranslateIntOpImage;
import java.awt.RenderingHints;
import java.awt.image.MultiPixelPackedSampleModel;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.awt.image.renderable.ParameterBlock;
import java.awt.image.renderable.RenderedImageFactory;
import javax.media.jai.BorderExtender;
import javax.media.jai.ImageLayout;
import javax.media.jai.Interpolation;
import javax.media.jai.InterpolationBicubic;
import javax.media.jai.InterpolationBicubic2;
import javax.media.jai.InterpolationBilinear;
import javax.media.jai.InterpolationNearest;
import javax.media.jai.InterpolationTable;

public class MlibScaleRIF
implements RenderedImageFactory {
    private static final float TOLERANCE = 0.01f;

    public RenderedImage create(ParameterBlock parameterBlock, RenderingHints renderingHints) {
        boolean bl2;
        ImageLayout imageLayout = RIFUtil.getImageLayoutHint(renderingHints);
        Interpolation interpolation = (Interpolation)parameterBlock.getObjectParameter(4);
        RenderedImage renderedImage = parameterBlock.getRenderedSource(0);
        if (!MediaLibAccessor.isMediaLibCompatible(parameterBlock, imageLayout) || !MediaLibAccessor.hasSameNumBands(parameterBlock, imageLayout) || renderedImage.getTileWidth() >= 32768 || renderedImage.getTileHeight() >= 32768) {
            return null;
        }
        SampleModel sampleModel = renderedImage.getSampleModel();
        boolean bl3 = bl2 = sampleModel instanceof MultiPixelPackedSampleModel && sampleModel.getSampleSize(0) == 1 && (sampleModel.getDataType() == 0 || sampleModel.getDataType() == 1 || sampleModel.getDataType() == 3);
        if (bl2) {
            return null;
        }
        BorderExtender borderExtender = RIFUtil.getBorderExtenderHint(renderingHints);
        float f2 = parameterBlock.getFloatParameter(0);
        float f3 = parameterBlock.getFloatParameter(1);
        float f4 = parameterBlock.getFloatParameter(2);
        float f5 = parameterBlock.getFloatParameter(3);
        if (f2 == 1.0f && f3 == 1.0f && f4 == 0.0f && f5 == 0.0f) {
            return new MlibCopyOpImage(renderedImage, renderingHints, imageLayout);
        }
        if (f2 == 1.0f && f3 == 1.0f && Math.abs(f4 - (float)((int)f4)) < 0.01f && Math.abs(f5 - (float)((int)f5)) < 0.01f && imageLayout == null) {
            return new TranslateIntOpImage(renderedImage, renderingHints, (int)f4, (int)f5);
        }
        if (interpolation instanceof InterpolationNearest) {
            return new MlibScaleNearestOpImage(renderedImage, borderExtender, renderingHints, imageLayout, f2, f3, f4, f5, interpolation);
        }
        if (interpolation instanceof InterpolationBilinear) {
            return new MlibScaleBilinearOpImage(renderedImage, borderExtender, renderingHints, imageLayout, f2, f3, f4, f5, interpolation);
        }
        if (interpolation instanceof InterpolationBicubic || interpolation instanceof InterpolationBicubic2) {
            return new MlibScaleBicubicOpImage(renderedImage, borderExtender, renderingHints, imageLayout, f2, f3, f4, f5, interpolation);
        }
        if (interpolation instanceof InterpolationTable) {
            return new MlibScaleTableOpImage(renderedImage, borderExtender, renderingHints, imageLayout, f2, f3, f4, f5, interpolation);
        }
        return null;
    }
}

