/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jai.mlib;

import com.sun.media.jai.mlib.JaiI18N;
import com.sun.media.jai.mlib.MediaLibAccessor;
import com.sun.medialib.mlib.Image;
import com.sun.medialib.mlib.mediaLibImage;
import java.awt.Rectangle;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.util.Map;
import javax.media.jai.AreaOpImage;
import javax.media.jai.BorderExtender;
import javax.media.jai.ImageLayout;
import javax.media.jai.KernelJAI;

final class MlibSeparableConvolveOpImage
extends AreaOpImage {
    protected KernelJAI kernel;
    private int kw;
    private int kh;
    float[] hValues;
    float[] vValues;
    double[] hDoubleData;
    double[] vDoubleData;
    int[] hIntData;
    int[] vIntData;
    int shift = -1;

    public MlibSeparableConvolveOpImage(RenderedImage renderedImage, BorderExtender borderExtender, Map map, ImageLayout imageLayout, KernelJAI kernelJAI) {
        super(renderedImage, imageLayout, map, true, borderExtender, kernelJAI.getLeftPadding(), kernelJAI.getRightPadding(), kernelJAI.getTopPadding(), kernelJAI.getBottomPadding());
        this.kernel = kernelJAI;
        this.kw = kernelJAI.getWidth();
        this.kh = kernelJAI.getHeight();
        this.hValues = kernelJAI.getHorizontalKernelData();
        this.vValues = kernelJAI.getVerticalKernelData();
        this.hDoubleData = new double[this.hValues.length];
        int n2 = 0;
        while (n2 < this.hValues.length) {
            this.hDoubleData[n2] = this.hValues[n2];
            ++n2;
        }
        this.vDoubleData = new double[this.vValues.length];
        int n3 = 0;
        while (n3 < this.vValues.length) {
            this.vDoubleData[n3] = this.vValues[n3];
            ++n3;
        }
        this.hIntData = new int[this.hValues.length];
        this.vIntData = new int[this.vValues.length];
    }

    private synchronized void setShift(int n2) {
        if (this.shift == -1) {
            int n3 = MediaLibAccessor.getMediaLibDataType(n2);
            this.shift = Image.SConvKernelConvert(this.hIntData, this.vIntData, this.hDoubleData, this.vDoubleData, this.kw, this.kh, n3);
        }
    }

    protected void computeRect(Raster[] rasterArray, WritableRaster writableRaster, Rectangle rectangle) {
        Raster raster = rasterArray[0];
        Rectangle rectangle2 = this.mapDestRect(rectangle, 0);
        int n2 = MediaLibAccessor.findCompatibleTag(rasterArray, writableRaster);
        MediaLibAccessor mediaLibAccessor = new MediaLibAccessor(raster, rectangle2, n2);
        MediaLibAccessor mediaLibAccessor2 = new MediaLibAccessor(writableRaster, rectangle, n2);
        int n3 = this.getSampleModel().getNumBands();
        mediaLibImage[] mediaLibImageArray = mediaLibAccessor.getMediaLibImages();
        mediaLibImage[] mediaLibImageArray2 = mediaLibAccessor2.getMediaLibImages();
        int n4 = 0;
        while (n4 < mediaLibImageArray2.length) {
            switch (mediaLibAccessor2.getDataType()) {
                case 0: 
                case 1: 
                case 2: 
                case 3: {
                    if (this.shift == -1) {
                        this.setShift(n2);
                    }
                    switch (this.kw) {
                        case 3: {
                            Image.SConv3x3(mediaLibImageArray2[n4], mediaLibImageArray[n4], this.hIntData, this.vIntData, this.shift, (1 << n3) - 1, 0);
                            break;
                        }
                        case 5: {
                            Image.SConv5x5(mediaLibImageArray2[n4], mediaLibImageArray[n4], this.hIntData, this.vIntData, this.shift, (1 << n3) - 1, 0);
                            break;
                        }
                        case 7: {
                            Image.SConv7x7(mediaLibImageArray2[n4], mediaLibImageArray[n4], this.hIntData, this.vIntData, this.shift, (1 << n3) - 1, 0);
                        }
                    }
                    break;
                }
                case 4: 
                case 5: {
                    switch (this.kw) {
                        case 3: {
                            Image.SConv3x3_Fp(mediaLibImageArray2[n4], mediaLibImageArray[n4], this.hDoubleData, this.vDoubleData, (1 << n3) - 1, 0);
                            break;
                        }
                        case 5: {
                            Image.SConv5x5_Fp(mediaLibImageArray2[n4], mediaLibImageArray[n4], this.hDoubleData, this.vDoubleData, (1 << n3) - 1, 0);
                            break;
                        }
                        case 7: {
                            Image.SConv7x7_Fp(mediaLibImageArray2[n4], mediaLibImageArray[n4], this.hDoubleData, this.vDoubleData, (1 << n3) - 1, 0);
                        }
                    }
                    break;
                }
                default: {
                    String string = this.getClass().getName();
                    throw new RuntimeException(JaiI18N.getString("Generic2"));
                }
            }
            ++n4;
        }
        if (mediaLibAccessor2.isDataCopy()) {
            mediaLibAccessor2.copyDataToRaster();
        }
    }
}

