/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jai.mlib;

import com.sun.media.jai.mlib.JaiI18N;
import com.sun.media.jai.mlib.MediaLibAccessor;
import com.sun.media.jai.util.ImageUtil;
import com.sun.medialib.mlib.Image;
import com.sun.medialib.mlib.mediaLibImage;
import com.sun.medialib.mlib.mediaLibImageInterpTable;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.util.Map;
import javax.media.jai.BorderExtender;
import javax.media.jai.ImageLayout;
import javax.media.jai.Interpolation;
import javax.media.jai.InterpolationTable;
import javax.media.jai.WarpGrid;
import javax.media.jai.WarpOpImage;

final class MlibWarpGridTableOpImage
extends WarpOpImage {
    private int xStart;
    private int xStep;
    private int xNumCells;
    private int xEnd;
    private int yStart;
    private int yStep;
    private int yNumCells;
    private int yEnd;
    private float[] xWarpPos;
    private float[] yWarpPos;
    private mediaLibImageInterpTable mlibInterpTableI = null;
    private mediaLibImageInterpTable mlibInterpTableF = null;
    private mediaLibImageInterpTable mlibInterpTableD = null;

    public MlibWarpGridTableOpImage(RenderedImage renderedImage, BorderExtender borderExtender, Map map, ImageLayout imageLayout, WarpGrid warpGrid, Interpolation interpolation, double[] dArray) {
        super(renderedImage, imageLayout, map, true, borderExtender, interpolation, warpGrid, dArray);
        this.xStart = warpGrid.getXStart();
        this.xStep = warpGrid.getXStep();
        this.xNumCells = warpGrid.getXNumCells();
        this.xEnd = this.xStart + this.xStep * this.xNumCells;
        this.yStart = warpGrid.getYStart();
        this.yStep = warpGrid.getYStep();
        this.yNumCells = warpGrid.getYNumCells();
        this.yEnd = this.yStart + this.yStep * this.yNumCells;
        this.xWarpPos = warpGrid.getXWarpPos();
        this.yWarpPos = warpGrid.getYWarpPos();
    }

    protected Rectangle backwardMapRect(Rectangle rectangle, int n2) {
        Rectangle rectangle2 = super.backwardMapRect(rectangle, n2);
        rectangle2.setBounds(rectangle2.x - 1, rectangle2.y - 1, rectangle2.width + 2, rectangle2.height + 2);
        return rectangle2;
    }

    public Raster computeTile(int n2, int n3) {
        Rectangle rectangle;
        Point point = new Point(this.tileXToX(n2), this.tileYToY(n3));
        WritableRaster writableRaster = this.createWritableRaster(this.sampleModel, point);
        Rectangle rectangle2 = new Rectangle(point.x, point.y, this.tileWidth, this.tileHeight);
        Rectangle rectangle3 = rectangle2.intersection(this.computableBounds);
        Rectangle rectangle4 = rectangle2.intersection(this.getBounds());
        if (rectangle3.isEmpty()) {
            if (this.setBackground) {
                ImageUtil.fillBackground(writableRaster, rectangle4, this.backgroundValues);
            }
            return writableRaster;
        }
        if (!rectangle4.equals(rectangle3)) {
            ImageUtil.fillBordersWithBackgroundValues(rectangle4, rectangle3, writableRaster, this.backgroundValues);
        }
        Raster[] rasterArray = new Raster[1];
        Rectangle rectangle5 = this.getSourceImage(0).getBounds();
        int n4 = rectangle3.x;
        int n5 = n4 + rectangle3.width - 1;
        int n6 = rectangle3.y;
        int n7 = n6 + rectangle3.height - 1;
        if (n4 >= this.xEnd || n5 < this.xStart || n6 >= this.yEnd || n7 < this.yStart) {
            Rectangle rectangle6 = rectangle5.intersection(rectangle3);
            if (!rectangle6.isEmpty()) {
                rasterArray[0] = this.getSourceImage(0).getData(rectangle6);
                this.copyRect(rasterArray, writableRaster, rectangle6);
                if (this.getSourceImage(0).overlapsMultipleTiles(rectangle6)) {
                    this.recycleTile(rasterArray[0]);
                }
            }
            return writableRaster;
        }
        if (n4 < this.xStart) {
            rectangle = rectangle5.intersection(new Rectangle(n4, n6, this.xStart - n4, n7 - n6 + 1));
            if (!rectangle.isEmpty()) {
                rasterArray[0] = this.getSourceImage(0).getData(rectangle);
                this.copyRect(rasterArray, writableRaster, rectangle);
                if (this.getSourceImage(0).overlapsMultipleTiles(rectangle)) {
                    this.recycleTile(rasterArray[0]);
                }
            }
            n4 = this.xStart;
        }
        if (n5 >= this.xEnd) {
            rectangle = rectangle5.intersection(new Rectangle(this.xEnd, n6, n5 - this.xEnd + 1, n7 - n6 + 1));
            if (!rectangle.isEmpty()) {
                rasterArray[0] = this.getSourceImage(0).getData(rectangle);
                this.copyRect(rasterArray, writableRaster, rectangle);
                if (this.getSourceImage(0).overlapsMultipleTiles(rectangle)) {
                    this.recycleTile(rasterArray[0]);
                }
            }
            n5 = this.xEnd - 1;
        }
        if (n6 < this.yStart) {
            rectangle = rectangle5.intersection(new Rectangle(n4, n6, n5 - n4 + 1, this.yStart - n6));
            if (!rectangle.isEmpty()) {
                rasterArray[0] = this.getSourceImage(0).getData(rectangle);
                this.copyRect(rasterArray, writableRaster, rectangle);
                if (this.getSourceImage(0).overlapsMultipleTiles(rectangle)) {
                    this.recycleTile(rasterArray[0]);
                }
            }
            n6 = this.yStart;
        }
        if (n7 >= this.yEnd) {
            rectangle = rectangle5.intersection(new Rectangle(n4, this.yEnd, n5 - n4 + 1, n7 - this.yEnd + 1));
            if (!rectangle.isEmpty()) {
                rasterArray[0] = this.getSourceImage(0).getData(rectangle);
                this.copyRect(rasterArray, writableRaster, rectangle);
                if (this.getSourceImage(0).overlapsMultipleTiles(rectangle)) {
                    this.recycleTile(rasterArray[0]);
                }
            }
            n7 = this.yEnd - 1;
        }
        if (!(rectangle = this.backwardMapRect(rectangle3 = new Rectangle(n4, n6, n5 - n4 + 1, n7 - n6 + 1), 0).intersection(rectangle5)).isEmpty()) {
            int n8 = this.interp == null ? 0 : this.interp.getLeftPadding();
            int n9 = this.interp == null ? 0 : this.interp.getRightPadding();
            int n10 = this.interp == null ? 0 : this.interp.getTopPadding();
            int n11 = this.interp == null ? 0 : this.interp.getBottomPadding();
            rectangle = new Rectangle(rectangle.x - n8, rectangle.y - n10, rectangle.width + n8 + n9, rectangle.height + n10 + n11);
            rasterArray[0] = this.getBorderExtender() != null ? this.getSourceImage(0).getExtendedData(rectangle, this.extender) : this.getSourceImage(0).getData(rectangle);
            this.computeRect(rasterArray, writableRaster, rectangle3);
            if (this.getSourceImage(0).overlapsMultipleTiles(rectangle)) {
                this.recycleTile(rasterArray[0]);
            }
        }
        return writableRaster;
    }

    protected void computeRect(Raster[] rasterArray, WritableRaster writableRaster, Rectangle rectangle) {
        int n2 = MediaLibAccessor.findCompatibleTag(rasterArray, writableRaster);
        Raster raster = rasterArray[0];
        MediaLibAccessor mediaLibAccessor = new MediaLibAccessor(raster, raster.getBounds(), n2);
        MediaLibAccessor mediaLibAccessor2 = new MediaLibAccessor(writableRaster, rectangle, n2);
        mediaLibImage[] mediaLibImageArray = mediaLibAccessor.getMediaLibImages();
        mediaLibImage[] mediaLibImageArray2 = mediaLibAccessor2.getMediaLibImages();
        switch (mediaLibAccessor2.getDataType()) {
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                if (this.mlibInterpTableI == null) {
                    InterpolationTable interpolationTable = (InterpolationTable)this.interp;
                    this.mlibInterpTableI = new mediaLibImageInterpTable(3, interpolationTable.getWidth(), interpolationTable.getHeight(), interpolationTable.getLeftPadding(), interpolationTable.getTopPadding(), interpolationTable.getSubsampleBitsH(), interpolationTable.getSubsampleBitsV(), interpolationTable.getPrecisionBits(), interpolationTable.getHorizontalTableData(), interpolationTable.getVerticalTableData());
                }
                if (this.setBackground) {
                    int n3 = 0;
                    while (n3 < mediaLibImageArray2.length) {
                        Image.GridWarpTable2(mediaLibImageArray2[n3], mediaLibImageArray[n3], this.xWarpPos, this.yWarpPos, raster.getMinX(), raster.getMinY(), this.xStart - rectangle.x, this.xStep, this.xNumCells, this.yStart - rectangle.y, this.yStep, this.yNumCells, this.mlibInterpTableI, 0, this.intBackgroundValues);
                        ++n3;
                    }
                } else {
                    int n4 = 0;
                    while (n4 < mediaLibImageArray2.length) {
                        Image.GridWarpTable(mediaLibImageArray2[n4], mediaLibImageArray[n4], this.xWarpPos, this.yWarpPos, raster.getMinX(), raster.getMinY(), this.xStart - rectangle.x, this.xStep, this.xNumCells, this.yStart - rectangle.y, this.yStep, this.yNumCells, this.mlibInterpTableI, 0);
                        ++n4;
                    }
                }
                break;
            }
            case 4: {
                if (this.mlibInterpTableF == null) {
                    InterpolationTable interpolationTable = (InterpolationTable)this.interp;
                    this.mlibInterpTableF = new mediaLibImageInterpTable(4, interpolationTable.getWidth(), interpolationTable.getHeight(), interpolationTable.getLeftPadding(), interpolationTable.getTopPadding(), interpolationTable.getSubsampleBitsH(), interpolationTable.getSubsampleBitsV(), interpolationTable.getPrecisionBits(), interpolationTable.getHorizontalTableDataFloat(), interpolationTable.getVerticalTableDataFloat());
                }
                if (this.setBackground) {
                    int n5 = 0;
                    while (n5 < mediaLibImageArray2.length) {
                        Image.GridWarpTable2_Fp(mediaLibImageArray2[n5], mediaLibImageArray[n5], this.xWarpPos, this.yWarpPos, raster.getMinX(), raster.getMinY(), this.xStart - rectangle.x, this.xStep, this.xNumCells, this.yStart - rectangle.y, this.yStep, this.yNumCells, this.mlibInterpTableF, 0, this.backgroundValues);
                        ++n5;
                    }
                } else {
                    int n6 = 0;
                    while (n6 < mediaLibImageArray2.length) {
                        Image.GridWarpTable_Fp(mediaLibImageArray2[n6], mediaLibImageArray[n6], this.xWarpPos, this.yWarpPos, raster.getMinX(), raster.getMinY(), this.xStart - rectangle.x, this.xStep, this.xNumCells, this.yStart - rectangle.y, this.yStep, this.yNumCells, this.mlibInterpTableF, 0);
                        ++n6;
                    }
                }
                break;
            }
            case 5: {
                if (this.mlibInterpTableD == null) {
                    InterpolationTable interpolationTable = (InterpolationTable)this.interp;
                    this.mlibInterpTableD = new mediaLibImageInterpTable(5, interpolationTable.getWidth(), interpolationTable.getHeight(), interpolationTable.getLeftPadding(), interpolationTable.getTopPadding(), interpolationTable.getSubsampleBitsH(), interpolationTable.getSubsampleBitsV(), interpolationTable.getPrecisionBits(), interpolationTable.getHorizontalTableDataDouble(), interpolationTable.getVerticalTableDataDouble());
                }
                if (this.setBackground) {
                    int n7 = 0;
                    while (n7 < mediaLibImageArray2.length) {
                        Image.GridWarpTable2_Fp(mediaLibImageArray2[n7], mediaLibImageArray[n7], this.xWarpPos, this.yWarpPos, raster.getMinX(), raster.getMinY(), this.xStart - rectangle.x, this.xStep, this.xNumCells, this.yStart - rectangle.y, this.yStep, this.yNumCells, this.mlibInterpTableD, 0, this.backgroundValues);
                        ++n7;
                    }
                } else {
                    int n8 = 0;
                    while (n8 < mediaLibImageArray2.length) {
                        Image.GridWarpTable_Fp(mediaLibImageArray2[n8], mediaLibImageArray[n8], this.xWarpPos, this.yWarpPos, raster.getMinX(), raster.getMinY(), this.xStart - rectangle.x, this.xStep, this.xNumCells, this.yStart - rectangle.y, this.yStep, this.yNumCells, this.mlibInterpTableD, 0);
                        ++n8;
                    }
                }
                break;
            }
            default: {
                throw new RuntimeException(JaiI18N.getString("Generic2"));
            }
        }
        if (mediaLibAccessor2.isDataCopy()) {
            mediaLibAccessor2.clampDataArrays();
            mediaLibAccessor2.copyDataToRaster();
        }
    }

    private void copyRect(Raster[] rasterArray, WritableRaster writableRaster, Rectangle rectangle) {
        int n2 = MediaLibAccessor.findCompatibleTag(rasterArray, writableRaster);
        MediaLibAccessor mediaLibAccessor = new MediaLibAccessor(rasterArray[0], rectangle, n2);
        MediaLibAccessor mediaLibAccessor2 = new MediaLibAccessor(writableRaster, rectangle, n2);
        mediaLibImage[] mediaLibImageArray = mediaLibAccessor.getMediaLibImages();
        mediaLibImage[] mediaLibImageArray2 = mediaLibAccessor2.getMediaLibImages();
        int n3 = 0;
        while (n3 < mediaLibImageArray2.length) {
            Image.Copy(mediaLibImageArray2[n3], mediaLibImageArray[n3]);
            ++n3;
        }
        if (mediaLibAccessor2.isDataCopy()) {
            mediaLibAccessor2.copyDataToRaster();
        }
    }
}

