/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jai.mlib;

import com.sun.media.jai.mlib.JaiI18N;
import com.sun.media.jai.mlib.MediaLibAccessor;
import com.sun.media.jai.util.ImageUtil;
import com.sun.medialib.mlib.Image;
import com.sun.medialib.mlib.mediaLibImage;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.util.Map;
import javax.media.jai.BorderExtender;
import javax.media.jai.ImageLayout;
import javax.media.jai.Interpolation;
import javax.media.jai.WarpOpImage;
import javax.media.jai.WarpPolynomial;

final class MlibWarpPolynomialOpImage
extends WarpOpImage {
    private double[] xCoeffs;
    private double[] yCoeffs;
    private int filter;
    private double preScaleX;
    private double preScaleY;
    private double postScaleX;
    private double postScaleY;

    public MlibWarpPolynomialOpImage(RenderedImage renderedImage, BorderExtender borderExtender, Map map, ImageLayout imageLayout, WarpPolynomial warpPolynomial, Interpolation interpolation, int n2, double[] dArray) {
        super(renderedImage, imageLayout, map, true, borderExtender, interpolation, warpPolynomial, dArray);
        float[] fArray = warpPolynomial.getXCoeffs();
        float[] fArray2 = warpPolynomial.getYCoeffs();
        int n3 = fArray.length;
        this.xCoeffs = new double[n3];
        this.yCoeffs = new double[n3];
        int n4 = 0;
        while (n4 < n3) {
            this.xCoeffs[n4] = fArray[n4];
            this.yCoeffs[n4] = fArray2[n4];
            ++n4;
        }
        this.filter = n2;
        this.preScaleX = warpPolynomial.getPreScaleX();
        this.preScaleY = warpPolynomial.getPreScaleY();
        this.postScaleX = warpPolynomial.getPostScaleX();
        this.postScaleY = warpPolynomial.getPostScaleY();
    }

    protected Rectangle backwardMapRect(Rectangle rectangle, int n2) {
        Rectangle rectangle2 = super.backwardMapRect(rectangle, n2);
        rectangle2.setBounds(rectangle2.x - 1, rectangle2.y - 1, rectangle2.width + 2, rectangle2.height + 2);
        return rectangle2;
    }

    public Raster computeTile(int n2, int n3) {
        Point point = new Point(this.tileXToX(n2), this.tileYToY(n3));
        WritableRaster writableRaster = this.createWritableRaster(this.sampleModel, point);
        Rectangle rectangle = new Rectangle(point.x, point.y, this.tileWidth, this.tileHeight);
        Rectangle rectangle2 = rectangle.intersection(this.computableBounds);
        Rectangle rectangle3 = rectangle.intersection(this.getBounds());
        if (rectangle2.isEmpty()) {
            if (this.setBackground) {
                ImageUtil.fillBackground(writableRaster, rectangle3, this.backgroundValues);
            }
            return writableRaster;
        }
        Rectangle rectangle4 = this.backwardMapRect(rectangle2, 0).intersection(this.getSourceImage(0).getBounds());
        if (rectangle4.isEmpty()) {
            if (this.setBackground) {
                ImageUtil.fillBackground(writableRaster, rectangle3, this.backgroundValues);
            }
            return writableRaster;
        }
        if (!rectangle3.equals(rectangle2)) {
            ImageUtil.fillBordersWithBackgroundValues(rectangle3, rectangle2, writableRaster, this.backgroundValues);
        }
        int n4 = this.interp == null ? 0 : this.interp.getLeftPadding();
        int n5 = this.interp == null ? 0 : this.interp.getRightPadding();
        int n6 = this.interp == null ? 0 : this.interp.getTopPadding();
        int n7 = this.interp == null ? 0 : this.interp.getBottomPadding();
        rectangle4 = new Rectangle(rectangle4.x - n4, rectangle4.y - n6, rectangle4.width + n4 + n5, rectangle4.height + n6 + n7);
        Raster[] rasterArray = new Raster[]{this.getBorderExtender() != null ? this.getSourceImage(0).getExtendedData(rectangle4, this.extender) : this.getSourceImage(0).getData(rectangle4)};
        this.computeRect(rasterArray, writableRaster, rectangle2);
        if (this.getSourceImage(0).overlapsMultipleTiles(rectangle4)) {
            this.recycleTile(rasterArray[0]);
        }
        return writableRaster;
    }

    protected void computeRect(Raster[] rasterArray, WritableRaster writableRaster, Rectangle rectangle) {
        Raster raster = rasterArray[0];
        int n2 = MediaLibAccessor.findCompatibleTag(rasterArray, writableRaster);
        MediaLibAccessor mediaLibAccessor = new MediaLibAccessor(raster, raster.getBounds(), n2);
        MediaLibAccessor mediaLibAccessor2 = new MediaLibAccessor(writableRaster, rectangle, n2);
        mediaLibImage[] mediaLibImageArray = mediaLibAccessor.getMediaLibImages();
        mediaLibImage[] mediaLibImageArray2 = mediaLibAccessor2.getMediaLibImages();
        switch (mediaLibAccessor2.getDataType()) {
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                if (this.setBackground) {
                    int n3 = 0;
                    while (n3 < mediaLibImageArray2.length) {
                        Image.PolynomialWarp2(mediaLibImageArray2[n3], mediaLibImageArray[n3], this.xCoeffs, this.yCoeffs, rectangle.x, rectangle.y, raster.getMinX(), raster.getMinY(), this.preScaleX, this.preScaleY, this.postScaleX, this.postScaleY, this.filter, 0, this.intBackgroundValues);
                        ++n3;
                    }
                } else {
                    int n4 = 0;
                    while (n4 < mediaLibImageArray2.length) {
                        Image.PolynomialWarp(mediaLibImageArray2[n4], mediaLibImageArray[n4], this.xCoeffs, this.yCoeffs, rectangle.x, rectangle.y, raster.getMinX(), raster.getMinY(), this.preScaleX, this.preScaleY, this.postScaleX, this.postScaleY, this.filter, 0);
                        ++n4;
                    }
                }
                break;
            }
            case 4: 
            case 5: {
                if (this.setBackground) {
                    int n5 = 0;
                    while (n5 < mediaLibImageArray2.length) {
                        Image.PolynomialWarp2_Fp(mediaLibImageArray2[n5], mediaLibImageArray[n5], this.xCoeffs, this.yCoeffs, rectangle.x, rectangle.y, raster.getMinX(), raster.getMinY(), this.preScaleX, this.preScaleY, this.postScaleX, this.postScaleY, this.filter, 0, this.backgroundValues);
                        ++n5;
                    }
                } else {
                    int n6 = 0;
                    while (n6 < mediaLibImageArray2.length) {
                        Image.PolynomialWarp_Fp(mediaLibImageArray2[n6], mediaLibImageArray[n6], this.xCoeffs, this.yCoeffs, rectangle.x, rectangle.y, raster.getMinX(), raster.getMinY(), this.preScaleX, this.preScaleY, this.postScaleX, this.postScaleY, this.filter, 0);
                        ++n6;
                    }
                }
                break;
            }
            default: {
                throw new RuntimeException(JaiI18N.getString("Generic2"));
            }
        }
        if (mediaLibAccessor2.isDataCopy()) {
            mediaLibAccessor2.clampDataArrays();
            mediaLibAccessor2.copyDataToRaster();
        }
    }
}

