/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jai.opimage;

import java.awt.Rectangle;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.util.Map;
import javax.media.jai.ImageLayout;
import javax.media.jai.PointOpImage;
import javax.media.jai.RasterAccessor;
import javax.media.jai.RasterFormatTag;

final class AbsoluteOpImage
extends PointOpImage {
    public AbsoluteOpImage(RenderedImage renderedImage, Map map, ImageLayout imageLayout) {
        super(renderedImage, imageLayout, map, true);
        this.permitInPlaceOperation();
    }

    protected void computeRect(Raster[] rasterArray, WritableRaster writableRaster, Rectangle rectangle) {
        RasterFormatTag[] rasterFormatTagArray = this.getFormatTags();
        RasterAccessor rasterAccessor = new RasterAccessor(rasterArray[0], rectangle, rasterFormatTagArray[0], this.getSourceImage(0).getColorModel());
        RasterAccessor rasterAccessor2 = new RasterAccessor(writableRaster, rectangle, rasterFormatTagArray[1], this.getColorModel());
        if (rasterAccessor2.isBinary()) {
            byte[] byArray = rasterAccessor2.getBinaryDataArray();
            System.arraycopy(rasterAccessor.getBinaryDataArray(), 0, byArray, 0, byArray.length);
            rasterAccessor2.copyBinaryDataToRaster();
            return;
        }
        switch (rasterAccessor2.getDataType()) {
            case 0: {
                this.byteAbsolute(rasterAccessor2.getNumBands(), rasterAccessor2.getWidth(), rasterAccessor2.getHeight(), rasterAccessor.getScanlineStride(), rasterAccessor.getPixelStride(), rasterAccessor.getBandOffsets(), rasterAccessor.getByteDataArrays(), rasterAccessor2.getScanlineStride(), rasterAccessor2.getPixelStride(), rasterAccessor2.getBandOffsets(), rasterAccessor2.getByteDataArrays());
                break;
            }
            case 2: {
                this.shortAbsolute(rasterAccessor2.getNumBands(), rasterAccessor2.getWidth(), rasterAccessor2.getHeight(), rasterAccessor.getScanlineStride(), rasterAccessor.getPixelStride(), rasterAccessor.getBandOffsets(), rasterAccessor.getShortDataArrays(), rasterAccessor2.getScanlineStride(), rasterAccessor2.getPixelStride(), rasterAccessor2.getBandOffsets(), rasterAccessor2.getShortDataArrays());
                break;
            }
            case 1: {
                this.ushortAbsolute(rasterAccessor2.getNumBands(), rasterAccessor2.getWidth(), rasterAccessor2.getHeight(), rasterAccessor.getScanlineStride(), rasterAccessor.getPixelStride(), rasterAccessor.getBandOffsets(), rasterAccessor.getShortDataArrays(), rasterAccessor2.getScanlineStride(), rasterAccessor2.getPixelStride(), rasterAccessor2.getBandOffsets(), rasterAccessor2.getShortDataArrays());
                break;
            }
            case 3: {
                this.intAbsolute(rasterAccessor2.getNumBands(), rasterAccessor2.getWidth(), rasterAccessor2.getHeight(), rasterAccessor.getScanlineStride(), rasterAccessor.getPixelStride(), rasterAccessor.getBandOffsets(), rasterAccessor.getIntDataArrays(), rasterAccessor2.getScanlineStride(), rasterAccessor2.getPixelStride(), rasterAccessor2.getBandOffsets(), rasterAccessor2.getIntDataArrays());
                break;
            }
            case 4: {
                this.floatAbsolute(rasterAccessor2.getNumBands(), rasterAccessor2.getWidth(), rasterAccessor2.getHeight(), rasterAccessor.getScanlineStride(), rasterAccessor.getPixelStride(), rasterAccessor.getBandOffsets(), rasterAccessor.getFloatDataArrays(), rasterAccessor2.getScanlineStride(), rasterAccessor2.getPixelStride(), rasterAccessor2.getBandOffsets(), rasterAccessor2.getFloatDataArrays());
                break;
            }
            case 5: {
                this.doubleAbsolute(rasterAccessor2.getNumBands(), rasterAccessor2.getWidth(), rasterAccessor2.getHeight(), rasterAccessor.getScanlineStride(), rasterAccessor.getPixelStride(), rasterAccessor.getBandOffsets(), rasterAccessor.getDoubleDataArrays(), rasterAccessor2.getScanlineStride(), rasterAccessor2.getPixelStride(), rasterAccessor2.getBandOffsets(), rasterAccessor2.getDoubleDataArrays());
            }
        }
        if (rasterAccessor2.needsClamping()) {
            rasterAccessor2.clampDataArrays();
        }
        rasterAccessor2.copyDataToRaster();
    }

    private void byteAbsolute(int n2, int n3, int n4, int n5, int n6, int[] nArray, byte[][] byArray, int n7, int n8, int[] nArray2, byte[][] byArray2) {
        int n9 = 0;
        while (n9 < n2) {
            byte[] byArray3 = byArray[n9];
            byte[] byArray4 = byArray2[n9];
            int n10 = nArray[n9];
            int n11 = nArray2[n9];
            int n12 = 0;
            while (n12 < n4) {
                int n13 = n10;
                int n14 = n11;
                int n15 = 0;
                while (n15 < n3) {
                    byArray4[n14] = byArray3[n13];
                    n13 += n6;
                    n14 += n8;
                    ++n15;
                }
                n10 += n5;
                n11 += n7;
                ++n12;
            }
            ++n9;
        }
    }

    private void shortAbsolute(int n2, int n3, int n4, int n5, int n6, int[] nArray, short[][] sArray, int n7, int n8, int[] nArray2, short[][] sArray2) {
        int n9 = 0;
        while (n9 < n2) {
            short[] sArray3 = sArray[n9];
            short[] sArray4 = sArray2[n9];
            int n10 = nArray[n9];
            int n11 = nArray2[n9];
            int n12 = 0;
            while (n12 < n4) {
                int n13 = n10;
                int n14 = n11;
                int n15 = 0;
                while (n15 < n3) {
                    short s2 = sArray3[n13];
                    sArray4[n14] = s2 != Short.MIN_VALUE && (s2 & Short.MIN_VALUE) != 0 ? (short)(-sArray3[n13]) : sArray3[n13];
                    n13 += n6;
                    n14 += n8;
                    ++n15;
                }
                n10 += n5;
                n11 += n7;
                ++n12;
            }
            ++n9;
        }
    }

    private void ushortAbsolute(int n2, int n3, int n4, int n5, int n6, int[] nArray, short[][] sArray, int n7, int n8, int[] nArray2, short[][] sArray2) {
        int n9 = 0;
        while (n9 < n2) {
            short[] sArray3 = sArray[n9];
            short[] sArray4 = sArray2[n9];
            int n10 = nArray[n9];
            int n11 = nArray2[n9];
            int n12 = 0;
            while (n12 < n4) {
                int n13 = n10;
                int n14 = n11;
                int n15 = 0;
                while (n15 < n3) {
                    sArray4[n14] = sArray3[n13];
                    n13 += n6;
                    n14 += n8;
                    ++n15;
                }
                n10 += n5;
                n11 += n7;
                ++n12;
            }
            ++n9;
        }
    }

    private void intAbsolute(int n2, int n3, int n4, int n5, int n6, int[] nArray, int[][] nArray2, int n7, int n8, int[] nArray3, int[][] nArray4) {
        int n9 = 0;
        while (n9 < n2) {
            int[] nArray5 = nArray2[n9];
            int[] nArray6 = nArray4[n9];
            int n10 = nArray[n9];
            int n11 = nArray3[n9];
            int n12 = 0;
            while (n12 < n4) {
                int n13 = n10;
                int n14 = n11;
                int n15 = 0;
                while (n15 < n3) {
                    int n16 = nArray5[n13];
                    nArray6[n14] = n16 != Integer.MIN_VALUE && (n16 & Integer.MIN_VALUE) != 0 ? -nArray5[n13] : nArray5[n13];
                    n13 += n6;
                    n14 += n8;
                    ++n15;
                }
                n10 += n5;
                n11 += n7;
                ++n12;
            }
            ++n9;
        }
    }

    private void floatAbsolute(int n2, int n3, int n4, int n5, int n6, int[] nArray, float[][] fArray, int n7, int n8, int[] nArray2, float[][] fArray2) {
        int n9 = 0;
        while (n9 < n2) {
            float[] fArray3 = fArray[n9];
            float[] fArray4 = fArray2[n9];
            int n10 = nArray[n9];
            int n11 = nArray2[n9];
            int n12 = 0;
            while (n12 < n4) {
                int n13 = n10;
                int n14 = n11;
                int n15 = 0;
                while (n15 < n3) {
                    fArray4[n14] = fArray3[n13] <= 0.0f ? 0.0f - fArray3[n13] : fArray3[n13];
                    n13 += n6;
                    n14 += n8;
                    ++n15;
                }
                n10 += n5;
                n11 += n7;
                ++n12;
            }
            ++n9;
        }
    }

    private void doubleAbsolute(int n2, int n3, int n4, int n5, int n6, int[] nArray, double[][] dArray, int n7, int n8, int[] nArray2, double[][] dArray2) {
        int n9 = 0;
        while (n9 < n2) {
            double[] dArray3 = dArray[n9];
            double[] dArray4 = dArray2[n9];
            int n10 = nArray[n9];
            int n11 = nArray2[n9];
            int n12 = 0;
            while (n12 < n4) {
                int n13 = n10;
                int n14 = n11;
                int n15 = 0;
                while (n15 < n3) {
                    dArray4[n14] = dArray3[n13] <= 0.0 ? 0.0 - dArray3[n13] : dArray3[n13];
                    n13 += n6;
                    n14 += n8;
                    ++n15;
                }
                n10 += n5;
                n11 += n7;
                ++n12;
            }
            ++n9;
        }
    }
}

