/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jai.opimage;

import com.sun.media.jai.util.ImageUtil;
import java.awt.Rectangle;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;
import javax.media.jai.ImageLayout;
import javax.media.jai.PointOpImage;
import javax.media.jai.RasterAccessor;
import javax.media.jai.RasterFormatTag;

final class AddCollectionOpImage
extends PointOpImage {
    private byte[][] byteTable = null;

    private synchronized void initByteTable() {
        if (this.byteTable != null) {
            return;
        }
        this.byteTable = new byte[256][256];
        int n2 = 0;
        while (n2 < 256) {
            byte[] byArray = this.byteTable[n2];
            int n3 = 0;
            while (n3 < 256) {
                byArray[n3] = ImageUtil.clampBytePositive(n2 + n3);
                ++n3;
            }
            ++n2;
        }
    }

    public AddCollectionOpImage(Collection collection, Map map, ImageLayout imageLayout) {
        super(AddCollectionOpImage.vectorize(collection), imageLayout, map, true);
    }

    private static Vector vectorize(Collection collection) {
        if (collection instanceof Vector) {
            return (Vector)collection;
        }
        Vector vector = new Vector(collection.size());
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            vector.add(iterator.next());
        }
        return vector;
    }

    protected void computeRect(Raster[] rasterArray, WritableRaster writableRaster, Rectangle rectangle) {
        RasterFormatTag[] rasterFormatTagArray = this.getFormatTags();
        int n2 = this.getNumSources();
        RasterAccessor rasterAccessor = new RasterAccessor(writableRaster, rectangle, rasterFormatTagArray[n2], this.getColorModel());
        RasterAccessor[] rasterAccessorArray = new RasterAccessor[n2];
        int n3 = 0;
        while (n3 < n2) {
            Rectangle rectangle2 = this.mapDestRect(rectangle, n3);
            rasterAccessorArray[n3] = new RasterAccessor(rasterArray[n3], rectangle2, rasterFormatTagArray[n3], this.getSourceImage(n3).getColorModel());
            ++n3;
        }
        switch (rasterAccessor.getDataType()) {
            case 0: {
                this.computeRectByte(rasterAccessorArray, rasterAccessor);
                break;
            }
            case 1: {
                this.computeRectUShort(rasterAccessorArray, rasterAccessor);
                break;
            }
            case 2: {
                this.computeRectShort(rasterAccessorArray, rasterAccessor);
                break;
            }
            case 3: {
                this.computeRectInt(rasterAccessorArray, rasterAccessor);
                break;
            }
            case 4: {
                this.computeRectFloat(rasterAccessorArray, rasterAccessor);
                break;
            }
            case 5: {
                this.computeRectDouble(rasterAccessorArray, rasterAccessor);
            }
        }
        if (rasterAccessor.needsClamping()) {
            rasterAccessor.clampDataArrays();
        }
        rasterAccessor.copyDataToRaster();
    }

    private void computeRectByte(RasterAccessor[] rasterAccessorArray, RasterAccessor rasterAccessor) {
        this.initByteTable();
        int n2 = rasterAccessor.getWidth();
        int n3 = rasterAccessor.getHeight();
        int n4 = rasterAccessor.getNumBands();
        int n5 = rasterAccessor.getScanlineStride();
        int n6 = rasterAccessor.getPixelStride();
        int[] nArray = rasterAccessor.getBandOffsets();
        byte[][] byArray = rasterAccessor.getByteDataArrays();
        int n7 = this.getNumSources();
        int n8 = 0;
        while (n8 < n7) {
            RasterAccessor rasterAccessor2 = rasterAccessorArray[n8];
            int n9 = rasterAccessor2.getScanlineStride();
            int n10 = rasterAccessor2.getPixelStride();
            int[] nArray2 = rasterAccessor2.getBandOffsets();
            byte[][] byArray2 = rasterAccessor2.getByteDataArrays();
            int n11 = 0;
            while (n11 < n4) {
                int n12 = nArray[n11];
                int n13 = nArray2[n11];
                byte[] byArray3 = byArray[n11];
                byte[] byArray4 = byArray2[n11];
                int n14 = 0;
                while (n14 < n3) {
                    int n15 = n12;
                    int n16 = n13;
                    n12 += n5;
                    n13 += n9;
                    int n17 = 0;
                    while (n17 < n2) {
                        byArray3[n15] = this.byteTable[byArray3[n15] & 0xFF][byArray4[n16] & 0xFF];
                        n15 += n6;
                        n16 += n10;
                        ++n17;
                    }
                    ++n14;
                }
                ++n11;
            }
            ++n8;
        }
    }

    private void computeRectUShort(RasterAccessor[] rasterAccessorArray, RasterAccessor rasterAccessor) {
        int n2 = rasterAccessor.getWidth();
        int n3 = rasterAccessor.getHeight();
        int n4 = rasterAccessor.getNumBands();
        int n5 = rasterAccessor.getScanlineStride();
        int n6 = rasterAccessor.getPixelStride();
        int[] nArray = rasterAccessor.getBandOffsets();
        short[][] sArray = rasterAccessor.getShortDataArrays();
        int n7 = this.getNumSources();
        int n8 = 0;
        while (n8 < n7) {
            RasterAccessor rasterAccessor2 = rasterAccessorArray[n8];
            int n9 = rasterAccessor2.getScanlineStride();
            int n10 = rasterAccessor2.getPixelStride();
            int[] nArray2 = rasterAccessor2.getBandOffsets();
            short[][] sArray2 = rasterAccessor2.getShortDataArrays();
            int n11 = 0;
            while (n11 < n4) {
                int n12 = nArray[n11];
                int n13 = nArray2[n11];
                short[] sArray3 = sArray[n11];
                short[] sArray4 = sArray2[n11];
                int n14 = 0;
                while (n14 < n3) {
                    int n15 = n12;
                    int n16 = n13;
                    n12 += n5;
                    n13 += n9;
                    int n17 = 0;
                    while (n17 < n2) {
                        sArray3[n15] = ImageUtil.clampUShortPositive((sArray3[n15] & 0xFFFF) + (sArray4[n16] & 0xFFFF));
                        n15 += n6;
                        n16 += n10;
                        ++n17;
                    }
                    ++n14;
                }
                ++n11;
            }
            ++n8;
        }
    }

    private void computeRectShort(RasterAccessor[] rasterAccessorArray, RasterAccessor rasterAccessor) {
        int n2 = rasterAccessor.getWidth();
        int n3 = rasterAccessor.getHeight();
        int n4 = rasterAccessor.getNumBands();
        int n5 = rasterAccessor.getScanlineStride();
        int n6 = rasterAccessor.getPixelStride();
        int[] nArray = rasterAccessor.getBandOffsets();
        short[][] sArray = rasterAccessor.getShortDataArrays();
        int n7 = this.getNumSources();
        int n8 = 0;
        while (n8 < n7) {
            RasterAccessor rasterAccessor2 = rasterAccessorArray[n8];
            int n9 = rasterAccessor2.getScanlineStride();
            int n10 = rasterAccessor2.getPixelStride();
            int[] nArray2 = rasterAccessor2.getBandOffsets();
            short[][] sArray2 = rasterAccessor2.getShortDataArrays();
            int n11 = 0;
            while (n11 < n4) {
                int n12 = nArray[n11];
                int n13 = nArray2[n11];
                short[] sArray3 = sArray[n11];
                short[] sArray4 = sArray2[n11];
                int n14 = 0;
                while (n14 < n3) {
                    int n15 = n12;
                    int n16 = n13;
                    n12 += n5;
                    n13 += n9;
                    int n17 = 0;
                    while (n17 < n2) {
                        sArray3[n15] = ImageUtil.clampShort(sArray3[n15] + sArray4[n16]);
                        n15 += n6;
                        n16 += n10;
                        ++n17;
                    }
                    ++n14;
                }
                ++n11;
            }
            ++n8;
        }
    }

    private void computeRectInt(RasterAccessor[] rasterAccessorArray, RasterAccessor rasterAccessor) {
        int n2 = rasterAccessor.getWidth();
        int n3 = rasterAccessor.getHeight();
        int n4 = rasterAccessor.getNumBands();
        int n5 = rasterAccessor.getScanlineStride();
        int n6 = rasterAccessor.getPixelStride();
        int[] nArray = rasterAccessor.getBandOffsets();
        int[][] nArray2 = rasterAccessor.getIntDataArrays();
        int n7 = this.getNumSources();
        int n8 = 0;
        while (n8 < n7) {
            RasterAccessor rasterAccessor2 = rasterAccessorArray[n8];
            int n9 = rasterAccessor2.getScanlineStride();
            int n10 = rasterAccessor2.getPixelStride();
            int[] nArray3 = rasterAccessor2.getBandOffsets();
            int[][] nArray4 = rasterAccessor2.getIntDataArrays();
            int n11 = 0;
            while (n11 < n4) {
                int n12 = nArray[n11];
                int n13 = nArray3[n11];
                int[] nArray5 = nArray2[n11];
                int[] nArray6 = nArray4[n11];
                int n14 = 0;
                while (n14 < n3) {
                    int n15 = n12;
                    int n16 = n13;
                    n12 += n5;
                    n13 += n9;
                    int n17 = 0;
                    while (n17 < n2) {
                        nArray5[n15] = ImageUtil.clampInt((long)nArray5[n15] + (long)nArray6[n16]);
                        n15 += n6;
                        n16 += n10;
                        ++n17;
                    }
                    ++n14;
                }
                ++n11;
            }
            ++n8;
        }
    }

    private void computeRectFloat(RasterAccessor[] rasterAccessorArray, RasterAccessor rasterAccessor) {
        int n2 = rasterAccessor.getWidth();
        int n3 = rasterAccessor.getHeight();
        int n4 = rasterAccessor.getNumBands();
        int n5 = rasterAccessor.getScanlineStride();
        int n6 = rasterAccessor.getPixelStride();
        int[] nArray = rasterAccessor.getBandOffsets();
        float[][] fArray = rasterAccessor.getFloatDataArrays();
        int n7 = this.getNumSources();
        int n8 = 0;
        while (n8 < n7) {
            RasterAccessor rasterAccessor2 = rasterAccessorArray[n8];
            int n9 = rasterAccessor2.getScanlineStride();
            int n10 = rasterAccessor2.getPixelStride();
            int[] nArray2 = rasterAccessor2.getBandOffsets();
            float[][] fArray2 = rasterAccessor2.getFloatDataArrays();
            int n11 = 0;
            while (n11 < n4) {
                int n12 = nArray[n11];
                int n13 = nArray2[n11];
                float[] fArray3 = fArray[n11];
                float[] fArray4 = fArray2[n11];
                int n14 = 0;
                while (n14 < n3) {
                    int n15 = n12;
                    int n16 = n13;
                    n12 += n5;
                    n13 += n9;
                    int n17 = 0;
                    while (n17 < n2) {
                        fArray3[n15] = ImageUtil.clampFloat((double)fArray3[n15] + (double)fArray4[n16]);
                        n15 += n6;
                        n16 += n10;
                        ++n17;
                    }
                    ++n14;
                }
                ++n11;
            }
            ++n8;
        }
    }

    private void computeRectDouble(RasterAccessor[] rasterAccessorArray, RasterAccessor rasterAccessor) {
        int n2 = rasterAccessor.getWidth();
        int n3 = rasterAccessor.getHeight();
        int n4 = rasterAccessor.getNumBands();
        int n5 = rasterAccessor.getScanlineStride();
        int n6 = rasterAccessor.getPixelStride();
        int[] nArray = rasterAccessor.getBandOffsets();
        double[][] dArray = rasterAccessor.getDoubleDataArrays();
        int n7 = this.getNumSources();
        int n8 = 0;
        while (n8 < n7) {
            RasterAccessor rasterAccessor2 = rasterAccessorArray[n8];
            int n9 = rasterAccessor2.getScanlineStride();
            int n10 = rasterAccessor2.getPixelStride();
            int[] nArray2 = rasterAccessor2.getBandOffsets();
            double[][] dArray2 = rasterAccessor2.getDoubleDataArrays();
            int n11 = 0;
            while (n11 < n4) {
                int n12 = nArray[n11];
                int n13 = nArray2[n11];
                double[] dArray3 = dArray[n11];
                double[] dArray4 = dArray2[n11];
                int n14 = 0;
                while (n14 < n3) {
                    int n15 = n12;
                    int n16 = n13;
                    n12 += n5;
                    n13 += n9;
                    int n17 = 0;
                    while (n17 < n2) {
                        dArray3[n15] = dArray3[n15] + dArray4[n16];
                        n15 += n6;
                        n16 += n10;
                        ++n17;
                    }
                    ++n14;
                }
                ++n11;
            }
            ++n8;
        }
    }
}

