/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jai.opimage;

import com.sun.media.jai.opimage.AffineOpImage;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.util.Map;
import javax.media.jai.BorderExtender;
import javax.media.jai.ImageLayout;
import javax.media.jai.Interpolation;
import javax.media.jai.RasterAccessor;
import javax.media.jai.RasterFormatTag;

final class AffineGeneralOpImage
extends AffineOpImage {
    private int subsampleBits;
    private int shiftvalue;
    private int interp_width;
    private int interp_height;
    private int interp_left;
    private int interp_top;
    private int interp_right;
    private int interp_bottom;

    public AffineGeneralOpImage(RenderedImage renderedImage, BorderExtender borderExtender, Map map, ImageLayout imageLayout, AffineTransform affineTransform, Interpolation interpolation, double[] dArray) {
        super(renderedImage, borderExtender, map, imageLayout, affineTransform, interpolation, dArray);
        this.subsampleBits = interpolation.getSubsampleBitsH();
        this.shiftvalue = 1 << this.subsampleBits;
        this.interp_width = interpolation.getWidth();
        this.interp_height = interpolation.getHeight();
        this.interp_left = interpolation.getLeftPadding();
        this.interp_top = interpolation.getTopPadding();
        this.interp_right = this.interp_width - this.interp_left - 1;
        this.interp_bottom = this.interp_height - this.interp_top - 1;
    }

    protected void computeRect(Raster[] rasterArray, WritableRaster writableRaster, Rectangle rectangle) {
        RasterFormatTag[] rasterFormatTagArray = this.getFormatTags();
        Raster raster = rasterArray[0];
        Rectangle rectangle2 = raster.getBounds();
        int n2 = rectangle2.x;
        int n3 = rectangle2.y;
        RasterAccessor rasterAccessor = new RasterAccessor(raster, rectangle2, rasterFormatTagArray[0], this.getSourceImage(0).getColorModel());
        RasterAccessor rasterAccessor2 = new RasterAccessor(writableRaster, rectangle, rasterFormatTagArray[1], this.getColorModel());
        switch (rasterAccessor2.getDataType()) {
            case 0: {
                this.byteLoop(rasterAccessor, rectangle, n2, n3, rasterAccessor2);
                break;
            }
            case 3: {
                this.intLoop(rasterAccessor, rectangle, n2, n3, rasterAccessor2);
                break;
            }
            case 2: {
                this.shortLoop(rasterAccessor, rectangle, n2, n3, rasterAccessor2);
                break;
            }
            case 1: {
                this.ushortLoop(rasterAccessor, rectangle, n2, n3, rasterAccessor2);
                break;
            }
            case 4: {
                this.floatLoop(rasterAccessor, rectangle, n2, n3, rasterAccessor2);
                break;
            }
            case 5: {
                this.doubleLoop(rasterAccessor, rectangle, n2, n3, rasterAccessor2);
            }
        }
        if (rasterAccessor2.isDataCopy()) {
            rasterAccessor2.clampDataArrays();
            rasterAccessor2.copyDataToRaster();
        }
    }

    private void byteLoop(RasterAccessor rasterAccessor, Rectangle rectangle, int n2, int n3, RasterAccessor rasterAccessor2) {
        float f2 = rasterAccessor.getX();
        float f3 = rasterAccessor.getY();
        float f4 = f2 + (float)rasterAccessor.getWidth();
        float f5 = f3 + (float)rasterAccessor.getHeight();
        int[][] nArray = new int[this.interp_height][this.interp_width];
        int n4 = 0;
        Point2D.Float float_ = new Point2D.Float();
        Point2D.Float float_2 = new Point2D.Float();
        byte[][] byArray = rasterAccessor2.getByteDataArrays();
        int[] nArray2 = rasterAccessor2.getBandOffsets();
        int n5 = rasterAccessor2.getPixelStride();
        int n6 = rasterAccessor2.getScanlineStride();
        byte[][] byArray2 = rasterAccessor.getByteDataArrays();
        int[] nArray3 = rasterAccessor.getBandOffsets();
        int n7 = rasterAccessor.getPixelStride();
        int n8 = rasterAccessor.getScanlineStride();
        int n9 = rasterAccessor2.getNumBands();
        int n10 = rectangle.x;
        int n11 = rectangle.y;
        int n12 = rectangle.x + rectangle.width;
        int n13 = rectangle.y + rectangle.height;
        byte[] byArray3 = new byte[n9];
        int n14 = 0;
        while (n14 < n9) {
            byArray3[n14] = (byte)this.backgroundValues[n14];
            ++n14;
        }
        int n15 = n11;
        while (n15 < n13) {
            int n16 = n4;
            ((Point2D)float_).setLocation((double)n10 + 0.5, (double)n15 + 0.5);
            this.mapDestPoint((Point2D)float_, float_2);
            float f6 = (float)((Point2D)float_2).getX();
            float f7 = (float)((Point2D)float_2).getY();
            f6 = (float)((double)f6 - 0.5);
            f7 = (float)((double)f7 - 0.5);
            int n17 = (int)Math.floor(f6);
            int n18 = (int)Math.floor(f7);
            float f8 = f6 - (float)n17;
            float f9 = f7 - (float)n18;
            int n19 = (n17 - n2) * n7;
            int n20 = (n18 - n3) * n8;
            int n21 = n10;
            while (n21 < n12) {
                int n22;
                if ((float)n17 >= f2 + (float)this.interp_left && (float)n17 < f4 - (float)this.interp_right && (float)n18 >= f3 + (float)this.interp_top && (float)n18 < f5 - (float)this.interp_bottom) {
                    n22 = 0;
                    while (n22 < n9) {
                        byte[] byArray4 = byArray2[n22];
                        int n23 = nArray3[n22];
                        int n24 = this.interp_left * n7 + this.interp_top * n8;
                        n24 = n19 + n20 - n24;
                        int n25 = 0;
                        int n26 = 0;
                        int n27 = 0;
                        while (n27 < this.interp_height) {
                            int n28 = n24;
                            int n29 = 0;
                            while (n29 < this.interp_width) {
                                nArray[n26][n25++] = byArray4[n24 + n23] & 0xFF;
                                n24 += n7;
                                ++n29;
                            }
                            ++n26;
                            n25 = 0;
                            n24 = n28 + n8;
                            ++n27;
                        }
                        int n30 = (int)(f8 * (float)this.shiftvalue);
                        int n31 = (int)(f9 * (float)this.shiftvalue);
                        int n32 = this.interp.interpolate(nArray, n30, n31);
                        int n33 = n32 < 0 ? 0 : (n32 > 255 ? 255 : n32);
                        byArray[n22][n16 + nArray2[n22]] = (byte)(n33 & 0xFF);
                        ++n22;
                    }
                } else if (this.setBackground) {
                    n22 = 0;
                    while (n22 < n9) {
                        byArray[n22][n16 + nArray2[n22]] = byArray3[n22];
                        ++n22;
                    }
                }
                if ((double)f8 < this.fracdx1) {
                    n17 += this.incx;
                    f8 = (float)((double)f8 + this.fracdx);
                } else {
                    n17 += this.incx1;
                    f8 = (float)((double)f8 - this.fracdx1);
                }
                if ((double)f9 < this.fracdy1) {
                    n18 += this.incy;
                    f9 = (float)((double)f9 + this.fracdy);
                } else {
                    n18 += this.incy1;
                    f9 = (float)((double)f9 - this.fracdy1);
                }
                n19 = (n17 - n2) * n7;
                n20 = (n18 - n3) * n8;
                n16 += n5;
                ++n21;
            }
            n4 += n6;
            ++n15;
        }
    }

    private void intLoop(RasterAccessor rasterAccessor, Rectangle rectangle, int n2, int n3, RasterAccessor rasterAccessor2) {
        float f2 = rasterAccessor.getX();
        float f3 = rasterAccessor.getY();
        float f4 = f2 + (float)rasterAccessor.getWidth();
        float f5 = f3 + (float)rasterAccessor.getHeight();
        int n4 = 0;
        int[][] nArray = new int[this.interp_height][this.interp_width];
        Point2D.Float float_ = new Point2D.Float();
        Point2D.Float float_2 = new Point2D.Float();
        int[][] nArray2 = rasterAccessor2.getIntDataArrays();
        int[] nArray3 = rasterAccessor2.getBandOffsets();
        int n5 = rasterAccessor2.getPixelStride();
        int n6 = rasterAccessor2.getScanlineStride();
        int[][] nArray4 = rasterAccessor.getIntDataArrays();
        int[] nArray5 = rasterAccessor.getBandOffsets();
        int n7 = rasterAccessor.getPixelStride();
        int n8 = rasterAccessor.getScanlineStride();
        int n9 = rasterAccessor2.getNumBands();
        int n10 = rectangle.x;
        int n11 = rectangle.y;
        int n12 = rectangle.x + rectangle.width;
        int n13 = rectangle.y + rectangle.height;
        int[] nArray6 = new int[n9];
        int n14 = 0;
        while (n14 < n9) {
            nArray6[n14] = (int)this.backgroundValues[n14];
            ++n14;
        }
        int n15 = n11;
        while (n15 < n13) {
            int n16 = n4;
            ((Point2D)float_).setLocation((double)n10 + 0.5, (double)n15 + 0.5);
            this.mapDestPoint((Point2D)float_, float_2);
            float f6 = (float)((Point2D)float_2).getX();
            float f7 = (float)((Point2D)float_2).getY();
            f6 = (float)((double)f6 - 0.5);
            f7 = (float)((double)f7 - 0.5);
            int n17 = (int)Math.floor(f6);
            int n18 = (int)Math.floor(f7);
            float f8 = f6 - (float)n17;
            float f9 = f7 - (float)n18;
            int n19 = (n17 - n2) * n7;
            int n20 = (n18 - n3) * n8;
            int n21 = n10;
            while (n21 < n12) {
                int n22;
                if ((float)n17 >= f2 + (float)this.interp_left && (float)n17 < f4 - (float)this.interp_right && (float)n18 >= f3 + (float)this.interp_top && (float)n18 < f5 - (float)this.interp_bottom) {
                    n22 = 0;
                    while (n22 < n9) {
                        int[] nArray7 = nArray4[n22];
                        int n23 = nArray5[n22];
                        int n24 = this.interp_left * n7 + this.interp_top * n8;
                        n24 = n19 + n20 - n24;
                        int n25 = 0;
                        int n26 = 0;
                        int n27 = 0;
                        while (n27 < this.interp_height) {
                            int n28 = n24;
                            int n29 = 0;
                            while (n29 < this.interp_width) {
                                nArray[n26][n25++] = nArray7[n24 + n23];
                                n24 += n7;
                                ++n29;
                            }
                            ++n26;
                            n25 = 0;
                            n24 = n28 + n8;
                            ++n27;
                        }
                        int n30 = (int)(f8 * (float)this.shiftvalue);
                        int n31 = (int)(f9 * (float)this.shiftvalue);
                        int n32 = this.interp.interpolate(nArray, n30, n31);
                        int n33 = n32 < Integer.MIN_VALUE ? Integer.MIN_VALUE : (n32 > Integer.MAX_VALUE ? Integer.MAX_VALUE : n32);
                        nArray2[n22][n16 + nArray3[n22]] = n33;
                        ++n22;
                    }
                } else if (this.setBackground) {
                    n22 = 0;
                    while (n22 < n9) {
                        nArray2[n22][n16 + nArray3[n22]] = nArray6[n22];
                        ++n22;
                    }
                }
                if ((double)f8 < this.fracdx1) {
                    n17 += this.incx;
                    f8 = (float)((double)f8 + this.fracdx);
                } else {
                    n17 += this.incx1;
                    f8 = (float)((double)f8 - this.fracdx1);
                }
                if ((double)f9 < this.fracdy1) {
                    n18 += this.incy;
                    f9 = (float)((double)f9 + this.fracdy);
                } else {
                    n18 += this.incy1;
                    f9 = (float)((double)f9 - this.fracdy1);
                }
                n19 = (n17 - n2) * n7;
                n20 = (n18 - n3) * n8;
                n16 += n5;
                ++n21;
            }
            n4 += n6;
            ++n15;
        }
    }

    private void shortLoop(RasterAccessor rasterAccessor, Rectangle rectangle, int n2, int n3, RasterAccessor rasterAccessor2) {
        float f2 = rasterAccessor.getX();
        float f3 = rasterAccessor.getY();
        float f4 = f2 + (float)rasterAccessor.getWidth();
        float f5 = f3 + (float)rasterAccessor.getHeight();
        int[][] nArray = new int[this.interp_height][this.interp_width];
        int n4 = 0;
        Point2D.Float float_ = new Point2D.Float();
        Point2D.Float float_2 = new Point2D.Float();
        short[][] sArray = rasterAccessor2.getShortDataArrays();
        int[] nArray2 = rasterAccessor2.getBandOffsets();
        int n5 = rasterAccessor2.getPixelStride();
        int n6 = rasterAccessor2.getScanlineStride();
        short[][] sArray2 = rasterAccessor.getShortDataArrays();
        int[] nArray3 = rasterAccessor.getBandOffsets();
        int n7 = rasterAccessor.getPixelStride();
        int n8 = rasterAccessor.getScanlineStride();
        int n9 = rasterAccessor2.getNumBands();
        int n10 = rectangle.x;
        int n11 = rectangle.y;
        int n12 = rectangle.x + rectangle.width;
        int n13 = rectangle.y + rectangle.height;
        short[] sArray3 = new short[n9];
        int n14 = 0;
        while (n14 < n9) {
            sArray3[n14] = (short)this.backgroundValues[n14];
            ++n14;
        }
        int n15 = n11;
        while (n15 < n13) {
            int n16 = n4;
            ((Point2D)float_).setLocation((double)n10 + 0.5, (double)n15 + 0.5);
            this.mapDestPoint((Point2D)float_, float_2);
            float f6 = (float)((Point2D)float_2).getX();
            float f7 = (float)((Point2D)float_2).getY();
            f6 = (float)((double)f6 - 0.5);
            f7 = (float)((double)f7 - 0.5);
            int n17 = (int)Math.floor(f6);
            int n18 = (int)Math.floor(f7);
            float f8 = f6 - (float)n17;
            float f9 = f7 - (float)n18;
            int n19 = (n17 - n2) * n7;
            int n20 = (n18 - n3) * n8;
            int n21 = n10;
            while (n21 < n12) {
                int n22;
                if ((float)n17 >= f2 + (float)this.interp_left && (float)n17 < f4 - (float)this.interp_right && (float)n18 >= f3 + (float)this.interp_top && (float)n18 < f5 - (float)this.interp_bottom) {
                    n22 = 0;
                    while (n22 < n9) {
                        short[] sArray4 = sArray2[n22];
                        int n23 = nArray3[n22];
                        int n24 = this.interp_left * n7 + this.interp_top * n8;
                        n24 = n19 + n20 - n24;
                        int n25 = 0;
                        int n26 = 0;
                        int n27 = 0;
                        while (n27 < this.interp_height) {
                            int n28 = n24;
                            int n29 = 0;
                            while (n29 < this.interp_width) {
                                nArray[n26][n25++] = sArray4[n24 + n23];
                                n24 += n7;
                                ++n29;
                            }
                            ++n26;
                            n25 = 0;
                            n24 = n28 + n8;
                            ++n27;
                        }
                        int n30 = (int)(f8 * (float)this.shiftvalue);
                        int n31 = (int)(f9 * (float)this.shiftvalue);
                        int n32 = this.interp.interpolate(nArray, n30, n31);
                        int n33 = n32 < Short.MIN_VALUE ? Short.MIN_VALUE : (n32 > Short.MAX_VALUE ? Short.MAX_VALUE : (int)((short)n32));
                        sArray[n22][n16 + nArray2[n22]] = n33;
                        ++n22;
                    }
                } else if (this.setBackground) {
                    n22 = 0;
                    while (n22 < n9) {
                        sArray[n22][n16 + nArray2[n22]] = sArray3[n22];
                        ++n22;
                    }
                }
                if ((double)f8 < this.fracdx1) {
                    n17 += this.incx;
                    f8 = (float)((double)f8 + this.fracdx);
                } else {
                    n17 += this.incx1;
                    f8 = (float)((double)f8 - this.fracdx1);
                }
                if ((double)f9 < this.fracdy1) {
                    n18 += this.incy;
                    f9 = (float)((double)f9 + this.fracdy);
                } else {
                    n18 += this.incy1;
                    f9 = (float)((double)f9 - this.fracdy1);
                }
                n19 = (n17 - n2) * n7;
                n20 = (n18 - n3) * n8;
                n16 += n5;
                ++n21;
            }
            n4 += n6;
            ++n15;
        }
    }

    private void ushortLoop(RasterAccessor rasterAccessor, Rectangle rectangle, int n2, int n3, RasterAccessor rasterAccessor2) {
        float f2 = rasterAccessor.getX();
        float f3 = rasterAccessor.getY();
        float f4 = f2 + (float)rasterAccessor.getWidth();
        float f5 = f3 + (float)rasterAccessor.getHeight();
        int[][] nArray = new int[this.interp_height][this.interp_width];
        int n4 = 0;
        Point2D.Float float_ = new Point2D.Float();
        Point2D.Float float_2 = new Point2D.Float();
        short[][] sArray = rasterAccessor2.getShortDataArrays();
        int[] nArray2 = rasterAccessor2.getBandOffsets();
        int n5 = rasterAccessor2.getPixelStride();
        int n6 = rasterAccessor2.getScanlineStride();
        short[][] sArray2 = rasterAccessor.getShortDataArrays();
        int[] nArray3 = rasterAccessor.getBandOffsets();
        int n7 = rasterAccessor.getPixelStride();
        int n8 = rasterAccessor.getScanlineStride();
        int n9 = rasterAccessor2.getNumBands();
        int n10 = rectangle.x;
        int n11 = rectangle.y;
        int n12 = rectangle.x + rectangle.width;
        int n13 = rectangle.y + rectangle.height;
        short[] sArray3 = new short[n9];
        int n14 = 0;
        while (n14 < n9) {
            sArray3[n14] = (short)this.backgroundValues[n14];
            ++n14;
        }
        int n15 = n11;
        while (n15 < n13) {
            int n16 = n4;
            ((Point2D)float_).setLocation((double)n10 + 0.5, (double)n15 + 0.5);
            this.mapDestPoint((Point2D)float_, float_2);
            float f6 = (float)((Point2D)float_2).getX();
            float f7 = (float)((Point2D)float_2).getY();
            f6 = (float)((double)f6 - 0.5);
            f7 = (float)((double)f7 - 0.5);
            int n17 = (int)Math.floor(f6);
            int n18 = (int)Math.floor(f7);
            float f8 = f6 - (float)n17;
            float f9 = f7 - (float)n18;
            int n19 = (n17 - n2) * n7;
            int n20 = (n18 - n3) * n8;
            int n21 = n10;
            while (n21 < n12) {
                int n22;
                if ((float)n17 >= f2 + (float)this.interp_left && (float)n17 < f4 - (float)this.interp_right && (float)n18 >= f3 + (float)this.interp_top && (float)n18 < f5 - (float)this.interp_bottom) {
                    n22 = 0;
                    while (n22 < n9) {
                        short[] sArray4 = sArray2[n22];
                        int n23 = nArray3[n22];
                        int n24 = this.interp_left * n7 + this.interp_top * n8;
                        n24 = n19 + n20 - n24;
                        int n25 = 0;
                        int n26 = 0;
                        int n27 = 0;
                        while (n27 < this.interp_height) {
                            int n28 = n24;
                            int n29 = 0;
                            while (n29 < this.interp_width) {
                                nArray[n26][n25++] = sArray4[n24 + n23] & 0xFFFF;
                                n24 += n7;
                                ++n29;
                            }
                            ++n26;
                            n25 = 0;
                            n24 = n28 + n8;
                            ++n27;
                        }
                        int n30 = (int)(f8 * (float)this.shiftvalue);
                        int n31 = (int)(f9 * (float)this.shiftvalue);
                        int n32 = this.interp.interpolate(nArray, n30, n31);
                        int n33 = n32 < 0 ? 0 : (n32 > 65535 ? 65535 : n32);
                        sArray[n22][n16 + nArray2[n22]] = (short)(n33 & 0xFFFF);
                        ++n22;
                    }
                } else if (this.setBackground) {
                    n22 = 0;
                    while (n22 < n9) {
                        sArray[n22][n16 + nArray2[n22]] = sArray3[n22];
                        ++n22;
                    }
                }
                if ((double)f8 < this.fracdx1) {
                    n17 += this.incx;
                    f8 = (float)((double)f8 + this.fracdx);
                } else {
                    n17 += this.incx1;
                    f8 = (float)((double)f8 - this.fracdx1);
                }
                if ((double)f9 < this.fracdy1) {
                    n18 += this.incy;
                    f9 = (float)((double)f9 + this.fracdy);
                } else {
                    n18 += this.incy1;
                    f9 = (float)((double)f9 - this.fracdy1);
                }
                n19 = (n17 - n2) * n7;
                n20 = (n18 - n3) * n8;
                n16 += n5;
                ++n21;
            }
            n4 += n6;
            ++n15;
        }
    }

    private void floatLoop(RasterAccessor rasterAccessor, Rectangle rectangle, int n2, int n3, RasterAccessor rasterAccessor2) {
        float f2 = rasterAccessor.getX();
        float f3 = rasterAccessor.getY();
        float f4 = f2 + (float)rasterAccessor.getWidth();
        float f5 = f3 + (float)rasterAccessor.getHeight();
        float[][] fArray = new float[this.interp_height][this.interp_width];
        int n4 = 0;
        Point2D.Float float_ = new Point2D.Float();
        Point2D.Float float_2 = new Point2D.Float();
        float[][] fArray2 = rasterAccessor2.getFloatDataArrays();
        int[] nArray = rasterAccessor2.getBandOffsets();
        int n5 = rasterAccessor2.getPixelStride();
        int n6 = rasterAccessor2.getScanlineStride();
        float[][] fArray3 = rasterAccessor.getFloatDataArrays();
        int[] nArray2 = rasterAccessor.getBandOffsets();
        int n7 = rasterAccessor.getPixelStride();
        int n8 = rasterAccessor.getScanlineStride();
        int n9 = rasterAccessor2.getNumBands();
        int n10 = rectangle.x;
        int n11 = rectangle.y;
        int n12 = rectangle.x + rectangle.width;
        int n13 = rectangle.y + rectangle.height;
        float[] fArray4 = new float[n9];
        int n14 = 0;
        while (n14 < n9) {
            fArray4[n14] = (float)this.backgroundValues[n14];
            ++n14;
        }
        int n15 = n11;
        while (n15 < n13) {
            int n16 = n4;
            ((Point2D)float_).setLocation((double)n10 + 0.5, (double)n15 + 0.5);
            this.mapDestPoint((Point2D)float_, float_2);
            float f6 = (float)((Point2D)float_2).getX();
            float f7 = (float)((Point2D)float_2).getY();
            f6 = (float)((double)f6 - 0.5);
            f7 = (float)((double)f7 - 0.5);
            int n17 = (int)Math.floor(f6);
            int n18 = (int)Math.floor(f7);
            float f8 = f6 - (float)n17;
            float f9 = f7 - (float)n18;
            int n19 = (n17 - n2) * n7;
            int n20 = (n18 - n3) * n8;
            int n21 = n10;
            while (n21 < n12) {
                int n22;
                if ((float)n17 >= f2 + (float)this.interp_left && (float)n17 < f4 - (float)this.interp_right && (float)n18 >= f3 + (float)this.interp_top && (float)n18 < f5 - (float)this.interp_bottom) {
                    n22 = 0;
                    while (n22 < n9) {
                        float f10;
                        float[] fArray5 = fArray3[n22];
                        int n23 = nArray2[n22];
                        int n24 = this.interp_left * n7 + this.interp_top * n8;
                        n24 = n19 + n20 - n24;
                        int n25 = 0;
                        int n26 = 0;
                        int n27 = 0;
                        while (n27 < this.interp_height) {
                            int n28 = n24;
                            int n29 = 0;
                            while (n29 < this.interp_width) {
                                fArray[n26][n25++] = fArray5[n24 + n23];
                                n24 += n7;
                                ++n29;
                            }
                            ++n26;
                            n25 = 0;
                            n24 = n28 + n8;
                            ++n27;
                        }
                        fArray2[n22][n16 + nArray[n22]] = f10 = this.interp.interpolate(fArray, f8, f9);
                        ++n22;
                    }
                } else if (this.setBackground) {
                    n22 = 0;
                    while (n22 < n9) {
                        fArray2[n22][n16 + nArray[n22]] = fArray4[n22];
                        ++n22;
                    }
                }
                if ((double)f8 < this.fracdx1) {
                    n17 += this.incx;
                    f8 = (float)((double)f8 + this.fracdx);
                } else {
                    n17 += this.incx1;
                    f8 = (float)((double)f8 - this.fracdx1);
                }
                if ((double)f9 < this.fracdy1) {
                    n18 += this.incy;
                    f9 = (float)((double)f9 + this.fracdy);
                } else {
                    n18 += this.incy1;
                    f9 = (float)((double)f9 - this.fracdy1);
                }
                n19 = (n17 - n2) * n7;
                n20 = (n18 - n3) * n8;
                n16 += n5;
                ++n21;
            }
            n4 += n6;
            ++n15;
        }
    }

    private void doubleLoop(RasterAccessor rasterAccessor, Rectangle rectangle, int n2, int n3, RasterAccessor rasterAccessor2) {
        float f2 = rasterAccessor.getX();
        float f3 = rasterAccessor.getY();
        float f4 = f2 + (float)rasterAccessor.getWidth();
        float f5 = f3 + (float)rasterAccessor.getHeight();
        double[][] dArray = new double[this.interp_height][this.interp_width];
        int n4 = 0;
        Point2D.Float float_ = new Point2D.Float();
        Point2D.Float float_2 = new Point2D.Float();
        double[][] dArray2 = rasterAccessor2.getDoubleDataArrays();
        int[] nArray = rasterAccessor2.getBandOffsets();
        int n5 = rasterAccessor2.getPixelStride();
        int n6 = rasterAccessor2.getScanlineStride();
        double[][] dArray3 = rasterAccessor.getDoubleDataArrays();
        int[] nArray2 = rasterAccessor.getBandOffsets();
        int n7 = rasterAccessor.getPixelStride();
        int n8 = rasterAccessor.getScanlineStride();
        int n9 = rasterAccessor2.getNumBands();
        int n10 = rectangle.x;
        int n11 = rectangle.y;
        int n12 = rectangle.x + rectangle.width;
        int n13 = rectangle.y + rectangle.height;
        int n14 = n11;
        while (n14 < n13) {
            int n15 = n4;
            ((Point2D)float_).setLocation((double)n10 + 0.5, (double)n14 + 0.5);
            this.mapDestPoint((Point2D)float_, float_2);
            double d2 = ((Point2D)float_2).getX();
            double d3 = ((Point2D)float_2).getY();
            int n16 = (int)Math.floor(d2 -= 0.5);
            int n17 = (int)Math.floor(d3 -= 0.5);
            double d4 = d2 - (double)n16;
            double d5 = d3 - (double)n17;
            int n18 = (n16 - n2) * n7;
            int n19 = (n17 - n3) * n8;
            int n20 = n10;
            while (n20 < n12) {
                int n21;
                if ((float)n16 >= f2 + (float)this.interp_left && (float)n16 < f4 - (float)this.interp_right && (float)n17 >= f3 + (float)this.interp_top && (float)n17 < f5 - (float)this.interp_bottom) {
                    n21 = 0;
                    while (n21 < n9) {
                        double d6;
                        double[] dArray4 = dArray3[n21];
                        int n22 = nArray2[n21];
                        int n23 = this.interp_left * n7 + this.interp_top * n8;
                        n23 = n18 + n19 - n23;
                        int n24 = 0;
                        int n25 = 0;
                        int n26 = 0;
                        while (n26 < this.interp_height) {
                            int n27 = n23;
                            int n28 = 0;
                            while (n28 < this.interp_width) {
                                dArray[n25][n24++] = dArray4[n23 + n22];
                                n23 += n7;
                                ++n28;
                            }
                            ++n25;
                            n24 = 0;
                            n23 = n27 + n8;
                            ++n26;
                        }
                        dArray2[n21][n15 + nArray[n21]] = d6 = this.interp.interpolate(dArray, (float)d4, (float)d5);
                        ++n21;
                    }
                } else if (this.setBackground) {
                    n21 = 0;
                    while (n21 < n9) {
                        dArray2[n21][n15 + nArray[n21]] = this.backgroundValues[n21];
                        ++n21;
                    }
                }
                if (d4 < this.fracdx1) {
                    n16 += this.incx;
                    d4 += this.fracdx;
                } else {
                    n16 += this.incx1;
                    d4 -= this.fracdx1;
                }
                if (d5 < this.fracdy1) {
                    n17 += this.incy;
                    d5 += this.fracdy;
                } else {
                    n17 += this.incy1;
                    d5 -= this.fracdy1;
                }
                n18 = (n16 - n2) * n7;
                n19 = (n17 - n3) * n8;
                n15 += n5;
                ++n20;
            }
            n4 += n6;
            ++n14;
        }
    }
}

