/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jai.opimage;

import com.sun.media.jai.opimage.AffineNearestOpImage;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferInt;
import java.awt.image.DataBufferShort;
import java.awt.image.MultiPixelPackedSampleModel;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.util.Map;
import javax.media.jai.BorderExtender;
import javax.media.jai.ImageLayout;
import javax.media.jai.Interpolation;
import javax.media.jai.JAI;
import javax.media.jai.util.Range;

final class AffineNearestBinaryOpImage
extends AffineNearestOpImage {
    private int black = 0;

    private static Map configHelper(Map map) {
        Map map2;
        if (map == null) {
            map2 = new RenderingHints(JAI.KEY_REPLACE_INDEX_COLOR_MODEL, Boolean.FALSE);
        } else {
            map2 = map;
            if (!map2.containsKey(JAI.KEY_REPLACE_INDEX_COLOR_MODEL)) {
                RenderingHints renderingHints = (RenderingHints)map;
                map2 = (RenderingHints)renderingHints.clone();
                map2.put(JAI.KEY_REPLACE_INDEX_COLOR_MODEL, Boolean.FALSE);
            }
        }
        return map2;
    }

    public AffineNearestBinaryOpImage(RenderedImage renderedImage, BorderExtender borderExtender, Map map, ImageLayout imageLayout, AffineTransform affineTransform, Interpolation interpolation, double[] dArray) {
        super(renderedImage, borderExtender, AffineNearestBinaryOpImage.configHelper(map), imageLayout, affineTransform, interpolation, dArray);
        this.colorModel = imageLayout != null ? imageLayout.getColorModel(renderedImage) : renderedImage.getColorModel();
        this.sampleModel = renderedImage.getSampleModel().createCompatibleSampleModel(this.tileWidth, this.tileHeight);
    }

    protected void computeRect(Raster[] rasterArray, WritableRaster writableRaster, Rectangle rectangle) {
        Raster raster = rasterArray[0];
        switch (raster.getSampleModel().getDataType()) {
            case 0: {
                this.byteLoop(raster, writableRaster, rectangle);
                break;
            }
            case 3: {
                this.intLoop(raster, writableRaster, rectangle);
                break;
            }
            case 1: 
            case 2: {
                this.shortLoop(raster, writableRaster, rectangle);
            }
        }
    }

    private void byteLoop(Raster raster, WritableRaster writableRaster, Rectangle rectangle) {
        float f2 = raster.getMinX();
        float f3 = raster.getMinY();
        float f4 = f2 + (float)raster.getWidth();
        float f5 = f3 + (float)raster.getHeight();
        MultiPixelPackedSampleModel multiPixelPackedSampleModel = (MultiPixelPackedSampleModel)raster.getSampleModel();
        DataBufferByte dataBufferByte = (DataBufferByte)raster.getDataBuffer();
        int n2 = raster.getSampleModelTranslateX();
        int n3 = raster.getSampleModelTranslateY();
        int n4 = multiPixelPackedSampleModel.getDataBitOffset();
        int n5 = multiPixelPackedSampleModel.getScanlineStride();
        MultiPixelPackedSampleModel multiPixelPackedSampleModel2 = (MultiPixelPackedSampleModel)writableRaster.getSampleModel();
        DataBufferByte dataBufferByte2 = (DataBufferByte)writableRaster.getDataBuffer();
        int n6 = writableRaster.getMinX();
        int n7 = writableRaster.getMinY();
        int n8 = writableRaster.getSampleModelTranslateX();
        int n9 = writableRaster.getSampleModelTranslateY();
        int n10 = multiPixelPackedSampleModel2.getDataBitOffset();
        int n11 = multiPixelPackedSampleModel2.getScanlineStride();
        byte[] byArray = dataBufferByte.getData();
        int n12 = dataBufferByte.getOffset();
        byte[] byArray2 = dataBufferByte2.getData();
        int n13 = dataBufferByte2.getOffset();
        Point2D.Float float_ = new Point2D.Float();
        Point2D.Float float_2 = new Point2D.Float();
        int n14 = rectangle.x;
        int n15 = rectangle.y;
        int n16 = rectangle.x + rectangle.width;
        int n17 = rectangle.y + rectangle.height;
        int n18 = this.incy * n5;
        int n19 = this.incy1 * n5;
        this.black = (int)this.backgroundValues[0] & 1;
        int n20 = n15;
        while (n20 < n17) {
            ((Point2D)float_).setLocation((double)n14 + 0.5, (double)n20 + 0.5);
            this.mapDestPoint((Point2D)float_, float_2);
            float f6 = (float)((Point2D)float_2).getX();
            float f7 = (float)((Point2D)float_2).getY();
            int n21 = (int)Math.floor(f6);
            int n22 = (int)Math.floor(f7);
            double d2 = (double)f6 - (double)n21;
            double d3 = (double)f7 - (double)n22;
            int n23 = (int)Math.floor(d2 * 1048576.0);
            int n24 = (int)Math.floor(d3 * 1048576.0);
            int n25 = n21;
            int n26 = n22;
            int n27 = n23;
            int n28 = n24;
            Range range = this.performScanlineClipping(f2, f3, f4, f5, n21, n22, n23, n24, n14, n16, 0, 0, 0, 0);
            int n29 = (Integer)range.getMinValue();
            int n30 = (Integer)range.getMaxValue();
            if (n29 <= n30) {
                int n31;
                int n32;
                int n33;
                int n34;
                int n35;
                int n36 = (n20 - n9) * n11 + n13;
                int n37 = n10 + (n14 - n8);
                int n38 = (n22 - n3) * n5 + n12;
                int n39 = n21 - n2 + n4;
                int n40 = n14;
                while (n40 < n29) {
                    if (this.setBackground) {
                        n35 = n36 + (n37 >> 3);
                        n34 = 7 - (n37 & 7);
                        n33 = byArray2[n35];
                        byArray2[n35] = (byte)(n33 |= this.black << n34);
                    }
                    if (n23 < this.ifracdx1) {
                        n21 += this.incx;
                        n23 += this.ifracdx;
                        n39 += this.incx;
                    } else {
                        n21 += this.incx1;
                        n23 -= this.ifracdx1;
                        n39 += this.incx1;
                    }
                    if (n24 < this.ifracdy1) {
                        n22 += this.incy;
                        n24 += this.ifracdy;
                        n38 += n18;
                    } else {
                        n22 += this.incy1;
                        n24 -= this.ifracdy1;
                        n38 += n19;
                    }
                    ++n37;
                    ++n40;
                }
                n35 = n29;
                while (n35 < n30) {
                    n34 = n38 + (n39 >> 3);
                    n33 = byArray[n34];
                    n32 = n33 >> 7 - (n39 & 7) & 1;
                    n31 = n36 + (n37 >> 3);
                    int n41 = 7 - (n37 & 7);
                    int n42 = byArray2[n31];
                    byArray2[n31] = (byte)(n42 |= n32 << n41);
                    if (n23 < this.ifracdx1) {
                        n21 += this.incx;
                        n23 += this.ifracdx;
                        n39 += this.incx;
                    } else {
                        n21 += this.incx1;
                        n23 -= this.ifracdx1;
                        n39 += this.incx1;
                    }
                    if (n24 < this.ifracdy1) {
                        n22 += this.incy;
                        n24 += this.ifracdy;
                        n38 += n18;
                    } else {
                        n22 += this.incy1;
                        n24 -= this.ifracdy1;
                        n38 += n19;
                    }
                    ++n37;
                    ++n35;
                }
                n34 = n30;
                while (n34 < n16) {
                    if (this.setBackground) {
                        n33 = n36 + (n37 >> 3);
                        n32 = 7 - (n37 & 7);
                        n31 = byArray2[n33];
                        byArray2[n33] = (byte)(n31 |= this.black << n32);
                    }
                    if (n23 < this.ifracdx1) {
                        n21 += this.incx;
                        n23 += this.ifracdx;
                        n39 += this.incx;
                    } else {
                        n21 += this.incx1;
                        n23 -= this.ifracdx1;
                        n39 += this.incx1;
                    }
                    if (n24 < this.ifracdy1) {
                        n22 += this.incy;
                        n24 += this.ifracdy;
                        n38 += n18;
                    } else {
                        n22 += this.incy1;
                        n24 -= this.ifracdy1;
                        n38 += n19;
                    }
                    ++n37;
                    ++n34;
                }
            }
            ++n20;
        }
    }

    private void shortLoop(Raster raster, WritableRaster writableRaster, Rectangle rectangle) {
        float f2 = raster.getMinX();
        float f3 = raster.getMinY();
        float f4 = f2 + (float)raster.getWidth();
        float f5 = f3 + (float)raster.getHeight();
        MultiPixelPackedSampleModel multiPixelPackedSampleModel = (MultiPixelPackedSampleModel)raster.getSampleModel();
        DataBufferShort dataBufferShort = (DataBufferShort)raster.getDataBuffer();
        int n2 = raster.getSampleModelTranslateX();
        int n3 = raster.getSampleModelTranslateY();
        int n4 = multiPixelPackedSampleModel.getDataBitOffset();
        int n5 = multiPixelPackedSampleModel.getScanlineStride();
        MultiPixelPackedSampleModel multiPixelPackedSampleModel2 = (MultiPixelPackedSampleModel)writableRaster.getSampleModel();
        DataBufferShort dataBufferShort2 = (DataBufferShort)writableRaster.getDataBuffer();
        int n6 = writableRaster.getMinX();
        int n7 = writableRaster.getMinY();
        int n8 = writableRaster.getSampleModelTranslateX();
        int n9 = writableRaster.getSampleModelTranslateY();
        int n10 = multiPixelPackedSampleModel2.getDataBitOffset();
        int n11 = multiPixelPackedSampleModel2.getScanlineStride();
        short[] sArray = dataBufferShort.getData();
        int n12 = dataBufferShort.getOffset();
        short[] sArray2 = dataBufferShort2.getData();
        int n13 = dataBufferShort2.getOffset();
        Point2D.Float float_ = new Point2D.Float();
        Point2D.Float float_2 = new Point2D.Float();
        int n14 = rectangle.x;
        int n15 = rectangle.y;
        int n16 = rectangle.x + rectangle.width;
        int n17 = rectangle.y + rectangle.height;
        int n18 = this.incy * n5;
        int n19 = this.incy1 * n5;
        this.black = (int)this.backgroundValues[0] & 1;
        int n20 = n15;
        while (n20 < n17) {
            ((Point2D)float_).setLocation((double)n14 + 0.5, (double)n20 + 0.5);
            this.mapDestPoint((Point2D)float_, float_2);
            float f6 = (float)((Point2D)float_2).getX();
            float f7 = (float)((Point2D)float_2).getY();
            int n21 = (int)Math.floor(f6);
            int n22 = (int)Math.floor(f7);
            double d2 = (double)f6 - (double)n21;
            double d3 = (double)f7 - (double)n22;
            int n23 = (int)Math.floor(d2 * 1048576.0);
            int n24 = (int)Math.floor(d3 * 1048576.0);
            int n25 = n21;
            int n26 = n22;
            int n27 = n23;
            int n28 = n24;
            Range range = this.performScanlineClipping(f2, f3, f4, f5, n21, n22, n23, n24, n14, n16, 0, 0, 0, 0);
            int n29 = (Integer)range.getMinValue();
            int n30 = (Integer)range.getMaxValue();
            if (n29 <= n30) {
                int n31;
                int n32;
                int n33;
                int n34;
                int n35;
                int n36 = (n20 - n9) * n11 + n13;
                int n37 = n10 + (n14 - n8);
                int n38 = (n22 - n3) * n5 + n12;
                int n39 = n21 - n2 + n4;
                int n40 = n14;
                while (n40 < n29) {
                    if (this.setBackground) {
                        n35 = n36 + (n37 >> 4);
                        n34 = 15 - (n37 & 0xF);
                        n33 = sArray2[n35];
                        sArray2[n35] = (short)(n33 |= this.black << n34);
                    }
                    if (n23 < this.ifracdx1) {
                        n21 += this.incx;
                        n23 += this.ifracdx;
                        n39 += this.incx;
                    } else {
                        n21 += this.incx1;
                        n23 -= this.ifracdx1;
                        n39 += this.incx1;
                    }
                    if (n24 < this.ifracdy1) {
                        n22 += this.incy;
                        n24 += this.ifracdy;
                        n38 += n18;
                    } else {
                        n22 += this.incy1;
                        n24 -= this.ifracdy1;
                        n38 += n19;
                    }
                    ++n37;
                    ++n40;
                }
                n35 = n29;
                while (n35 < n30) {
                    n34 = n38 + (n39 >> 4);
                    n33 = sArray[n34];
                    n32 = n33 >> 15 - (n39 & 0xF) & 1;
                    n31 = n36 + (n37 >> 4);
                    int n41 = 15 - (n37 & 0xF);
                    int n42 = sArray2[n31];
                    sArray2[n31] = (short)(n42 |= n32 << n41);
                    if (n23 < this.ifracdx1) {
                        n21 += this.incx;
                        n23 += this.ifracdx;
                        n39 += this.incx;
                    } else {
                        n21 += this.incx1;
                        n23 -= this.ifracdx1;
                        n39 += this.incx1;
                    }
                    if (n24 < this.ifracdy1) {
                        n22 += this.incy;
                        n24 += this.ifracdy;
                        n38 += n18;
                    } else {
                        n22 += this.incy1;
                        n24 -= this.ifracdy1;
                        n38 += n19;
                    }
                    ++n37;
                    ++n35;
                }
                n34 = n30;
                while (n34 < n16) {
                    if (this.setBackground) {
                        n33 = n36 + (n37 >> 4);
                        n32 = 15 - (n37 & 0xF);
                        n31 = sArray2[n33];
                        sArray2[n33] = (short)(n31 |= this.black << n32);
                    }
                    if (n23 < this.ifracdx1) {
                        n21 += this.incx;
                        n23 += this.ifracdx;
                        n39 += this.incx;
                    } else {
                        n21 += this.incx1;
                        n23 -= this.ifracdx1;
                        n39 += this.incx1;
                    }
                    if (n24 < this.ifracdy1) {
                        n22 += this.incy;
                        n24 += this.ifracdy;
                        n38 += n18;
                    } else {
                        n22 += this.incy1;
                        n24 -= this.ifracdy1;
                        n38 += n19;
                    }
                    ++n37;
                    ++n34;
                }
            }
            ++n20;
        }
    }

    private void intLoop(Raster raster, WritableRaster writableRaster, Rectangle rectangle) {
        float f2 = raster.getMinX();
        float f3 = raster.getMinY();
        float f4 = f2 + (float)raster.getWidth();
        float f5 = f3 + (float)raster.getHeight();
        MultiPixelPackedSampleModel multiPixelPackedSampleModel = (MultiPixelPackedSampleModel)raster.getSampleModel();
        DataBufferInt dataBufferInt = (DataBufferInt)raster.getDataBuffer();
        int n2 = raster.getSampleModelTranslateX();
        int n3 = raster.getSampleModelTranslateY();
        int n4 = multiPixelPackedSampleModel.getDataBitOffset();
        int n5 = multiPixelPackedSampleModel.getScanlineStride();
        MultiPixelPackedSampleModel multiPixelPackedSampleModel2 = (MultiPixelPackedSampleModel)writableRaster.getSampleModel();
        DataBufferInt dataBufferInt2 = (DataBufferInt)writableRaster.getDataBuffer();
        int n6 = writableRaster.getMinX();
        int n7 = writableRaster.getMinY();
        int n8 = writableRaster.getSampleModelTranslateX();
        int n9 = writableRaster.getSampleModelTranslateY();
        int n10 = multiPixelPackedSampleModel2.getDataBitOffset();
        int n11 = multiPixelPackedSampleModel2.getScanlineStride();
        int[] nArray = dataBufferInt.getData();
        int n12 = dataBufferInt.getOffset();
        int[] nArray2 = dataBufferInt2.getData();
        int n13 = dataBufferInt2.getOffset();
        Point2D.Float float_ = new Point2D.Float();
        Point2D.Float float_2 = new Point2D.Float();
        int n14 = rectangle.x;
        int n15 = rectangle.y;
        int n16 = rectangle.x + rectangle.width;
        int n17 = rectangle.y + rectangle.height;
        int n18 = this.incy * n5;
        int n19 = this.incy1 * n5;
        this.black = (int)this.backgroundValues[0] & 1;
        int n20 = n15;
        while (n20 < n17) {
            ((Point2D)float_).setLocation((double)n14 + 0.5, (double)n20 + 0.5);
            this.mapDestPoint((Point2D)float_, float_2);
            float f6 = (float)((Point2D)float_2).getX();
            float f7 = (float)((Point2D)float_2).getY();
            int n21 = (int)Math.floor(f6);
            int n22 = (int)Math.floor(f7);
            double d2 = (double)f6 - (double)n21;
            double d3 = (double)f7 - (double)n22;
            int n23 = (int)Math.floor(d2 * 1048576.0);
            int n24 = (int)Math.floor(d3 * 1048576.0);
            int n25 = n21;
            int n26 = n22;
            int n27 = n23;
            int n28 = n24;
            Range range = this.performScanlineClipping(f2, f3, f4, f5, n21, n22, n23, n24, n14, n16, 0, 0, 0, 0);
            int n29 = (Integer)range.getMinValue();
            int n30 = (Integer)range.getMaxValue();
            if (n29 <= n30) {
                int n31;
                int n32;
                int n33;
                int n34;
                int n35;
                int n36 = (n20 - n9) * n11 + n13;
                int n37 = n10 + (n14 - n8);
                int n38 = (n22 - n3) * n5 + n12;
                int n39 = n21 - n2 + n4;
                int n40 = n14;
                while (n40 < n29) {
                    if (this.setBackground) {
                        n35 = n36 + (n37 >> 5);
                        n34 = 31 - (n37 & 0x1F);
                        n33 = nArray2[n35];
                        nArray2[n35] = n33 |= this.black << n34;
                    }
                    if (n23 < this.ifracdx1) {
                        n21 += this.incx;
                        n23 += this.ifracdx;
                        n39 += this.incx;
                    } else {
                        n21 += this.incx1;
                        n23 -= this.ifracdx1;
                        n39 += this.incx1;
                    }
                    if (n24 < this.ifracdy1) {
                        n22 += this.incy;
                        n24 += this.ifracdy;
                        n38 += n18;
                    } else {
                        n22 += this.incy1;
                        n24 -= this.ifracdy1;
                        n38 += n19;
                    }
                    ++n37;
                    ++n40;
                }
                n35 = n29;
                while (n35 < n30) {
                    n34 = n38 + (n39 >> 5);
                    n33 = nArray[n34];
                    n32 = n33 >> 31 - (n39 & 0x1F) & 1;
                    n31 = n36 + (n37 >> 5);
                    int n41 = 31 - (n37 & 0x1F);
                    int n42 = nArray2[n31];
                    nArray2[n31] = n42 |= n32 << n41;
                    if (n23 < this.ifracdx1) {
                        n21 += this.incx;
                        n23 += this.ifracdx;
                        n39 += this.incx;
                    } else {
                        n21 += this.incx1;
                        n23 -= this.ifracdx1;
                        n39 += this.incx1;
                    }
                    if (n24 < this.ifracdy1) {
                        n22 += this.incy;
                        n24 += this.ifracdy;
                        n38 += n18;
                    } else {
                        n22 += this.incy1;
                        n24 -= this.ifracdy1;
                        n38 += n19;
                    }
                    ++n37;
                    ++n35;
                }
                n34 = n30;
                while (n34 < n16) {
                    if (this.setBackground) {
                        n33 = n36 + (n37 >> 5);
                        n32 = 31 - (n37 & 0x1F);
                        n31 = nArray2[n33];
                        nArray2[n33] = n31 |= this.black << n32;
                    }
                    if (n23 < this.ifracdx1) {
                        n21 += this.incx;
                        n23 += this.ifracdx;
                        n39 += this.incx;
                    } else {
                        n21 += this.incx1;
                        n23 -= this.ifracdx1;
                        n39 += this.incx1;
                    }
                    if (n24 < this.ifracdy1) {
                        n22 += this.incy;
                        n24 += this.ifracdy;
                        n38 += n18;
                    } else {
                        n22 += this.incy1;
                        n24 -= this.ifracdy1;
                        n38 += n19;
                    }
                    ++n37;
                    ++n34;
                }
            }
            ++n20;
        }
    }
}

