/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jai.opimage;

import com.sun.media.jai.util.ImageUtil;
import com.sun.media.jai.util.JDKWorkarounds;
import java.awt.Rectangle;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.util.Map;
import javax.media.jai.ImageLayout;
import javax.media.jai.PointOpImage;
import javax.media.jai.RasterAccessor;
import javax.media.jai.RasterFactory;
import javax.media.jai.RasterFormatTag;

final class BandCombineOpImage
extends PointOpImage {
    private double[][] matrix;

    public BandCombineOpImage(RenderedImage renderedImage, Map map, ImageLayout imageLayout, double[][] dArray) {
        super(renderedImage, imageLayout, map, true);
        this.matrix = dArray;
        int n2 = dArray.length;
        if (this.getSampleModel().getNumBands() != n2) {
            this.sampleModel = RasterFactory.createComponentSampleModel(this.sampleModel, this.sampleModel.getDataType(), this.tileWidth, this.tileHeight, n2);
            if (this.colorModel != null && !JDKWorkarounds.areCompatibleDataModels(this.sampleModel, this.colorModel)) {
                this.colorModel = ImageUtil.getCompatibleColorModel(this.sampleModel, map);
            }
        }
    }

    protected void computeRect(Raster[] rasterArray, WritableRaster writableRaster, Rectangle rectangle) {
        RasterFormatTag[] rasterFormatTagArray = this.getFormatTags();
        RasterAccessor rasterAccessor = new RasterAccessor(rasterArray[0], rectangle, rasterFormatTagArray[0], this.getSourceImage(0).getColorModel());
        RasterAccessor rasterAccessor2 = new RasterAccessor(writableRaster, rectangle, rasterFormatTagArray[1], this.getColorModel());
        switch (rasterAccessor2.getDataType()) {
            case 0: {
                this.computeRectByte(rasterAccessor, rasterAccessor2);
                break;
            }
            case 1: {
                this.computeRectUShort(rasterAccessor, rasterAccessor2);
                break;
            }
            case 2: {
                this.computeRectShort(rasterAccessor, rasterAccessor2);
                break;
            }
            case 3: {
                this.computeRectInt(rasterAccessor, rasterAccessor2);
                break;
            }
            case 4: {
                this.computeRectFloat(rasterAccessor, rasterAccessor2);
                break;
            }
            case 5: {
                this.computeRectDouble(rasterAccessor, rasterAccessor2);
            }
        }
        if (rasterAccessor2.isDataCopy()) {
            rasterAccessor2.clampDataArrays();
            rasterAccessor2.copyDataToRaster();
        }
    }

    private void computeRectByte(RasterAccessor rasterAccessor, RasterAccessor rasterAccessor2) {
        int n2 = rasterAccessor.getScanlineStride();
        int n3 = rasterAccessor.getPixelStride();
        int n4 = rasterAccessor.getNumBands();
        int[] nArray = rasterAccessor.getBandOffsets();
        byte[][] byArray = rasterAccessor.getByteDataArrays();
        int n5 = rasterAccessor2.getWidth();
        int n6 = rasterAccessor2.getHeight();
        int n7 = rasterAccessor2.getNumBands();
        int n8 = rasterAccessor2.getScanlineStride();
        int n9 = rasterAccessor2.getPixelStride();
        int[] nArray2 = rasterAccessor2.getBandOffsets();
        byte[][] byArray2 = rasterAccessor2.getByteDataArrays();
        int n10 = 0;
        int n11 = 0;
        int n12 = 0;
        while (n12 < n6) {
            int n13 = n10;
            int n14 = n11;
            int n15 = 0;
            while (n15 < n5) {
                int n16 = 0;
                while (n16 < n7) {
                    float f2 = 0.0f;
                    double[] dArray = this.matrix[n16];
                    int n17 = 0;
                    while (n17 < n4) {
                        f2 += (float)dArray[n17] * (float)(byArray[n17][n13 + nArray[n17]] & 0xFF);
                        ++n17;
                    }
                    byArray2[n16][n14 + nArray2[n16]] = ImageUtil.clampRoundByte(f2 + (float)dArray[n4]);
                    ++n16;
                }
                n13 += n3;
                n14 += n9;
                ++n15;
            }
            n10 += n2;
            n11 += n8;
            ++n12;
        }
    }

    private void computeRectUShort(RasterAccessor rasterAccessor, RasterAccessor rasterAccessor2) {
        int n2 = rasterAccessor.getScanlineStride();
        int n3 = rasterAccessor.getPixelStride();
        int n4 = rasterAccessor.getNumBands();
        int[] nArray = rasterAccessor.getBandOffsets();
        short[][] sArray = rasterAccessor.getShortDataArrays();
        int n5 = rasterAccessor2.getWidth();
        int n6 = rasterAccessor2.getHeight();
        int n7 = rasterAccessor2.getNumBands();
        int n8 = rasterAccessor2.getScanlineStride();
        int n9 = rasterAccessor2.getPixelStride();
        int[] nArray2 = rasterAccessor2.getBandOffsets();
        short[][] sArray2 = rasterAccessor2.getShortDataArrays();
        int n10 = 0;
        int n11 = 0;
        int n12 = 0;
        while (n12 < n6) {
            int n13 = n10;
            int n14 = n11;
            int n15 = 0;
            while (n15 < n5) {
                int n16 = 0;
                while (n16 < n7) {
                    float f2 = 0.0f;
                    double[] dArray = this.matrix[n16];
                    int n17 = 0;
                    while (n17 < n4) {
                        f2 += (float)dArray[n17] * (float)(sArray[n17][n13 + nArray[n17]] & 0xFFFF);
                        ++n17;
                    }
                    sArray2[n16][n14 + nArray2[n16]] = ImageUtil.clampRoundUShort(f2 + (float)this.matrix[n16][n4]);
                    ++n16;
                }
                n13 += n3;
                n14 += n9;
                ++n15;
            }
            n10 += n2;
            n11 += n8;
            ++n12;
        }
    }

    private void computeRectShort(RasterAccessor rasterAccessor, RasterAccessor rasterAccessor2) {
        int n2 = rasterAccessor.getScanlineStride();
        int n3 = rasterAccessor.getPixelStride();
        int n4 = rasterAccessor.getNumBands();
        int[] nArray = rasterAccessor.getBandOffsets();
        short[][] sArray = rasterAccessor.getShortDataArrays();
        int n5 = rasterAccessor2.getWidth();
        int n6 = rasterAccessor2.getHeight();
        int n7 = rasterAccessor2.getNumBands();
        int n8 = rasterAccessor2.getScanlineStride();
        int n9 = rasterAccessor2.getPixelStride();
        int[] nArray2 = rasterAccessor2.getBandOffsets();
        short[][] sArray2 = rasterAccessor2.getShortDataArrays();
        int n10 = 0;
        int n11 = 0;
        int n12 = 0;
        while (n12 < n6) {
            int n13 = n10;
            int n14 = n11;
            int n15 = 0;
            while (n15 < n5) {
                int n16 = 0;
                while (n16 < n7) {
                    float f2 = 0.0f;
                    double[] dArray = this.matrix[n16];
                    int n17 = 0;
                    while (n17 < n4) {
                        f2 += (float)dArray[n17] * (float)sArray[n17][n13 + nArray[n17]];
                        ++n17;
                    }
                    sArray2[n16][n14 + nArray2[n16]] = ImageUtil.clampRoundUShort(f2 + (float)this.matrix[n16][n4]);
                    ++n16;
                }
                n13 += n3;
                n14 += n9;
                ++n15;
            }
            n10 += n2;
            n11 += n8;
            ++n12;
        }
    }

    private void computeRectInt(RasterAccessor rasterAccessor, RasterAccessor rasterAccessor2) {
        int n2 = rasterAccessor.getScanlineStride();
        int n3 = rasterAccessor.getPixelStride();
        int n4 = rasterAccessor.getNumBands();
        int[] nArray = rasterAccessor.getBandOffsets();
        int[][] nArray2 = rasterAccessor.getIntDataArrays();
        int n5 = rasterAccessor2.getWidth();
        int n6 = rasterAccessor2.getHeight();
        int n7 = rasterAccessor2.getNumBands();
        int n8 = rasterAccessor2.getScanlineStride();
        int n9 = rasterAccessor2.getPixelStride();
        int[] nArray3 = rasterAccessor2.getBandOffsets();
        int[][] nArray4 = rasterAccessor2.getIntDataArrays();
        int n10 = 0;
        int n11 = 0;
        int n12 = 0;
        while (n12 < n6) {
            int n13 = n10;
            int n14 = n11;
            int n15 = 0;
            while (n15 < n5) {
                int n16 = 0;
                while (n16 < n7) {
                    float f2 = 0.0f;
                    double[] dArray = this.matrix[n16];
                    int n17 = 0;
                    while (n17 < n4) {
                        f2 += (float)dArray[n17] * (float)nArray2[n17][n13 + nArray[n17]];
                        ++n17;
                    }
                    nArray4[n16][n14 + nArray3[n16]] = ImageUtil.clampRoundInt(f2 + (float)this.matrix[n16][n4]);
                    ++n16;
                }
                n13 += n3;
                n14 += n9;
                ++n15;
            }
            n10 += n2;
            n11 += n8;
            ++n12;
        }
    }

    private void computeRectFloat(RasterAccessor rasterAccessor, RasterAccessor rasterAccessor2) {
        int n2 = rasterAccessor.getScanlineStride();
        int n3 = rasterAccessor.getPixelStride();
        int n4 = rasterAccessor.getNumBands();
        int[] nArray = rasterAccessor.getBandOffsets();
        float[][] fArray = rasterAccessor.getFloatDataArrays();
        int n5 = rasterAccessor2.getWidth();
        int n6 = rasterAccessor2.getHeight();
        int n7 = rasterAccessor2.getNumBands();
        int n8 = rasterAccessor2.getScanlineStride();
        int n9 = rasterAccessor2.getPixelStride();
        int[] nArray2 = rasterAccessor2.getBandOffsets();
        float[][] fArray2 = rasterAccessor2.getFloatDataArrays();
        int n10 = 0;
        int n11 = 0;
        int n12 = 0;
        while (n12 < n6) {
            int n13 = n10;
            int n14 = n11;
            int n15 = 0;
            while (n15 < n5) {
                int n16 = 0;
                while (n16 < n7) {
                    float f2 = 0.0f;
                    double[] dArray = this.matrix[n16];
                    int n17 = 0;
                    while (n17 < n4) {
                        f2 += (float)dArray[n17] * fArray[n17][n13 + nArray[n17]];
                        ++n17;
                    }
                    fArray2[n16][n14 + nArray2[n16]] = f2 + (float)this.matrix[n16][n4];
                    ++n16;
                }
                n13 += n3;
                n14 += n9;
                ++n15;
            }
            n10 += n2;
            n11 += n8;
            ++n12;
        }
    }

    private void computeRectDouble(RasterAccessor rasterAccessor, RasterAccessor rasterAccessor2) {
        int n2 = rasterAccessor.getScanlineStride();
        int n3 = rasterAccessor.getPixelStride();
        int n4 = rasterAccessor.getNumBands();
        int[] nArray = rasterAccessor.getBandOffsets();
        double[][] dArray = rasterAccessor.getDoubleDataArrays();
        int n5 = rasterAccessor2.getWidth();
        int n6 = rasterAccessor2.getHeight();
        int n7 = rasterAccessor2.getNumBands();
        int n8 = rasterAccessor2.getScanlineStride();
        int n9 = rasterAccessor2.getPixelStride();
        int[] nArray2 = rasterAccessor2.getBandOffsets();
        double[][] dArray2 = rasterAccessor2.getDoubleDataArrays();
        int n10 = 0;
        int n11 = 0;
        int n12 = 0;
        while (n12 < n6) {
            int n13 = n10;
            int n14 = n11;
            int n15 = 0;
            while (n15 < n5) {
                int n16 = 0;
                while (n16 < n7) {
                    double d2 = 0.0;
                    double[] dArray3 = this.matrix[n16];
                    int n17 = 0;
                    while (n17 < n4) {
                        d2 += dArray3[n17] * dArray[n17][n13 + nArray[n17]];
                        ++n17;
                    }
                    dArray2[n16][n14 + nArray2[n16]] = d2 + this.matrix[n16][n4];
                    ++n16;
                }
                n13 += n3;
                n14 += n9;
                ++n15;
            }
            n10 += n2;
            n11 += n8;
            ++n12;
        }
    }
}

