/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jai.opimage;

import java.awt.Rectangle;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.util.Map;
import javax.media.jai.ImageLayout;
import javax.media.jai.PointOpImage;
import javax.media.jai.RasterAccessor;
import javax.media.jai.RasterFormatTag;

final class ClampOpImage
extends PointOpImage {
    private byte[][] byteTable = null;
    private final double[] low;
    private final double[] high;

    private synchronized void initByteTable() {
        if (this.byteTable == null) {
            int n2 = this.getSampleModel().getNumBands();
            this.byteTable = new byte[n2][256];
            int n3 = 0;
            while (n3 < n2) {
                byte[] byArray = this.byteTable[n3];
                int n4 = (int)this.low[n3];
                int n5 = (int)this.high[n3];
                byte by2 = (byte)n4;
                byte by3 = (byte)n5;
                int n6 = 0;
                while (n6 < 256) {
                    byArray[n6] = n6 < n4 ? by2 : (n6 > n5 ? by3 : (byte)n6);
                    ++n6;
                }
                ++n3;
            }
        }
    }

    public ClampOpImage(RenderedImage renderedImage, Map map, ImageLayout imageLayout, double[] dArray, double[] dArray2) {
        super(renderedImage, imageLayout, map, true);
        int n2 = this.getSampleModel().getNumBands();
        if (dArray.length < n2 || dArray2.length < n2) {
            this.low = new double[n2];
            this.high = new double[n2];
            int n3 = 0;
            while (n3 < n2) {
                this.low[n3] = dArray[0];
                this.high[n3] = dArray2[0];
                ++n3;
            }
        } else {
            this.low = (double[])dArray.clone();
            this.high = (double[])dArray2.clone();
        }
        this.permitInPlaceOperation();
    }

    protected void computeRect(Raster[] rasterArray, WritableRaster writableRaster, Rectangle rectangle) {
        RasterFormatTag[] rasterFormatTagArray = this.getFormatTags();
        Rectangle rectangle2 = this.mapDestRect(rectangle, 0);
        RasterAccessor rasterAccessor = new RasterAccessor(rasterArray[0], rectangle2, rasterFormatTagArray[0], this.getSourceImage(0).getColorModel());
        RasterAccessor rasterAccessor2 = new RasterAccessor(writableRaster, rectangle, rasterFormatTagArray[1], this.getColorModel());
        switch (rasterAccessor2.getDataType()) {
            case 0: {
                this.computeRectByte(rasterAccessor, rasterAccessor2);
                break;
            }
            case 1: {
                this.computeRectUShort(rasterAccessor, rasterAccessor2);
                break;
            }
            case 2: {
                this.computeRectShort(rasterAccessor, rasterAccessor2);
                break;
            }
            case 3: {
                this.computeRectInt(rasterAccessor, rasterAccessor2);
                break;
            }
            case 4: {
                this.computeRectFloat(rasterAccessor, rasterAccessor2);
                break;
            }
            case 5: {
                this.computeRectDouble(rasterAccessor, rasterAccessor2);
            }
        }
        rasterAccessor2.copyDataToRaster();
    }

    private void computeRectByte(RasterAccessor rasterAccessor, RasterAccessor rasterAccessor2) {
        this.initByteTable();
        int n2 = rasterAccessor2.getWidth();
        int n3 = rasterAccessor2.getHeight();
        int n4 = rasterAccessor2.getNumBands();
        int n5 = rasterAccessor2.getScanlineStride();
        int n6 = rasterAccessor2.getPixelStride();
        int[] nArray = rasterAccessor2.getBandOffsets();
        byte[][] byArray = rasterAccessor2.getByteDataArrays();
        int n7 = rasterAccessor.getScanlineStride();
        int n8 = rasterAccessor.getPixelStride();
        int[] nArray2 = rasterAccessor.getBandOffsets();
        byte[][] byArray2 = rasterAccessor.getByteDataArrays();
        int n9 = 0;
        while (n9 < n4) {
            byte[] byArray3 = byArray[n9];
            byte[] byArray4 = byArray2[n9];
            byte[] byArray5 = this.byteTable[n9];
            int n10 = nArray[n9];
            int n11 = nArray2[n9];
            int n12 = 0;
            while (n12 < n3) {
                int n13 = n10;
                int n14 = n11;
                n10 += n5;
                n11 += n7;
                int n15 = 0;
                while (n15 < n2) {
                    byArray3[n13] = byArray5[byArray4[n14] & 0xFF];
                    n13 += n6;
                    n14 += n8;
                    ++n15;
                }
                ++n12;
            }
            ++n9;
        }
    }

    private void computeRectUShort(RasterAccessor rasterAccessor, RasterAccessor rasterAccessor2) {
        int n2 = rasterAccessor2.getWidth();
        int n3 = rasterAccessor2.getHeight();
        int n4 = rasterAccessor2.getNumBands();
        int n5 = rasterAccessor2.getScanlineStride();
        int n6 = rasterAccessor2.getPixelStride();
        int[] nArray = rasterAccessor2.getBandOffsets();
        short[][] sArray = rasterAccessor2.getShortDataArrays();
        int n7 = rasterAccessor.getScanlineStride();
        int n8 = rasterAccessor.getPixelStride();
        int[] nArray2 = rasterAccessor.getBandOffsets();
        short[][] sArray2 = rasterAccessor.getShortDataArrays();
        int n9 = 0;
        while (n9 < n4) {
            short[] sArray3 = sArray[n9];
            short[] sArray4 = sArray2[n9];
            int n10 = (int)this.low[n9];
            int n11 = (int)this.high[n9];
            short s2 = (short)n10;
            short s3 = (short)n11;
            int n12 = nArray[n9];
            int n13 = nArray2[n9];
            int n14 = 0;
            while (n14 < n3) {
                int n15 = n12;
                int n16 = n13;
                n12 += n5;
                n13 += n7;
                int n17 = 0;
                while (n17 < n2) {
                    int n18 = sArray4[n16] & 0xFFFF;
                    sArray3[n15] = n18 < n10 ? s2 : (n18 > n11 ? s3 : (short)n18);
                    n15 += n6;
                    n16 += n8;
                    ++n17;
                }
                ++n14;
            }
            ++n9;
        }
    }

    private void computeRectShort(RasterAccessor rasterAccessor, RasterAccessor rasterAccessor2) {
        int n2 = rasterAccessor2.getWidth();
        int n3 = rasterAccessor2.getHeight();
        int n4 = rasterAccessor2.getNumBands();
        int n5 = rasterAccessor2.getScanlineStride();
        int n6 = rasterAccessor2.getPixelStride();
        int[] nArray = rasterAccessor2.getBandOffsets();
        short[][] sArray = rasterAccessor2.getShortDataArrays();
        int n7 = rasterAccessor.getScanlineStride();
        int n8 = rasterAccessor.getPixelStride();
        int[] nArray2 = rasterAccessor.getBandOffsets();
        short[][] sArray2 = rasterAccessor.getShortDataArrays();
        int n9 = 0;
        while (n9 < n4) {
            short[] sArray3 = sArray[n9];
            short[] sArray4 = sArray2[n9];
            int n10 = (int)this.low[n9];
            int n11 = (int)this.high[n9];
            short s2 = (short)n10;
            short s3 = (short)n11;
            int n12 = nArray[n9];
            int n13 = nArray2[n9];
            int n14 = 0;
            while (n14 < n3) {
                int n15 = n12;
                int n16 = n13;
                n12 += n5;
                n13 += n7;
                int n17 = 0;
                while (n17 < n2) {
                    short s4 = sArray4[n16];
                    sArray3[n15] = s4 < n10 ? s2 : (s4 > n11 ? s3 : s4);
                    n15 += n6;
                    n16 += n8;
                    ++n17;
                }
                ++n14;
            }
            ++n9;
        }
    }

    private void computeRectInt(RasterAccessor rasterAccessor, RasterAccessor rasterAccessor2) {
        int n2 = rasterAccessor2.getWidth();
        int n3 = rasterAccessor2.getHeight();
        int n4 = rasterAccessor2.getNumBands();
        int n5 = rasterAccessor2.getScanlineStride();
        int n6 = rasterAccessor2.getPixelStride();
        int[] nArray = rasterAccessor2.getBandOffsets();
        int[][] nArray2 = rasterAccessor2.getIntDataArrays();
        int n7 = rasterAccessor.getScanlineStride();
        int n8 = rasterAccessor.getPixelStride();
        int[] nArray3 = rasterAccessor.getBandOffsets();
        int[][] nArray4 = rasterAccessor.getIntDataArrays();
        int n9 = 0;
        while (n9 < n4) {
            int[] nArray5 = nArray2[n9];
            int[] nArray6 = nArray4[n9];
            double d2 = this.low[n9];
            double d3 = this.high[n9];
            int n10 = (int)d2;
            int n11 = (int)d3;
            int n12 = nArray[n9];
            int n13 = nArray3[n9];
            int n14 = 0;
            while (n14 < n3) {
                int n15 = n12;
                int n16 = n13;
                n12 += n5;
                n13 += n7;
                int n17 = 0;
                while (n17 < n2) {
                    int n18 = nArray6[n16];
                    nArray5[n15] = (double)n18 < d2 ? n10 : ((double)n18 > d3 ? n11 : n18);
                    n15 += n6;
                    n16 += n8;
                    ++n17;
                }
                ++n14;
            }
            ++n9;
        }
    }

    private void computeRectFloat(RasterAccessor rasterAccessor, RasterAccessor rasterAccessor2) {
        int n2 = rasterAccessor2.getWidth();
        int n3 = rasterAccessor2.getHeight();
        int n4 = rasterAccessor2.getNumBands();
        int n5 = rasterAccessor2.getScanlineStride();
        int n6 = rasterAccessor2.getPixelStride();
        int[] nArray = rasterAccessor2.getBandOffsets();
        float[][] fArray = rasterAccessor2.getFloatDataArrays();
        int n7 = rasterAccessor.getScanlineStride();
        int n8 = rasterAccessor.getPixelStride();
        int[] nArray2 = rasterAccessor.getBandOffsets();
        float[][] fArray2 = rasterAccessor.getFloatDataArrays();
        int n9 = 0;
        while (n9 < n4) {
            float[] fArray3 = fArray[n9];
            float[] fArray4 = fArray2[n9];
            double d2 = this.low[n9];
            double d3 = this.high[n9];
            float f2 = (float)d2;
            float f3 = (float)d3;
            int n10 = nArray[n9];
            int n11 = nArray2[n9];
            int n12 = 0;
            while (n12 < n3) {
                int n13 = n10;
                int n14 = n11;
                n10 += n5;
                n11 += n7;
                int n15 = 0;
                while (n15 < n2) {
                    float f4 = fArray4[n14];
                    fArray3[n13] = (double)f4 < d2 ? f2 : ((double)f4 > d3 ? f3 : f4);
                    n13 += n6;
                    n14 += n8;
                    ++n15;
                }
                ++n12;
            }
            ++n9;
        }
    }

    private void computeRectDouble(RasterAccessor rasterAccessor, RasterAccessor rasterAccessor2) {
        int n2 = rasterAccessor2.getWidth();
        int n3 = rasterAccessor2.getHeight();
        int n4 = rasterAccessor2.getNumBands();
        int n5 = rasterAccessor2.getScanlineStride();
        int n6 = rasterAccessor2.getPixelStride();
        int[] nArray = rasterAccessor2.getBandOffsets();
        double[][] dArray = rasterAccessor2.getDoubleDataArrays();
        int n7 = rasterAccessor.getScanlineStride();
        int n8 = rasterAccessor.getPixelStride();
        int[] nArray2 = rasterAccessor.getBandOffsets();
        double[][] dArray2 = rasterAccessor.getDoubleDataArrays();
        int n9 = 0;
        while (n9 < n4) {
            double[] dArray3 = dArray[n9];
            double[] dArray4 = dArray2[n9];
            double d2 = this.low[n9];
            double d3 = this.high[n9];
            int n10 = nArray[n9];
            int n11 = nArray2[n9];
            int n12 = 0;
            while (n12 < n3) {
                int n13 = n10;
                int n14 = n11;
                n10 += n5;
                n11 += n7;
                int n15 = 0;
                while (n15 < n2) {
                    double d4 = dArray4[n14];
                    dArray3[n13] = d4 < d2 ? d2 : (d4 > d3 ? d3 : d4);
                    n13 += n6;
                    n14 += n8;
                    ++n15;
                }
                ++n12;
            }
            ++n9;
        }
    }
}

