/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jai.opimage;

import com.sun.media.jai.codec.ImageCodec;
import com.sun.media.jai.codec.ImageDecodeParam;
import com.sun.media.jai.codec.ImageDecoder;
import com.sun.media.jai.codec.SeekableStream;
import com.sun.media.jai.opimage.JaiI18N;
import com.sun.media.jai.opimage.RIFUtil;
import com.sun.media.jai.util.ImageUtil;
import java.awt.RenderingHints;
import java.awt.image.RenderedImage;
import java.awt.image.renderable.ParameterBlock;
import java.io.IOException;
import java.util.Map;
import javax.media.jai.ImageLayout;
import javax.media.jai.JAI;
import javax.media.jai.NullOpImage;
import javax.media.jai.OpImage;
import javax.media.jai.TileCache;
import javax.media.jai.util.ImagingException;
import javax.media.jai.util.ImagingListener;

public class CodecRIFUtil {
    static /* synthetic */ Class class$com$sun$media$jai$opimage$CodecRIFUtil;

    private CodecRIFUtil() {
    }

    public static RenderedImage create(String string, ParameterBlock parameterBlock, RenderingHints renderingHints) {
        ImagingListener imagingListener = ImageUtil.getImagingListener(renderingHints);
        SeekableStream seekableStream = (SeekableStream)parameterBlock.getObjectParameter(0);
        ImageDecodeParam imageDecodeParam = null;
        if (parameterBlock.getNumParameters() > 1) {
            imageDecodeParam = (ImageDecodeParam)parameterBlock.getObjectParameter(1);
        }
        int n2 = 0;
        if (parameterBlock.getNumParameters() > 2) {
            n2 = parameterBlock.getIntParameter(2);
        }
        ImageDecoder imageDecoder = ImageCodec.createImageDecoder(string, seekableStream, imageDecodeParam);
        try {
            RenderingHints.Key key;
            int n3 = 2;
            ImageLayout imageLayout = RIFUtil.getImageLayoutHint(renderingHints);
            if (renderingHints != null && renderingHints.containsKey(key = JAI.KEY_OPERATION_BOUND)) {
                n3 = (Integer)renderingHints.get(key);
            }
            boolean bl2 = seekableStream.canSeekBackwards();
            long l2 = Long.MIN_VALUE;
            if (bl2) {
                try {
                    l2 = seekableStream.getFilePointer();
                }
                catch (IOException iOException) {
                    imagingListener.errorOccurred(JaiI18N.getString("StreamRIF1"), iOException, class$com$sun$media$jai$opimage$CodecRIFUtil == null ? (class$com$sun$media$jai$opimage$CodecRIFUtil = CodecRIFUtil.class$("com.sun.media.jai.opimage.CodecRIFUtil")) : class$com$sun$media$jai$opimage$CodecRIFUtil, false);
                    bl2 = false;
                }
            }
            OpImage opImage = null;
            try {
                opImage = new NullOpImage(imageDecoder.decodeAsRenderedImage(n2), imageLayout, (Map)renderingHints, n3);
            }
            catch (OutOfMemoryError outOfMemoryError) {
                if (bl2) {
                    TileCache tileCache;
                    TileCache tileCache2 = tileCache = opImage != null ? opImage.getTileCache() : RIFUtil.getTileCacheHint(renderingHints);
                    if (tileCache != null) {
                        tileCache.flush();
                    }
                    System.gc();
                    seekableStream.seek(l2);
                    opImage = new NullOpImage(imageDecoder.decodeAsRenderedImage(n2), imageLayout, (Map)renderingHints, n3);
                }
                String string2 = JaiI18N.getString("CodecRIFUtil0");
                imagingListener.errorOccurred(string2, new ImagingException(string2, outOfMemoryError), class$com$sun$media$jai$opimage$CodecRIFUtil == null ? (class$com$sun$media$jai$opimage$CodecRIFUtil = CodecRIFUtil.class$("com.sun.media.jai.opimage.CodecRIFUtil")) : class$com$sun$media$jai$opimage$CodecRIFUtil, false);
            }
            return opImage;
        }
        catch (Exception exception) {
            imagingListener.errorOccurred(JaiI18N.getString("CodecRIFUtil1"), exception, class$com$sun$media$jai$opimage$CodecRIFUtil == null ? (class$com$sun$media$jai$opimage$CodecRIFUtil = CodecRIFUtil.class$("com.sun.media.jai.opimage.CodecRIFUtil")) : class$com$sun$media$jai$opimage$CodecRIFUtil, false);
            return null;
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

