/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jai.opimage;

import com.sun.media.jai.opimage.JaiI18N;
import com.sun.media.jai.util.ImageUtil;
import com.sun.media.jai.util.JDKWorkarounds;
import java.awt.Rectangle;
import java.awt.image.ColorModel;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import java.util.Map;
import javax.media.jai.ImageLayout;
import javax.media.jai.PointOpImage;
import javax.media.jai.RasterAccessor;
import javax.media.jai.RasterFactory;
import javax.media.jai.RasterFormatTag;

final class ComplexArithmeticOpImage
extends PointOpImage {
    protected boolean isDivision = false;
    private int[] s1r;
    private int[] s1i;
    private int[] s2r;
    private int[] s2i;

    private static ImageLayout layoutHelper(ImageLayout imageLayout, RenderedImage renderedImage) {
        SampleModel sampleModel;
        int n2;
        ImageLayout imageLayout2 = imageLayout == null ? new ImageLayout() : (ImageLayout)imageLayout.clone();
        if (imageLayout2.isValid(256) && (n2 = (sampleModel = imageLayout2.getSampleModel(null)).getNumBands()) % 2 != 0) {
            sampleModel = RasterFactory.createComponentSampleModel(sampleModel, sampleModel.getTransferType(), sampleModel.getWidth(), sampleModel.getHeight(), ++n2);
            imageLayout2.setSampleModel(sampleModel);
            ColorModel colorModel = imageLayout.getColorModel(null);
            if (colorModel != null && !JDKWorkarounds.areCompatibleDataModels(sampleModel, colorModel)) {
                imageLayout2.unsetValid(512);
            }
        }
        return imageLayout2;
    }

    public ComplexArithmeticOpImage(RenderedImage renderedImage, RenderedImage renderedImage2, Map map, ImageLayout imageLayout, boolean bl2) {
        super(renderedImage, renderedImage2, ComplexArithmeticOpImage.layoutHelper(imageLayout, renderedImage), map, true);
        this.isDivision = bl2;
        int n2 = renderedImage.getSampleModel().getNumBands();
        int n3 = renderedImage2.getSampleModel().getNumBands();
        int n4 = Math.min(n2, n3);
        int n5 = 0;
        if (imageLayout != null) {
            n5 = imageLayout.getSampleModel(null).getNumBands();
        }
        if (imageLayout != null && imageLayout.isValid(256) && (n2 == 2 && n3 > 2 || n3 == 2 && n2 > 2 || n2 >= n5 && n3 >= n5 && n5 > 0) && n5 % 2 == 0) {
            n4 = n5;
            n4 = Math.min(Math.max(n2, n3), n4);
        }
        if (n4 != this.sampleModel.getNumBands()) {
            this.sampleModel = RasterFactory.createComponentSampleModel(this.sampleModel, this.sampleModel.getTransferType(), this.sampleModel.getWidth(), this.sampleModel.getHeight(), n4);
            if (this.colorModel != null && !JDKWorkarounds.areCompatibleDataModels(this.sampleModel, this.colorModel)) {
                this.colorModel = ImageUtil.getCompatibleColorModel(this.sampleModel, map);
            }
        }
        int n6 = this.sampleModel.getNumBands() / 2;
        this.s1r = new int[n6];
        this.s1i = new int[n6];
        this.s2r = new int[n6];
        this.s2i = new int[n6];
        int n7 = n2 > 2 ? 2 : 0;
        int n8 = n3 > 2 ? 2 : 0;
        int n9 = 0;
        int n10 = 0;
        int n11 = 0;
        while (n11 < n6) {
            this.s1r[n11] = n9;
            this.s1i[n11] = n9 + 1;
            this.s2r[n11] = n10;
            this.s2i[n11] = n10 + 1;
            n9 += n7;
            n10 += n8;
            ++n11;
        }
        this.permitInPlaceOperation();
    }

    protected void computeRect(Raster[] rasterArray, WritableRaster writableRaster, Rectangle rectangle) {
        RasterFormatTag[] rasterFormatTagArray = this.getFormatTags();
        RasterAccessor rasterAccessor = new RasterAccessor(rasterArray[0], rectangle, rasterFormatTagArray[0], this.getSourceImage(0).getColorModel());
        RasterAccessor rasterAccessor2 = new RasterAccessor(rasterArray[1], rectangle, rasterFormatTagArray[1], this.getSourceImage(1).getColorModel());
        RasterAccessor rasterAccessor3 = new RasterAccessor(writableRaster, rectangle, rasterFormatTagArray[2], this.getColorModel());
        switch (rasterAccessor3.getDataType()) {
            case 0: {
                this.computeRectByte(rasterAccessor, rasterAccessor2, rasterAccessor3);
                break;
            }
            case 2: {
                this.computeRectShort(rasterAccessor, rasterAccessor2, rasterAccessor3);
                break;
            }
            case 1: {
                this.computeRectUShort(rasterAccessor, rasterAccessor2, rasterAccessor3);
                break;
            }
            case 3: {
                this.computeRectInt(rasterAccessor, rasterAccessor2, rasterAccessor3);
                break;
            }
            case 4: {
                this.computeRectFloat(rasterAccessor, rasterAccessor2, rasterAccessor3);
                break;
            }
            case 5: {
                this.computeRectDouble(rasterAccessor, rasterAccessor2, rasterAccessor3);
                break;
            }
            default: {
                throw new RuntimeException(JaiI18N.getString("ComplexArithmeticOpImage0"));
            }
        }
        if (rasterAccessor3.needsClamping()) {
            rasterAccessor3.clampDataArrays();
        }
        rasterAccessor3.copyDataToRaster();
    }

    private void computeRectDouble(RasterAccessor rasterAccessor, RasterAccessor rasterAccessor2, RasterAccessor rasterAccessor3) {
        int n2 = rasterAccessor3.getHeight();
        int n3 = rasterAccessor3.getWidth();
        int n4 = rasterAccessor.getPixelStride();
        int n5 = rasterAccessor.getScanlineStride();
        int n6 = rasterAccessor2.getPixelStride();
        int n7 = rasterAccessor2.getScanlineStride();
        int n8 = rasterAccessor3.getPixelStride();
        int n9 = rasterAccessor3.getScanlineStride();
        int n10 = this.sampleModel.getNumBands() / 2;
        int n11 = 0;
        while (n11 < n10) {
            int n12 = 2 * n11;
            int n13 = n12 + 1;
            double[] dArray = rasterAccessor.getDoubleDataArray(this.s1r[n11]);
            double[] dArray2 = rasterAccessor.getDoubleDataArray(this.s1i[n11]);
            double[] dArray3 = rasterAccessor2.getDoubleDataArray(this.s2r[n11]);
            double[] dArray4 = rasterAccessor2.getDoubleDataArray(this.s2i[n11]);
            double[] dArray5 = rasterAccessor3.getDoubleDataArray(n12);
            double[] dArray6 = rasterAccessor3.getDoubleDataArray(n13);
            int n14 = rasterAccessor.getBandOffset(this.s1r[n11]);
            int n15 = rasterAccessor.getBandOffset(this.s1i[n11]);
            int n16 = rasterAccessor2.getBandOffset(this.s2r[n11]);
            int n17 = rasterAccessor2.getBandOffset(this.s2i[n11]);
            int n18 = rasterAccessor3.getBandOffset(n12);
            int n19 = rasterAccessor3.getBandOffset(n13);
            int n20 = n14;
            int n21 = n15;
            int n22 = n16;
            int n23 = n17;
            int n24 = n18;
            int n25 = n19;
            int n26 = 0;
            while (n26 < n2) {
                double d2;
                double d3;
                double d4;
                double d5;
                int n27;
                int n28 = n20;
                int n29 = n21;
                int n30 = n22;
                int n31 = n23;
                int n32 = n24;
                int n33 = n25;
                if (this.isDivision) {
                    n27 = 0;
                    while (n27 < n3) {
                        d5 = dArray[n28];
                        d4 = dArray2[n29];
                        d3 = dArray3[n30];
                        d2 = dArray4[n31];
                        double d6 = d3 * d3 + d2 * d2;
                        dArray5[n32] = (d5 * d3 + d4 * d2) / d6;
                        dArray6[n33] = (d4 * d3 - d5 * d2) / d6;
                        n28 += n4;
                        n29 += n4;
                        n30 += n6;
                        n31 += n6;
                        n32 += n8;
                        n33 += n8;
                        ++n27;
                    }
                } else {
                    n27 = 0;
                    while (n27 < n3) {
                        d5 = dArray[n28];
                        d4 = dArray2[n29];
                        d3 = dArray3[n30];
                        d2 = dArray4[n31];
                        dArray5[n32] = d5 * d3 - d4 * d2;
                        dArray6[n33] = d5 * d2 + d4 * d3;
                        n28 += n4;
                        n29 += n4;
                        n30 += n6;
                        n31 += n6;
                        n32 += n8;
                        n33 += n8;
                        ++n27;
                    }
                }
                n20 += n5;
                n21 += n5;
                n22 += n7;
                n23 += n7;
                n24 += n9;
                n25 += n9;
                ++n26;
            }
            ++n11;
        }
    }

    private void computeRectFloat(RasterAccessor rasterAccessor, RasterAccessor rasterAccessor2, RasterAccessor rasterAccessor3) {
        int n2 = rasterAccessor3.getHeight();
        int n3 = rasterAccessor3.getWidth();
        int n4 = rasterAccessor.getPixelStride();
        int n5 = rasterAccessor.getScanlineStride();
        int n6 = rasterAccessor2.getPixelStride();
        int n7 = rasterAccessor2.getScanlineStride();
        int n8 = rasterAccessor3.getPixelStride();
        int n9 = rasterAccessor3.getScanlineStride();
        int n10 = this.sampleModel.getNumBands() / 2;
        int n11 = 0;
        while (n11 < n10) {
            int n12 = 2 * n11;
            int n13 = n12 + 1;
            float[] fArray = rasterAccessor.getFloatDataArray(this.s1r[n11]);
            float[] fArray2 = rasterAccessor.getFloatDataArray(this.s1i[n11]);
            float[] fArray3 = rasterAccessor2.getFloatDataArray(this.s2r[n11]);
            float[] fArray4 = rasterAccessor2.getFloatDataArray(this.s2i[n11]);
            float[] fArray5 = rasterAccessor3.getFloatDataArray(n12);
            float[] fArray6 = rasterAccessor3.getFloatDataArray(n13);
            int n14 = rasterAccessor.getBandOffset(this.s1r[n11]);
            int n15 = rasterAccessor.getBandOffset(this.s1i[n11]);
            int n16 = rasterAccessor2.getBandOffset(this.s2r[n11]);
            int n17 = rasterAccessor2.getBandOffset(this.s2i[n11]);
            int n18 = rasterAccessor3.getBandOffset(n12);
            int n19 = rasterAccessor3.getBandOffset(n13);
            int n20 = n14;
            int n21 = n15;
            int n22 = n16;
            int n23 = n17;
            int n24 = n18;
            int n25 = n19;
            int n26 = 0;
            while (n26 < n2) {
                float f2;
                float f3;
                float f4;
                float f5;
                int n27;
                int n28 = n20;
                int n29 = n21;
                int n30 = n22;
                int n31 = n23;
                int n32 = n24;
                int n33 = n25;
                if (this.isDivision) {
                    n27 = 0;
                    while (n27 < n3) {
                        f5 = fArray[n28];
                        f4 = fArray2[n29];
                        f3 = fArray3[n30];
                        f2 = fArray4[n31];
                        float f6 = f3 * f3 + f2 * f2;
                        fArray5[n32] = (f5 * f3 + f4 * f2) / f6;
                        fArray6[n33] = (f4 * f3 - f5 * f2) / f6;
                        n28 += n4;
                        n29 += n4;
                        n30 += n6;
                        n31 += n6;
                        n32 += n8;
                        n33 += n8;
                        ++n27;
                    }
                } else {
                    n27 = 0;
                    while (n27 < n3) {
                        f5 = fArray[n28];
                        f4 = fArray2[n29];
                        f3 = fArray3[n30];
                        f2 = fArray4[n31];
                        fArray5[n32] = f5 * f3 - f4 * f2;
                        fArray6[n33] = f5 * f2 + f4 * f3;
                        n28 += n4;
                        n29 += n4;
                        n30 += n6;
                        n31 += n6;
                        n32 += n8;
                        n33 += n8;
                        ++n27;
                    }
                }
                n20 += n5;
                n21 += n5;
                n22 += n7;
                n23 += n7;
                n24 += n9;
                n25 += n9;
                ++n26;
            }
            ++n11;
        }
    }

    private void computeRectInt(RasterAccessor rasterAccessor, RasterAccessor rasterAccessor2, RasterAccessor rasterAccessor3) {
        int n2 = rasterAccessor3.getHeight();
        int n3 = rasterAccessor3.getWidth();
        int n4 = rasterAccessor.getPixelStride();
        int n5 = rasterAccessor.getScanlineStride();
        int n6 = rasterAccessor2.getPixelStride();
        int n7 = rasterAccessor2.getScanlineStride();
        int n8 = rasterAccessor3.getPixelStride();
        int n9 = rasterAccessor3.getScanlineStride();
        int n10 = this.sampleModel.getNumBands() / 2;
        int n11 = 0;
        while (n11 < n10) {
            int n12 = 2 * n11;
            int n13 = n12 + 1;
            int[] nArray = rasterAccessor.getIntDataArray(this.s1r[n11]);
            int[] nArray2 = rasterAccessor.getIntDataArray(this.s1i[n11]);
            int[] nArray3 = rasterAccessor2.getIntDataArray(this.s2r[n11]);
            int[] nArray4 = rasterAccessor2.getIntDataArray(this.s2i[n11]);
            int[] nArray5 = rasterAccessor3.getIntDataArray(n12);
            int[] nArray6 = rasterAccessor3.getIntDataArray(n13);
            int n14 = rasterAccessor.getBandOffset(this.s1r[n11]);
            int n15 = rasterAccessor.getBandOffset(this.s1i[n11]);
            int n16 = rasterAccessor2.getBandOffset(this.s2r[n11]);
            int n17 = rasterAccessor2.getBandOffset(this.s2i[n11]);
            int n18 = rasterAccessor3.getBandOffset(n12);
            int n19 = rasterAccessor3.getBandOffset(n13);
            int n20 = n14;
            int n21 = n15;
            int n22 = n16;
            int n23 = n17;
            int n24 = n18;
            int n25 = n19;
            int n26 = 0;
            while (n26 < n2) {
                int n27;
                int n28 = n20;
                int n29 = n21;
                int n30 = n22;
                int n31 = n23;
                int n32 = n24;
                int n33 = n25;
                if (this.isDivision) {
                    n27 = 0;
                    while (n27 < n3) {
                        int n34 = nArray[n28];
                        int n35 = nArray2[n29];
                        int n36 = nArray3[n30];
                        int n37 = nArray4[n31];
                        float f2 = n36 * n36 + n37 * n37;
                        nArray5[n32] = ImageUtil.clampRoundInt((float)(n34 * n36 + n35 * n37) / f2);
                        nArray6[n33] = ImageUtil.clampRoundInt((float)(n35 * n36 - n34 * n37) / f2);
                        n28 += n4;
                        n29 += n4;
                        n30 += n6;
                        n31 += n6;
                        n32 += n8;
                        n33 += n8;
                        ++n27;
                    }
                } else {
                    n27 = 0;
                    while (n27 < n3) {
                        long l2 = nArray[n28];
                        long l3 = nArray2[n29];
                        long l4 = nArray3[n30];
                        long l5 = nArray4[n31];
                        nArray5[n32] = ImageUtil.clampInt(l2 * l4 - l3 * l5);
                        nArray6[n33] = ImageUtil.clampInt(l2 * l5 + l3 * l4);
                        n28 += n4;
                        n29 += n4;
                        n30 += n6;
                        n31 += n6;
                        n32 += n8;
                        n33 += n8;
                        ++n27;
                    }
                }
                n20 += n5;
                n21 += n5;
                n22 += n7;
                n23 += n7;
                n24 += n9;
                n25 += n9;
                ++n26;
            }
            ++n11;
        }
    }

    private void computeRectUShort(RasterAccessor rasterAccessor, RasterAccessor rasterAccessor2, RasterAccessor rasterAccessor3) {
        int n2 = rasterAccessor3.getHeight();
        int n3 = rasterAccessor3.getWidth();
        int n4 = rasterAccessor.getPixelStride();
        int n5 = rasterAccessor.getScanlineStride();
        int n6 = rasterAccessor2.getPixelStride();
        int n7 = rasterAccessor2.getScanlineStride();
        int n8 = rasterAccessor3.getPixelStride();
        int n9 = rasterAccessor3.getScanlineStride();
        int n10 = this.sampleModel.getNumBands() / 2;
        int n11 = 0;
        while (n11 < n10) {
            int n12 = 2 * n11;
            int n13 = n12 + 1;
            short[] sArray = rasterAccessor.getShortDataArray(this.s1r[n11]);
            short[] sArray2 = rasterAccessor.getShortDataArray(this.s1i[n11]);
            short[] sArray3 = rasterAccessor2.getShortDataArray(this.s2r[n11]);
            short[] sArray4 = rasterAccessor2.getShortDataArray(this.s2i[n11]);
            short[] sArray5 = rasterAccessor3.getShortDataArray(n12);
            short[] sArray6 = rasterAccessor3.getShortDataArray(n13);
            int n14 = rasterAccessor.getBandOffset(this.s1r[n11]);
            int n15 = rasterAccessor.getBandOffset(this.s1i[n11]);
            int n16 = rasterAccessor2.getBandOffset(this.s2r[n11]);
            int n17 = rasterAccessor2.getBandOffset(this.s2i[n11]);
            int n18 = rasterAccessor3.getBandOffset(n12);
            int n19 = rasterAccessor3.getBandOffset(n13);
            int n20 = n14;
            int n21 = n15;
            int n22 = n16;
            int n23 = n17;
            int n24 = n18;
            int n25 = n19;
            int n26 = 0;
            while (n26 < n2) {
                int n27;
                int n28;
                int n29;
                int n30;
                int n31;
                int n32 = n20;
                int n33 = n21;
                int n34 = n22;
                int n35 = n23;
                int n36 = n24;
                int n37 = n25;
                if (this.isDivision) {
                    n31 = 0;
                    while (n31 < n3) {
                        n30 = sArray[n32] & 0xFFFF;
                        n29 = sArray2[n33] & 0xFFFF;
                        n28 = sArray3[n34] & 0xFFFF;
                        n27 = sArray4[n35] & 0xFFFF;
                        int n38 = n28 * n28 + n27 * n27;
                        sArray5[n36] = ImageUtil.clampUShort((n30 * n28 + n29 * n27) / n38);
                        sArray6[n37] = ImageUtil.clampUShort((n29 * n28 - n30 * n27) / n38);
                        n32 += n4;
                        n33 += n4;
                        n34 += n6;
                        n35 += n6;
                        n36 += n8;
                        n37 += n8;
                        ++n31;
                    }
                } else {
                    n31 = 0;
                    while (n31 < n3) {
                        n30 = sArray[n32] & 0xFFFF;
                        n29 = sArray2[n33] & 0xFFFF;
                        n28 = sArray3[n34] & 0xFFFF;
                        n27 = sArray4[n35] & 0xFFFF;
                        sArray5[n36] = ImageUtil.clampUShort(n30 * n28 - n29 * n27);
                        sArray6[n37] = ImageUtil.clampUShort(n30 * n27 + n29 * n28);
                        n32 += n4;
                        n33 += n4;
                        n34 += n6;
                        n35 += n6;
                        n36 += n8;
                        n37 += n8;
                        ++n31;
                    }
                }
                n20 += n5;
                n21 += n5;
                n22 += n7;
                n23 += n7;
                n24 += n9;
                n25 += n9;
                ++n26;
            }
            ++n11;
        }
    }

    private void computeRectShort(RasterAccessor rasterAccessor, RasterAccessor rasterAccessor2, RasterAccessor rasterAccessor3) {
        int n2 = rasterAccessor3.getHeight();
        int n3 = rasterAccessor3.getWidth();
        int n4 = rasterAccessor.getPixelStride();
        int n5 = rasterAccessor.getScanlineStride();
        int n6 = rasterAccessor2.getPixelStride();
        int n7 = rasterAccessor2.getScanlineStride();
        int n8 = rasterAccessor3.getPixelStride();
        int n9 = rasterAccessor3.getScanlineStride();
        int n10 = this.sampleModel.getNumBands() / 2;
        int n11 = 0;
        while (n11 < n10) {
            int n12 = 2 * n11;
            int n13 = n12 + 1;
            short[] sArray = rasterAccessor.getShortDataArray(this.s1r[n11]);
            short[] sArray2 = rasterAccessor.getShortDataArray(this.s1i[n11]);
            short[] sArray3 = rasterAccessor2.getShortDataArray(this.s2r[n11]);
            short[] sArray4 = rasterAccessor2.getShortDataArray(this.s2i[n11]);
            short[] sArray5 = rasterAccessor3.getShortDataArray(n12);
            short[] sArray6 = rasterAccessor3.getShortDataArray(n13);
            int n14 = rasterAccessor.getBandOffset(this.s1r[n11]);
            int n15 = rasterAccessor.getBandOffset(this.s1i[n11]);
            int n16 = rasterAccessor2.getBandOffset(this.s2r[n11]);
            int n17 = rasterAccessor2.getBandOffset(this.s2i[n11]);
            int n18 = rasterAccessor3.getBandOffset(n12);
            int n19 = rasterAccessor3.getBandOffset(n13);
            int n20 = n14;
            int n21 = n15;
            int n22 = n16;
            int n23 = n17;
            int n24 = n18;
            int n25 = n19;
            int n26 = 0;
            while (n26 < n2) {
                short s2;
                short s3;
                short s4;
                short s5;
                int n27;
                int n28 = n20;
                int n29 = n21;
                int n30 = n22;
                int n31 = n23;
                int n32 = n24;
                int n33 = n25;
                if (this.isDivision) {
                    n27 = 0;
                    while (n27 < n3) {
                        s5 = sArray[n28];
                        s4 = sArray2[n29];
                        s3 = sArray3[n30];
                        s2 = sArray4[n31];
                        int n34 = s3 * s3 + s2 * s2;
                        sArray5[n32] = ImageUtil.clampShort((s5 * s3 + s4 * s2) / n34);
                        sArray6[n33] = ImageUtil.clampShort((s4 * s3 - s5 * s2) / n34);
                        n28 += n4;
                        n29 += n4;
                        n30 += n6;
                        n31 += n6;
                        n32 += n8;
                        n33 += n8;
                        ++n27;
                    }
                } else {
                    n27 = 0;
                    while (n27 < n3) {
                        s5 = sArray[n28];
                        s4 = sArray2[n29];
                        s3 = sArray3[n30];
                        s2 = sArray4[n31];
                        sArray5[n32] = ImageUtil.clampShort(s5 * s3 - s4 * s2);
                        sArray6[n33] = ImageUtil.clampShort(s5 * s2 + s4 * s3);
                        n28 += n4;
                        n29 += n4;
                        n30 += n6;
                        n31 += n6;
                        n32 += n8;
                        n33 += n8;
                        ++n27;
                    }
                }
                n20 += n5;
                n21 += n5;
                n22 += n7;
                n23 += n7;
                n24 += n9;
                n25 += n9;
                ++n26;
            }
            ++n11;
        }
    }

    private void computeRectByte(RasterAccessor rasterAccessor, RasterAccessor rasterAccessor2, RasterAccessor rasterAccessor3) {
        int n2 = rasterAccessor3.getHeight();
        int n3 = rasterAccessor3.getWidth();
        int n4 = rasterAccessor.getPixelStride();
        int n5 = rasterAccessor.getScanlineStride();
        int n6 = rasterAccessor2.getPixelStride();
        int n7 = rasterAccessor2.getScanlineStride();
        int n8 = rasterAccessor3.getPixelStride();
        int n9 = rasterAccessor3.getScanlineStride();
        int n10 = this.sampleModel.getNumBands() / 2;
        int n11 = 0;
        while (n11 < n10) {
            int n12 = 2 * n11;
            int n13 = n12 + 1;
            byte[] byArray = rasterAccessor.getByteDataArray(this.s1r[n11]);
            byte[] byArray2 = rasterAccessor.getByteDataArray(this.s1i[n11]);
            byte[] byArray3 = rasterAccessor2.getByteDataArray(this.s2r[n11]);
            byte[] byArray4 = rasterAccessor2.getByteDataArray(this.s2i[n11]);
            byte[] byArray5 = rasterAccessor3.getByteDataArray(n12);
            byte[] byArray6 = rasterAccessor3.getByteDataArray(n13);
            int n14 = rasterAccessor.getBandOffset(this.s1r[n11]);
            int n15 = rasterAccessor.getBandOffset(this.s1i[n11]);
            int n16 = rasterAccessor2.getBandOffset(this.s2r[n11]);
            int n17 = rasterAccessor2.getBandOffset(this.s2i[n11]);
            int n18 = rasterAccessor3.getBandOffset(n12);
            int n19 = rasterAccessor3.getBandOffset(n13);
            int n20 = n14;
            int n21 = n15;
            int n22 = n16;
            int n23 = n17;
            int n24 = n18;
            int n25 = n19;
            int n26 = 0;
            while (n26 < n2) {
                int n27;
                int n28;
                int n29;
                int n30;
                int n31;
                int n32 = n20;
                int n33 = n21;
                int n34 = n22;
                int n35 = n23;
                int n36 = n24;
                int n37 = n25;
                if (this.isDivision) {
                    n31 = 0;
                    while (n31 < n3) {
                        n30 = byArray[n32] & 0xFF;
                        n29 = byArray2[n33] & 0xFF;
                        n28 = byArray3[n34] & 0xFF;
                        n27 = byArray4[n35] & 0xFF;
                        int n38 = n28 * n28 + n27 * n27;
                        byArray5[n36] = ImageUtil.clampByte((n30 * n28 + n29 * n27) / n38);
                        byArray6[n37] = ImageUtil.clampByte((n29 * n28 - n30 * n27) / n38);
                        n32 += n4;
                        n33 += n4;
                        n34 += n6;
                        n35 += n6;
                        n36 += n8;
                        n37 += n8;
                        ++n31;
                    }
                } else {
                    n31 = 0;
                    while (n31 < n3) {
                        n30 = byArray[n32] & 0xFF;
                        n29 = byArray2[n33] & 0xFF;
                        n28 = byArray3[n34] & 0xFF;
                        n27 = byArray4[n35] & 0xFF;
                        byArray5[n36] = ImageUtil.clampByte(n30 * n28 - n29 * n27);
                        byArray6[n37] = ImageUtil.clampByte(n30 * n27 + n29 * n28);
                        n32 += n4;
                        n33 += n4;
                        n34 += n6;
                        n35 += n6;
                        n36 += n8;
                        n37 += n8;
                        ++n31;
                    }
                }
                n20 += n5;
                n21 += n5;
                n22 += n7;
                n23 += n7;
                n24 += n9;
                n25 += n9;
                ++n26;
            }
            ++n11;
        }
    }
}

