/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jai.opimage;

import java.awt.Rectangle;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.util.Map;
import javax.media.jai.ImageLayout;
import javax.media.jai.PointOpImage;
import javax.media.jai.RasterAccessor;
import javax.media.jai.RasterFormatTag;

final class CompositeNoDestAlphaOpImage
extends PointOpImage {
    private RenderedImage alpha1;
    private RenderedImage alpha2;
    private boolean premultiplied;
    private RasterFormatTag[] tags;

    public CompositeNoDestAlphaOpImage(RenderedImage renderedImage, RenderedImage renderedImage2, Map map, ImageLayout imageLayout, RenderedImage renderedImage3, RenderedImage renderedImage4, boolean bl2) {
        super(renderedImage, renderedImage2, imageLayout, map, true);
        this.alpha1 = renderedImage3;
        this.alpha2 = renderedImage4;
        this.premultiplied = bl2;
        this.tags = this.getFormatTags();
    }

    protected void computeRect(Raster[] rasterArray, WritableRaster writableRaster, Rectangle rectangle) {
        RasterAccessor rasterAccessor;
        RasterAccessor rasterAccessor2 = new RasterAccessor(rasterArray[0], rectangle, this.tags[0], this.getSourceImage(0).getColorModel());
        RasterAccessor rasterAccessor3 = new RasterAccessor(rasterArray[1], rectangle, this.tags[1], this.getSourceImage(1).getColorModel());
        RasterAccessor rasterAccessor4 = new RasterAccessor(this.alpha1.getData(rectangle), rectangle, this.tags[2], this.alpha1.getColorModel());
        RasterAccessor rasterAccessor5 = null;
        if (this.alpha2 == null) {
            rasterAccessor = new RasterAccessor(writableRaster, rectangle, this.tags[3], this.getColorModel());
        } else {
            rasterAccessor5 = new RasterAccessor(this.alpha2.getData(rectangle), rectangle, this.tags[3], this.alpha2.getColorModel());
            rasterAccessor = new RasterAccessor(writableRaster, rectangle, this.tags[4], this.getColorModel());
        }
        switch (rasterAccessor.getDataType()) {
            case 0: {
                this.byteLoop(rasterAccessor2, rasterAccessor3, rasterAccessor4, rasterAccessor5, rasterAccessor);
                break;
            }
            case 1: {
                this.ushortLoop(rasterAccessor2, rasterAccessor3, rasterAccessor4, rasterAccessor5, rasterAccessor);
                break;
            }
            case 2: {
                this.shortLoop(rasterAccessor2, rasterAccessor3, rasterAccessor4, rasterAccessor5, rasterAccessor);
                break;
            }
            case 3: {
                this.intLoop(rasterAccessor2, rasterAccessor3, rasterAccessor4, rasterAccessor5, rasterAccessor);
                break;
            }
            case 4: {
                this.floatLoop(rasterAccessor2, rasterAccessor3, rasterAccessor4, rasterAccessor5, rasterAccessor);
                break;
            }
            case 5: {
                this.doubleLoop(rasterAccessor2, rasterAccessor3, rasterAccessor4, rasterAccessor5, rasterAccessor);
            }
        }
        if (rasterAccessor.isDataCopy()) {
            rasterAccessor.clampDataArrays();
            rasterAccessor.copyDataToRaster();
        }
    }

    private void byteLoop(RasterAccessor rasterAccessor, RasterAccessor rasterAccessor2, RasterAccessor rasterAccessor3, RasterAccessor rasterAccessor4, RasterAccessor rasterAccessor5) {
        int n2 = rasterAccessor.getScanlineStride();
        int n3 = rasterAccessor.getPixelStride();
        int[] nArray = rasterAccessor.getBandOffsets();
        byte[][] byArray = rasterAccessor.getByteDataArrays();
        int n4 = rasterAccessor2.getScanlineStride();
        int n5 = rasterAccessor2.getPixelStride();
        int[] nArray2 = rasterAccessor2.getBandOffsets();
        byte[][] byArray2 = rasterAccessor2.getByteDataArrays();
        int n6 = rasterAccessor3.getScanlineStride();
        int n7 = rasterAccessor3.getPixelStride();
        int n8 = rasterAccessor3.getBandOffset(0);
        byte[] byArray3 = rasterAccessor3.getByteDataArray(0);
        int n9 = 0;
        int n10 = 0;
        int n11 = 0;
        byte[] byArray4 = null;
        if (this.alpha2 != null) {
            n9 = rasterAccessor4.getScanlineStride();
            n10 = rasterAccessor4.getPixelStride();
            n11 = rasterAccessor4.getBandOffset(0);
            byArray4 = rasterAccessor4.getByteDataArray(0);
        }
        int n12 = rasterAccessor5.getScanlineStride();
        int n13 = rasterAccessor5.getPixelStride();
        int[] nArray3 = rasterAccessor5.getBandOffsets();
        byte[][] byArray5 = rasterAccessor5.getByteDataArrays();
        int n14 = rasterAccessor5.getWidth();
        int n15 = rasterAccessor5.getHeight();
        int n16 = rasterAccessor5.getNumBands();
        float f2 = 0.003921569f;
        int n17 = 0;
        int n18 = 0;
        int n19 = 0;
        int n20 = 0;
        int n21 = 0;
        if (this.premultiplied) {
            int n22 = 0;
            while (n22 < n15) {
                int n23 = n17;
                int n24 = n18;
                int n25 = n19 + n8;
                int n26 = n21;
                n17 += n2;
                n18 += n4;
                n19 += n6;
                n21 += n12;
                int n27 = 0;
                while (n27 < n14) {
                    float f3 = 1.0f - (float)(byArray3[n25] & 0xFF) * f2;
                    int n28 = 0;
                    while (n28 < n16) {
                        byArray5[n28][n26 + nArray3[n28]] = (byte)((float)(byArray[n28][n23 + nArray[n28]] & 0xFF) + (float)(byArray2[n28][n24 + nArray2[n28]] & 0xFF) * f3);
                        ++n28;
                    }
                    n23 += n3;
                    n24 += n5;
                    n25 += n7;
                    n26 += n13;
                    ++n27;
                }
                ++n22;
            }
        } else if (this.alpha2 == null) {
            int n29 = 0;
            while (n29 < n15) {
                int n30 = n17;
                int n31 = n18;
                int n32 = n19 + n8;
                int n33 = n21;
                n17 += n2;
                n18 += n4;
                n19 += n6;
                n21 += n12;
                int n34 = 0;
                while (n34 < n14) {
                    float f4 = (float)(byArray3[n32] & 0xFF) * f2;
                    float f5 = 1.0f - f4;
                    int n35 = 0;
                    while (n35 < n16) {
                        byArray5[n35][n33 + nArray3[n35]] = (byte)((float)(byArray[n35][n30 + nArray[n35]] & 0xFF) * f4 + (float)(byArray2[n35][n31 + nArray2[n35]] & 0xFF) * f5);
                        ++n35;
                    }
                    n30 += n3;
                    n31 += n5;
                    n32 += n7;
                    n33 += n13;
                    ++n34;
                }
                ++n29;
            }
        } else {
            int n36 = 0;
            while (n36 < n15) {
                int n37 = n17;
                int n38 = n18;
                int n39 = n19 + n8;
                int n40 = n20 + n11;
                int n41 = n21;
                n17 += n2;
                n18 += n4;
                n19 += n6;
                n20 += n9;
                n21 += n12;
                int n42 = 0;
                while (n42 < n14) {
                    float f6;
                    float f7;
                    int n43 = byArray3[n39] & 0xFF;
                    float f8 = (float)(byArray4[n40] & 0xFF) * (1.0f - (float)n43 * f2);
                    float f9 = (float)n43 + f8;
                    if (f9 == 0.0f) {
                        f7 = 0.0f;
                        f6 = 0.0f;
                    } else {
                        f7 = (float)n43 / f9;
                        f6 = f8 / f9;
                    }
                    int n44 = 0;
                    while (n44 < n16) {
                        byArray5[n44][n41 + nArray3[n44]] = (byte)((float)(byArray[n44][n37 + nArray[n44]] & 0xFF) * f7 + (float)(byArray2[n44][n38 + nArray2[n44]] & 0xFF) * f6);
                        ++n44;
                    }
                    n37 += n3;
                    n38 += n5;
                    n39 += n7;
                    n40 += n10;
                    n41 += n13;
                    ++n42;
                }
                ++n36;
            }
        }
    }

    private void ushortLoop(RasterAccessor rasterAccessor, RasterAccessor rasterAccessor2, RasterAccessor rasterAccessor3, RasterAccessor rasterAccessor4, RasterAccessor rasterAccessor5) {
        int n2 = rasterAccessor.getScanlineStride();
        int n3 = rasterAccessor.getPixelStride();
        int[] nArray = rasterAccessor.getBandOffsets();
        short[][] sArray = rasterAccessor.getShortDataArrays();
        int n4 = rasterAccessor2.getScanlineStride();
        int n5 = rasterAccessor2.getPixelStride();
        int[] nArray2 = rasterAccessor2.getBandOffsets();
        short[][] sArray2 = rasterAccessor2.getShortDataArrays();
        int n6 = rasterAccessor3.getScanlineStride();
        int n7 = rasterAccessor3.getPixelStride();
        int n8 = rasterAccessor3.getBandOffset(0);
        short[] sArray3 = rasterAccessor3.getShortDataArray(0);
        int n9 = 0;
        int n10 = 0;
        int n11 = 0;
        short[] sArray4 = null;
        if (this.alpha2 != null) {
            n9 = rasterAccessor4.getScanlineStride();
            n10 = rasterAccessor4.getPixelStride();
            n11 = rasterAccessor4.getBandOffset(0);
            sArray4 = rasterAccessor4.getShortDataArray(0);
        }
        int n12 = rasterAccessor5.getScanlineStride();
        int n13 = rasterAccessor5.getPixelStride();
        int[] nArray3 = rasterAccessor5.getBandOffsets();
        short[][] sArray5 = rasterAccessor5.getShortDataArrays();
        int n14 = rasterAccessor5.getWidth();
        int n15 = rasterAccessor5.getHeight();
        int n16 = rasterAccessor5.getNumBands();
        float f2 = 1.5259022E-5f;
        int n17 = 0;
        int n18 = 0;
        int n19 = 0;
        int n20 = 0;
        int n21 = 0;
        if (this.premultiplied) {
            int n22 = 0;
            while (n22 < n15) {
                int n23 = n17;
                int n24 = n18;
                int n25 = n19 + n8;
                int n26 = n21;
                n17 += n2;
                n18 += n4;
                n19 += n6;
                n21 += n12;
                int n27 = 0;
                while (n27 < n14) {
                    float f3 = 1.0f - (float)(sArray3[n25] & 0xFFFF) * f2;
                    int n28 = 0;
                    while (n28 < n16) {
                        sArray5[n28][n26 + nArray3[n28]] = (short)((float)(sArray[n28][n23 + nArray[n28]] & 0xFFFF) + (float)(sArray2[n28][n24 + nArray2[n28]] & 0xFFFF) * f3);
                        ++n28;
                    }
                    n23 += n3;
                    n24 += n5;
                    n25 += n7;
                    n26 += n13;
                    ++n27;
                }
                ++n22;
            }
        } else if (this.alpha2 == null) {
            int n29 = 0;
            while (n29 < n15) {
                int n30 = n17;
                int n31 = n18;
                int n32 = n19 + n8;
                int n33 = n21;
                n17 += n2;
                n18 += n4;
                n19 += n6;
                n21 += n12;
                int n34 = 0;
                while (n34 < n14) {
                    float f4 = (float)(sArray3[n32] & 0xFFFF) * f2;
                    float f5 = 1.0f - f4;
                    int n35 = 0;
                    while (n35 < n16) {
                        sArray5[n35][n33 + nArray3[n35]] = (short)((float)(sArray[n35][n30 + nArray[n35]] & 0xFFFF) * f4 + (float)(sArray2[n35][n31 + nArray2[n35]] & 0xFFFF) * f5);
                        ++n35;
                    }
                    n30 += n3;
                    n31 += n5;
                    n32 += n7;
                    n33 += n13;
                    ++n34;
                }
                ++n29;
            }
        } else {
            int n36 = 0;
            while (n36 < n15) {
                int n37 = n17;
                int n38 = n18;
                int n39 = n19 + n8;
                int n40 = n20 + n11;
                int n41 = n21;
                n17 += n2;
                n18 += n4;
                n19 += n6;
                n20 += n9;
                n21 += n12;
                int n42 = 0;
                while (n42 < n14) {
                    float f6;
                    float f7;
                    int n43 = sArray3[n39] & 0xFFFF;
                    float f8 = (float)(sArray4[n40] & 0xFFFF) * (1.0f - (float)n43 * f2);
                    float f9 = (float)n43 + f8;
                    if (f9 == 0.0f) {
                        f7 = 0.0f;
                        f6 = 0.0f;
                    } else {
                        f7 = (float)n43 / f9;
                        f6 = f8 / f9;
                    }
                    int n44 = 0;
                    while (n44 < n16) {
                        sArray5[n44][n41 + nArray3[n44]] = (short)((float)(sArray[n44][n37 + nArray[n44]] & 0xFFFF) * f7 + (float)(sArray2[n44][n38 + nArray2[n44]] & 0xFFFF) * f6);
                        ++n44;
                    }
                    n37 += n3;
                    n38 += n5;
                    n39 += n7;
                    n40 += n10;
                    n41 += n13;
                    ++n42;
                }
                ++n36;
            }
        }
    }

    private void shortLoop(RasterAccessor rasterAccessor, RasterAccessor rasterAccessor2, RasterAccessor rasterAccessor3, RasterAccessor rasterAccessor4, RasterAccessor rasterAccessor5) {
        int n2 = rasterAccessor.getScanlineStride();
        int n3 = rasterAccessor.getPixelStride();
        int[] nArray = rasterAccessor.getBandOffsets();
        short[][] sArray = rasterAccessor.getShortDataArrays();
        int n4 = rasterAccessor2.getScanlineStride();
        int n5 = rasterAccessor2.getPixelStride();
        int[] nArray2 = rasterAccessor2.getBandOffsets();
        short[][] sArray2 = rasterAccessor2.getShortDataArrays();
        int n6 = rasterAccessor3.getScanlineStride();
        int n7 = rasterAccessor3.getPixelStride();
        int n8 = rasterAccessor3.getBandOffset(0);
        short[] sArray3 = rasterAccessor3.getShortDataArray(0);
        int n9 = 0;
        int n10 = 0;
        int n11 = 0;
        short[] sArray4 = null;
        if (this.alpha2 != null) {
            n9 = rasterAccessor4.getScanlineStride();
            n10 = rasterAccessor4.getPixelStride();
            n11 = rasterAccessor4.getBandOffset(0);
            sArray4 = rasterAccessor4.getShortDataArray(0);
        }
        int n12 = rasterAccessor5.getScanlineStride();
        int n13 = rasterAccessor5.getPixelStride();
        int[] nArray3 = rasterAccessor5.getBandOffsets();
        short[][] sArray5 = rasterAccessor5.getShortDataArrays();
        int n14 = rasterAccessor5.getWidth();
        int n15 = rasterAccessor5.getHeight();
        int n16 = rasterAccessor5.getNumBands();
        float f2 = 3.051851E-5f;
        int n17 = 0;
        int n18 = 0;
        int n19 = 0;
        int n20 = 0;
        int n21 = 0;
        if (this.premultiplied) {
            int n22 = 0;
            while (n22 < n15) {
                int n23 = n17;
                int n24 = n18;
                int n25 = n19 + n8;
                int n26 = n21;
                n17 += n2;
                n18 += n4;
                n19 += n6;
                n21 += n12;
                int n27 = 0;
                while (n27 < n14) {
                    float f3 = 1.0f - (float)sArray3[n25] * f2;
                    int n28 = 0;
                    while (n28 < n16) {
                        sArray5[n28][n26 + nArray3[n28]] = (short)((float)sArray[n28][n23 + nArray[n28]] + (float)sArray2[n28][n24 + nArray2[n28]] * f3);
                        ++n28;
                    }
                    n23 += n3;
                    n24 += n5;
                    n25 += n7;
                    n26 += n13;
                    ++n27;
                }
                ++n22;
            }
        } else if (this.alpha2 == null) {
            int n29 = 0;
            while (n29 < n15) {
                int n30 = n17;
                int n31 = n18;
                int n32 = n19 + n8;
                int n33 = n21;
                n17 += n2;
                n18 += n4;
                n19 += n6;
                n21 += n12;
                int n34 = 0;
                while (n34 < n14) {
                    float f4 = (float)sArray3[n32] * f2;
                    float f5 = 1.0f - f4;
                    int n35 = 0;
                    while (n35 < n16) {
                        sArray5[n35][n33 + nArray3[n35]] = (short)((float)sArray[n35][n30 + nArray[n35]] * f4 + (float)sArray2[n35][n31 + nArray2[n35]] * f5);
                        ++n35;
                    }
                    n30 += n3;
                    n31 += n5;
                    n32 += n7;
                    n33 += n13;
                    ++n34;
                }
                ++n29;
            }
        } else {
            int n36 = 0;
            while (n36 < n15) {
                int n37 = n17;
                int n38 = n18;
                int n39 = n19 + n8;
                int n40 = n20 + n11;
                int n41 = n21;
                n17 += n2;
                n18 += n4;
                n19 += n6;
                n20 += n9;
                n21 += n12;
                int n42 = 0;
                while (n42 < n14) {
                    float f6;
                    float f7;
                    short s2 = sArray3[n39];
                    float f8 = (float)sArray4[n40] * (1.0f - (float)s2 * f2);
                    float f9 = (float)s2 + f8;
                    if (f9 == 0.0f) {
                        f7 = 0.0f;
                        f6 = 0.0f;
                    } else {
                        f7 = (float)s2 / f9;
                        f6 = f8 / f9;
                    }
                    int n43 = 0;
                    while (n43 < n16) {
                        sArray5[n43][n41 + nArray3[n43]] = (short)((float)sArray[n43][n37 + nArray[n43]] * f7 + (float)sArray2[n43][n38 + nArray2[n43]] * f6);
                        ++n43;
                    }
                    n37 += n3;
                    n38 += n5;
                    n39 += n7;
                    n40 += n10;
                    n41 += n13;
                    ++n42;
                }
                ++n36;
            }
        }
    }

    private void intLoop(RasterAccessor rasterAccessor, RasterAccessor rasterAccessor2, RasterAccessor rasterAccessor3, RasterAccessor rasterAccessor4, RasterAccessor rasterAccessor5) {
        int n2 = rasterAccessor.getScanlineStride();
        int n3 = rasterAccessor.getPixelStride();
        int[] nArray = rasterAccessor.getBandOffsets();
        int[][] nArray2 = rasterAccessor.getIntDataArrays();
        int n4 = rasterAccessor2.getScanlineStride();
        int n5 = rasterAccessor2.getPixelStride();
        int[] nArray3 = rasterAccessor2.getBandOffsets();
        int[][] nArray4 = rasterAccessor2.getIntDataArrays();
        int n6 = rasterAccessor3.getScanlineStride();
        int n7 = rasterAccessor3.getPixelStride();
        int n8 = rasterAccessor3.getBandOffset(0);
        int[] nArray5 = rasterAccessor3.getIntDataArray(0);
        int n9 = 0;
        int n10 = 0;
        int n11 = 0;
        int[] nArray6 = null;
        if (this.alpha2 != null) {
            n9 = rasterAccessor4.getScanlineStride();
            n10 = rasterAccessor4.getPixelStride();
            n11 = rasterAccessor4.getBandOffset(0);
            nArray6 = rasterAccessor4.getIntDataArray(0);
        }
        int n12 = rasterAccessor5.getScanlineStride();
        int n13 = rasterAccessor5.getPixelStride();
        int[] nArray7 = rasterAccessor5.getBandOffsets();
        int[][] nArray8 = rasterAccessor5.getIntDataArrays();
        int n14 = rasterAccessor5.getWidth();
        int n15 = rasterAccessor5.getHeight();
        int n16 = rasterAccessor5.getNumBands();
        float f2 = 4.656613E-10f;
        int n17 = 0;
        int n18 = 0;
        int n19 = 0;
        int n20 = 0;
        int n21 = 0;
        if (this.premultiplied) {
            int n22 = 0;
            while (n22 < n15) {
                int n23 = n17;
                int n24 = n18;
                int n25 = n19 + n8;
                int n26 = n21;
                n17 += n2;
                n18 += n4;
                n19 += n6;
                n21 += n12;
                int n27 = 0;
                while (n27 < n14) {
                    float f3 = 1.0f - (float)nArray5[n25] * f2;
                    int n28 = 0;
                    while (n28 < n16) {
                        nArray8[n28][n26 + nArray7[n28]] = (int)((float)nArray2[n28][n23 + nArray[n28]] + (float)nArray4[n28][n24 + nArray3[n28]] * f3);
                        ++n28;
                    }
                    n23 += n3;
                    n24 += n5;
                    n25 += n7;
                    n26 += n13;
                    ++n27;
                }
                ++n22;
            }
        } else if (this.alpha2 == null) {
            int n29 = 0;
            while (n29 < n15) {
                int n30 = n17;
                int n31 = n18;
                int n32 = n19 + n8;
                int n33 = n21;
                n17 += n2;
                n18 += n4;
                n19 += n6;
                n21 += n12;
                int n34 = 0;
                while (n34 < n14) {
                    float f4 = (float)nArray5[n32] * f2;
                    float f5 = 1.0f - f4;
                    int n35 = 0;
                    while (n35 < n16) {
                        nArray8[n35][n33 + nArray7[n35]] = (int)((float)nArray2[n35][n30 + nArray[n35]] * f4 + (float)nArray4[n35][n31 + nArray3[n35]] * f5);
                        ++n35;
                    }
                    n30 += n3;
                    n31 += n5;
                    n32 += n7;
                    n33 += n13;
                    ++n34;
                }
                ++n29;
            }
        } else {
            int n36 = 0;
            while (n36 < n15) {
                int n37 = n17;
                int n38 = n18;
                int n39 = n19 + n8;
                int n40 = n20 + n11;
                int n41 = n21;
                n17 += n2;
                n18 += n4;
                n19 += n6;
                n20 += n9;
                n21 += n12;
                int n42 = 0;
                while (n42 < n14) {
                    float f6;
                    float f7;
                    int n43 = nArray5[n39];
                    float f8 = (float)nArray6[n40] * (1.0f - (float)n43 * f2);
                    float f9 = (float)n43 + f8;
                    if (f9 == 0.0f) {
                        f7 = 0.0f;
                        f6 = 0.0f;
                    } else {
                        f7 = (float)n43 / f9;
                        f6 = f8 / f9;
                    }
                    int n44 = 0;
                    while (n44 < n16) {
                        nArray8[n44][n41 + nArray7[n44]] = (int)((float)nArray2[n44][n37 + nArray[n44]] * f7 + (float)nArray4[n44][n38 + nArray3[n44]] * f6);
                        ++n44;
                    }
                    n37 += n3;
                    n38 += n5;
                    n39 += n7;
                    n40 += n10;
                    n41 += n13;
                    ++n42;
                }
                ++n36;
            }
        }
    }

    private void floatLoop(RasterAccessor rasterAccessor, RasterAccessor rasterAccessor2, RasterAccessor rasterAccessor3, RasterAccessor rasterAccessor4, RasterAccessor rasterAccessor5) {
        int n2 = rasterAccessor.getScanlineStride();
        int n3 = rasterAccessor.getPixelStride();
        int[] nArray = rasterAccessor.getBandOffsets();
        float[][] fArray = rasterAccessor.getFloatDataArrays();
        int n4 = rasterAccessor2.getScanlineStride();
        int n5 = rasterAccessor2.getPixelStride();
        int[] nArray2 = rasterAccessor2.getBandOffsets();
        float[][] fArray2 = rasterAccessor2.getFloatDataArrays();
        int n6 = rasterAccessor3.getScanlineStride();
        int n7 = rasterAccessor3.getPixelStride();
        int n8 = rasterAccessor3.getBandOffset(0);
        float[] fArray3 = rasterAccessor3.getFloatDataArray(0);
        int n9 = 0;
        int n10 = 0;
        int n11 = 0;
        float[] fArray4 = null;
        if (this.alpha2 != null) {
            n9 = rasterAccessor4.getScanlineStride();
            n10 = rasterAccessor4.getPixelStride();
            n11 = rasterAccessor4.getBandOffset(0);
            fArray4 = rasterAccessor4.getFloatDataArray(0);
        }
        int n12 = rasterAccessor5.getScanlineStride();
        int n13 = rasterAccessor5.getPixelStride();
        int[] nArray3 = rasterAccessor5.getBandOffsets();
        float[][] fArray5 = rasterAccessor5.getFloatDataArrays();
        int n14 = rasterAccessor5.getWidth();
        int n15 = rasterAccessor5.getHeight();
        int n16 = rasterAccessor5.getNumBands();
        int n17 = 0;
        int n18 = 0;
        int n19 = 0;
        int n20 = 0;
        int n21 = 0;
        if (this.premultiplied) {
            int n22 = 0;
            while (n22 < n15) {
                int n23 = n17;
                int n24 = n18;
                int n25 = n19 + n8;
                int n26 = n21;
                n17 += n2;
                n18 += n4;
                n19 += n6;
                n21 += n12;
                int n27 = 0;
                while (n27 < n14) {
                    float f2 = 1.0f - fArray3[n25];
                    int n28 = 0;
                    while (n28 < n16) {
                        fArray5[n28][n26 + nArray3[n28]] = fArray[n28][n23 + nArray[n28]] + fArray2[n28][n24 + nArray2[n28]] * f2;
                        ++n28;
                    }
                    n23 += n3;
                    n24 += n5;
                    n25 += n7;
                    n26 += n13;
                    ++n27;
                }
                ++n22;
            }
        } else if (this.alpha2 == null) {
            int n29 = 0;
            while (n29 < n15) {
                int n30 = n17;
                int n31 = n18;
                int n32 = n19 + n8;
                int n33 = n21;
                n17 += n2;
                n18 += n4;
                n19 += n6;
                n21 += n12;
                int n34 = 0;
                while (n34 < n14) {
                    float f3 = fArray3[n32];
                    float f4 = 1.0f - f3;
                    int n35 = 0;
                    while (n35 < n16) {
                        fArray5[n35][n33 + nArray3[n35]] = fArray[n35][n30 + nArray[n35]] * f3 + fArray2[n35][n31 + nArray2[n35]] * f4;
                        ++n35;
                    }
                    n30 += n3;
                    n31 += n5;
                    n32 += n7;
                    n33 += n13;
                    ++n34;
                }
                ++n29;
            }
        } else {
            int n36 = 0;
            while (n36 < n15) {
                int n37 = n17;
                int n38 = n18;
                int n39 = n19 + n8;
                int n40 = n20 + n11;
                int n41 = n21;
                n17 += n2;
                n18 += n4;
                n19 += n6;
                n20 += n9;
                n21 += n12;
                int n42 = 0;
                while (n42 < n14) {
                    float f5;
                    float f6;
                    float f7 = fArray3[n39];
                    float f8 = fArray4[n40] * (1.0f - f7);
                    float f9 = f7 + f8;
                    if (f9 == 0.0f) {
                        f6 = 0.0f;
                        f5 = 0.0f;
                    } else {
                        f6 = f7 / f9;
                        f5 = f8 / f9;
                    }
                    int n43 = 0;
                    while (n43 < n16) {
                        fArray5[n43][n41 + nArray3[n43]] = fArray[n43][n37 + nArray[n43]] * f6 + fArray2[n43][n38 + nArray2[n43]] * f5;
                        ++n43;
                    }
                    n37 += n3;
                    n38 += n5;
                    n39 += n7;
                    n40 += n10;
                    n41 += n13;
                    ++n42;
                }
                ++n36;
            }
        }
    }

    private void doubleLoop(RasterAccessor rasterAccessor, RasterAccessor rasterAccessor2, RasterAccessor rasterAccessor3, RasterAccessor rasterAccessor4, RasterAccessor rasterAccessor5) {
        int n2 = rasterAccessor.getScanlineStride();
        int n3 = rasterAccessor.getPixelStride();
        int[] nArray = rasterAccessor.getBandOffsets();
        double[][] dArray = rasterAccessor.getDoubleDataArrays();
        int n4 = rasterAccessor2.getScanlineStride();
        int n5 = rasterAccessor2.getPixelStride();
        int[] nArray2 = rasterAccessor2.getBandOffsets();
        double[][] dArray2 = rasterAccessor2.getDoubleDataArrays();
        int n6 = rasterAccessor3.getScanlineStride();
        int n7 = rasterAccessor3.getPixelStride();
        int n8 = rasterAccessor3.getBandOffset(0);
        double[] dArray3 = rasterAccessor3.getDoubleDataArray(0);
        int n9 = 0;
        int n10 = 0;
        int n11 = 0;
        double[] dArray4 = null;
        if (this.alpha2 != null) {
            n9 = rasterAccessor4.getScanlineStride();
            n10 = rasterAccessor4.getPixelStride();
            n11 = rasterAccessor4.getBandOffset(0);
            dArray4 = rasterAccessor4.getDoubleDataArray(0);
        }
        int n12 = rasterAccessor5.getScanlineStride();
        int n13 = rasterAccessor5.getPixelStride();
        int[] nArray3 = rasterAccessor5.getBandOffsets();
        double[][] dArray5 = rasterAccessor5.getDoubleDataArrays();
        int n14 = rasterAccessor5.getWidth();
        int n15 = rasterAccessor5.getHeight();
        int n16 = rasterAccessor5.getNumBands();
        int n17 = 0;
        int n18 = 0;
        int n19 = 0;
        int n20 = 0;
        int n21 = 0;
        if (this.premultiplied) {
            int n22 = 0;
            while (n22 < n15) {
                int n23 = n17;
                int n24 = n18;
                int n25 = n19 + n8;
                int n26 = n21;
                n17 += n2;
                n18 += n4;
                n19 += n6;
                n21 += n12;
                int n27 = 0;
                while (n27 < n14) {
                    double d2 = 1.0 - dArray3[n25];
                    int n28 = 0;
                    while (n28 < n16) {
                        dArray5[n28][n26 + nArray3[n28]] = dArray[n28][n23 + nArray[n28]] + dArray2[n28][n24 + nArray2[n28]] * d2;
                        ++n28;
                    }
                    n23 += n3;
                    n24 += n5;
                    n25 += n7;
                    n26 += n13;
                    ++n27;
                }
                ++n22;
            }
        } else if (this.alpha2 == null) {
            int n29 = 0;
            while (n29 < n15) {
                int n30 = n17;
                int n31 = n18;
                int n32 = n19 + n8;
                int n33 = n21;
                n17 += n2;
                n18 += n4;
                n19 += n6;
                n21 += n12;
                int n34 = 0;
                while (n34 < n14) {
                    double d3 = dArray3[n32];
                    double d4 = 1.0 - d3;
                    int n35 = 0;
                    while (n35 < n16) {
                        dArray5[n35][n33 + nArray3[n35]] = dArray[n35][n30 + nArray[n35]] * d3 + dArray2[n35][n31 + nArray2[n35]] * d4;
                        ++n35;
                    }
                    n30 += n3;
                    n31 += n5;
                    n32 += n7;
                    n33 += n13;
                    ++n34;
                }
                ++n29;
            }
        } else {
            int n36 = 0;
            while (n36 < n15) {
                int n37 = n17;
                int n38 = n18;
                int n39 = n19 + n8;
                int n40 = n20 + n11;
                int n41 = n21;
                n17 += n2;
                n18 += n4;
                n19 += n6;
                n20 += n9;
                n21 += n12;
                int n42 = 0;
                while (n42 < n14) {
                    double d5;
                    double d6;
                    double d7 = dArray3[n39];
                    double d8 = dArray4[n40] * (1.0 - d7);
                    double d9 = d7 + d8;
                    if (d9 == 0.0) {
                        d6 = 0.0;
                        d5 = 0.0;
                    } else {
                        d6 = d7 / d9;
                        d5 = d8 / d9;
                    }
                    int n43 = 0;
                    while (n43 < n16) {
                        dArray5[n43][n41 + nArray3[n43]] = dArray[n43][n37 + nArray[n43]] * d6 + dArray2[n43][n38 + nArray2[n43]] * d5;
                        ++n43;
                    }
                    n37 += n3;
                    n38 += n5;
                    n39 += n7;
                    n40 += n10;
                    n41 += n13;
                    ++n42;
                }
                ++n36;
            }
        }
    }

    protected synchronized RasterFormatTag[] getFormatTags() {
        RenderedImage[] renderedImageArray;
        if (this.alpha2 == null) {
            renderedImageArray = new RenderedImage[3];
        } else {
            renderedImageArray = new RenderedImage[4];
            renderedImageArray[3] = this.alpha2;
        }
        renderedImageArray[0] = this.getSourceImage(0);
        renderedImageArray[1] = this.getSourceImage(1);
        renderedImageArray[2] = this.alpha1;
        return RasterAccessor.findCompatibleTags(renderedImageArray, this);
    }
}

