/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jai.opimage;

import com.sun.media.jai.opimage.JaiI18N;
import com.sun.media.jai.util.ImageUtil;
import com.sun.media.jai.util.JDKWorkarounds;
import java.awt.Rectangle;
import java.awt.image.ColorModel;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import java.util.Map;
import javax.media.jai.ImageLayout;
import javax.media.jai.PointOpImage;
import javax.media.jai.RasterAccessor;
import javax.media.jai.RasterFactory;
import javax.media.jai.RasterFormatTag;

final class ConjugateOpImage
extends PointOpImage {
    private static ImageLayout layoutHelper(ImageLayout imageLayout, RenderedImage renderedImage) {
        ImageLayout imageLayout2 = imageLayout == null ? new ImageLayout() : (ImageLayout)imageLayout.clone();
        SampleModel sampleModel = imageLayout2.getSampleModel(renderedImage);
        int n2 = sampleModel.getTransferType();
        boolean bl2 = false;
        if (n2 == 0) {
            n2 = 2;
            bl2 = true;
        } else if (n2 == 1) {
            n2 = 3;
            bl2 = true;
        }
        if (bl2) {
            sampleModel = RasterFactory.createComponentSampleModel(sampleModel, n2, sampleModel.getWidth(), sampleModel.getHeight(), sampleModel.getNumBands());
            imageLayout2.setSampleModel(sampleModel);
            ColorModel colorModel = imageLayout2.getColorModel(null);
            if (colorModel != null && !JDKWorkarounds.areCompatibleDataModels(sampleModel, colorModel)) {
                imageLayout2.unsetValid(512);
            }
        }
        return imageLayout2;
    }

    public ConjugateOpImage(RenderedImage renderedImage, Map map, ImageLayout imageLayout) {
        super(renderedImage, ConjugateOpImage.layoutHelper(imageLayout, renderedImage), map, true);
        this.permitInPlaceOperation();
    }

    protected void computeRect(Raster[] rasterArray, WritableRaster writableRaster, Rectangle rectangle) {
        RasterFormatTag[] rasterFormatTagArray = this.getFormatTags();
        Raster raster = rasterArray[0];
        Rectangle rectangle2 = this.mapDestRect(rectangle, 0);
        RasterAccessor rasterAccessor = new RasterAccessor(raster, rectangle2, rasterFormatTagArray[0], this.getSourceImage(0).getColorModel());
        RasterAccessor rasterAccessor2 = new RasterAccessor(writableRaster, rectangle, rasterFormatTagArray[1], this.getColorModel());
        switch (rasterAccessor2.getDataType()) {
            case 2: {
                this.shortLoop(rasterAccessor, rasterAccessor2);
                break;
            }
            case 3: {
                this.intLoop(rasterAccessor, rasterAccessor2);
                break;
            }
            case 4: {
                this.floatLoop(rasterAccessor, rasterAccessor2);
                break;
            }
            case 5: {
                this.doubleLoop(rasterAccessor, rasterAccessor2);
                break;
            }
            default: {
                throw new RuntimeException(JaiI18N.getString("ConjugateOpImage0"));
            }
        }
        if (rasterAccessor2.isDataCopy()) {
            rasterAccessor2.clampDataArrays();
            rasterAccessor2.copyDataToRaster();
        }
    }

    private void shortLoop(RasterAccessor rasterAccessor, RasterAccessor rasterAccessor2) {
        int n2 = rasterAccessor2.getWidth();
        int n3 = rasterAccessor2.getHeight();
        int n4 = rasterAccessor2.getNumBands();
        short[][] sArray = rasterAccessor2.getShortDataArrays();
        int[] nArray = rasterAccessor2.getBandOffsets();
        int n5 = rasterAccessor2.getPixelStride();
        int n6 = rasterAccessor2.getScanlineStride();
        short[][] sArray2 = rasterAccessor.getShortDataArrays();
        int[] nArray2 = rasterAccessor.getBandOffsets();
        int n7 = rasterAccessor.getPixelStride();
        int n8 = rasterAccessor.getScanlineStride();
        int n9 = 0;
        while (n9 < n4) {
            int n10;
            int n11;
            int n12;
            int n13;
            boolean bl2 = n9 % 2 == 0;
            short[] sArray3 = sArray[n9];
            short[] sArray4 = sArray2[n9];
            int n14 = nArray2[n9];
            int n15 = nArray[n9];
            if (bl2) {
                n13 = 0;
                while (n13 < n3) {
                    n12 = n14;
                    n11 = n15;
                    n10 = 0;
                    while (n10 < n2) {
                        sArray3[n11] = sArray4[n12];
                        n12 += n7;
                        n11 += n5;
                        ++n10;
                    }
                    n14 += n8;
                    n15 += n6;
                    ++n13;
                }
            } else {
                n13 = 0;
                while (n13 < n3) {
                    n12 = n14;
                    n11 = n15;
                    n10 = 0;
                    while (n10 < n2) {
                        sArray3[n11] = ImageUtil.clampShort(-sArray4[n12]);
                        n12 += n7;
                        n11 += n5;
                        ++n10;
                    }
                    n14 += n8;
                    n15 += n6;
                    ++n13;
                }
            }
            ++n9;
        }
    }

    private void intLoop(RasterAccessor rasterAccessor, RasterAccessor rasterAccessor2) {
        int n2 = rasterAccessor2.getWidth();
        int n3 = rasterAccessor2.getHeight();
        int n4 = rasterAccessor2.getNumBands();
        int[][] nArray = rasterAccessor2.getIntDataArrays();
        int[] nArray2 = rasterAccessor2.getBandOffsets();
        int n5 = rasterAccessor2.getPixelStride();
        int n6 = rasterAccessor2.getScanlineStride();
        int[][] nArray3 = rasterAccessor.getIntDataArrays();
        int[] nArray4 = rasterAccessor.getBandOffsets();
        int n7 = rasterAccessor.getPixelStride();
        int n8 = rasterAccessor.getScanlineStride();
        int n9 = 0;
        while (n9 < n4) {
            int n10;
            int n11;
            int n12;
            int n13;
            boolean bl2 = n9 % 2 == 0;
            int[] nArray5 = nArray[n9];
            int[] nArray6 = nArray3[n9];
            int n14 = nArray4[n9];
            int n15 = nArray2[n9];
            if (bl2) {
                n13 = 0;
                while (n13 < n3) {
                    n12 = n14;
                    n11 = n15;
                    n10 = 0;
                    while (n10 < n2) {
                        nArray5[n11] = nArray6[n12];
                        n12 += n7;
                        n11 += n5;
                        ++n10;
                    }
                    n14 += n8;
                    n15 += n6;
                    ++n13;
                }
            } else {
                n13 = 0;
                while (n13 < n3) {
                    n12 = n14;
                    n11 = n15;
                    n10 = 0;
                    while (n10 < n2) {
                        nArray5[n11] = -nArray6[n12];
                        n12 += n7;
                        n11 += n5;
                        ++n10;
                    }
                    n14 += n8;
                    n15 += n6;
                    ++n13;
                }
            }
            ++n9;
        }
    }

    private void floatLoop(RasterAccessor rasterAccessor, RasterAccessor rasterAccessor2) {
        int n2 = rasterAccessor2.getWidth();
        int n3 = rasterAccessor2.getHeight();
        int n4 = rasterAccessor2.getNumBands();
        float[][] fArray = rasterAccessor2.getFloatDataArrays();
        int[] nArray = rasterAccessor2.getBandOffsets();
        int n5 = rasterAccessor2.getPixelStride();
        int n6 = rasterAccessor2.getScanlineStride();
        float[][] fArray2 = rasterAccessor.getFloatDataArrays();
        int[] nArray2 = rasterAccessor.getBandOffsets();
        int n7 = rasterAccessor.getPixelStride();
        int n8 = rasterAccessor.getScanlineStride();
        int n9 = 0;
        while (n9 < n4) {
            int n10;
            int n11;
            int n12;
            int n13;
            boolean bl2 = n9 % 2 == 0;
            float[] fArray3 = fArray[n9];
            float[] fArray4 = fArray2[n9];
            int n14 = nArray2[n9];
            int n15 = nArray[n9];
            if (bl2) {
                n13 = 0;
                while (n13 < n3) {
                    n12 = n14;
                    n11 = n15;
                    n10 = 0;
                    while (n10 < n2) {
                        fArray3[n11] = fArray4[n12];
                        n12 += n7;
                        n11 += n5;
                        ++n10;
                    }
                    n14 += n8;
                    n15 += n6;
                    ++n13;
                }
            } else {
                n13 = 0;
                while (n13 < n3) {
                    n12 = n14;
                    n11 = n15;
                    n10 = 0;
                    while (n10 < n2) {
                        fArray3[n11] = -fArray4[n12];
                        n12 += n7;
                        n11 += n5;
                        ++n10;
                    }
                    n14 += n8;
                    n15 += n6;
                    ++n13;
                }
            }
            ++n9;
        }
    }

    private void doubleLoop(RasterAccessor rasterAccessor, RasterAccessor rasterAccessor2) {
        int n2 = rasterAccessor2.getWidth();
        int n3 = rasterAccessor2.getHeight();
        int n4 = rasterAccessor2.getNumBands();
        double[][] dArray = rasterAccessor2.getDoubleDataArrays();
        int[] nArray = rasterAccessor2.getBandOffsets();
        int n5 = rasterAccessor2.getPixelStride();
        int n6 = rasterAccessor2.getScanlineStride();
        double[][] dArray2 = rasterAccessor.getDoubleDataArrays();
        int[] nArray2 = rasterAccessor.getBandOffsets();
        int n7 = rasterAccessor.getPixelStride();
        int n8 = rasterAccessor.getScanlineStride();
        int n9 = 0;
        while (n9 < n4) {
            int n10;
            int n11;
            int n12;
            int n13;
            boolean bl2 = n9 % 2 == 0;
            double[] dArray3 = dArray[n9];
            double[] dArray4 = dArray2[n9];
            int n14 = nArray2[n9];
            int n15 = nArray[n9];
            if (bl2) {
                n13 = 0;
                while (n13 < n3) {
                    n12 = n14;
                    n11 = n15;
                    n10 = 0;
                    while (n10 < n2) {
                        dArray3[n11] = dArray4[n12];
                        n12 += n7;
                        n11 += n5;
                        ++n10;
                    }
                    n14 += n8;
                    n15 += n6;
                    ++n13;
                }
            } else {
                n13 = 0;
                while (n13 < n3) {
                    n12 = n14;
                    n11 = n15;
                    n10 = 0;
                    while (n10 < n2) {
                        dArray3[n11] = -dArray4[n12];
                        n12 += n7;
                        n11 += n5;
                        ++n10;
                    }
                    n14 += n8;
                    n15 += n6;
                    ++n13;
                }
            }
            ++n9;
        }
    }
}

