/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jai.opimage;

import com.sun.media.jai.opimage.PatternOpImage;
import java.awt.Point;
import java.awt.image.ColorModel;
import java.awt.image.Raster;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import javax.media.jai.PlanarImage;
import javax.media.jai.RasterFactory;

final class ConstantOpImage
extends PatternOpImage {
    private static Raster makePattern(SampleModel sampleModel, Number[] numberArray) {
        WritableRaster writableRaster = RasterFactory.createWritableRaster(sampleModel, new Point(0, 0));
        int n2 = sampleModel.getWidth();
        int n3 = sampleModel.getHeight();
        int n4 = sampleModel.getTransferType();
        int n5 = sampleModel.getNumBands();
        switch (n4) {
            case 0: {
                int[] nArray = new int[n5];
                int n6 = 0;
                while (n6 < n5) {
                    nArray[n6] = numberArray[n6].intValue() & 0xFF;
                    ++n6;
                }
                int n7 = 0;
                while (n7 < n2) {
                    writableRaster.setPixel(n7, 0, nArray);
                    ++n7;
                }
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                int[] nArray = new int[n5];
                int n8 = 0;
                while (n8 < n5) {
                    nArray[n8] = numberArray[n8].intValue();
                    ++n8;
                }
                int n9 = 0;
                while (n9 < n2) {
                    writableRaster.setPixel(n9, 0, nArray);
                    ++n9;
                }
                break;
            }
            case 4: {
                float[] fArray = new float[n5];
                int n10 = 0;
                while (n10 < n5) {
                    fArray[n10] = numberArray[n10].floatValue();
                    ++n10;
                }
                int n11 = 0;
                while (n11 < n2) {
                    writableRaster.setPixel(n11, 0, fArray);
                    ++n11;
                }
                break;
            }
            case 5: {
                double[] dArray = new double[n5];
                int n12 = 0;
                while (n12 < n5) {
                    dArray[n12] = numberArray[n12].doubleValue();
                    ++n12;
                }
                int n13 = 0;
                while (n13 < n2) {
                    writableRaster.setPixel(n13, 0, dArray);
                    ++n13;
                }
                break;
            }
        }
        Object object = writableRaster.getDataElements(0, 0, n2, 1, null);
        int n14 = 1;
        while (n14 < n3) {
            writableRaster.setDataElements(0, n14, n2, 1, object);
            ++n14;
        }
        return writableRaster;
    }

    private static SampleModel makeSampleModel(int n2, int n3, Number[] numberArray) {
        int n4;
        int n5 = numberArray.length;
        if (numberArray instanceof Byte[]) {
            n4 = 0;
        } else if (numberArray instanceof Short[]) {
            n4 = 1;
            Short[] shortArray = (Short[])numberArray;
            int n6 = 0;
            while (n6 < n5) {
                if (shortArray[n6] < 0) {
                    n4 = 2;
                    break;
                }
                ++n6;
            }
        } else {
            n4 = numberArray instanceof Integer[] ? 3 : (numberArray instanceof Float[] ? 4 : (numberArray instanceof Double[] ? 5 : 32));
        }
        return RasterFactory.createPixelInterleavedSampleModel(n4, n2, n3, n5);
    }

    private static Raster patternHelper(int n2, int n3, Number[] numberArray) {
        SampleModel sampleModel = ConstantOpImage.makeSampleModel(n2, n3, numberArray);
        return ConstantOpImage.makePattern(sampleModel, numberArray);
    }

    private static ColorModel colorModelHelper(Number[] numberArray) {
        SampleModel sampleModel = ConstantOpImage.makeSampleModel(1, 1, numberArray);
        return PlanarImage.createColorModel(sampleModel);
    }

    public ConstantOpImage(int n2, int n3, int n4, int n5, int n6, int n7, Number[] numberArray) {
        super(ConstantOpImage.patternHelper(n6, n7, numberArray), ConstantOpImage.colorModelHelper(numberArray), n2, n3, n4, n5);
    }
}

