/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jai.opimage;

import com.sun.media.jai.opimage.FCT;
import com.sun.media.jai.opimage.JaiI18N;
import com.sun.media.jai.util.JDKWorkarounds;
import com.sun.media.jai.util.MathJAI;
import java.awt.Rectangle;
import java.awt.geom.Point2D;
import java.awt.image.ColorModel;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import java.util.Map;
import javax.media.jai.ImageLayout;
import javax.media.jai.RasterAccessor;
import javax.media.jai.RasterFactory;
import javax.media.jai.RasterFormatTag;
import javax.media.jai.UntiledOpImage;

public class DCTOpImage
extends UntiledOpImage {
    private FCT fct;

    private static ImageLayout layoutHelper(ImageLayout imageLayout, RenderedImage renderedImage) {
        SampleModel sampleModel;
        int n2;
        int n3;
        int n4;
        ImageLayout imageLayout2 = imageLayout == null ? new ImageLayout() : (ImageLayout)imageLayout.clone();
        imageLayout2.setMinX(renderedImage.getMinX());
        imageLayout2.setMinY(renderedImage.getMinY());
        boolean bl2 = false;
        int n5 = imageLayout2.getWidth(renderedImage);
        if (n5 > 1 && (n4 = MathJAI.nextPositivePowerOf2(n5)) != n5) {
            n5 = n4;
            imageLayout2.setWidth(n5);
            bl2 = true;
        }
        if ((n4 = imageLayout2.getHeight(renderedImage)) > 1 && (n3 = MathJAI.nextPositivePowerOf2(n4)) != n4) {
            n4 = n3;
            imageLayout2.setHeight(n4);
            bl2 = true;
        }
        if ((n2 = (sampleModel = imageLayout2.getSampleModel(renderedImage)).getTransferType()) != 4 && n2 != 5) {
            n2 = 4;
            bl2 = true;
        }
        if (bl2) {
            sampleModel = RasterFactory.createComponentSampleModel(sampleModel, n2, n5, n4, sampleModel.getNumBands());
            imageLayout2.setSampleModel(sampleModel);
            ColorModel colorModel = imageLayout2.getColorModel(null);
            if (colorModel != null && !JDKWorkarounds.areCompatibleDataModels(sampleModel, colorModel)) {
                imageLayout2.unsetValid(512);
            }
        }
        return imageLayout2;
    }

    public DCTOpImage(RenderedImage renderedImage, Map map, ImageLayout imageLayout, FCT fCT) {
        super(renderedImage, map, DCTOpImage.layoutHelper(imageLayout, renderedImage));
        this.fct = fCT;
    }

    public Point2D mapDestPoint(Point2D point2D) {
        if (point2D == null) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic0"));
        }
        return null;
    }

    public Point2D mapSourcePoint(Point2D point2D) {
        if (point2D == null) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic0"));
        }
        return null;
    }

    protected void computeImage(Raster[] rasterArray, WritableRaster writableRaster, Rectangle rectangle) {
        Raster raster = rasterArray[0];
        if (rectangle.width == 1 && rectangle.height == 1) {
            double[] dArray = raster.getPixel(rectangle.x, rectangle.y, (double[])null);
            writableRaster.setPixel(rectangle.x, rectangle.y, dArray);
            return;
        }
        this.fct.setLength(rectangle.width > 1 ? this.getWidth() : this.getHeight());
        int n2 = raster.getWidth();
        int n3 = raster.getHeight();
        int n4 = raster.getMinX();
        int n5 = raster.getMinY();
        RasterFormatTag[] rasterFormatTagArray = this.getFormatTags();
        RasterAccessor rasterAccessor = new RasterAccessor(raster, new Rectangle(n4, n5, n2, n3), rasterFormatTagArray[0], this.getSourceImage(0).getColorModel());
        RasterAccessor rasterAccessor2 = new RasterAccessor(writableRaster, rectangle, rasterFormatTagArray[1], this.getColorModel());
        int n6 = rasterAccessor.getDataType();
        int n7 = rasterAccessor2.getDataType();
        int n8 = rasterAccessor.getPixelStride();
        int n9 = rasterAccessor.getScanlineStride();
        int n10 = rasterAccessor2.getPixelStride();
        int n11 = rasterAccessor2.getScanlineStride();
        int n12 = this.sampleModel.getNumBands();
        int n13 = 0;
        while (n13 < n12) {
            int n14;
            int n15;
            Object object = rasterAccessor.getDataArray(n13);
            Object object2 = rasterAccessor2.getDataArray(n13);
            if (rectangle.width > 1) {
                this.fct.setLength(this.getWidth());
                n15 = rasterAccessor.getBandOffset(n13);
                n14 = rasterAccessor2.getBandOffset(n13);
                int n16 = 0;
                while (n16 < n3) {
                    this.fct.setData(n6, object, n15, n8, n2);
                    this.fct.transform();
                    this.fct.getData(n7, object2, n14, n10);
                    n15 += n9;
                    n14 += n11;
                    ++n16;
                }
            }
            if (rectangle.width == 1) {
                n15 = rasterAccessor.getBandOffset(n13);
                n14 = rasterAccessor2.getBandOffset(n13);
                this.fct.setData(n6, object, n15, n9, n3);
                this.fct.transform();
                this.fct.getData(n7, object2, n14, n11);
            } else if (rectangle.height > 1) {
                this.fct.setLength(this.getHeight());
                n15 = rasterAccessor2.getBandOffset(n13);
                n14 = 0;
                while (n14 < rectangle.width) {
                    this.fct.setData(n7, object2, n15, n11, rectangle.height);
                    this.fct.transform();
                    this.fct.getData(n7, object2, n15, n11);
                    n15 += n10;
                    ++n14;
                }
            }
            ++n13;
        }
        if (rasterAccessor2.needsClamping()) {
            rasterAccessor2.clampDataArrays();
        }
        rasterAccessor2.copyDataToRaster();
    }
}

