/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jai.opimage;

import com.sun.media.jai.opimage.FFT;
import com.sun.media.jai.opimage.JaiI18N;
import com.sun.media.jai.util.JDKWorkarounds;
import com.sun.media.jai.util.MathJAI;
import java.awt.Rectangle;
import java.awt.geom.Point2D;
import java.awt.image.ColorModel;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import java.util.Map;
import javax.media.jai.EnumeratedParameter;
import javax.media.jai.ImageLayout;
import javax.media.jai.RasterAccessor;
import javax.media.jai.RasterFactory;
import javax.media.jai.RasterFormatTag;
import javax.media.jai.UntiledOpImage;
import javax.media.jai.operator.DFTDescriptor;

public class DFTOpImage
extends UntiledOpImage {
    FFT fft;
    protected boolean complexSrc;
    protected boolean complexDst;

    private static ImageLayout layoutHelper(ImageLayout imageLayout, RenderedImage renderedImage, EnumeratedParameter enumeratedParameter) {
        int n2;
        int n3;
        int n4;
        ImageLayout imageLayout2 = imageLayout == null ? new ImageLayout() : (ImageLayout)imageLayout.clone();
        imageLayout2.setMinX(renderedImage.getMinX());
        imageLayout2.setMinY(renderedImage.getMinY());
        int n5 = imageLayout2.getWidth(renderedImage);
        int n6 = imageLayout2.getHeight(renderedImage);
        if (n5 == 1 && n6 == 1) {
            n4 = 1;
            n3 = 1;
        } else if (n5 == 1 && n6 > 1) {
            n3 = 1;
            n4 = MathJAI.nextPositivePowerOf2(n6);
        } else if (n5 > 1 && n6 == 1) {
            n3 = MathJAI.nextPositivePowerOf2(n5);
            n4 = 1;
        } else {
            n3 = MathJAI.nextPositivePowerOf2(n5);
            n4 = MathJAI.nextPositivePowerOf2(n6);
        }
        imageLayout2.setWidth(n3);
        imageLayout2.setHeight(n4);
        boolean bl2 = !enumeratedParameter.equals(DFTDescriptor.REAL_TO_COMPLEX);
        boolean bl3 = !enumeratedParameter.equals(DFTDescriptor.COMPLEX_TO_REAL);
        boolean bl4 = false;
        SampleModel sampleModel = renderedImage.getSampleModel();
        int n7 = sampleModel.getNumBands();
        if (bl2 && !bl3) {
            n7 /= 2;
        } else if (!bl2 && bl3) {
            n7 *= 2;
        }
        SampleModel sampleModel2 = imageLayout2.getSampleModel(renderedImage);
        int n8 = sampleModel2.getNumBands();
        if (n8 != n7) {
            n8 = n7;
            bl4 = true;
        }
        if ((n2 = sampleModel2.getTransferType()) != 4 && n2 != 5) {
            n2 = 4;
            bl4 = true;
        }
        if (bl4) {
            sampleModel2 = RasterFactory.createComponentSampleModel(sampleModel2, n2, n3, n4, n8);
            imageLayout2.setSampleModel(sampleModel2);
            ColorModel colorModel = imageLayout2.getColorModel(null);
            if (colorModel != null && !JDKWorkarounds.areCompatibleDataModels(sampleModel2, colorModel)) {
                imageLayout2.unsetValid(512);
            }
        }
        return imageLayout2;
    }

    public DFTOpImage(RenderedImage renderedImage, Map map, ImageLayout imageLayout, EnumeratedParameter enumeratedParameter, FFT fFT) {
        super(renderedImage, map, DFTOpImage.layoutHelper(imageLayout, renderedImage, enumeratedParameter));
        this.fft = fFT;
        this.complexSrc = !enumeratedParameter.equals(DFTDescriptor.REAL_TO_COMPLEX);
        this.complexDst = !enumeratedParameter.equals(DFTDescriptor.COMPLEX_TO_REAL);
    }

    public Point2D mapDestPoint(Point2D point2D) {
        if (point2D == null) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic0"));
        }
        return null;
    }

    public Point2D mapSourcePoint(Point2D point2D) {
        if (point2D == null) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic0"));
        }
        return null;
    }

    protected void computeImage(Raster[] rasterArray, WritableRaster writableRaster, Rectangle rectangle) {
        Raster raster = rasterArray[0];
        if (rectangle.width == 1 && rectangle.height == 1) {
            int n2 = this.sampleModel.getNumBands();
            double[] dArray = new double[raster.getSampleModel().getNumBands()];
            raster.getPixel(rectangle.x, rectangle.y, dArray);
            if (this.complexSrc && this.complexDst) {
                writableRaster.setPixel(rectangle.x, rectangle.y, dArray);
            } else if (this.complexSrc) {
                int n3 = 0;
                while (n3 < n2) {
                    writableRaster.setSample(rectangle.x, rectangle.y, n3, dArray[2 * n3]);
                    ++n3;
                }
            } else if (this.complexDst) {
                int n4 = 0;
                while (n4 < n2) {
                    writableRaster.setSample(rectangle.x, rectangle.y, n4, n4 % 2 == 0 ? dArray[n4 / 2] : 0.0);
                    ++n4;
                }
            } else {
                throw new RuntimeException(JaiI18N.getString("DFTOpImage1"));
            }
            return;
        }
        this.fft.setLength(rectangle.width > 1 ? this.getWidth() : this.getHeight());
        int n5 = raster.getWidth();
        int n6 = raster.getHeight();
        int n7 = raster.getMinX();
        int n8 = raster.getMinY();
        RasterFormatTag[] rasterFormatTagArray = this.getFormatTags();
        RasterAccessor rasterAccessor = new RasterAccessor(raster, new Rectangle(n7, n8, n5, n6), rasterFormatTagArray[0], this.getSourceImage(0).getColorModel());
        RasterAccessor rasterAccessor2 = new RasterAccessor(writableRaster, rectangle, rasterFormatTagArray[1], this.getColorModel());
        int n9 = rasterAccessor.getDataType();
        int n10 = rasterAccessor2.getDataType();
        int n11 = rasterAccessor.getPixelStride();
        int n12 = rasterAccessor.getScanlineStride();
        int n13 = rasterAccessor2.getPixelStride();
        int n14 = rasterAccessor2.getScanlineStride();
        int n15 = 1;
        int n16 = rectangle.width;
        if (this.complexDst) {
            n15 = n13;
            n16 = n14;
        }
        int n17 = 0;
        int n18 = this.complexSrc ? 2 : 1;
        int n19 = 0;
        int n20 = this.complexDst ? 2 : 1;
        int n21 = this.complexDst ? writableRaster.getSampleModel().getNumBands() / 2 : writableRaster.getSampleModel().getNumBands();
        int n22 = 0;
        while (n22 < n21) {
            int n23;
            int n24;
            int n25;
            int n26;
            Object object = rasterAccessor.getDataArray(n17);
            Object object2 = null;
            if (this.complexSrc) {
                object2 = rasterAccessor.getDataArray(n17 + 1);
            }
            Object object3 = rasterAccessor2.getDataArray(n19);
            Object object4 = null;
            object4 = this.complexDst ? rasterAccessor2.getDataArray(n19 + 1) : (n10 == 4 ? (Object)new float[rectangle.width * rectangle.height] : (Object)new double[rectangle.width * rectangle.height]);
            if (rectangle.width > 1) {
                this.fft.setLength(this.getWidth());
                n26 = rasterAccessor.getBandOffset(n17);
                n25 = 0;
                if (this.complexSrc) {
                    n25 = rasterAccessor.getBandOffset(n17 + 1);
                }
                n24 = rasterAccessor2.getBandOffset(n19);
                n23 = 0;
                if (this.complexDst) {
                    n23 = rasterAccessor2.getBandOffset(n19 + 1);
                }
                int n27 = 0;
                while (n27 < n6) {
                    this.fft.setData(n9, object, n26, n11, object2, n25, n11, n5);
                    this.fft.transform();
                    this.fft.getData(n10, object3, n24, n13, object4, n23, n15);
                    n26 += n12;
                    n25 += n12;
                    n24 += n14;
                    n23 += n16;
                    ++n27;
                }
            }
            if (rectangle.width == 1) {
                n26 = rasterAccessor.getBandOffset(n17);
                n25 = 0;
                if (this.complexSrc) {
                    n25 = rasterAccessor.getBandOffset(n17 + 1);
                }
                n24 = rasterAccessor2.getBandOffset(n19);
                n23 = 0;
                if (this.complexDst) {
                    n23 = rasterAccessor2.getBandOffset(n19 + 1);
                }
                this.fft.setData(n9, object, n26, n12, object2, n25, n12, n6);
                this.fft.transform();
                this.fft.getData(n10, object3, n24, n14, object4, n23, n16);
            } else if (rectangle.height > 1) {
                this.fft.setLength(this.getHeight());
                n26 = rasterAccessor2.getBandOffset(n19);
                n25 = 0;
                if (this.complexDst) {
                    n25 = rasterAccessor2.getBandOffset(n19 + 1);
                }
                n24 = 0;
                while (n24 < rectangle.width) {
                    this.fft.setData(n10, object3, n26, n14, object4, n25, n16, rectangle.height);
                    this.fft.transform();
                    this.fft.getData(n10, object3, n26, n14, this.complexDst ? object4 : null, n25, n16);
                    n26 += n13;
                    n25 += n15;
                    ++n24;
                }
            }
            n17 += n18;
            n19 += n20;
            ++n22;
        }
        if (rasterAccessor2.needsClamping()) {
            rasterAccessor2.clampDataArrays();
        }
        rasterAccessor2.copyDataToRaster();
    }
}

