/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jai.opimage;

import java.awt.Rectangle;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.util.Map;
import javax.media.jai.AreaOpImage;
import javax.media.jai.BorderExtender;
import javax.media.jai.ImageLayout;
import javax.media.jai.KernelJAI;
import javax.media.jai.RasterAccessor;
import javax.media.jai.RasterFormatTag;

final class ErodeOpImage
extends AreaOpImage {
    protected KernelJAI kernel;
    private int kw;
    private int kh;
    private int kx;
    private int ky;
    private float[] kdata;

    public ErodeOpImage(RenderedImage renderedImage, BorderExtender borderExtender, Map map, ImageLayout imageLayout, KernelJAI kernelJAI) {
        super(renderedImage, imageLayout, map, true, borderExtender, kernelJAI.getLeftPadding(), kernelJAI.getRightPadding(), kernelJAI.getTopPadding(), kernelJAI.getBottomPadding());
        this.kernel = kernelJAI;
        this.kw = kernelJAI.getWidth();
        this.kh = kernelJAI.getHeight();
        this.kx = kernelJAI.getXOrigin();
        this.ky = kernelJAI.getYOrigin();
        this.kdata = kernelJAI.getKernelData();
    }

    protected void computeRect(Raster[] rasterArray, WritableRaster writableRaster, Rectangle rectangle) {
        RasterFormatTag[] rasterFormatTagArray = this.getFormatTags();
        Raster raster = rasterArray[0];
        Rectangle rectangle2 = this.mapDestRect(rectangle, 0);
        RasterAccessor rasterAccessor = new RasterAccessor(raster, rectangle2, rasterFormatTagArray[0], this.getSourceImage(0).getColorModel());
        RasterAccessor rasterAccessor2 = new RasterAccessor(writableRaster, rectangle, rasterFormatTagArray[1], this.getColorModel());
        switch (rasterAccessor2.getDataType()) {
            case 0: {
                this.byteLoop(rasterAccessor, rasterAccessor2);
                break;
            }
            case 3: {
                this.intLoop(rasterAccessor, rasterAccessor2);
                break;
            }
            case 2: {
                this.shortLoop(rasterAccessor, rasterAccessor2);
                break;
            }
            case 1: {
                this.ushortLoop(rasterAccessor, rasterAccessor2);
                break;
            }
            case 4: {
                this.floatLoop(rasterAccessor, rasterAccessor2);
                break;
            }
            case 5: {
                this.doubleLoop(rasterAccessor, rasterAccessor2);
                break;
            }
        }
        if (rasterAccessor2.isDataCopy()) {
            rasterAccessor2.clampDataArrays();
            rasterAccessor2.copyDataToRaster();
        }
    }

    private void byteLoop(RasterAccessor rasterAccessor, RasterAccessor rasterAccessor2) {
        int n2 = rasterAccessor2.getWidth();
        int n3 = rasterAccessor2.getHeight();
        int n4 = rasterAccessor2.getNumBands();
        int[] nArray = rasterAccessor2.getBandOffsets();
        int n5 = rasterAccessor2.getPixelStride();
        int n6 = rasterAccessor2.getScanlineStride();
        int[] nArray2 = rasterAccessor.getBandOffsets();
        int n7 = rasterAccessor.getPixelStride();
        int n8 = rasterAccessor.getScanlineStride();
        byte[][] byArray = rasterAccessor2.getByteDataArrays();
        byte[][] byArray2 = rasterAccessor.getByteDataArrays();
        int n9 = 0;
        while (n9 < n4) {
            byte[] byArray3 = byArray[n9];
            byte[] byArray4 = byArray2[n9];
            int n10 = nArray2[n9];
            int n11 = nArray[n9];
            int n12 = 0;
            while (n12 < n3) {
                int n13 = n10;
                int n14 = n11;
                int n15 = 0;
                while (n15 < n2) {
                    int n16;
                    int n17 = 0;
                    int n18 = n13;
                    float f2 = Float.POSITIVE_INFINITY;
                    int n19 = 0;
                    while (n19 < this.kh) {
                        n16 = n18;
                        int n20 = 0;
                        while (n20 < this.kw) {
                            float f3 = (float)(byArray4[n16] & 0xFF) - this.kdata[n17 + n20];
                            if (f3 < f2) {
                                f2 = f3;
                            }
                            n16 += n7;
                            ++n20;
                        }
                        n17 += this.kw;
                        n18 += n8;
                        ++n19;
                    }
                    if (Float.isInfinite(f2)) {
                        f2 = 0.0f;
                    }
                    if ((n16 = (int)f2) < 0) {
                        n16 = 0;
                    } else if (n16 > 255) {
                        n16 = 255;
                    }
                    byArray3[n14] = (byte)n16;
                    n13 += n7;
                    n14 += n5;
                    ++n15;
                }
                n10 += n8;
                n11 += n6;
                ++n12;
            }
            ++n9;
        }
    }

    private void shortLoop(RasterAccessor rasterAccessor, RasterAccessor rasterAccessor2) {
        int n2 = rasterAccessor2.getWidth();
        int n3 = rasterAccessor2.getHeight();
        int n4 = rasterAccessor2.getNumBands();
        int[] nArray = rasterAccessor2.getBandOffsets();
        int n5 = rasterAccessor2.getPixelStride();
        int n6 = rasterAccessor2.getScanlineStride();
        int[] nArray2 = rasterAccessor.getBandOffsets();
        int n7 = rasterAccessor.getPixelStride();
        int n8 = rasterAccessor.getScanlineStride();
        short[][] sArray = rasterAccessor2.getShortDataArrays();
        short[][] sArray2 = rasterAccessor.getShortDataArrays();
        int n9 = 0;
        while (n9 < n4) {
            short[] sArray3 = sArray[n9];
            short[] sArray4 = sArray2[n9];
            int n10 = nArray2[n9];
            int n11 = nArray[n9];
            int n12 = 0;
            while (n12 < n3) {
                int n13 = n10;
                int n14 = n11;
                int n15 = 0;
                while (n15 < n2) {
                    int n16;
                    int n17 = 0;
                    int n18 = n13;
                    float f2 = Float.POSITIVE_INFINITY;
                    int n19 = 0;
                    while (n19 < this.kh) {
                        n16 = n18;
                        int n20 = 0;
                        while (n20 < this.kw) {
                            float f3 = (float)sArray4[n16] - this.kdata[n17 + n20];
                            if (f3 < f2) {
                                f2 = f3;
                            }
                            n16 += n7;
                            ++n20;
                        }
                        n17 += this.kw;
                        n18 += n8;
                        ++n19;
                    }
                    if (Float.isInfinite(f2)) {
                        f2 = 0.0f;
                    }
                    if ((n16 = (int)f2) < Short.MIN_VALUE) {
                        n16 = Short.MIN_VALUE;
                    } else if (n16 > Short.MAX_VALUE) {
                        n16 = Short.MAX_VALUE;
                    }
                    sArray3[n14] = (short)n16;
                    n13 += n7;
                    n14 += n5;
                    ++n15;
                }
                n10 += n8;
                n11 += n6;
                ++n12;
            }
            ++n9;
        }
    }

    private void ushortLoop(RasterAccessor rasterAccessor, RasterAccessor rasterAccessor2) {
        int n2 = rasterAccessor2.getWidth();
        int n3 = rasterAccessor2.getHeight();
        int n4 = rasterAccessor2.getNumBands();
        int[] nArray = rasterAccessor2.getBandOffsets();
        int n5 = rasterAccessor2.getPixelStride();
        int n6 = rasterAccessor2.getScanlineStride();
        int[] nArray2 = rasterAccessor.getBandOffsets();
        int n7 = rasterAccessor.getPixelStride();
        int n8 = rasterAccessor.getScanlineStride();
        short[][] sArray = rasterAccessor2.getShortDataArrays();
        short[][] sArray2 = rasterAccessor.getShortDataArrays();
        int n9 = 0;
        while (n9 < n4) {
            short[] sArray3 = sArray[n9];
            short[] sArray4 = sArray2[n9];
            int n10 = nArray2[n9];
            int n11 = nArray[n9];
            int n12 = 0;
            while (n12 < n3) {
                int n13 = n10;
                int n14 = n11;
                int n15 = 0;
                while (n15 < n2) {
                    int n16;
                    int n17 = 0;
                    int n18 = n13;
                    float f2 = Float.POSITIVE_INFINITY;
                    int n19 = 0;
                    while (n19 < this.kh) {
                        n16 = n18;
                        int n20 = 0;
                        while (n20 < this.kw) {
                            float f3 = (float)(sArray4[n16] & 0xFFFF) - this.kdata[n17 + n20];
                            if (f3 < f2) {
                                f2 = f3;
                            }
                            n16 += n7;
                            ++n20;
                        }
                        n17 += this.kw;
                        n18 += n8;
                        ++n19;
                    }
                    if (Float.isInfinite(f2)) {
                        f2 = 0.0f;
                    }
                    if ((n16 = (int)f2) < 0) {
                        n16 = 0;
                    } else if (n16 > 65535) {
                        n16 = 65535;
                    }
                    sArray3[n14] = (short)n16;
                    n13 += n7;
                    n14 += n5;
                    ++n15;
                }
                n10 += n8;
                n11 += n6;
                ++n12;
            }
            ++n9;
        }
    }

    private void intLoop(RasterAccessor rasterAccessor, RasterAccessor rasterAccessor2) {
        int n2 = rasterAccessor2.getWidth();
        int n3 = rasterAccessor2.getHeight();
        int n4 = rasterAccessor2.getNumBands();
        int[] nArray = rasterAccessor2.getBandOffsets();
        int n5 = rasterAccessor2.getPixelStride();
        int n6 = rasterAccessor2.getScanlineStride();
        int[] nArray2 = rasterAccessor.getBandOffsets();
        int n7 = rasterAccessor.getPixelStride();
        int n8 = rasterAccessor.getScanlineStride();
        int[][] nArray3 = rasterAccessor2.getIntDataArrays();
        int[][] nArray4 = rasterAccessor.getIntDataArrays();
        int n9 = 0;
        while (n9 < n4) {
            int[] nArray5 = nArray3[n9];
            int[] nArray6 = nArray4[n9];
            int n10 = nArray2[n9];
            int n11 = nArray[n9];
            int n12 = 0;
            while (n12 < n3) {
                int n13 = n10;
                int n14 = n11;
                int n15 = 0;
                while (n15 < n2) {
                    int n16 = 0;
                    int n17 = n13;
                    float f2 = Float.POSITIVE_INFINITY;
                    int n18 = 0;
                    while (n18 < this.kh) {
                        int n19 = n17;
                        int n20 = 0;
                        while (n20 < this.kw) {
                            float f3 = (float)nArray6[n19] - this.kdata[n16 + n20];
                            if (f3 < f2) {
                                f2 = f3;
                            }
                            n19 += n7;
                            ++n20;
                        }
                        n16 += this.kw;
                        n17 += n8;
                        ++n18;
                    }
                    if (Float.isInfinite(f2)) {
                        f2 = 0.0f;
                    }
                    nArray5[n14] = (int)f2;
                    n13 += n7;
                    n14 += n5;
                    ++n15;
                }
                n10 += n8;
                n11 += n6;
                ++n12;
            }
            ++n9;
        }
    }

    private void floatLoop(RasterAccessor rasterAccessor, RasterAccessor rasterAccessor2) {
        int n2 = rasterAccessor2.getWidth();
        int n3 = rasterAccessor2.getHeight();
        int n4 = rasterAccessor2.getNumBands();
        int[] nArray = rasterAccessor2.getBandOffsets();
        int n5 = rasterAccessor2.getPixelStride();
        int n6 = rasterAccessor2.getScanlineStride();
        int[] nArray2 = rasterAccessor.getBandOffsets();
        int n7 = rasterAccessor.getPixelStride();
        int n8 = rasterAccessor.getScanlineStride();
        float[][] fArray = rasterAccessor2.getFloatDataArrays();
        float[][] fArray2 = rasterAccessor.getFloatDataArrays();
        int n9 = 0;
        while (n9 < n4) {
            float[] fArray3 = fArray[n9];
            float[] fArray4 = fArray2[n9];
            int n10 = nArray2[n9];
            int n11 = nArray[n9];
            int n12 = 0;
            while (n12 < n3) {
                int n13 = n10;
                int n14 = n11;
                int n15 = 0;
                while (n15 < n2) {
                    int n16 = 0;
                    int n17 = n13;
                    float f2 = Float.POSITIVE_INFINITY;
                    int n18 = 0;
                    while (n18 < this.kh) {
                        int n19 = n17;
                        int n20 = 0;
                        while (n20 < this.kw) {
                            float f3 = fArray4[n19] - this.kdata[n16 + n20];
                            if (f3 < f2) {
                                f2 = f3;
                            }
                            n19 += n7;
                            ++n20;
                        }
                        n16 += this.kw;
                        n17 += n8;
                        ++n18;
                    }
                    if (Float.isInfinite(f2)) {
                        f2 = 0.0f;
                    }
                    fArray3[n14] = f2;
                    n13 += n7;
                    n14 += n5;
                    ++n15;
                }
                n10 += n8;
                n11 += n6;
                ++n12;
            }
            ++n9;
        }
    }

    private void doubleLoop(RasterAccessor rasterAccessor, RasterAccessor rasterAccessor2) {
        int n2 = rasterAccessor2.getWidth();
        int n3 = rasterAccessor2.getHeight();
        int n4 = rasterAccessor2.getNumBands();
        int[] nArray = rasterAccessor2.getBandOffsets();
        int n5 = rasterAccessor2.getPixelStride();
        int n6 = rasterAccessor2.getScanlineStride();
        int[] nArray2 = rasterAccessor.getBandOffsets();
        int n7 = rasterAccessor.getPixelStride();
        int n8 = rasterAccessor.getScanlineStride();
        double[][] dArray = rasterAccessor2.getDoubleDataArrays();
        double[][] dArray2 = rasterAccessor.getDoubleDataArrays();
        int n9 = 0;
        while (n9 < n4) {
            double[] dArray3 = dArray[n9];
            double[] dArray4 = dArray2[n9];
            int n10 = nArray2[n9];
            int n11 = nArray[n9];
            int n12 = 0;
            while (n12 < n3) {
                int n13 = n10;
                int n14 = n11;
                int n15 = 0;
                while (n15 < n2) {
                    int n16 = 0;
                    int n17 = n13;
                    double d2 = Double.POSITIVE_INFINITY;
                    int n18 = 0;
                    while (n18 < this.kh) {
                        int n19 = n17;
                        int n20 = 0;
                        while (n20 < this.kw) {
                            double d3 = dArray4[n19] - (double)this.kdata[n16 + n20];
                            if (d3 < d2) {
                                d2 = d3;
                            }
                            n19 += n7;
                            ++n20;
                        }
                        n16 += this.kw;
                        n17 += n8;
                        ++n18;
                    }
                    if (Double.isInfinite(d2)) {
                        d2 = 0.0;
                    }
                    dArray3[n14] = d2;
                    n13 += n7;
                    n14 += n5;
                    ++n15;
                }
                n10 += n8;
                n11 += n6;
                ++n12;
            }
            ++n9;
        }
    }
}

