/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jai.opimage;

import com.sun.media.jai.opimage.JaiI18N;
import com.sun.media.jai.util.ImageUtil;
import com.sun.media.jai.util.JDKWorkarounds;
import java.awt.Rectangle;
import java.awt.image.ColorModel;
import java.awt.image.IndexColorModel;
import java.awt.image.MultiPixelPackedSampleModel;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import java.util.Map;
import javax.media.jai.ColorCube;
import javax.media.jai.ImageLayout;
import javax.media.jai.KernelJAI;
import javax.media.jai.LookupTableJAI;
import javax.media.jai.RasterAccessor;
import javax.media.jai.RasterFactory;
import javax.media.jai.RasterFormatTag;
import javax.media.jai.UntiledOpImage;

final class ErrorDiffusionOpImage
extends UntiledOpImage {
    private static final float FLOAT_EPSILON = 1.1920929E-7f;
    private static final int NBANDS = 3;
    private static final int NGRAYS = 256;
    private static final int OVERSHOOT = 256;
    private static final int UNDERSHOOT = 256;
    private static final int TOTALGRAYS = 768;
    private static final int ERR_SHIFT = 8;
    protected LookupTableJAI colorMap;
    protected KernelJAI errorKernel;
    private int numBandsSource;
    private boolean isOptimizedCase = false;
    private float minPixelValue;
    private float maxPixelValue;

    private static boolean isFloydSteinbergKernel(KernelJAI kernelJAI) {
        int n2 = kernelJAI.getYOrigin();
        return kernelJAI.getWidth() == 3 && kernelJAI.getXOrigin() == 1 && kernelJAI.getHeight() - n2 == 2 && Math.abs(kernelJAI.getElement(2, n2) - 0.4375f) < 1.1920929E-7f && Math.abs(kernelJAI.getElement(0, n2 + 1) - 0.1875f) < 1.1920929E-7f && Math.abs(kernelJAI.getElement(1, n2 + 1) - 0.3125f) < 1.1920929E-7f && Math.abs(kernelJAI.getElement(2, n2 + 1) - 0.0625f) < 1.1920929E-7f;
    }

    private static int[] initFloydSteinberg24To8(ColorCube colorCube) {
        int n2;
        int[] nArray = new int[2304];
        float[] fArray = new float[256];
        int[] nArray2 = colorCube.getMultipliers();
        int[] nArray3 = colorCube.getDimsLessOne();
        int n3 = colorCube.getAdjustedOffset();
        int n4 = 0;
        while (n4 < 3) {
            int n5;
            n2 = n4 * 768;
            float f2 = 255.0f / (float)nArray3[n4];
            int n6 = 0;
            while (n6 < nArray3[n4]) {
                fArray[n6] = ((float)n6 + 0.5f) * f2;
                ++n6;
            }
            fArray[nArray3[n4]] = 256.0f;
            int n7 = 256;
            int n8 = -65536;
            int n9 = -256;
            while (n9 < 0) {
                nArray[n2++] = n8;
                n8 += n7;
                ++n9;
            }
            int n10 = 0;
            float f3 = 0.0f;
            int n11 = 0;
            float f4 = fArray[0];
            int n12 = 0;
            while (n12 < 256) {
                int n13 = n10;
                n5 = (int)(f3 + 0.5f);
                while ((float)n12 < f4) {
                    nArray[n2++] = (n12 - n5 << 8) + n13;
                    ++n12;
                }
                f4 = fArray[++n11];
                n10 += nArray2[n4];
                f3 += f2;
            }
            n5 = 255;
            n8 = 256 - n5 << 8 | (n10 -= nArray2[n4]);
            n12 = 256;
            while (n12 < 512) {
                nArray[n2++] = n8;
                n8 += n7;
                ++n12;
            }
            ++n4;
        }
        n2 = 0;
        int n14 = 768;
        while (n14 != 0) {
            int n15 = n2++;
            nArray[n15] = nArray[n15] + n3;
            --n14;
        }
        return nArray;
    }

    private static ImageLayout layoutHelper(ImageLayout imageLayout, RenderedImage renderedImage, LookupTableJAI lookupTableJAI) {
        ColorModel colorModel;
        ImageLayout imageLayout2 = imageLayout == null ? new ImageLayout() : (ImageLayout)imageLayout.clone();
        imageLayout2.setMinX(renderedImage.getMinX());
        imageLayout2.setMinY(renderedImage.getMinY());
        imageLayout2.setWidth(renderedImage.getWidth());
        imageLayout2.setHeight(renderedImage.getHeight());
        SampleModel sampleModel = imageLayout2.getSampleModel(renderedImage);
        if (lookupTableJAI.getNumBands() == 1 && lookupTableJAI.getNumEntries() == 2 && !ImageUtil.isBinary(imageLayout2.getSampleModel(renderedImage))) {
            sampleModel = new MultiPixelPackedSampleModel(0, imageLayout2.getTileWidth(renderedImage), imageLayout2.getTileHeight(renderedImage), 1);
            imageLayout2.setSampleModel(sampleModel);
        }
        if (sampleModel.getNumBands() != 1) {
            sampleModel = RasterFactory.createComponentSampleModel(sampleModel, sampleModel.getTransferType(), sampleModel.getWidth(), sampleModel.getHeight(), 1);
            imageLayout2.setSampleModel(sampleModel);
            colorModel = imageLayout2.getColorModel(null);
            if (colorModel != null && !JDKWorkarounds.areCompatibleDataModels(sampleModel, colorModel)) {
                imageLayout2.unsetValid(512);
            }
        }
        if ((imageLayout == null || !imageLayout2.isValid(512)) && renderedImage.getSampleModel().getDataType() == 0 && sampleModel.getDataType() == 0 && lookupTableJAI.getDataType() == 0 && lookupTableJAI.getNumBands() == 3 && ((colorModel = renderedImage.getColorModel()) == null || colorModel != null && colorModel.getColorSpace().isCS_sRGB())) {
            int n2 = lookupTableJAI.getNumEntries();
            byte[][] byArray = new byte[3][256];
            int n3 = 0;
            while (n3 < 3) {
                byte[] byArray2 = byArray[n3];
                byte[] byArray3 = lookupTableJAI.getByteData(n3);
                int n4 = lookupTableJAI.getOffset(n3);
                int n5 = n4 + n2;
                int n6 = 0;
                while (n6 < n4) {
                    byArray2[n6] = 0;
                    ++n6;
                }
                int n7 = n4;
                while (n7 < n5) {
                    byArray2[n7] = byArray3[n7 - n4];
                    ++n7;
                }
                int n8 = n5;
                while (n8 < 256) {
                    byArray2[n8] = -1;
                    ++n8;
                }
                ++n3;
            }
            imageLayout2.setColorModel(new IndexColorModel(8, 256, byArray[0], byArray[1], byArray[2]));
        }
        return imageLayout2;
    }

    public ErrorDiffusionOpImage(RenderedImage renderedImage, Map map, ImageLayout imageLayout, LookupTableJAI lookupTableJAI, KernelJAI kernelJAI) {
        super(renderedImage, map, ErrorDiffusionOpImage.layoutHelper(imageLayout, renderedImage, lookupTableJAI));
        SampleModel sampleModel = renderedImage.getSampleModel();
        this.numBandsSource = sampleModel.getNumBands();
        this.colorMap = lookupTableJAI;
        this.errorKernel = kernelJAI;
        this.isOptimizedCase = this.sampleModel.getTransferType() == 0 && sampleModel.getTransferType() == 0 && this.numBandsSource == 3 && lookupTableJAI instanceof ColorCube && ErrorDiffusionOpImage.isFloydSteinbergKernel(kernelJAI);
        switch (lookupTableJAI.getDataType()) {
            case 0: {
                this.minPixelValue = 0.0f;
                this.maxPixelValue = 255.0f;
                break;
            }
            case 2: {
                this.minPixelValue = -32768.0f;
                this.maxPixelValue = 32767.0f;
                break;
            }
            case 1: {
                this.minPixelValue = 0.0f;
                this.maxPixelValue = 65535.0f;
                break;
            }
            case 3: {
                this.minPixelValue = -2.1474836E9f;
                this.maxPixelValue = 2.1474836E9f;
                break;
            }
            case 4: {
                this.minPixelValue = 0.0f;
                this.maxPixelValue = Float.MAX_VALUE;
                break;
            }
            case 5: {
                this.minPixelValue = 0.0f;
                this.maxPixelValue = Float.MAX_VALUE;
                break;
            }
            default: {
                throw new RuntimeException(JaiI18N.getString("ErrorDiffusionOpImage0"));
            }
        }
    }

    protected void computeImage(Raster[] rasterArray, WritableRaster writableRaster, Rectangle rectangle) {
        Raster raster = rasterArray[0];
        if (this.isOptimizedCase) {
            this.computeImageOptimized(raster, writableRaster, rectangle);
        } else {
            this.computeImageDefault(raster, writableRaster, rectangle);
        }
    }

    protected void computeImageDefault(Raster raster, WritableRaster writableRaster, Rectangle rectangle) {
        int n2 = this.minX;
        int n3 = n2 + this.width - 1;
        int n4 = this.minY;
        int n5 = n4 + this.height - 1;
        int n6 = this.errorKernel.getHeight() - this.errorKernel.getYOrigin();
        float[][] fArray = new float[n6][this.width * this.numBandsSource];
        int[] nArray = new int[n6];
        int n7 = 0;
        while (n7 < n6) {
            nArray[n7] = n7;
            raster.getPixels(n2, n4 + n7, this.width, 1, fArray[n7]);
            ++n7;
        }
        int n8 = n6 - 1;
        int n9 = this.errorKernel.getWidth();
        float[] fArray2 = this.errorKernel.getKernelData();
        int n10 = n9 - this.errorKernel.getXOrigin() - 1;
        int n11 = this.errorKernel.getHeight() - this.errorKernel.getYOrigin() - 1;
        int n12 = this.errorKernel.getYOrigin() * n9 + this.errorKernel.getXOrigin() + 1;
        int n13 = (this.errorKernel.getYOrigin() + 1) * n9;
        float[] fArray3 = new float[this.numBandsSource];
        int n14 = this.colorMap.getOffset();
        float[] fArray4 = new float[this.numBandsSource];
        int[] nArray2 = new int[this.width];
        int n15 = n4;
        while (n15 <= n5) {
            int n16;
            int n17 = nArray[0];
            float[] fArray5 = fArray[n17];
            int n18 = 0;
            int n19 = n2;
            int n20 = 0;
            while (n19 <= n3) {
                n16 = 0;
                while (n16 < this.numBandsSource) {
                    fArray3[n16] = fArray5[n20++];
                    if (fArray3[n16] < this.minPixelValue || fArray3[n16] > this.maxPixelValue) {
                        fArray3[n16] = Math.max(fArray3[n16], this.minPixelValue);
                        fArray3[n16] = Math.min(fArray3[n16], this.maxPixelValue);
                    }
                    ++n16;
                }
                int n21 = this.colorMap.findNearestEntry(fArray3);
                nArray2[n18++] = n21;
                boolean bl2 = false;
                int n22 = 0;
                while (n22 < this.numBandsSource) {
                    fArray4[n22] = fArray3[n22] - this.colorMap.lookupFloat(n22, n21);
                    if (fArray4[n22] != 0.0f) {
                        bl2 = true;
                    }
                    ++n22;
                }
                if (bl2) {
                    int n23;
                    int n24 = Math.min(n10, n3 - n19);
                    int n25 = n12;
                    int n26 = n20;
                    int n27 = 1;
                    while (n27 <= n24) {
                        n23 = 0;
                        while (n23 < this.numBandsSource) {
                            int n28 = n26++;
                            fArray5[n28] = fArray5[n28] + fArray4[n23] * fArray2[n25];
                            ++n23;
                        }
                        ++n25;
                        ++n27;
                    }
                    n23 = Math.min(n19 - n2, n10);
                    int n29 = Math.min(n19 + n10, n3) - Math.max(n19 - n10, n2) + 1;
                    int n30 = 1;
                    while (n30 <= n11) {
                        float[] fArray6 = fArray[nArray[n30]];
                        n25 = n13;
                        n26 = n20 - (n23 + 1) * this.numBandsSource;
                        int n31 = 1;
                        while (n31 <= n29) {
                            int n32 = 0;
                            while (n32 < this.numBandsSource) {
                                int n33 = n26++;
                                fArray6[n33] = fArray6[n33] + fArray4[n32] * fArray2[n25];
                                ++n32;
                            }
                            ++n25;
                            ++n31;
                        }
                        ++n30;
                    }
                }
                ++n19;
            }
            writableRaster.setSamples(n2, n15, rectangle.width, 1, 0, nArray2);
            n16 = 0;
            while (n16 < n8) {
                nArray[n16] = nArray[n16 + 1];
                ++n16;
            }
            nArray[n8] = n17;
            if (n15 + n6 < this.getMaxY()) {
                raster.getPixels(n2, n15 + n6, this.width, 1, fArray[nArray[n8]]);
            }
            ++n15;
        }
    }

    protected void computeImageOptimized(Raster raster, WritableRaster writableRaster, Rectangle rectangle) {
        int n2 = this.minX;
        int n3 = n2 + this.width - 1;
        int n4 = this.minY;
        int n5 = n4 + this.height - 1;
        int[] nArray = ErrorDiffusionOpImage.initFloydSteinberg24To8((ColorCube)this.colorMap);
        int n6 = raster.getWidth() + 2;
        int[] nArray2 = new int[n6 * 3];
        RasterFormatTag[] rasterFormatTagArray = this.getFormatTags();
        RasterAccessor rasterAccessor = new RasterAccessor(raster, new Rectangle(n2, n4, raster.getWidth(), raster.getHeight()), rasterFormatTagArray[0], this.getSourceImage(0).getColorModel());
        RasterAccessor rasterAccessor2 = new RasterAccessor(writableRaster, rectangle, rasterFormatTagArray[1], this.getColorModel());
        int n7 = rasterAccessor.getPixelStride();
        int n8 = rasterAccessor.getScanlineStride();
        int n9 = rasterAccessor2.getPixelStride();
        int n10 = rasterAccessor2.getScanlineStride();
        byte[] byArray = rasterAccessor.getByteDataArray(0);
        byte[] byArray2 = rasterAccessor.getByteDataArray(1);
        byte[] byArray3 = rasterAccessor.getByteDataArray(2);
        byte[] byArray4 = rasterAccessor2.getByteDataArray(0);
        int n11 = rasterAccessor.getBandOffset(0);
        int n12 = rasterAccessor.getBandOffset(1);
        int n13 = rasterAccessor.getBandOffset(2);
        int n14 = rasterAccessor2.getBandOffset(0);
        int n15 = n4;
        while (n15 <= n5) {
            int n16;
            int n17 = n11;
            int n18 = n12;
            int n19 = n13;
            int n20 = n14;
            int n21 = 0;
            int n22 = 0;
            int n23 = 0;
            int n24 = 0;
            int n25 = 0;
            int n26 = 0;
            int n27 = 0;
            int n28 = 0;
            int n29 = 0;
            int n30 = 0;
            boolean bl2 = false;
            int n31 = n2;
            while (n31 <= n3) {
                int n32;
                n16 = 256;
                int n33 = (n21 + nArray2[n30 + 3] + 8 >> 4) + (byArray[n17] & 0xFF);
                n17 += n7;
                int n34 = nArray[n16 + n33];
                int n35 = n32 = n34 >> 8;
                int n36 = n34 & 0xFF;
                int n37 = n32 + n32;
                nArray2[n30] = n22 + (n32 += n37);
                n22 = n23 + (n32 += n37);
                n23 = n35;
                n21 = n32 += n37;
                n33 = (n24 + nArray2[n30 + 4] + 8 >> 4) + (byArray2[n18] & 0xFF);
                n18 += n7;
                n34 = nArray[(n16 += 768) + n33];
                n35 = n32 = n34 >> 8;
                n36 += n34 & 0xFF;
                n37 = n32 + n32;
                nArray2[n30 + 1] = n25 + (n32 += n37);
                n25 = n26 + (n32 += n37);
                n26 = n35;
                n24 = n32 += n37;
                n33 = (n27 + nArray2[n30 + 5] + 8 >> 4) + (byArray3[n19] & 0xFF);
                n19 += n7;
                n34 = nArray[(n16 += 768) + n33];
                n35 = n32 = n34 >> 8;
                n36 += n34 & 0xFF;
                n37 = n32 + n32;
                nArray2[n30 + 2] = n28 + (n32 += n37);
                n28 = n29 + (n32 += n37);
                n29 = n35;
                n27 = n32 += n37;
                byArray4[n20] = (byte)(n36 & 0xFF);
                n20 += n9;
                n30 += 3;
                ++n31;
            }
            n16 = 3 * (n6 - 2);
            nArray2[n16] = n22;
            nArray2[n16 + 1] = n25;
            nArray2[n16 + 2] = n28;
            n11 += n8;
            n12 += n8;
            n13 += n8;
            n14 += n10;
            ++n15;
        }
        rasterAccessor2.copyDataToRaster();
    }
}

