/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jai.opimage;

import com.sun.media.jai.opimage.JaiI18N;
import com.sun.media.jai.util.MathJAI;
import java.text.NumberFormat;
import java.util.Arrays;
import java.util.Locale;
import javax.media.jai.operator.DFTDescriptor;

public class FFT {
    public static final int SCALING_NONE = DFTDescriptor.SCALING_NONE.getValue();
    public static final int SCALING_UNITARY = DFTDescriptor.SCALING_UNITARY.getValue();
    public static final int SCALING_DIMENSIONS = DFTDescriptor.SCALING_DIMENSIONS.getValue();
    protected boolean lengthIsSet = false;
    protected int exponentSign;
    protected int scaleType;
    protected int length;
    private int nbits;
    private int[] index;
    private double scaleFactor;
    private double[] wr;
    private double[] wi;
    private double[] wrFCT;
    private double[] wiFCT;
    protected double[] real;
    protected double[] imag;

    public FFT(boolean bl2, Integer n2, int n3) {
        this.exponentSign = bl2 ? -1 : 1;
        this.scaleType = n2;
        this.setLength(n3);
    }

    public void setLength(int n2) {
        if (this.lengthIsSet && n2 == this.length) {
            return;
        }
        if (!MathJAI.isPositivePowerOf2(n2)) {
            throw new RuntimeException(JaiI18N.getString("FFT0"));
        }
        this.length = n2;
        if (this.scaleType == SCALING_NONE) {
            this.scaleFactor = 1.0;
        } else if (this.scaleType == SCALING_UNITARY) {
            this.scaleFactor = 1.0 / Math.sqrt(n2);
        } else if (this.scaleType == SCALING_DIMENSIONS) {
            this.scaleFactor = 1.0 / (double)n2;
        } else {
            throw new RuntimeException(JaiI18N.getString("FFT1"));
        }
        int n3 = 1;
        this.nbits = 0;
        while (n3 < n2) {
            ++this.nbits;
            n3 <<= 1;
        }
        this.initBitReversalLUT();
        this.calculateCoefficientLUTs();
        if (!this.lengthIsSet || n2 > this.real.length) {
            this.real = new double[n2];
            this.imag = new double[n2];
        }
        this.lengthIsSet = true;
    }

    private void initBitReversalLUT() {
        this.index = new int[this.length];
        int n2 = 0;
        while (n2 < this.length) {
            int n3 = n2;
            int n4 = this.length >> 1;
            int n5 = 0;
            int n6 = 0;
            while (n6 < this.nbits) {
                int n7 = n3 & 1;
                if (n7 != 0) {
                    n5 += n4;
                }
                n3 >>= 1;
                n4 >>= 1;
                this.index[n2] = n5;
                ++n6;
            }
            ++n2;
        }
    }

    private void calculateCoefficientLUTs() {
        this.wr = new double[this.nbits];
        this.wi = new double[this.nbits];
        int n2 = 1;
        double d2 = (double)this.exponentSign * Math.PI;
        int n3 = 0;
        while (n3 < this.nbits) {
            this.wr[n3] = Math.cos(d2 / (double)n2);
            this.wi[n3] = Math.sin(d2 / (double)n2);
            n2 *= 2;
            ++n3;
        }
    }

    private void calculateFCTLUTs() {
        this.wrFCT = new double[this.length];
        this.wiFCT = new double[this.length];
        int n2 = 0;
        while (n2 < this.length) {
            double d2 = n2 == 0 ? Math.sqrt(1.0 / (double)this.length) : Math.sqrt(2.0 / (double)this.length);
            double d3 = Math.PI * (double)n2 / (2.0 * (double)this.length);
            this.wrFCT[n2] = d2 * Math.cos(d3);
            this.wiFCT[n2] = d2 * Math.sin(d3);
            ++n2;
        }
    }

    public void setData(int n2, Object object, int n3, int n4, Object object2, int n5, int n6, int n7) {
        switch (n2) {
            case 4: {
                float[] fArray = (float[])object;
                if (object2 != null) {
                    float[] fArray2 = (float[])object2;
                    if (n3 == n5 && n4 == n6) {
                        int n8 = 0;
                        while (n8 < n7) {
                            this.real[n8] = fArray[n3];
                            this.imag[n8] = fArray2[n3];
                            n3 += n4;
                            ++n8;
                        }
                    } else {
                        int n9 = 0;
                        while (n9 < n7) {
                            this.real[n9] = fArray[n3];
                            this.imag[n9] = fArray2[n5];
                            n3 += n4;
                            n5 += n6;
                            ++n9;
                        }
                    }
                } else {
                    int n10 = 0;
                    while (n10 < n7) {
                        this.real[n10] = fArray[n3];
                        n3 += n4;
                        ++n10;
                    }
                }
                break;
            }
            case 5: {
                double[] dArray = (double[])object;
                if (n4 == 1 && n6 == 1) {
                    System.arraycopy(dArray, n3, this.real, 0, n7);
                    if (object2 == null) break;
                    System.arraycopy((double[])object2, n5, this.imag, 0, n7);
                    break;
                }
                if (object2 != null) {
                    double[] dArray2 = (double[])object2;
                    if (n3 == n5 && n4 == n6) {
                        int n11 = 0;
                        while (n11 < n7) {
                            this.real[n11] = dArray[n3];
                            this.imag[n11] = dArray2[n3];
                            n3 += n4;
                            ++n11;
                        }
                    } else {
                        int n12 = 0;
                        while (n12 < n7) {
                            this.real[n12] = dArray[n3];
                            this.imag[n12] = dArray2[n5];
                            n3 += n4;
                            n5 += n6;
                            ++n12;
                        }
                    }
                } else {
                    int n13 = 0;
                    while (n13 < n7) {
                        this.real[n13] = dArray[n3];
                        n3 += n4;
                        ++n13;
                    }
                }
                break;
            }
            default: {
                throw new RuntimeException(n2 + JaiI18N.getString("FFT2"));
            }
        }
        if (n7 < this.length) {
            Arrays.fill(this.real, n7, this.length, 0.0);
            if (object2 != null) {
                Arrays.fill(this.imag, n7, this.length, 0.0);
            }
        }
        if (object2 == null) {
            Arrays.fill(this.imag, 0, this.length, 0.0);
        }
    }

    public void getData(int n2, Object object, int n3, int n4, Object object2, int n5, int n6) {
        switch (n2) {
            case 4: {
                float[] fArray = (float[])object;
                if (object2 != null) {
                    float[] fArray2 = (float[])object2;
                    if (n3 == n5 && n4 == n6) {
                        int n7 = 0;
                        while (n7 < this.length) {
                            int n8 = this.index[n7];
                            fArray[n3] = (float)this.real[n8];
                            fArray2[n3] = (float)this.imag[n8];
                            n3 += n4;
                            ++n7;
                        }
                    } else {
                        int n9 = 0;
                        while (n9 < this.length) {
                            int n10 = this.index[n9];
                            fArray[n3] = (float)this.real[n10];
                            fArray2[n5] = (float)this.imag[n10];
                            n3 += n4;
                            n5 += n6;
                            ++n9;
                        }
                    }
                } else {
                    int n11 = 0;
                    while (n11 < this.length) {
                        fArray[n3] = (float)this.real[this.index[n11]];
                        n3 += n4;
                        ++n11;
                    }
                }
                break;
            }
            case 5: {
                double[] dArray = (double[])object;
                if (object2 != null) {
                    double[] dArray2 = (double[])object2;
                    if (n3 == n5 && n4 == n6) {
                        int n12 = 0;
                        while (n12 < this.length) {
                            int n13 = this.index[n12];
                            dArray[n3] = this.real[n13];
                            dArray2[n3] = this.imag[n13];
                            n3 += n4;
                            ++n12;
                        }
                    } else {
                        int n14 = 0;
                        while (n14 < this.length) {
                            int n15 = this.index[n14];
                            dArray[n3] = this.real[n15];
                            dArray2[n5] = this.imag[n15];
                            n3 += n4;
                            n5 += n6;
                            ++n14;
                        }
                    }
                } else {
                    int n16 = 0;
                    while (n16 < this.length) {
                        dArray[n3] = this.real[this.index[n16]];
                        n3 += n4;
                        ++n16;
                    }
                }
                break;
            }
            default: {
                throw new RuntimeException(n2 + JaiI18N.getString("FFT2"));
            }
        }
    }

    public void setFCTData(int n2, Object object, int n3, int n4, int n5) {
        switch (n2) {
            case 4: {
                float[] fArray = (float[])object;
                int n6 = 0;
                while (n6 < n5) {
                    this.imag[n6] = fArray[n3];
                    n3 += n4;
                    ++n6;
                }
                int n7 = n5;
                while (n7 < this.length) {
                    this.imag[n7] = 0.0;
                    ++n7;
                }
                int n8 = this.length - 1;
                int n9 = 0;
                int n10 = 0;
                while (n10 < n8) {
                    this.real[n10] = this.imag[n9++];
                    this.real[n8--] = this.imag[n9++];
                    ++n10;
                }
                break;
            }
            case 5: {
                double[] dArray = (double[])object;
                int n11 = 0;
                while (n11 < n5) {
                    this.imag[n11] = dArray[n3];
                    n3 += n4;
                    ++n11;
                }
                int n12 = n5;
                while (n12 < this.length) {
                    this.imag[n12] = 0.0;
                    ++n12;
                }
                int n13 = this.length - 1;
                int n14 = 0;
                int n15 = 0;
                while (n15 < n13) {
                    this.real[n15] = this.imag[n14++];
                    this.real[n13--] = this.imag[n14++];
                    ++n15;
                }
                break;
            }
            default: {
                throw new RuntimeException(n2 + JaiI18N.getString("FFT2"));
            }
        }
        Arrays.fill(this.imag, 0, this.length, 0.0);
    }

    public void getFCTData(int n2, Object object, int n3, int n4) {
        if (this.wrFCT == null || this.wrFCT.length != this.length) {
            this.calculateFCTLUTs();
        }
        switch (n2) {
            case 4: {
                float[] fArray = (float[])object;
                int n5 = 0;
                while (n5 < this.length) {
                    int n6 = this.index[n5];
                    fArray[n3] = (float)(this.wrFCT[n5] * this.real[n6] + this.wiFCT[n5] * this.imag[n6]);
                    n3 += n4;
                    ++n5;
                }
                break;
            }
            case 5: {
                double[] dArray = (double[])object;
                int n7 = 0;
                while (n7 < this.length) {
                    int n8 = this.index[n7];
                    dArray[n3] = this.wrFCT[n7] * this.real[n8] + this.wiFCT[n7] * this.imag[n8];
                    n3 += n4;
                    ++n7;
                }
                break;
            }
            default: {
                throw new RuntimeException(n2 + JaiI18N.getString("FFT2"));
            }
        }
    }

    public void setIFCTData(int n2, Object object, int n3, int n4, int n5) {
        if (this.wrFCT == null || this.wrFCT.length != this.length) {
            this.calculateFCTLUTs();
        }
        switch (n2) {
            case 4: {
                float[] fArray = (float[])object;
                int n6 = 0;
                while (n6 < n5) {
                    float f2 = fArray[n3];
                    this.real[n6] = (double)f2 * this.wrFCT[n6];
                    this.imag[n6] = (double)f2 * this.wiFCT[n6];
                    n3 += n4;
                    ++n6;
                }
                break;
            }
            case 5: {
                double[] dArray = (double[])object;
                int n7 = 0;
                while (n7 < n5) {
                    double d2 = dArray[n3];
                    this.real[n7] = d2 * this.wrFCT[n7];
                    this.imag[n7] = d2 * this.wiFCT[n7];
                    n3 += n4;
                    ++n7;
                }
                break;
            }
            default: {
                throw new RuntimeException(n2 + JaiI18N.getString("FFT2"));
            }
        }
        if (n5 < this.length) {
            Arrays.fill(this.real, n5, this.length, 0.0);
            Arrays.fill(this.imag, n5, this.length, 0.0);
        }
    }

    public void getIFCTData(int n2, Object object, int n3, int n4) {
        switch (n2) {
            case 4: {
                float[] fArray = (float[])object;
                int n5 = this.length - 1;
                int n6 = 0;
                while (n6 < n5) {
                    fArray[n3] = (float)this.real[this.index[n6]];
                    fArray[n3 += n4] = (float)this.real[this.index[n5--]];
                    n3 += n4;
                    ++n6;
                }
                break;
            }
            case 5: {
                double[] dArray = (double[])object;
                int n7 = this.length - 1;
                int n8 = 0;
                while (n8 < n7) {
                    dArray[n3] = (float)this.real[this.index[n8]];
                    dArray[n3 += n4] = (float)this.real[this.index[n7--]];
                    n3 += n4;
                    ++n8;
                }
                break;
            }
            default: {
                throw new RuntimeException(n2 + JaiI18N.getString("FFT2"));
            }
        }
    }

    public void transform() {
        int n2;
        Integer n3 = new Integer(this.length);
        NumberFormat numberFormat = NumberFormat.getNumberInstance(Locale.getDefault());
        if (this.real.length < this.length || this.imag.length < this.length) {
            throw new RuntimeException(numberFormat.format(n3) + JaiI18N.getString("FFT3"));
        }
        int n4 = 1;
        int n5 = 0;
        while (n5 < this.nbits) {
            double d2 = 1.0;
            double d3 = 0.0;
            int n6 = 2 * n4;
            int n7 = 0;
            while (n7 < n4) {
                n2 = n7;
                while (n2 < this.length) {
                    int n8 = n2 + n4;
                    int n9 = this.index[n2];
                    int n10 = this.index[n8];
                    double d4 = this.real[n10] * d2 - this.imag[n10] * d3;
                    double d5 = this.imag[n10] * d2 + this.real[n10] * d3;
                    this.real[n10] = this.real[n9] - d4;
                    this.imag[n10] = this.imag[n9] - d5;
                    this.real[n9] = this.real[n9] + d4;
                    this.imag[n9] = this.imag[n9] + d5;
                    n2 += n6;
                }
                double d6 = d2;
                d2 = d2 * this.wr[n5] - d3 * this.wi[n5];
                d3 = d6 * this.wi[n5] + d3 * this.wr[n5];
                ++n7;
            }
            n4 *= 2;
            ++n5;
        }
        if (this.scaleFactor != 1.0) {
            n2 = 0;
            while (n2 < this.length) {
                this.real[n2] = this.real[n2] * this.scaleFactor;
                this.imag[n2] = this.imag[n2] * this.scaleFactor;
                ++n2;
            }
        }
    }
}

