/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jai.opimage;

import java.awt.RenderingHints;
import java.awt.image.RenderedImage;
import java.awt.image.renderable.ParameterBlock;
import java.util.Arrays;
import javax.media.jai.CRIFImpl;
import javax.media.jai.JAI;
import javax.media.jai.KernelJAI;

final class FilterCRIF
extends CRIFImpl {
    private static final int STEPSIZE = 5;

    private static final KernelJAI createKernel(double d2) {
        float[] fArray;
        int n2;
        int n3 = 5;
        if (d2 == 0.0) {
            return null;
        }
        double d3 = Math.abs(d2);
        int n4 = (int)d3 / n3;
        double d4 = (double)(10.0f / (float)n3) * (d3 - (double)(n4 * n3));
        double d5 = 0.010101010101010102 * (Math.pow(10.0, 0.2 * d4) - 1.0);
        if ((double)(n4 * n3) == d3) {
            n2 = 2 * n4 + 1;
            fArray = new float[n2 * n2];
            float f2 = 1.0f / (float)(n2 * n2);
            Arrays.fill(fArray, f2);
        } else {
            int n5 = 2 * n4 + 1;
            n2 = n5 + 2;
            fArray = new float[n2 * n2];
            float f3 = 1.0f / (float)(n5 * n5) * (1.0f - (float)d5);
            int n6 = n2;
            int n7 = 1;
            while (n7 < n2 - 1) {
                int n8 = 1;
                while (n8 < n2 - 1) {
                    fArray[n6 + n8] = f3;
                    ++n8;
                }
                n6 += n2;
                ++n7;
            }
            float f4 = 1.0f / (float)(n2 * n2) * (float)d5;
            int n9 = 0;
            while (n9 < fArray.length) {
                int n10 = n9++;
                fArray[n10] = fArray[n10] + f4;
            }
        }
        if (d2 > 0.0) {
            int n11 = 0;
            while (n11 < fArray.length) {
                int n12 = n11++;
                fArray[n12] = (float)((double)fArray[n12] * -1.0);
            }
            int n13 = fArray.length / 2;
            fArray[n13] = fArray[n13] + 2.0f;
        }
        return new KernelJAI(n2, n2, fArray);
    }

    public RenderedImage create(ParameterBlock parameterBlock, RenderingHints renderingHints) {
        KernelJAI kernelJAI = FilterCRIF.createKernel(parameterBlock.getFloatParameter(0));
        return kernelJAI == null ? parameterBlock.getRenderedSource(0) : JAI.create("convolve", parameterBlock.getRenderedSource(0), (Object)kernelJAI);
    }
}

