/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jai.opimage;

import com.sun.media.jai.opimage.CopyOpImage;
import com.sun.media.jai.opimage.RIFUtil;
import com.sun.media.jai.util.JDKWorkarounds;
import java.awt.RenderingHints;
import java.awt.image.ColorModel;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.awt.image.renderable.ParameterBlock;
import java.util.Map;
import javax.media.jai.CRIFImpl;
import javax.media.jai.ImageLayout;
import javax.media.jai.JAI;
import javax.media.jai.NullOpImage;
import javax.media.jai.RasterFactory;

public class FormatCRIF
extends CRIFImpl {
    public FormatCRIF() {
        super("format");
    }

    public RenderedImage create(ParameterBlock parameterBlock, RenderingHints renderingHints) {
        ColorModel colorModel;
        RenderedImage renderedImage = parameterBlock.getRenderedSource(0);
        Integer n2 = (Integer)parameterBlock.getObjectParameter(0);
        int n3 = n2;
        ImageLayout imageLayout = RIFUtil.getImageLayoutHint(renderingHints);
        if (imageLayout == null && n3 == renderedImage.getSampleModel().getDataType()) {
            return renderedImage;
        }
        imageLayout = imageLayout == null ? new ImageLayout(renderedImage) : (ImageLayout)imageLayout.clone();
        boolean bl2 = false;
        SampleModel sampleModel = imageLayout.getSampleModel(renderedImage);
        if (sampleModel.getDataType() != n3) {
            int n4 = imageLayout.getTileWidth(renderedImage);
            int n5 = imageLayout.getTileHeight(renderedImage);
            int n6 = renderedImage.getSampleModel().getNumBands();
            SampleModel sampleModel2 = RasterFactory.createComponentSampleModel(sampleModel, n3, n4, n5, n6);
            imageLayout.setSampleModel(sampleModel2);
            bl2 = true;
        }
        if ((colorModel = imageLayout.getColorModel(null)) != null && !JDKWorkarounds.areCompatibleDataModels(imageLayout.getSampleModel(renderedImage), colorModel)) {
            imageLayout.unsetValid(512);
        }
        if (imageLayout.getSampleModel(renderedImage) == renderedImage.getSampleModel() && imageLayout.getMinX(renderedImage) == renderedImage.getMinX() && imageLayout.getMinY(renderedImage) == renderedImage.getMinY() && imageLayout.getWidth(renderedImage) == renderedImage.getWidth() && imageLayout.getHeight(renderedImage) == renderedImage.getHeight() && imageLayout.getTileWidth(renderedImage) == renderedImage.getTileWidth() && imageLayout.getTileHeight(renderedImage) == renderedImage.getTileHeight() && imageLayout.getTileGridXOffset(renderedImage) == renderedImage.getTileGridXOffset() && imageLayout.getTileGridYOffset(renderedImage) == renderedImage.getTileGridYOffset()) {
            if (imageLayout.getColorModel(renderedImage) == renderedImage.getColorModel()) {
                return renderedImage;
            }
            RenderingHints renderingHints2 = renderingHints;
            if (renderingHints2 != null && renderingHints2.containsKey(JAI.KEY_TILE_CACHE)) {
                renderingHints2 = new RenderingHints(renderingHints);
                renderingHints2.remove(JAI.KEY_TILE_CACHE);
            }
            return new NullOpImage(renderedImage, imageLayout, (Map)renderingHints2, 2);
        }
        if (bl2) {
            if (renderingHints == null) {
                renderingHints = new RenderingHints(JAI.KEY_REPLACE_INDEX_COLOR_MODEL, Boolean.TRUE);
            } else if (!renderingHints.containsKey(JAI.KEY_REPLACE_INDEX_COLOR_MODEL)) {
                renderingHints.put(JAI.KEY_REPLACE_INDEX_COLOR_MODEL, Boolean.TRUE);
            }
        }
        return new CopyOpImage(renderedImage, renderingHints, imageLayout);
    }
}

