/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jai.opimage;

import java.awt.Rectangle;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.util.Map;
import javax.media.jai.AreaOpImage;
import javax.media.jai.BorderExtender;
import javax.media.jai.ImageLayout;
import javax.media.jai.KernelJAI;
import javax.media.jai.RasterAccessor;
import javax.media.jai.RasterFormatTag;

final class GradientOpImage
extends AreaOpImage {
    protected KernelJAI kernel_h;
    protected KernelJAI kernel_v;
    private int kw;
    private int kh;

    public GradientOpImage(RenderedImage renderedImage, BorderExtender borderExtender, Map map, ImageLayout imageLayout, KernelJAI kernelJAI, KernelJAI kernelJAI2) {
        super(renderedImage, imageLayout, map, true, borderExtender, kernelJAI.getLeftPadding(), kernelJAI.getRightPadding(), kernelJAI.getTopPadding(), kernelJAI.getBottomPadding());
        this.kernel_h = kernelJAI;
        this.kernel_v = kernelJAI2;
        this.kw = kernelJAI.getWidth();
        this.kh = kernelJAI.getHeight();
    }

    protected void computeRect(Raster[] rasterArray, WritableRaster writableRaster, Rectangle rectangle) {
        RasterFormatTag[] rasterFormatTagArray = this.getFormatTags();
        Raster raster = rasterArray[0];
        Rectangle rectangle2 = this.mapDestRect(rectangle, 0);
        RasterAccessor rasterAccessor = new RasterAccessor(raster, rectangle2, rasterFormatTagArray[0], this.getSourceImage(0).getColorModel());
        RasterAccessor rasterAccessor2 = new RasterAccessor(writableRaster, rectangle, rasterFormatTagArray[1], this.getColorModel());
        switch (rasterAccessor2.getDataType()) {
            case 0: {
                this.byteLoop(rasterAccessor, rasterAccessor2);
                break;
            }
            case 3: {
                this.intLoop(rasterAccessor, rasterAccessor2);
                break;
            }
            case 2: {
                this.shortLoop(rasterAccessor, rasterAccessor2);
                break;
            }
            case 1: {
                this.ushortLoop(rasterAccessor, rasterAccessor2);
                break;
            }
            case 4: {
                this.floatLoop(rasterAccessor, rasterAccessor2);
                break;
            }
            case 5: {
                this.doubleLoop(rasterAccessor, rasterAccessor2);
                break;
            }
        }
        if (rasterAccessor2.isDataCopy()) {
            rasterAccessor2.clampDataArrays();
            rasterAccessor2.copyDataToRaster();
        }
    }

    private void byteLoop(RasterAccessor rasterAccessor, RasterAccessor rasterAccessor2) {
        int n2 = rasterAccessor2.getWidth();
        int n3 = rasterAccessor2.getHeight();
        int n4 = rasterAccessor2.getNumBands();
        float[] fArray = this.kernel_h.getKernelData();
        float[] fArray2 = this.kernel_v.getKernelData();
        byte[][] byArray = rasterAccessor2.getByteDataArrays();
        int[] nArray = rasterAccessor2.getBandOffsets();
        int n5 = rasterAccessor2.getPixelStride();
        int n6 = rasterAccessor2.getScanlineStride();
        byte[][] byArray2 = rasterAccessor.getByteDataArrays();
        int[] nArray2 = rasterAccessor.getBandOffsets();
        int n7 = rasterAccessor.getPixelStride();
        int n8 = rasterAccessor.getScanlineStride();
        int n9 = 0;
        while (n9 < n4) {
            byte[] byArray3 = byArray[n9];
            byte[] byArray4 = byArray2[n9];
            int n10 = nArray2[n9];
            int n11 = nArray[n9];
            int n12 = 0;
            while (n12 < n3) {
                int n13 = n10;
                int n14 = n11;
                int n15 = 0;
                while (n15 < n2) {
                    float f2 = 0.0f;
                    float f3 = 0.0f;
                    int n16 = 0;
                    int n17 = n13;
                    int n18 = 0;
                    while (n18 < this.kh) {
                        int n19 = n17;
                        int n20 = 0;
                        while (n20 < this.kw) {
                            f2 += (float)(byArray4[n19] & 0xFF) * fArray[n16 + n20];
                            f3 += (float)(byArray4[n19] & 0xFF) * fArray2[n16 + n20];
                            n19 += n7;
                            ++n20;
                        }
                        n16 += this.kw;
                        n17 += n8;
                        ++n18;
                    }
                    float f4 = f2 * f2;
                    float f5 = f3 * f3;
                    float f6 = (float)Math.sqrt(f4 + f5);
                    int n21 = (int)(f6 + 0.5f);
                    if (n21 < 0) {
                        n21 = 0;
                    } else if (n21 > 255) {
                        n21 = 255;
                    }
                    byArray3[n14] = (byte)n21;
                    n13 += n7;
                    n14 += n5;
                    ++n15;
                }
                n10 += n8;
                n11 += n6;
                ++n12;
            }
            ++n9;
        }
    }

    private void shortLoop(RasterAccessor rasterAccessor, RasterAccessor rasterAccessor2) {
        int n2 = rasterAccessor2.getWidth();
        int n3 = rasterAccessor2.getHeight();
        int n4 = rasterAccessor2.getNumBands();
        float[] fArray = this.kernel_h.getKernelData();
        float[] fArray2 = this.kernel_v.getKernelData();
        short[][] sArray = rasterAccessor2.getShortDataArrays();
        int[] nArray = rasterAccessor2.getBandOffsets();
        int n5 = rasterAccessor2.getPixelStride();
        int n6 = rasterAccessor2.getScanlineStride();
        short[][] sArray2 = rasterAccessor.getShortDataArrays();
        int[] nArray2 = rasterAccessor.getBandOffsets();
        int n7 = rasterAccessor.getPixelStride();
        int n8 = rasterAccessor.getScanlineStride();
        int n9 = 0;
        while (n9 < n4) {
            short[] sArray3 = sArray[n9];
            short[] sArray4 = sArray2[n9];
            int n10 = nArray2[n9];
            int n11 = nArray[n9];
            int n12 = 0;
            while (n12 < n3) {
                int n13 = n10;
                int n14 = n11;
                int n15 = 0;
                while (n15 < n2) {
                    float f2 = 0.0f;
                    float f3 = 0.0f;
                    int n16 = 0;
                    int n17 = n13;
                    int n18 = 0;
                    while (n18 < this.kh) {
                        int n19 = n17;
                        int n20 = 0;
                        while (n20 < this.kw) {
                            f2 += (float)sArray4[n19] * fArray[n16 + n20];
                            f3 += (float)sArray4[n19] * fArray2[n16 + n20];
                            n19 += n7;
                            ++n20;
                        }
                        n16 += this.kw;
                        n17 += n8;
                        ++n18;
                    }
                    float f4 = f2 * f2;
                    float f5 = f3 * f3;
                    float f6 = (float)Math.sqrt(f4 + f5);
                    int n21 = (int)(f6 + 0.5f);
                    if (n21 < Short.MIN_VALUE) {
                        n21 = Short.MIN_VALUE;
                    } else if (n21 > Short.MAX_VALUE) {
                        n21 = Short.MAX_VALUE;
                    }
                    sArray3[n14] = (short)n21;
                    n13 += n7;
                    n14 += n5;
                    ++n15;
                }
                n10 += n8;
                n11 += n6;
                ++n12;
            }
            ++n9;
        }
    }

    private void ushortLoop(RasterAccessor rasterAccessor, RasterAccessor rasterAccessor2) {
        int n2 = rasterAccessor2.getWidth();
        int n3 = rasterAccessor2.getHeight();
        int n4 = rasterAccessor2.getNumBands();
        float[] fArray = this.kernel_h.getKernelData();
        float[] fArray2 = this.kernel_v.getKernelData();
        short[][] sArray = rasterAccessor2.getShortDataArrays();
        int[] nArray = rasterAccessor2.getBandOffsets();
        int n5 = rasterAccessor2.getPixelStride();
        int n6 = rasterAccessor2.getScanlineStride();
        short[][] sArray2 = rasterAccessor.getShortDataArrays();
        int[] nArray2 = rasterAccessor.getBandOffsets();
        int n7 = rasterAccessor.getPixelStride();
        int n8 = rasterAccessor.getScanlineStride();
        int n9 = 0;
        while (n9 < n4) {
            short[] sArray3 = sArray[n9];
            short[] sArray4 = sArray2[n9];
            int n10 = nArray2[n9];
            int n11 = nArray[n9];
            int n12 = 0;
            while (n12 < n3) {
                int n13 = n10;
                int n14 = n11;
                int n15 = 0;
                while (n15 < n2) {
                    float f2 = 0.0f;
                    float f3 = 0.0f;
                    int n16 = 0;
                    int n17 = n13;
                    int n18 = 0;
                    while (n18 < this.kh) {
                        int n19 = n17;
                        int n20 = 0;
                        while (n20 < this.kw) {
                            f2 += (float)(sArray4[n19] & 0xFFFF) * fArray[n16 + n20];
                            f3 += (float)(sArray4[n19] & 0xFFFF) * fArray2[n16 + n20];
                            n19 += n7;
                            ++n20;
                        }
                        n16 += this.kw;
                        n17 += n8;
                        ++n18;
                    }
                    float f4 = f2 * f2;
                    float f5 = f3 * f3;
                    float f6 = (float)Math.sqrt(f4 + f5);
                    int n21 = (int)(f6 + 0.5f);
                    if (n21 < 0) {
                        n21 = 0;
                    } else if (n21 > 65535) {
                        n21 = 65535;
                    }
                    sArray3[n14] = (short)n21;
                    n13 += n7;
                    n14 += n5;
                    ++n15;
                }
                n10 += n8;
                n11 += n6;
                ++n12;
            }
            ++n9;
        }
    }

    private void intLoop(RasterAccessor rasterAccessor, RasterAccessor rasterAccessor2) {
        int n2 = rasterAccessor2.getWidth();
        int n3 = rasterAccessor2.getHeight();
        int n4 = rasterAccessor2.getNumBands();
        float[] fArray = this.kernel_h.getKernelData();
        float[] fArray2 = this.kernel_v.getKernelData();
        int[][] nArray = rasterAccessor2.getIntDataArrays();
        int[] nArray2 = rasterAccessor2.getBandOffsets();
        int n5 = rasterAccessor2.getPixelStride();
        int n6 = rasterAccessor2.getScanlineStride();
        int[][] nArray3 = rasterAccessor.getIntDataArrays();
        int[] nArray4 = rasterAccessor.getBandOffsets();
        int n7 = rasterAccessor.getPixelStride();
        int n8 = rasterAccessor.getScanlineStride();
        int n9 = 0;
        while (n9 < n4) {
            int[] nArray5 = nArray[n9];
            int[] nArray6 = nArray3[n9];
            int n10 = nArray4[n9];
            int n11 = nArray2[n9];
            int n12 = 0;
            while (n12 < n3) {
                int n13 = n10;
                int n14 = n11;
                int n15 = 0;
                while (n15 < n2) {
                    float f2 = 0.0f;
                    float f3 = 0.0f;
                    int n16 = 0;
                    int n17 = n13;
                    int n18 = 0;
                    while (n18 < this.kh) {
                        int n19 = n17;
                        int n20 = 0;
                        while (n20 < this.kw) {
                            f2 += (float)nArray6[n19] * fArray[n16 + n20];
                            f3 += (float)nArray6[n19] * fArray2[n16 + n20];
                            n19 += n7;
                            ++n20;
                        }
                        n16 += this.kw;
                        n17 += n8;
                        ++n18;
                    }
                    float f4 = f2 * f2;
                    float f5 = f3 * f3;
                    float f6 = (float)Math.sqrt(f4 + f5);
                    nArray5[n14] = (int)(f6 + 0.5f);
                    n13 += n7;
                    n14 += n5;
                    ++n15;
                }
                n10 += n8;
                n11 += n6;
                ++n12;
            }
            ++n9;
        }
    }

    private void floatLoop(RasterAccessor rasterAccessor, RasterAccessor rasterAccessor2) {
        int n2 = rasterAccessor2.getWidth();
        int n3 = rasterAccessor2.getHeight();
        int n4 = rasterAccessor2.getNumBands();
        float[] fArray = this.kernel_h.getKernelData();
        float[] fArray2 = this.kernel_v.getKernelData();
        float[][] fArray3 = rasterAccessor2.getFloatDataArrays();
        int[] nArray = rasterAccessor2.getBandOffsets();
        int n5 = rasterAccessor2.getPixelStride();
        int n6 = rasterAccessor2.getScanlineStride();
        float[][] fArray4 = rasterAccessor.getFloatDataArrays();
        int[] nArray2 = rasterAccessor.getBandOffsets();
        int n7 = rasterAccessor.getPixelStride();
        int n8 = rasterAccessor.getScanlineStride();
        int n9 = 0;
        while (n9 < n4) {
            float[] fArray5 = fArray3[n9];
            float[] fArray6 = fArray4[n9];
            int n10 = nArray2[n9];
            int n11 = nArray[n9];
            int n12 = 0;
            while (n12 < n3) {
                int n13 = n10;
                int n14 = n11;
                int n15 = 0;
                while (n15 < n2) {
                    float f2;
                    float f3 = 0.0f;
                    float f4 = 0.0f;
                    int n16 = 0;
                    int n17 = n13;
                    int n18 = 0;
                    while (n18 < this.kh) {
                        int n19 = n17;
                        int n20 = 0;
                        while (n20 < this.kw) {
                            f3 += fArray6[n19] * fArray[n16 + n20];
                            f4 += fArray6[n19] * fArray2[n16 + n20];
                            n19 += n7;
                            ++n20;
                        }
                        n16 += this.kw;
                        n17 += n8;
                        ++n18;
                    }
                    float f5 = f3 * f3;
                    float f6 = f4 * f4;
                    fArray5[n14] = f2 = (float)Math.sqrt(f5 + f6);
                    n13 += n7;
                    n14 += n5;
                    ++n15;
                }
                n10 += n8;
                n11 += n6;
                ++n12;
            }
            ++n9;
        }
    }

    private void doubleLoop(RasterAccessor rasterAccessor, RasterAccessor rasterAccessor2) {
        int n2 = rasterAccessor2.getWidth();
        int n3 = rasterAccessor2.getHeight();
        int n4 = rasterAccessor2.getNumBands();
        float[] fArray = this.kernel_h.getKernelData();
        float[] fArray2 = this.kernel_v.getKernelData();
        double[][] dArray = rasterAccessor2.getDoubleDataArrays();
        int[] nArray = rasterAccessor2.getBandOffsets();
        int n5 = rasterAccessor2.getPixelStride();
        int n6 = rasterAccessor2.getScanlineStride();
        double[][] dArray2 = rasterAccessor.getDoubleDataArrays();
        int[] nArray2 = rasterAccessor.getBandOffsets();
        int n7 = rasterAccessor.getPixelStride();
        int n8 = rasterAccessor.getScanlineStride();
        int n9 = 0;
        while (n9 < n4) {
            double[] dArray3 = dArray[n9];
            double[] dArray4 = dArray2[n9];
            int n10 = nArray2[n9];
            int n11 = nArray[n9];
            int n12 = 0;
            while (n12 < n3) {
                int n13 = n10;
                int n14 = n11;
                int n15 = 0;
                while (n15 < n2) {
                    double d2;
                    double d3 = 0.0;
                    double d4 = 0.0;
                    int n16 = 0;
                    int n17 = n13;
                    int n18 = 0;
                    while (n18 < this.kh) {
                        int n19 = n17;
                        int n20 = 0;
                        while (n20 < this.kw) {
                            d3 += dArray4[n19] * (double)fArray[n16 + n20];
                            d4 += dArray4[n19] * (double)fArray2[n16 + n20];
                            n19 += n7;
                            ++n20;
                        }
                        n16 += this.kw;
                        n17 += n8;
                        ++n18;
                    }
                    double d5 = d3 * d3;
                    double d6 = d4 * d4;
                    dArray3[n14] = d2 = Math.sqrt(d5 + d6);
                    n13 += n7;
                    n14 += n5;
                    ++n15;
                }
                n10 += n8;
                n11 += n6;
                ++n12;
            }
            ++n9;
        }
    }
}

