/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jai.opimage;

class HistogramHash {
    int capacity;
    int[] colors;
    int[] counts;
    int size;
    int hashsize;
    boolean packed = false;
    int[] newColors;
    int[] newCounts;

    public HistogramHash(int n2) {
        this.capacity = n2;
        this.hashsize = n2 * 4 / 3;
        this.colors = new int[this.hashsize];
        this.counts = new int[this.hashsize];
    }

    void init() {
        this.size = 0;
        this.packed = false;
        int n2 = 0;
        while (n2 < this.hashsize) {
            this.colors[n2] = -1;
            this.counts[n2] = 0;
            ++n2;
        }
    }

    boolean insert(int n2) {
        int n3 = this.hashCode(n2);
        if (this.colors[n3] == -1) {
            this.colors[n3] = n2;
            int n4 = n3;
            this.counts[n4] = this.counts[n4] + 1;
            ++this.size;
            return this.size <= this.capacity;
        }
        if (this.colors[n3] == n2) {
            int n5 = n3;
            this.counts[n5] = this.counts[n5] + 1;
            return this.size <= this.capacity;
        }
        int n6 = n3 + 1;
        while (n6 != n3) {
            if (this.colors[n6 %= this.hashsize] == -1) {
                this.colors[n6] = n2;
                int n7 = n6;
                this.counts[n7] = this.counts[n7] + 1;
                ++this.size;
                return this.size <= this.capacity;
            }
            if (this.colors[n6] == n2) {
                int n8 = n6;
                this.counts[n8] = this.counts[n8] + 1;
                return this.size <= this.capacity;
            }
            ++n6;
        }
        return this.size <= this.capacity;
    }

    boolean isFull() {
        return this.size > this.capacity;
    }

    void put(int n2, int n3) {
        int n4 = this.hashCode(n2);
        if (this.colors[n4] == -1) {
            this.colors[n4] = n2;
            this.counts[n4] = n3;
            ++this.size;
            return;
        }
        if (this.colors[n4] == n2) {
            this.counts[n4] = n3;
            return;
        }
        int n5 = n4 + 1;
        while (n5 != n4) {
            if (this.colors[n5 %= this.hashsize] == -1) {
                this.colors[n5] = n2;
                this.counts[n5] = n3;
                ++this.size;
                return;
            }
            if (this.colors[n5] == n2) {
                this.counts[n5] = n3;
                return;
            }
            ++n5;
        }
    }

    int get(int n2) {
        int n3 = this.hashCode(n2);
        if (this.colors[n3] == n2) {
            return this.counts[n3];
        }
        int n4 = n3 + 1;
        while (n4 != n3) {
            if (this.colors[n4 %= this.hashsize] == n2) {
                return this.counts[n4];
            }
            ++n4;
        }
        return -1;
    }

    int[] getCounts() {
        if (!this.packed) {
            this.pack();
        }
        return this.newCounts;
    }

    int[] getColors() {
        if (!this.packed) {
            this.pack();
        }
        return this.newColors;
    }

    void pack() {
        this.newColors = new int[this.capacity];
        this.newCounts = new int[this.capacity];
        int n2 = 0;
        int n3 = 0;
        while (n2 < this.hashsize) {
            if (this.colors[n2] != -1) {
                this.newColors[n3] = this.colors[n2];
                this.newCounts[n3] = this.counts[n2];
                ++n3;
            }
            ++n2;
        }
        this.packed = true;
    }

    int hashCode(int n2) {
        return ((n2 >> 16) * 33023 + (n2 >> 8 & 0xFF) * 30013 + (n2 & 0xFF) * 27011) % this.hashsize;
    }
}

