/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jai.opimage;

import java.awt.Image;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import javax.media.jai.Histogram;
import javax.media.jai.ROI;
import javax.media.jai.StatisticsOpImage;

final class HistogramOpImage
extends StatisticsOpImage {
    private int[] numBins;
    private double[] lowValue;
    private double[] highValue;
    private int numBands;

    private final boolean tileIntersectsROI(int n2, int n3) {
        if (this.roi == null) {
            return true;
        }
        return this.roi.intersects(this.tileXToX(n2), this.tileYToY(n3), this.tileWidth, this.tileHeight);
    }

    public HistogramOpImage(RenderedImage renderedImage, ROI rOI, int n2, int n3, int n4, int n5, int[] nArray, double[] dArray, double[] dArray2) {
        super(renderedImage, rOI, n2, n3, n4, n5);
        this.numBands = renderedImage.getSampleModel().getNumBands();
        this.numBins = new int[this.numBands];
        this.lowValue = new double[this.numBands];
        this.highValue = new double[this.numBands];
        int n6 = 0;
        while (n6 < this.numBands) {
            this.numBins[n6] = nArray.length == 1 ? nArray[0] : nArray[n6];
            this.lowValue[n6] = dArray.length == 1 ? dArray[0] : dArray[n6];
            this.highValue[n6] = dArray2.length == 1 ? dArray2[0] : dArray2[n6];
            ++n6;
        }
    }

    protected String[] getStatisticsNames() {
        String[] stringArray = new String[]{"histogram"};
        return stringArray;
    }

    protected Object createStatistics(String string) {
        if (string.equalsIgnoreCase("histogram")) {
            return new Histogram(this.numBins, this.lowValue, this.highValue);
        }
        return Image.UndefinedProperty;
    }

    protected void accumulateStatistics(String string, Raster raster, Object object) {
        Histogram histogram = (Histogram)object;
        histogram.countPixels(raster, this.roi, this.xStart, this.yStart, this.xPeriod, this.yPeriod);
    }
}

