/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jai.opimage;

import com.sun.media.jai.opimage.JaiI18N;
import java.awt.Rectangle;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.util.Map;
import javax.media.jai.ColormapOpImage;
import javax.media.jai.ImageLayout;
import javax.media.jai.RasterAccessor;
import javax.media.jai.RasterFormatTag;

final class InvertOpImage
extends ColormapOpImage {
    public InvertOpImage(RenderedImage renderedImage, Map map, ImageLayout imageLayout) {
        super(renderedImage, imageLayout, map, true);
        this.permitInPlaceOperation();
        this.initializeColormapOperation();
    }

    protected void transformColormap(byte[][] byArray) {
        int n2 = 0;
        while (n2 < 3) {
            byte[] byArray2 = byArray[n2];
            int n3 = byArray2.length;
            int n4 = 0;
            while (n4 < n3) {
                byArray2[n4] = (byte)(255 - (byArray2[n4] & 0xFF));
                ++n4;
            }
            ++n2;
        }
    }

    protected void computeRect(Raster[] rasterArray, WritableRaster writableRaster, Rectangle rectangle) {
        RasterFormatTag[] rasterFormatTagArray = this.getFormatTags();
        RasterAccessor rasterAccessor = new RasterAccessor(rasterArray[0], rectangle, rasterFormatTagArray[0], this.getSourceImage(0).getColorModel());
        RasterAccessor rasterAccessor2 = new RasterAccessor(writableRaster, rectangle, rasterFormatTagArray[1], this.getColorModel());
        if (rasterAccessor2.isBinary()) {
            byte[] byArray = rasterAccessor.getBinaryDataArray();
            byte[] byArray2 = rasterAccessor2.getBinaryDataArray();
            int n2 = byArray2.length;
            int n3 = 0;
            while (n3 < n2) {
                byArray2[n3] = ~byArray[n3];
                ++n3;
            }
            rasterAccessor2.copyBinaryDataToRaster();
        } else {
            switch (rasterAccessor2.getDataType()) {
                case 0: {
                    this.computeRectByte(rasterAccessor, rasterAccessor2);
                    break;
                }
                case 1: {
                    this.computeRectUShort(rasterAccessor, rasterAccessor2);
                    break;
                }
                case 2: {
                    this.computeRectShort(rasterAccessor, rasterAccessor2);
                    break;
                }
                case 3: {
                    this.computeRectInt(rasterAccessor, rasterAccessor2);
                    break;
                }
                case 4: 
                case 5: {
                    throw new RuntimeException(JaiI18N.getString("InvertOpImage0"));
                }
            }
            rasterAccessor2.copyDataToRaster();
        }
    }

    private void computeRectByte(RasterAccessor rasterAccessor, RasterAccessor rasterAccessor2) {
        int n2 = rasterAccessor.getScanlineStride();
        int n3 = rasterAccessor.getPixelStride();
        int[] nArray = rasterAccessor.getBandOffsets();
        byte[][] byArray = rasterAccessor.getByteDataArrays();
        int n4 = rasterAccessor2.getWidth();
        int n5 = rasterAccessor2.getHeight();
        int n6 = rasterAccessor2.getNumBands();
        int n7 = rasterAccessor2.getScanlineStride();
        int n8 = rasterAccessor2.getPixelStride();
        int[] nArray2 = rasterAccessor2.getBandOffsets();
        byte[][] byArray2 = rasterAccessor2.getByteDataArrays();
        int n9 = 0;
        while (n9 < n6) {
            byte[] byArray3 = byArray[n9];
            byte[] byArray4 = byArray2[n9];
            int n10 = nArray[n9];
            int n11 = nArray2[n9];
            int n12 = 0;
            while (n12 < n5) {
                int n13 = n10;
                int n14 = n11;
                n10 += n2;
                n11 += n7;
                int n15 = n14 + n4 * n8;
                while (n14 < n15) {
                    byArray4[n14] = (byte)(255 - (byArray3[n13] & 0xFF));
                    n13 += n3;
                    n14 += n8;
                }
                ++n12;
            }
            ++n9;
        }
    }

    private void computeRectUShort(RasterAccessor rasterAccessor, RasterAccessor rasterAccessor2) {
        int n2 = rasterAccessor.getScanlineStride();
        int n3 = rasterAccessor.getPixelStride();
        int[] nArray = rasterAccessor.getBandOffsets();
        short[][] sArray = rasterAccessor.getShortDataArrays();
        int n4 = rasterAccessor2.getWidth();
        int n5 = rasterAccessor2.getHeight();
        int n6 = rasterAccessor2.getNumBands();
        int n7 = rasterAccessor2.getScanlineStride();
        int n8 = rasterAccessor2.getPixelStride();
        int[] nArray2 = rasterAccessor2.getBandOffsets();
        short[][] sArray2 = rasterAccessor2.getShortDataArrays();
        int n9 = 0;
        while (n9 < n6) {
            short[] sArray3 = sArray[n9];
            short[] sArray4 = sArray2[n9];
            int n10 = nArray[n9];
            int n11 = nArray2[n9];
            int n12 = 0;
            while (n12 < n5) {
                int n13 = n10;
                int n14 = n11;
                n10 += n2;
                n11 += n7;
                int n15 = n14 + n4 * n8;
                while (n14 < n15) {
                    sArray4[n14] = (short)(65535 - (sArray3[n13] & 0xFFFF));
                    n13 += n3;
                    n14 += n8;
                }
                ++n12;
            }
            ++n9;
        }
    }

    private void computeRectShort(RasterAccessor rasterAccessor, RasterAccessor rasterAccessor2) {
        int n2 = rasterAccessor.getScanlineStride();
        int n3 = rasterAccessor.getPixelStride();
        int[] nArray = rasterAccessor.getBandOffsets();
        short[][] sArray = rasterAccessor.getShortDataArrays();
        int n4 = rasterAccessor2.getWidth();
        int n5 = rasterAccessor2.getHeight();
        int n6 = rasterAccessor2.getNumBands();
        int n7 = rasterAccessor2.getScanlineStride();
        int n8 = rasterAccessor2.getPixelStride();
        int[] nArray2 = rasterAccessor2.getBandOffsets();
        short[][] sArray2 = rasterAccessor2.getShortDataArrays();
        int n9 = 0;
        while (n9 < n6) {
            short[] sArray3 = sArray[n9];
            short[] sArray4 = sArray2[n9];
            int n10 = nArray[n9];
            int n11 = nArray2[n9];
            int n12 = 0;
            while (n12 < n5) {
                int n13 = n10;
                int n14 = n11;
                n10 += n2;
                n11 += n7;
                int n15 = n14 + n4 * n8;
                while (n14 < n15) {
                    sArray4[n14] = (short)(Short.MAX_VALUE - sArray3[n13]);
                    n13 += n3;
                    n14 += n8;
                }
                ++n12;
            }
            ++n9;
        }
    }

    private void computeRectInt(RasterAccessor rasterAccessor, RasterAccessor rasterAccessor2) {
        int n2 = rasterAccessor.getScanlineStride();
        int n3 = rasterAccessor.getPixelStride();
        int[] nArray = rasterAccessor.getBandOffsets();
        int[][] nArray2 = rasterAccessor.getIntDataArrays();
        int n4 = rasterAccessor2.getWidth();
        int n5 = rasterAccessor2.getHeight();
        int n6 = rasterAccessor2.getNumBands();
        int n7 = rasterAccessor2.getScanlineStride();
        int n8 = rasterAccessor2.getPixelStride();
        int[] nArray3 = rasterAccessor2.getBandOffsets();
        int[][] nArray4 = rasterAccessor2.getIntDataArrays();
        int[] nArray5 = nArray2[0];
        int[] nArray6 = nArray4[0];
        int n9 = nArray6.length;
        switch (this.sampleModel.getTransferType()) {
            case 0: {
                int n10 = 0;
                while (n10 < n9) {
                    nArray6[n10] = ~nArray5[n10] & 0xFF;
                    ++n10;
                }
                break;
            }
            case 1: {
                int n11 = 0;
                while (n11 < n9) {
                    nArray6[n11] = ~nArray5[n11] & 0xFFFF;
                    ++n11;
                }
                break;
            }
            case 2: {
                int n12 = 0;
                while (n12 < n9) {
                    nArray6[n12] = Short.MAX_VALUE - nArray5[n12];
                    ++n12;
                }
                break;
            }
            case 3: {
                int n13 = 0;
                while (n13 < n6) {
                    nArray5 = nArray2[n13];
                    nArray6 = nArray4[n13];
                    int n14 = nArray[n13];
                    int n15 = nArray3[n13];
                    int n16 = 0;
                    while (n16 < n5) {
                        int n17 = n14;
                        int n18 = n15;
                        n14 += n2;
                        n15 += n7;
                        int n19 = n18 + n4 * n8;
                        while (n18 < n19) {
                            nArray6[n18] = Integer.MAX_VALUE - nArray5[n17];
                            n17 += n3;
                            n18 += n8;
                        }
                        ++n16;
                    }
                    ++n13;
                }
                break;
            }
        }
    }
}

