/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jai.opimage;

import java.awt.Rectangle;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.util.Map;
import javax.media.jai.ColormapOpImage;
import javax.media.jai.ImageLayout;
import javax.media.jai.RasterAccessor;
import javax.media.jai.RasterFormatTag;

final class LogOpImage
extends ColormapOpImage {
    private byte[] byteTable = null;

    public LogOpImage(RenderedImage renderedImage, Map map, ImageLayout imageLayout) {
        super(renderedImage, imageLayout, map, true);
        this.permitInPlaceOperation();
        this.initializeColormapOperation();
    }

    protected void transformColormap(byte[][] byArray) {
        this.initByteTable();
        int n2 = 0;
        while (n2 < 3) {
            byte[] byArray2 = byArray[n2];
            int n3 = byArray2.length;
            int n4 = 0;
            while (n4 < n3) {
                byArray2[n4] = this.byteTable[byArray2[n4] & 0xFF];
                ++n4;
            }
            ++n2;
        }
    }

    protected void computeRect(Raster[] rasterArray, WritableRaster writableRaster, Rectangle rectangle) {
        RasterFormatTag[] rasterFormatTagArray = this.getFormatTags();
        RasterAccessor rasterAccessor = new RasterAccessor(rasterArray[0], rectangle, rasterFormatTagArray[0], this.getSourceImage(0).getColorModel());
        RasterAccessor rasterAccessor2 = new RasterAccessor(writableRaster, rectangle, rasterFormatTagArray[1], this.getColorModel());
        switch (rasterAccessor2.getDataType()) {
            case 0: {
                this.computeRectByte(rasterAccessor, rasterAccessor2);
                break;
            }
            case 1: {
                this.computeRectUShort(rasterAccessor, rasterAccessor2);
                break;
            }
            case 2: {
                this.computeRectShort(rasterAccessor, rasterAccessor2);
                break;
            }
            case 3: {
                this.computeRectInt(rasterAccessor, rasterAccessor2);
                break;
            }
            case 4: {
                this.computeRectFloat(rasterAccessor, rasterAccessor2);
                break;
            }
            case 5: {
                this.computeRectDouble(rasterAccessor, rasterAccessor2);
            }
        }
        if (rasterAccessor2.needsClamping()) {
            rasterAccessor2.clampDataArrays();
        }
        rasterAccessor2.copyDataToRaster();
    }

    private void computeRectByte(RasterAccessor rasterAccessor, RasterAccessor rasterAccessor2) {
        this.initByteTable();
        int n2 = rasterAccessor.getScanlineStride();
        int n3 = rasterAccessor.getPixelStride();
        int[] nArray = rasterAccessor.getBandOffsets();
        byte[][] byArray = rasterAccessor.getByteDataArrays();
        int n4 = rasterAccessor2.getScanlineStride();
        int n5 = rasterAccessor2.getPixelStride();
        int[] nArray2 = rasterAccessor2.getBandOffsets();
        byte[][] byArray2 = rasterAccessor2.getByteDataArrays();
        int n6 = rasterAccessor2.getWidth();
        int n7 = rasterAccessor2.getHeight();
        int n8 = rasterAccessor2.getNumBands();
        int n9 = 0;
        while (n9 < n8) {
            byte[] byArray3 = byArray[n9];
            byte[] byArray4 = byArray2[n9];
            int n10 = nArray[n9];
            int n11 = nArray2[n9];
            int n12 = 0;
            while (n12 < n7) {
                int n13 = n10;
                int n14 = n11;
                n10 += n2;
                n11 += n4;
                int n15 = 0;
                while (n15 < n6) {
                    byArray4[n14] = this.byteTable[byArray3[n13] & 0xFF];
                    n13 += n3;
                    n14 += n5;
                    ++n15;
                }
                ++n12;
            }
            ++n9;
        }
    }

    private void computeRectUShort(RasterAccessor rasterAccessor, RasterAccessor rasterAccessor2) {
        int n2 = rasterAccessor.getScanlineStride();
        int n3 = rasterAccessor.getPixelStride();
        int[] nArray = rasterAccessor.getBandOffsets();
        short[][] sArray = rasterAccessor.getShortDataArrays();
        int n4 = rasterAccessor2.getScanlineStride();
        int n5 = rasterAccessor2.getPixelStride();
        int[] nArray2 = rasterAccessor2.getBandOffsets();
        short[][] sArray2 = rasterAccessor2.getShortDataArrays();
        int n6 = rasterAccessor2.getWidth();
        int n7 = rasterAccessor2.getHeight();
        int n8 = rasterAccessor2.getNumBands();
        int n9 = 0;
        while (n9 < n8) {
            short[] sArray3 = sArray[n9];
            short[] sArray4 = sArray2[n9];
            int n10 = nArray[n9];
            int n11 = nArray2[n9];
            int n12 = 0;
            while (n12 < n7) {
                int n13 = n10;
                int n14 = n11;
                n10 += n2;
                n11 += n4;
                int n15 = 0;
                while (n15 < n6) {
                    sArray4[n14] = (short)(Math.log(sArray3[n13] & 0xFFFF) + 0.5);
                    n13 += n3;
                    n14 += n5;
                    ++n15;
                }
                ++n12;
            }
            ++n9;
        }
    }

    private void computeRectShort(RasterAccessor rasterAccessor, RasterAccessor rasterAccessor2) {
        int n2 = rasterAccessor.getScanlineStride();
        int n3 = rasterAccessor.getPixelStride();
        int[] nArray = rasterAccessor.getBandOffsets();
        short[][] sArray = rasterAccessor.getShortDataArrays();
        int n4 = rasterAccessor2.getScanlineStride();
        int n5 = rasterAccessor2.getPixelStride();
        int[] nArray2 = rasterAccessor2.getBandOffsets();
        short[][] sArray2 = rasterAccessor2.getShortDataArrays();
        int n6 = rasterAccessor2.getWidth();
        int n7 = rasterAccessor2.getHeight();
        int n8 = rasterAccessor2.getNumBands();
        int n9 = 0;
        while (n9 < n8) {
            short[] sArray3 = sArray[n9];
            short[] sArray4 = sArray2[n9];
            int n10 = nArray[n9];
            int n11 = nArray2[n9];
            int n12 = 0;
            while (n12 < n7) {
                int n13 = n10;
                int n14 = n11;
                n10 += n2;
                n11 += n4;
                int n15 = 0;
                while (n15 < n6) {
                    sArray4[n14] = (short)(Math.log(sArray3[n13]) + 0.5);
                    n13 += n3;
                    n14 += n5;
                    ++n15;
                }
                ++n12;
            }
            ++n9;
        }
    }

    private void computeRectInt(RasterAccessor rasterAccessor, RasterAccessor rasterAccessor2) {
        int n2 = rasterAccessor.getScanlineStride();
        int n3 = rasterAccessor.getPixelStride();
        int[] nArray = rasterAccessor.getBandOffsets();
        int[][] nArray2 = rasterAccessor.getIntDataArrays();
        int n4 = rasterAccessor2.getScanlineStride();
        int n5 = rasterAccessor2.getPixelStride();
        int[] nArray3 = rasterAccessor2.getBandOffsets();
        int[][] nArray4 = rasterAccessor2.getIntDataArrays();
        int n6 = rasterAccessor2.getWidth();
        int n7 = rasterAccessor2.getHeight();
        int n8 = rasterAccessor2.getNumBands();
        int n9 = 0;
        while (n9 < n8) {
            int[] nArray5 = nArray2[n9];
            int[] nArray6 = nArray4[n9];
            int n10 = nArray[n9];
            int n11 = nArray3[n9];
            int n12 = 0;
            while (n12 < n7) {
                int n13 = n10;
                int n14 = n11;
                n10 += n2;
                n11 += n4;
                int n15 = 0;
                while (n15 < n6) {
                    double d2 = nArray5[n13];
                    nArray6[n14] = d2 > 0.0 ? (int)(Math.log(d2) + 0.5) : (d2 == 0.0 ? 0 : -1);
                    n13 += n3;
                    n14 += n5;
                    ++n15;
                }
                ++n12;
            }
            ++n9;
        }
    }

    private void computeRectFloat(RasterAccessor rasterAccessor, RasterAccessor rasterAccessor2) {
        int n2 = rasterAccessor.getScanlineStride();
        int n3 = rasterAccessor.getPixelStride();
        int[] nArray = rasterAccessor.getBandOffsets();
        float[][] fArray = rasterAccessor.getFloatDataArrays();
        int n4 = rasterAccessor2.getScanlineStride();
        int n5 = rasterAccessor2.getPixelStride();
        int[] nArray2 = rasterAccessor2.getBandOffsets();
        float[][] fArray2 = rasterAccessor2.getFloatDataArrays();
        int n6 = rasterAccessor2.getWidth();
        int n7 = rasterAccessor2.getHeight();
        int n8 = rasterAccessor2.getNumBands();
        int n9 = 0;
        while (n9 < n8) {
            float[] fArray3 = fArray[n9];
            float[] fArray4 = fArray2[n9];
            int n10 = nArray[n9];
            int n11 = nArray2[n9];
            int n12 = 0;
            while (n12 < n7) {
                int n13 = n10;
                int n14 = n11;
                n10 += n2;
                n11 += n4;
                int n15 = 0;
                while (n15 < n6) {
                    fArray4[n14] = (float)Math.log(fArray3[n13]);
                    n13 += n3;
                    n14 += n5;
                    ++n15;
                }
                ++n12;
            }
            ++n9;
        }
    }

    private void computeRectDouble(RasterAccessor rasterAccessor, RasterAccessor rasterAccessor2) {
        int n2 = rasterAccessor.getScanlineStride();
        int n3 = rasterAccessor.getPixelStride();
        int[] nArray = rasterAccessor.getBandOffsets();
        double[][] dArray = rasterAccessor.getDoubleDataArrays();
        int n4 = rasterAccessor2.getScanlineStride();
        int n5 = rasterAccessor2.getPixelStride();
        int[] nArray2 = rasterAccessor2.getBandOffsets();
        double[][] dArray2 = rasterAccessor2.getDoubleDataArrays();
        int n6 = rasterAccessor2.getWidth();
        int n7 = rasterAccessor2.getHeight();
        int n8 = rasterAccessor2.getNumBands();
        int n9 = 0;
        while (n9 < n8) {
            double[] dArray3 = dArray[n9];
            double[] dArray4 = dArray2[n9];
            int n10 = nArray[n9];
            int n11 = nArray2[n9];
            int n12 = 0;
            while (n12 < n7) {
                int n13 = n10;
                int n14 = n11;
                n10 += n2;
                n11 += n4;
                int n15 = 0;
                while (n15 < n6) {
                    dArray4[n14] = Math.log(dArray3[n13]);
                    n13 += n3;
                    n14 += n5;
                    ++n15;
                }
                ++n12;
            }
            ++n9;
        }
    }

    private synchronized void initByteTable() {
        if (this.byteTable != null) {
            return;
        }
        this.byteTable = new byte[256];
        this.byteTable[0] = 0;
        this.byteTable[1] = 0;
        int n2 = 2;
        while (n2 < 256) {
            this.byteTable[n2] = (byte)(Math.log(n2) + 0.5);
            ++n2;
        }
    }
}

