/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jai.opimage;

import java.awt.Rectangle;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.util.Map;
import javax.media.jai.AreaOpImage;
import javax.media.jai.BorderExtender;
import javax.media.jai.ImageLayout;
import javax.media.jai.RasterAccessor;
import javax.media.jai.RasterFormatTag;
import javax.media.jai.operator.MaxFilterShape;

abstract class MaxFilterOpImage
extends AreaOpImage {
    protected MaxFilterShape maskType;
    protected int maskSize;

    public MaxFilterOpImage(RenderedImage renderedImage, BorderExtender borderExtender, Map map, ImageLayout imageLayout, MaxFilterShape maxFilterShape, int n2) {
        super(renderedImage, imageLayout, map, true, borderExtender, (n2 - 1) / 2, (n2 - 1) / 2, n2 / 2, n2 / 2);
        this.maskType = maxFilterShape;
        this.maskSize = n2;
    }

    protected void computeRect(Raster[] rasterArray, WritableRaster writableRaster, Rectangle rectangle) {
        RasterFormatTag[] rasterFormatTagArray = this.getFormatTags();
        Raster raster = rasterArray[0];
        Rectangle rectangle2 = this.mapDestRect(rectangle, 0);
        RasterAccessor rasterAccessor = new RasterAccessor(raster, rectangle2, rasterFormatTagArray[0], this.getSourceImage(0).getColorModel());
        RasterAccessor rasterAccessor2 = new RasterAccessor(writableRaster, rectangle, rasterFormatTagArray[1], this.getColorModel());
        switch (rasterAccessor2.getDataType()) {
            case 0: {
                this.byteLoop(rasterAccessor, rasterAccessor2, this.maskSize);
                break;
            }
            case 2: {
                this.shortLoop(rasterAccessor, rasterAccessor2, this.maskSize);
                break;
            }
            case 1: {
                this.ushortLoop(rasterAccessor, rasterAccessor2, this.maskSize);
                break;
            }
            case 3: {
                this.intLoop(rasterAccessor, rasterAccessor2, this.maskSize);
                break;
            }
            case 4: {
                this.floatLoop(rasterAccessor, rasterAccessor2, this.maskSize);
                break;
            }
            case 5: {
                this.doubleLoop(rasterAccessor, rasterAccessor2, this.maskSize);
            }
        }
        if (rasterAccessor2.isDataCopy()) {
            rasterAccessor2.clampDataArrays();
            rasterAccessor2.copyDataToRaster();
        }
    }

    protected abstract void byteLoop(RasterAccessor var1, RasterAccessor var2, int var3);

    protected abstract void shortLoop(RasterAccessor var1, RasterAccessor var2, int var3);

    protected abstract void ushortLoop(RasterAccessor var1, RasterAccessor var2, int var3);

    protected abstract void intLoop(RasterAccessor var1, RasterAccessor var2, int var3);

    protected abstract void floatLoop(RasterAccessor var1, RasterAccessor var2, int var3);

    protected abstract void doubleLoop(RasterAccessor var1, RasterAccessor var2, int var3);

    static final int maxFilter(int[] nArray) {
        if (nArray.length == 3) {
            int n2 = nArray[0];
            int n3 = nArray[1];
            int n4 = nArray[2];
            if (n2 < n3) {
                return n3 < n4 ? n4 : n3;
            }
            return n2 < n4 ? n4 : n2;
        }
        int n5 = nArray[0];
        int n6 = 1;
        while (n6 < nArray.length) {
            if (n5 < nArray[n6]) {
                n5 = nArray[n6];
            }
            ++n6;
        }
        return n5;
    }

    static final float maxFilterFloat(float[] fArray) {
        if (fArray.length == 3) {
            float f2 = fArray[0];
            float f3 = fArray[1];
            float f4 = fArray[2];
            if (f2 < f3) {
                return f3 < f4 ? f4 : f3;
            }
            return f2 < f4 ? f4 : f2;
        }
        float f5 = fArray[0];
        int n2 = 1;
        while (n2 < fArray.length) {
            if (f5 < fArray[n2]) {
                f5 = fArray[n2];
            }
            ++n2;
        }
        return f5;
    }

    static final double maxFilterDouble(double[] dArray) {
        if (dArray.length == 3) {
            double d2 = dArray[0];
            double d3 = dArray[1];
            double d4 = dArray[2];
            if (d2 < d3) {
                return d3 < d4 ? d4 : d3;
            }
            return d2 < d4 ? d4 : d2;
        }
        double d5 = dArray[0];
        int n2 = 1;
        while (n2 < dArray.length) {
            if (d5 < dArray[n2]) {
                d5 = dArray[n2];
            }
            ++n2;
        }
        return d5;
    }
}

