/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jai.opimage;

import java.awt.Rectangle;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.lang.ref.SoftReference;
import java.util.Map;
import javax.media.jai.ImageLayout;
import javax.media.jai.PointOpImage;
import javax.media.jai.RasterAccessor;
import javax.media.jai.RasterFormatTag;

final class MaxOpImage
extends PointOpImage {
    private static long negativeZeroFloatBits = Float.floatToIntBits(-0.0f);
    private static long negativeZeroDoubleBits = Double.doubleToLongBits(-0.0);
    private static byte[] byteTable = null;
    private static SoftReference softRef = null;

    private synchronized void allocByteTable() {
        if (softRef == null || softRef.get() == null) {
            byteTable = new byte[65536];
            softRef = new SoftReference<byte[]>(byteTable);
            boolean bl2 = false;
            int n2 = 0;
            while (n2 < 256) {
                int n3 = n2 << 8;
                int n4 = 0;
                while (n4 < n2) {
                    MaxOpImage.byteTable[n3 + n4] = (byte)n2;
                    ++n4;
                }
                int n5 = n2;
                while (n5 < 256) {
                    MaxOpImage.byteTable[n3 + n5] = (byte)n5;
                    ++n5;
                }
                ++n2;
            }
        }
    }

    public MaxOpImage(RenderedImage renderedImage, RenderedImage renderedImage2, Map map, ImageLayout imageLayout) {
        super(renderedImage, renderedImage2, imageLayout, map, true);
        if (this.sampleModel.getTransferType() == 0) {
            this.allocByteTable();
        }
        this.permitInPlaceOperation();
    }

    protected void computeRect(Raster[] rasterArray, WritableRaster writableRaster, Rectangle rectangle) {
        RasterFormatTag[] rasterFormatTagArray = this.getFormatTags();
        RasterAccessor rasterAccessor = new RasterAccessor(rasterArray[0], rectangle, rasterFormatTagArray[0], this.getSourceImage(0).getColorModel());
        RasterAccessor rasterAccessor2 = new RasterAccessor(rasterArray[1], rectangle, rasterFormatTagArray[1], this.getSourceImage(1).getColorModel());
        RasterAccessor rasterAccessor3 = new RasterAccessor(writableRaster, rectangle, rasterFormatTagArray[2], this.getColorModel());
        switch (rasterAccessor3.getDataType()) {
            case 0: {
                this.computeRectByte(rasterAccessor, rasterAccessor2, rasterAccessor3);
                break;
            }
            case 1: {
                this.computeRectUShort(rasterAccessor, rasterAccessor2, rasterAccessor3);
                break;
            }
            case 2: {
                this.computeRectShort(rasterAccessor, rasterAccessor2, rasterAccessor3);
                break;
            }
            case 3: {
                this.computeRectInt(rasterAccessor, rasterAccessor2, rasterAccessor3);
                break;
            }
            case 4: {
                this.computeRectFloat(rasterAccessor, rasterAccessor2, rasterAccessor3);
                break;
            }
            case 5: {
                this.computeRectDouble(rasterAccessor, rasterAccessor2, rasterAccessor3);
            }
        }
        if (rasterAccessor3.isDataCopy()) {
            rasterAccessor3.clampDataArrays();
            rasterAccessor3.copyDataToRaster();
        }
    }

    private void computeRectByte(RasterAccessor rasterAccessor, RasterAccessor rasterAccessor2, RasterAccessor rasterAccessor3) {
        int n2 = rasterAccessor.getScanlineStride();
        int n3 = rasterAccessor.getPixelStride();
        int[] nArray = rasterAccessor.getBandOffsets();
        byte[][] byArray = rasterAccessor.getByteDataArrays();
        int n4 = rasterAccessor2.getScanlineStride();
        int n5 = rasterAccessor2.getPixelStride();
        int[] nArray2 = rasterAccessor2.getBandOffsets();
        byte[][] byArray2 = rasterAccessor2.getByteDataArrays();
        int n6 = rasterAccessor3.getWidth();
        int n7 = rasterAccessor3.getHeight();
        int n8 = rasterAccessor3.getNumBands();
        int n9 = rasterAccessor3.getScanlineStride();
        int n10 = rasterAccessor3.getPixelStride();
        int[] nArray3 = rasterAccessor3.getBandOffsets();
        byte[][] byArray3 = rasterAccessor3.getByteDataArrays();
        int n11 = 0;
        while (n11 < n8) {
            byte[] byArray4 = byArray[n11];
            byte[] byArray5 = byArray2[n11];
            byte[] byArray6 = byArray3[n11];
            int n12 = nArray[n11];
            int n13 = nArray2[n11];
            int n14 = nArray3[n11];
            int n15 = 0;
            while (n15 < n7) {
                int n16 = n12;
                int n17 = n13;
                int n18 = n14;
                n12 += n2;
                n13 += n4;
                n14 += n9;
                int n19 = n18 + n6 * n10;
                while (n18 < n19) {
                    int n20 = byArray4[n16] & 0xFF;
                    int n21 = byArray5[n17] & 0xFF;
                    byArray6[n18] = byteTable[(n20 << 8) + n21];
                    n16 += n3;
                    n17 += n5;
                    n18 += n10;
                }
                ++n15;
            }
            ++n11;
        }
    }

    private void computeRectUShort(RasterAccessor rasterAccessor, RasterAccessor rasterAccessor2, RasterAccessor rasterAccessor3) {
        int n2 = rasterAccessor.getScanlineStride();
        int n3 = rasterAccessor.getPixelStride();
        int[] nArray = rasterAccessor.getBandOffsets();
        short[][] sArray = rasterAccessor.getShortDataArrays();
        int n4 = rasterAccessor2.getScanlineStride();
        int n5 = rasterAccessor2.getPixelStride();
        int[] nArray2 = rasterAccessor2.getBandOffsets();
        short[][] sArray2 = rasterAccessor2.getShortDataArrays();
        int n6 = rasterAccessor3.getWidth();
        int n7 = rasterAccessor3.getHeight();
        int n8 = rasterAccessor3.getNumBands();
        int n9 = rasterAccessor3.getScanlineStride();
        int n10 = rasterAccessor3.getPixelStride();
        int[] nArray3 = rasterAccessor3.getBandOffsets();
        short[][] sArray3 = rasterAccessor3.getShortDataArrays();
        int n11 = 0;
        while (n11 < n8) {
            short[] sArray4 = sArray[n11];
            short[] sArray5 = sArray2[n11];
            short[] sArray6 = sArray3[n11];
            int n12 = nArray[n11];
            int n13 = nArray2[n11];
            int n14 = nArray3[n11];
            int n15 = 0;
            while (n15 < n7) {
                int n16 = n12;
                int n17 = n13;
                int n18 = n14;
                n12 += n2;
                n13 += n4;
                n14 += n9;
                int n19 = 0;
                while (n19 < n6) {
                    sArray6[n18] = this.maxUShort(sArray4[n16], sArray5[n17]);
                    n16 += n3;
                    n17 += n5;
                    n18 += n10;
                    ++n19;
                }
                ++n15;
            }
            ++n11;
        }
    }

    private void computeRectShort(RasterAccessor rasterAccessor, RasterAccessor rasterAccessor2, RasterAccessor rasterAccessor3) {
        int n2 = rasterAccessor.getScanlineStride();
        int n3 = rasterAccessor.getPixelStride();
        int[] nArray = rasterAccessor.getBandOffsets();
        short[][] sArray = rasterAccessor.getShortDataArrays();
        int n4 = rasterAccessor2.getScanlineStride();
        int n5 = rasterAccessor2.getPixelStride();
        int[] nArray2 = rasterAccessor2.getBandOffsets();
        short[][] sArray2 = rasterAccessor2.getShortDataArrays();
        int n6 = rasterAccessor3.getWidth();
        int n7 = rasterAccessor3.getHeight();
        int n8 = rasterAccessor3.getNumBands();
        int n9 = rasterAccessor3.getScanlineStride();
        int n10 = rasterAccessor3.getPixelStride();
        int[] nArray3 = rasterAccessor3.getBandOffsets();
        short[][] sArray3 = rasterAccessor3.getShortDataArrays();
        int n11 = 0;
        while (n11 < n8) {
            short[] sArray4 = sArray[n11];
            short[] sArray5 = sArray2[n11];
            short[] sArray6 = sArray3[n11];
            int n12 = nArray[n11];
            int n13 = nArray2[n11];
            int n14 = nArray3[n11];
            int n15 = 0;
            while (n15 < n7) {
                int n16 = n12;
                int n17 = n13;
                int n18 = n14;
                n12 += n2;
                n13 += n4;
                n14 += n9;
                int n19 = 0;
                while (n19 < n6) {
                    sArray6[n18] = this.maxShort(sArray4[n16], sArray5[n17]);
                    n16 += n3;
                    n17 += n5;
                    n18 += n10;
                    ++n19;
                }
                ++n15;
            }
            ++n11;
        }
    }

    private void computeRectInt(RasterAccessor rasterAccessor, RasterAccessor rasterAccessor2, RasterAccessor rasterAccessor3) {
        int n2 = rasterAccessor.getScanlineStride();
        int n3 = rasterAccessor.getPixelStride();
        int[] nArray = rasterAccessor.getBandOffsets();
        int[][] nArray2 = rasterAccessor.getIntDataArrays();
        int n4 = rasterAccessor2.getScanlineStride();
        int n5 = rasterAccessor2.getPixelStride();
        int[] nArray3 = rasterAccessor2.getBandOffsets();
        int[][] nArray4 = rasterAccessor2.getIntDataArrays();
        int n6 = rasterAccessor3.getWidth();
        int n7 = rasterAccessor3.getHeight();
        int n8 = rasterAccessor3.getNumBands();
        int n9 = rasterAccessor3.getScanlineStride();
        int n10 = rasterAccessor3.getPixelStride();
        int[] nArray5 = rasterAccessor3.getBandOffsets();
        int[][] nArray6 = rasterAccessor3.getIntDataArrays();
        int n11 = 0;
        while (n11 < n8) {
            int[] nArray7 = nArray2[n11];
            int[] nArray8 = nArray4[n11];
            int[] nArray9 = nArray6[n11];
            int n12 = nArray[n11];
            int n13 = nArray3[n11];
            int n14 = nArray5[n11];
            int n15 = 0;
            while (n15 < n7) {
                int n16 = n12;
                int n17 = n13;
                int n18 = n14;
                n12 += n2;
                n13 += n4;
                n14 += n9;
                int n19 = 0;
                while (n19 < n6) {
                    nArray9[n18] = this.maxInt(nArray7[n16], nArray8[n17]);
                    n16 += n3;
                    n17 += n5;
                    n18 += n10;
                    ++n19;
                }
                ++n15;
            }
            ++n11;
        }
    }

    private void computeRectFloat(RasterAccessor rasterAccessor, RasterAccessor rasterAccessor2, RasterAccessor rasterAccessor3) {
        int n2 = rasterAccessor.getScanlineStride();
        int n3 = rasterAccessor.getPixelStride();
        int[] nArray = rasterAccessor.getBandOffsets();
        float[][] fArray = rasterAccessor.getFloatDataArrays();
        int n4 = rasterAccessor2.getScanlineStride();
        int n5 = rasterAccessor2.getPixelStride();
        int[] nArray2 = rasterAccessor2.getBandOffsets();
        float[][] fArray2 = rasterAccessor2.getFloatDataArrays();
        int n6 = rasterAccessor3.getWidth();
        int n7 = rasterAccessor3.getHeight();
        int n8 = rasterAccessor3.getNumBands();
        int n9 = rasterAccessor3.getScanlineStride();
        int n10 = rasterAccessor3.getPixelStride();
        int[] nArray3 = rasterAccessor3.getBandOffsets();
        float[][] fArray3 = rasterAccessor3.getFloatDataArrays();
        int n11 = 0;
        while (n11 < n8) {
            float[] fArray4 = fArray[n11];
            float[] fArray5 = fArray2[n11];
            float[] fArray6 = fArray3[n11];
            int n12 = nArray[n11];
            int n13 = nArray2[n11];
            int n14 = nArray3[n11];
            int n15 = 0;
            while (n15 < n7) {
                int n16 = n12;
                int n17 = n13;
                int n18 = n14;
                n12 += n2;
                n13 += n4;
                n14 += n9;
                int n19 = 0;
                while (n19 < n6) {
                    fArray6[n18] = this.maxFloat(fArray4[n16], fArray5[n17]);
                    n16 += n3;
                    n17 += n5;
                    n18 += n10;
                    ++n19;
                }
                ++n15;
            }
            ++n11;
        }
    }

    private void computeRectDouble(RasterAccessor rasterAccessor, RasterAccessor rasterAccessor2, RasterAccessor rasterAccessor3) {
        int n2 = rasterAccessor.getScanlineStride();
        int n3 = rasterAccessor.getPixelStride();
        int[] nArray = rasterAccessor.getBandOffsets();
        double[][] dArray = rasterAccessor.getDoubleDataArrays();
        int n4 = rasterAccessor2.getScanlineStride();
        int n5 = rasterAccessor2.getPixelStride();
        int[] nArray2 = rasterAccessor2.getBandOffsets();
        double[][] dArray2 = rasterAccessor2.getDoubleDataArrays();
        int n6 = rasterAccessor3.getWidth();
        int n7 = rasterAccessor3.getHeight();
        int n8 = rasterAccessor3.getNumBands();
        int n9 = rasterAccessor3.getScanlineStride();
        int n10 = rasterAccessor3.getPixelStride();
        int[] nArray3 = rasterAccessor3.getBandOffsets();
        double[][] dArray3 = rasterAccessor3.getDoubleDataArrays();
        int n11 = 0;
        while (n11 < n8) {
            double[] dArray4 = dArray[n11];
            double[] dArray5 = dArray2[n11];
            double[] dArray6 = dArray3[n11];
            int n12 = nArray[n11];
            int n13 = nArray2[n11];
            int n14 = nArray3[n11];
            int n15 = 0;
            while (n15 < n7) {
                int n16 = n12;
                int n17 = n13;
                int n18 = n14;
                n12 += n2;
                n13 += n4;
                n14 += n9;
                int n19 = 0;
                while (n19 < n6) {
                    dArray6[n18] = this.maxDouble(dArray4[n16], dArray5[n17]);
                    n16 += n3;
                    n17 += n5;
                    n18 += n10;
                    ++n19;
                }
                ++n15;
            }
            ++n11;
        }
    }

    private final short maxUShort(short s2, short s3) {
        return (s2 & 0xFFFF) > (s3 & 0xFFFF) ? s2 : s3;
    }

    private final short maxShort(short s2, short s3) {
        return s2 > s3 ? s2 : s3;
    }

    private final int maxInt(int n2, int n3) {
        return n2 > n3 ? n2 : n3;
    }

    private final float maxFloat(float f2, float f3) {
        if (f2 != f2) {
            return f2;
        }
        if (f2 == 0.0f && f3 == 0.0f && (long)Float.floatToIntBits(f2) == negativeZeroFloatBits) {
            return f3;
        }
        return f2 >= f3 ? f2 : f3;
    }

    private final double maxDouble(double d2, double d3) {
        if (d2 != d2) {
            return d2;
        }
        if (d2 == 0.0 && d3 == 0.0 && Double.doubleToLongBits(d2) == negativeZeroDoubleBits) {
            return d3;
        }
        return d2 >= d3 ? d2 : d3;
    }
}

